import javax.microedition.lcdui.*;
import javax.microedition.media.*;

public class SelectFile implements CommandListener {

	public static final int ANY=0;
	public static final int SOUND=1;
	public static final int PICTURE=2;

	public static final String DATA = "Data";
	public static final String CONFIG = "Config";
	public static final String MMC = "MMC";
	public static final String THIS_DIR = Msg.THISDIR;

	public static Command CMD_PLAY = new Command(Msg.PLAY, Command.OK, 1);
	public static Command CMD_VIEW = new Command(Msg.VIEW, Command.OK, 1);
	public static Command CMD_STOP = new Command(Msg.STOP, Command.STOP, 0);
	public static Command CMD_BACK = new Command(Msg.BACK, Command.BACK, 0);
	public static Command CMD_CANCEL = new Command(Msg.CANCEL, Command.BACK, 2);

	Form QF;
	List list;
	Displayable lastview;
	Player pl;
	StringItem si;
	String currentdir;
	int type;
	String mask;
	String contains;
	boolean isDir;

	static Image imgDISK = null;
	static Image imgMMC = null;
	static Image imgDIR = null;
	static Image imgFILE = null;

	static {
		try {
			imgDISK = Image.createImage("/images/disk.png");
			imgMMC = Image.createImage("/images/mmc.png");
			imgDIR = Image.createImage("/images/folder.png");
			imgFILE = Image.createImage("/images/file.png");
		}
		catch (Exception e) { }
	}

	public SelectFile(Form f, Widget w) {

		try {

			QF = f;
			si =(StringItem)w.item;
			String fname = si.getText().replace('/', '\\');
			if (fname.startsWith("2:") && !AFile.JSR) fname="3:"+fname.substring(2);
			if (fname.endsWith("\\")) {
				fname = fname.substring(0, fname.length()-1);
			}
			mask = w.tag.getString("mask");
			if (mask != null) {
				if (mask.equals("*.*") || mask.equals("*")) {
					mask = null;
				} else {
					if (mask.startsWith("*")) mask = mask.substring(1);
					mask = mask.toLowerCase();
				}
			}
			String stype = w.tag.getString("type");
			if (stype == null) stype = "";
			stype = stype.toLowerCase();
			if (stype.equals("sound")) {
				type = SOUND;
			} else if (stype.equals("picture")) {
				type = PICTURE;
			} else {
				type = ANY;
			}
			contains = w.tag.getString("contains");
			isDir = (w.type == Widget.SELECTDIR);
			currentdir = "";
			try {
				if (AFile.isDirectory(fname)) {
					currentdir = fname;
				} else {
					int i = fname.lastIndexOf('\\');
					if (i != -1) fname = fname.substring(0, i);
					if (AFile.isDirectory(fname)) {
						currentdir = fname;
					}
				}
			}
			catch (Exception e) { }

			reloadList();
			lastview = null;

		}
		catch (Exception e) {

			Master.D.setCurrent(new Msg(e, f));

		}

	}

	public void commandAction(Command c, Displayable d) {

		Master.timeout = 0;
		String s, news;

		switch (c.getCommandType()) {

			case Command.OK:

				s = list.getString(list.getSelectedIndex());
				news = currentdir + "\\" + s;
				try {
					if (AFile.isDirectory(news)) return;
					if (type == SOUND) play(news);
					if (type == PICTURE) view(news);
				}
				catch (Exception e) {
					Master.D.setCurrent(new Msg(e, list));
				}
				break;

			case Command.SCREEN:

				s = list.getString(list.getSelectedIndex());
				if (currentdir.length() == 0) {
					if (s.equals(DATA)) {
						currentdir = "0:";
					} else if (s.equals(CONFIG)) {
						currentdir = AFile.JSR ? "2:" : "3:";
					} else if (s.equals(MMC)) {
						currentdir = "4:";
					}
					reloadList();
				} else {
					if (s.equals(THIS_DIR)) {
						selectFile(currentdir);
					} else {
						news = currentdir + "\\" + s;
						try {
							if (AFile.isDirectory(news)) {
								currentdir = news;
								reloadList();
							} else {
								selectFile(news);
							}
						}
						catch (Exception e) { }
					}
				}
				break;

			case Command.STOP:

				try {
					pl.stop();
					pl.close();
				}
				catch (Exception e) { }
				Master.D.setCurrent(list);
				break;

			case Command.BACK:

        			if (d instanceof Form) {
					Master.D.setCurrent(list);
					return;
				}

				if (currentdir.length() == 0) {
					Master.D.setCurrent(QF);
					return;
				}

				int i = currentdir.lastIndexOf('\\');
				if (i == -1) {
					currentdir = "";
				} else {
					currentdir = currentdir.substring(0, i);
				}
				if (lastview != null) {
					Master.D.setCurrent(lastview);
					list = (List)lastview;
				} else {
					reloadList();
				}
				lastview = null;
				break;

		}

	}

	public void reloadList() {

		String title;

		if (currentdir.length() == 0) {

			title = isDir ? Msg.CHOOSEDIR : Msg.CHOOSEFILE;
			list = new List(title, List.IMPLICIT);

			list.append(DATA, imgDISK);
			list.append(CONFIG, imgDISK);
			list.append(MMC, imgMMC);

		} else {

			int i = currentdir.lastIndexOf('\\');
			title = (i == -1) ? currentdir : currentdir.substring(i+1);
			list = new List(title, List.IMPLICIT);

			if (isDir) list.append(THIS_DIR, null);

			try {

				String[] list1 = AFile.list(currentdir+"\\");

				for (i=0; i<list1.length; i++) {
					if (AFile.isDirectory(currentdir+"\\"+list1[i])) {
						list.append(list1[i], imgDIR);
						list1[i] = null;
					}
				}

				for (i=0; i<list1.length; i++) {
					if (isDir) break;
					if (list1[i] == null) continue;
					String fn = list1[i].toLowerCase();
					if (type == ANY) {
						if (mask == null || fn.endsWith(mask)) {
							list.append(list1[i], imgFILE);
						}
					} else if (type == SOUND) {
						if (fn.endsWith(".wav") ||
							fn.endsWith(".mid") ||
							fn.endsWith(".amr") ||
							fn.endsWith(".wav") ||
							fn.endsWith(".mp3") ||
							fn.endsWith(".aac")
						) {
							list.append(list1[i], imgFILE);
						}
					} else if (type == PICTURE) {
						if (fn.endsWith(".png") ||
							fn.endsWith(".bmp") ||
							fn.endsWith(".gif") ||
							fn.endsWith(".jpg")
						) {
							list.append(list1[i], imgFILE);
						}
					}
				}

			}
			catch (Exception e) { }

			if (type == SOUND) list.addCommand(CMD_PLAY);
			if (type == PICTURE) list.addCommand(CMD_VIEW);

		}

		list.addCommand(CMD_CANCEL);
		list.setCommandListener(this);
		lastview = Master.D.getCurrent();
		Master.D.setCurrent(list);

	}

	private void selectFile(String name) {

		if (isDir) name += "\\";
		if (name.startsWith("3:")) name="2:"+name.substring(2);

		si.setText(name);
		Master.D.setCurrent(QF);

	}

	private void play(String file) throws Exception {

		pl = Manager.createPlayer("file:///" + file.replace('\\','/'));
		pl.realize();
		pl.start();

		Alert a = new Alert(Msg.PLAY, Msg.PLAYING + " " + file, null, null);
		a.addCommand(CMD_STOP);
		a.setCommandListener(this);
		Master.D.setCurrent(a);

	}

	private void view(String file) throws Exception {

		AFile F = AFile.open(file);
		int len = F.length();
		byte[] b = new byte[len];
		F.read(b, 0, len);
		F.close();
		Image img = Image.createImage(b, 0, len);

		int i = file.lastIndexOf('\\');
		if (i == -1) return;
		Form f = new Form(file.substring(i+1));
		f.append(new Spacer(10, 10));
		f.append(new ImageItem(null, img, ImageItem.LAYOUT_CENTER | ImageItem.LAYOUT_NEWLINE_BEFORE, "[image]"));

		f.addCommand(CMD_BACK);
		f.setCommandListener(this);
		Master.D.setCurrent(f);

	}

}
