import javax.microedition.io.file.*;
import javax.microedition.io.*;
import java.io.*;
import java.util.Enumeration;

public class AFileJ extends AFile {

  private FileConnection C;
  private InputStream is;
  private OutputStream os;

  private static FileConnection connect(String name) throws Exception {

	String s = "file:///" + name.replace('\\', '/');
	return (FileConnection)Connector.open(s);

  }

  public static boolean exists(String name) throws Exception {

	FileConnection fc = connect(name);
	boolean r = fc.exists();
	fc.close();
	return r;

  }

  public static String[] list(String name) throws Exception {

	FileConnection fc = connect(name);
	Enumeration e = fc.list();
	fc.close();
	String[] r1 = new String[256];
	int i = 0;
	while (e.hasMoreElements()) {
		String s = (String)(e.nextElement());
		if (s.endsWith("/")) s = s.substring(0, s.length()-1);
		r1[i++] = s;
		if (i == 256) break;
	}
	String[] r2 = new String[i];
	System.arraycopy(r1, 0, r2, 0, i);
	return r2;

  }

  public static void delete(String name) throws Exception {

	FileConnection fc = connect(name);
	fc.delete();
	fc.close();

  }

  public static boolean isDirectory(String name) throws Exception {

	FileConnection fc = connect(name);
	boolean r = fc.isDirectory();
	fc.close();
	return r;

  }

  public static AFile open(String name) throws Exception {

	AFileJ af = new AFileJ();
	af.C = connect(name);
	if (! af.C.exists()) {
		af.C.create();
	}
	af.is = af.C.openInputStream();
	af.os = af.C.openOutputStream();

	return af;

  }

  public int read(byte[] buf, int off, int len) throws Exception {

	return is.read(buf, off, len);

  }

  public int write(byte[] buf, int off, int len) throws Exception {

	os.write(buf, off, len);
	return len;

  }

  public int length() throws Exception {

	return (int)C.fileSize();

  }

  public void close() throws Exception {

	is.close();
	os.flush();
	os.close();
	C.close();

	is = null;
	os = null;
	C = null;

  }

}
