/*
 * Decompiled with CFR 0.152.
 */
package canvas;

import canvas.TMyFile;
import canvas.TMyFont;
import canvas.TMyMMCFile;
import canvas.TMyPngFont;
import canvas.TMyStdFont;
import com.siemens.mp.game.ExtendedImage;
import com.siemens.mp.game.Light;
import com.siemens.mp.io.File;
import javax.microedition.lcdui.Font;

public class Common {
    public static final byte[] DOS_ENCODE = new byte[]{-64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, 45, 45, 45, -90, 43, -90, -90, -84, -84, -90, -90, -84, 45, 45, 45, -84, 76, 43, 84, 43, 45, 43, -90, -90, 76, -29, -90, 84, -90, 61, 43, -90, -90, 84, 84, 76, 76, 45, -29, 43, 43, 45, 45, 45, 45, -90, -90, 45, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, -88, -72, -86, -70, -81, -65, -95, -94, -80, -107, -73, 118, -71, -92, -90, -96};
    private static final byte _$3456 = 20;
    private static final byte _$3457 = 40;
    public String[] FontList;
    public int[] FontListId;
    public int FontsCount;
    public String[] FileList;
    public int FileListCount;
    public boolean bUpdateFileList = false;
    private TMyFont _$3458;

    public static int ClampTo8(int n) {
        if (n % 8 == 0) {
            return n / 8 * 8;
        }
        return (n / 8 + 1) * 8;
    }

    public void InvertPixels(int n, int n2, int n3, int n4, ExtendedImage extendedImage) {
        int n5 = n / 8 * 8;
        int n6 = Common.ClampTo8(n - n5 + n3) / 8;
        byte[] byArray = new byte[n6 * n4];
        extendedImage.getPixelBytes(byArray, n5, n2, n6 * 8, n4);
        int n7 = 255 >> n - n5;
        int n8 = 255 << n5 + n6 * 8 - (n + n3);
        if (n6 == 1) {
            n7 &= n8;
        }
        int n9 = 0;
        for (int i = 0; i < n4; ++i) {
            byArray[n9] = (byte)(byArray[n9] ^ n7);
            ++n9;
            for (int j = 2; j < n6; ++j) {
                byArray[n9] = ~byArray[n9];
                ++n9;
            }
            if (n6 <= 1) continue;
            byArray[n9] = (byte)(byArray[n9] ^ n8);
            ++n9;
        }
        extendedImage.setPixels(byArray, n5, n2, n6 * 8, n4);
    }

    public String GetBoolOption(String string, boolean bl) {
        if (string.length() <= 6) {
            if (bl) {
                return String.valueOf(String.valueOf(string)).concat(": ON");
            }
            return String.valueOf(String.valueOf(string)).concat(": OFF");
        }
        if (bl) {
            return String.valueOf(String.valueOf(string)).concat(": ON");
        }
        return String.valueOf(String.valueOf(string)).concat(":OFF");
    }

    public void RefreshFileList() {
        TMyMMCFile tMyMMCFile;
        this.FileListCount = 0;
        if (File.exists((String)"filelist.dat") < 0) {
            return;
        }
        try {
            tMyMMCFile = new TMyMMCFile("filelist.dat");
        }
        catch (Exception exception) {
            return;
        }
        while (!tMyMMCFile.EOF() && this.FileListCount < 40) {
            try {
                String string = tMyMMCFile.Readln().trim();
                if (File.exists((String)string) < 0) continue;
                this.FileList[this.FileListCount] = new String(string.toUpperCase());
                ++this.FileListCount;
            }
            catch (Exception exception) {
                ((TMyFile)tMyMMCFile).Close();
                return;
            }
        }
        ((TMyFile)tMyMMCFile).Close();
    }

    public void CreateFontsList(TMyFont tMyFont) {
        TMyMMCFile tMyMMCFile;
        this._$3458 = tMyFont;
        this.FileList = new String[40];
        this.FontList = new String[20];
        this.FontListId = new int[20];
        this.FontsCount = 8;
        int n = Font.getFont((int)0, (int)0, (int)8).getHeight();
        int n2 = Font.getFont((int)0, (int)0, (int)0).getHeight();
        int n3 = Font.getFont((int)0, (int)0, (int)16).getHeight();
        System.gc();
        this.FontList[0] = new String("Std ".concat(String.valueOf(String.valueOf(n - 2))));
        this.FontListId[0] = 4;
        this.FontList[1] = new String(String.valueOf(String.valueOf(new StringBuffer("Std ").append(n - 2).append("(Bold)"))));
        this.FontListId[1] = 5;
        this.FontList[2] = new String("Std ".concat(String.valueOf(String.valueOf(n2 - 2))));
        this.FontListId[2] = 6;
        this.FontList[3] = new String("Std ".concat(String.valueOf(String.valueOf(n3 - 2))));
        this.FontListId[3] = 7;
        this.FontList[4] = new String("5x3");
        this.FontListId[4] = 0;
        this.FontList[5] = new String("5x4");
        this.FontListId[5] = 1;
        this.FontList[6] = new String("6x4 CYR");
        this.FontListId[6] = 2;
        this.FontList[7] = new String("6x4 CE");
        this.FontListId[7] = 3;
        if (File.exists((String)"fontlist.dat") < 0) {
            return;
        }
        try {
            tMyMMCFile = new TMyMMCFile("fontlist.dat");
        }
        catch (Exception exception) {
            return;
        }
        while (!tMyMMCFile.EOF() && this.FontsCount < 20) {
            try {
                String string = tMyMMCFile.Readln().trim();
                if (File.exists((String)string) < 0) continue;
                this.FontList[this.FontsCount] = string;
                this.FontListId[this.FontsCount] = TMyPngFont.GetFontId(string);
                ++this.FontsCount;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public TMyFont CreateFontByIndex(int n, byte by) {
        try {
            switch (this.FontListId[n]) {
                case 0: {
                    TMyPngFont tMyPngFont = new TMyPngFont("resource:res/font5x3.fnt", by);
                    tMyPngFont.Id = 0;
                    TMyPngFont tMyPngFont2 = tMyPngFont;
                    return tMyPngFont2;
                }
                case 1: {
                    TMyPngFont tMyPngFont = new TMyPngFont("resource:res/font5x4.fnt", by);
                    tMyPngFont.Id = 1;
                    TMyPngFont tMyPngFont3 = tMyPngFont;
                    return tMyPngFont3;
                }
                case 2: {
                    TMyPngFont tMyPngFont = new TMyPngFont("resource:res/font6x4ru.fnt", by);
                    tMyPngFont.Id = 2;
                    TMyPngFont tMyPngFont4 = tMyPngFont;
                    return tMyPngFont4;
                }
                case 3: {
                    TMyPngFont tMyPngFont = new TMyPngFont("resource:res/font6x4ce.fnt", by);
                    tMyPngFont.Id = 3;
                    TMyPngFont tMyPngFont5 = tMyPngFont;
                    return tMyPngFont5;
                }
                case 4: {
                    TMyStdFont tMyStdFont = new TMyStdFont(0, 8, 4, by);
                    return tMyStdFont;
                }
                case 5: {
                    TMyStdFont tMyStdFont = new TMyStdFont(1, 8, 5, by);
                    return tMyStdFont;
                }
                case 6: {
                    TMyStdFont tMyStdFont = new TMyStdFont(0, 0, 6, by);
                    return tMyStdFont;
                }
                case 7: {
                    TMyStdFont tMyStdFont = new TMyStdFont(0, 16, 7, by);
                    return tMyStdFont;
                }
            }
            TMyPngFont tMyPngFont = new TMyPngFont(this.FontList[n], by);
            return tMyPngFont;
        }
        catch (Exception exception) {
            TMyFont tMyFont = this._$3458;
            return tMyFont;
        }
    }

    public int GetFontIndexById(int n) {
        for (int i = 0; i < this.FontsCount; ++i) {
            if (this.FontListId[i] != n) continue;
            return i;
        }
        return -1;
    }

    public String GetIndexFileName(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            n = string.length();
        }
        if (!string.startsWith("resource:res/")) {
            return String.valueOf(String.valueOf(string.substring(0, n))).concat(".idx");
        }
        return String.valueOf(String.valueOf(string.substring(13, n))).concat(".idx");
    }

    public void SetLight(boolean bl) {
        if (bl) {
            Light.setLightOn();
        } else {
            Light.setLightOff();
        }
    }

    public void UpdateFileList(String string) {
        TMyMMCFile tMyMMCFile;
        int n;
        this.bUpdateFileList = false;
        if (string.startsWith("resource:")) {
            return;
        }
        string = string.toUpperCase();
        for (n = 0; n < this.FileListCount; ++n) {
            if (!this.FileList[n].toUpperCase().equals(string)) continue;
            return;
        }
        if (this.FileListCount < 40) {
            this.FileList[this.FileListCount] = string;
            ++this.FileListCount;
        }
        try {
            File.delete((String)"filelist.dat");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tMyMMCFile = new TMyMMCFile("filelist.dat");
        }
        catch (Exception exception) {
            return;
        }
        for (n = 0; n < this.FileListCount; ++n) {
            try {
                ((TMyFile)tMyMMCFile).Writeln(this.FileList[n]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        ((TMyFile)tMyMMCFile).Close();
    }

    public String TimeString() {
        long l = System.currentTimeMillis();
        long l2 = l / (long)1000 % (long)60;
        long l3 = l / (long)60000 % (long)60;
        long l4 = l / (long)3600000 % (long)24;
        if (l3 < (long)10 && l2 < (long)10) {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(l4))).append(":0").append(l3).append(":0").append(l2)));
        }
        if (l3 < (long)10) {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(l4))).append(":0").append(l3).append(":").append(l2)));
        }
        if (l2 < (long)10) {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(l4))).append(":").append(l3).append(":0").append(l2)));
        }
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(l4))).append(":").append(l3).append(":").append(l2)));
    }

    static {
        _$3456 = (byte)20;
        _$3457 = (byte)40;
    }
}

