/*
 * Decompiled with CFR 0.152.
 */
package canvas;

import canvas.TMyMMCFile;
import canvas.TMyResourceFile;
import java.io.IOException;

public abstract class TMyFile {
    public int FilePos;
    public int Length;

    static TMyFile OpenFile(String string) throws Exception {
        if (string.startsWith("resource:")) {
            return new TMyResourceFile(string);
        }
        return new TMyMMCFile(string);
    }

    public abstract void Close();

    public abstract int Read(byte[] var1, int var2, int var3) throws IOException;

    public abstract boolean ReadSingleByte(byte[] var1, int var2) throws IOException;

    public abstract boolean ReadSingleByteReverse(byte[] var1, int var2) throws IOException;

    public int ReadInt() throws IOException {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        this.Read(byArray, 0, 4);
        return TMyFile.ubyte(byArray[0]) + (TMyFile.ubyte(byArray[1]) << 8) + (TMyFile.ubyte(byArray[2]) << 16) + (TMyFile.ubyte(byArray[3]) << 24);
    }

    public boolean ReadBoolean() throws IOException {
        return this.ReadByte() != 0;
    }

    public abstract byte ReadByte() throws IOException;

    public abstract int Write(byte[] var1, int var2, int var3) throws IOException;

    public abstract void Write(int var1) throws IOException;

    public abstract void Write(boolean var1) throws IOException;

    public abstract void Write(byte var1) throws IOException;

    public abstract void Writeln(String var1) throws IOException;

    public void Seek(int n) throws IOException {
        if (n > this.Length) {
            n = this.Length;
        }
        if (n < 0) {
            n = 0;
        }
        this.FilePos = n;
    }

    public boolean EOF() {
        return this.FilePos > this.Length - 1;
    }

    static int ubyte(byte by) {
        if (by >= 0) {
            return by;
        }
        return 256 + by;
    }

    public String Readln() throws IOException {
        byte[] byArray = new byte[255];
        int n = 0;
        do {
            this.Read(byArray, n, 1);
            if (byArray[n] == 10) continue;
            ++n;
        } while (!this.EOF() && n != 255 && (n == 0 || byArray[n - 1] != 13));
        if (n > 0 && byArray[n - 1] == 13) {
            --n;
        }
        return new String(byArray, 0, n);
    }
}

