/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class ShrSms
extends MIDlet
implements CommandListener {
    private Command m_comExit;
    private Command m_comOkPhone;
    private Command m_comSend;
    private Command m_comBack;
    private Command m_comAbout;
    private Command m_comOptions;
    private Command m_comOkOptions;
    private Command m_comCancelOptions;
    int m_iMajV = 1;
    int m_iMinV = 1;
    String m_sRev;
    KPhoneBook m_fmPhone;
    KOptions m_fmOptions;
    Display m_disMain;
    TextBox m_tbMessage;

    public ShrSms() {
        this.setBuildNo();
        this.m_fmPhone = new KPhoneBook();
        this.m_fmOptions = new KOptions();
        this.m_tbMessage = new TextBox("Text", "", 512, 0);
        this.m_comExit = new Command("Exit", 7, 3);
        this.m_comOkPhone = new Command("Continue", 4, 1);
        this.m_comOptions = new Command("Options", 1, 2);
        this.m_comOkOptions = new Command("Save", 4, 1);
        this.m_comCancelOptions = new Command("Cancel", 3, 1);
        this.m_comBack = new Command("Back", 3, 1);
        this.m_comSend = new Command("Send", 4, 1);
        this.m_comAbout = new Command("About...", 1, 15);
        this.m_fmPhone.addCommand(this.m_comExit);
        this.m_fmPhone.addCommand(this.m_comOkPhone);
        this.m_fmPhone.addCommand(this.m_comOptions);
        this.m_fmPhone.addCommand(this.m_comAbout);
        this.m_fmOptions.addCommand(this.m_comOkOptions);
        this.m_fmOptions.addCommand(this.m_comCancelOptions);
        this.m_fmOptions.addCommand(this.m_comAbout);
        this.m_tbMessage.addCommand(this.m_comBack);
        this.m_tbMessage.addCommand(this.m_comSend);
        this.m_tbMessage.addCommand(this.m_comAbout);
        this.m_fmPhone.setCommandListener(this);
        this.m_fmOptions.setCommandListener(this);
        this.m_tbMessage.setCommandListener((CommandListener)this);
        this.m_disMain = Display.getDisplay((MIDlet)this);
    }

    private void setBuildNo() {
        this.m_sRev = new String("$Revision: 1.19 $");
        int n = this.m_sRev.indexOf(58);
        int n2 = this.m_sRev.indexOf(36, n);
        this.m_sRev = this.m_sRev.substring(n + 1, n2).trim();
    }

    protected void startApp() {
        this.m_disMain.setCurrent((Displayable)this.m_fmPhone);
    }

    protected void pauseApp() {
        this.m_fmPhone.saveBook();
    }

    protected void destroyApp(boolean bl) {
        this.m_fmPhone.saveBook();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.m_comExit) {
            this.destroyApp(false);
            this.notifyDestroyed();
        }
        if (command == this.m_comOkPhone) {
            this.m_fmPhone.savePhoneAndName();
            this.m_tbMessage.setTitle(this.m_fmPhone.getName() + "/" + this.m_fmPhone.getPhone());
            this.m_tbMessage.setString(this.m_fmOptions.getSign());
            this.m_disMain.setCurrent((Displayable)this.m_tbMessage);
        }
        if (command == this.m_comOptions) {
            this.m_disMain.setCurrent((Displayable)this.m_fmOptions);
        }
        if (command == this.m_comOkOptions) {
            this.m_fmOptions.saveOptions();
            this.m_disMain.setCurrent((Displayable)this.m_fmPhone);
        }
        if (command == this.m_comCancelOptions || command == this.m_comBack) {
            this.m_disMain.setCurrent((Displayable)this.m_fmPhone);
            if (command == this.m_comCancelOptions) {
                this.m_fmOptions.readOptions();
            }
        }
        if (command == this.m_comSend) {
            this.sendSms();
        }
        if (command == this.m_comAbout) {
            this.showAbout();
        }
    }

    private String encodeUrl(String string) {
        String string2 = new String("");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '\u0081') {
                if (c < '!') {
                    string2 = string2 + "%20";
                    continue;
                }
                if (c == '%') {
                    string2 = string2 + "%25";
                    continue;
                }
                if (c == '?') {
                    string2 = string2 + "%3F";
                    continue;
                }
                if (c == '#') {
                    string2 = string2 + "%23";
                    continue;
                }
                if (c == '+') {
                    string2 = string2 + "%2B";
                    continue;
                }
                string2 = string2 + (char)c;
                continue;
            }
            string2 = c == '\u0451' ? string2 + "%B8" : (c == '\u0401' ? string2 + "%A8" : string2 + "%" + Integer.toHexString(c - 848));
        }
        return string2;
    }

    private String getRequest() {
        String string = new String();
        string = "name=" + this.m_fmPhone.getPhone() + "&text=" + this.encodeUrl(this.m_tbMessage.getString());
        if (this.m_fmOptions.getLogin().trim().length() > 0) {
            string = string + "&log=" + this.encodeUrl(this.m_fmOptions.getLogin());
        }
        if (this.m_fmOptions.getPassword().trim().length() > 0) {
            string = string + "&psw=" + this.encodeUrl(this.m_fmOptions.getPassword());
        }
        if (this.m_sRev.length() > 0) {
            string = string + "&rev=" + this.m_sRev;
        }
        return string;
    }

    private void sendSms() {
        int n = 0;
        String string = new String("");
        Alert alert = new Alert("Result", "", null, AlertType.INFO);
        Form form = new Form("In progress");
        alert.setTimeout(-2);
        form.append("Sending message to " + this.m_fmPhone.getPhone() + ".\n Please, wait...");
        this.m_disMain.setCurrent((Displayable)form);
        try {
            String string2 = this.getRequest();
            String string3 = this.m_fmOptions.getUrl();
            HttpConnection httpConnection = (HttpConnection)Connector.open((String)(string3 + "?" + string2));
            httpConnection.setRequestMethod("GET");
            httpConnection.setRequestProperty("User-Agent", "Mozilla/4.0");
            httpConnection.setRequestProperty("Content-Language", "en");
            httpConnection.setRequestProperty("Accept", "*/*, text/plain, text/xml, text/html");
            httpConnection.setRequestProperty("Accept-Encoding", "deflate, gzip");
            httpConnection.setRequestProperty("Accept-Charset", "utf-8");
            n = httpConnection.getResponseCode();
            if (200 == n) {
                int n2;
                InputStream inputStream = httpConnection.openInputStream();
                while ((n2 = inputStream.read()) != -1) {
                    string = string + (char)n2;
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            if (httpConnection != null) {
                httpConnection.close();
            }
        }
        catch (Exception exception) {
            n = -1;
            string = exception.toString();
        }
        alert.setString(this.getStatus(n, string));
        this.m_disMain.setCurrent(alert, (Displayable)this.m_fmPhone);
    }

    private String getStatus(int n, String string) {
        switch (n) {
            case 200: {
                int n2 = string.indexOf("<out>");
                int n3 = string.indexOf("</out>");
                if (n2 >= 0 && n3 >= 0 && n3 > n2 + 5) {
                    return string.substring(n2 + 5, n3).trim();
                }
                n2 = string.indexOf("<p>");
                n3 = string.indexOf("</p>");
                if (n2 >= 0 && n3 >= 0 && n3 > n2 + 3) {
                    return string.substring(n2 + 3, n3).trim();
                }
                return "Strange response(or sent via WAP-gate):\n" + string.trim();
            }
            case 404: {
                return "Gate not found. Check 'Options'";
            }
            case 500: {
                return "Internal server error. Try late.";
            }
            case 502: {
                return "Bad gateway.\nSeems you should use WAP con.profile.";
            }
            case -1: {
                return "Internal error or connection lost.\n" + string;
            }
        }
        return "Unexpected server error [" + n + "].\n Please, report.";
    }

    private void showAbout() {
        Alert alert = new Alert("About", "SMSSender v" + this.m_iMajV + "." + this.m_iMinV + "/R" + this.m_sRev + "\n" + "(c) D.B.Moskvin, 2004,\nwww.moskvin.biz/sms.\n" + "Thanks to Alex Kotov & K.I.Semenenkov\n" + "allsms.spb.ru\n", null, AlertType.INFO);
        alert.setTimeout(-2);
        this.m_disMain.setCurrent((Displayable)alert);
    }

    class KPhoneBook
    extends Form
    implements ItemStateListener {
        static final int DEEP = 16;
        private int m_iCount;
        private TextField m_tbPhone;
        private TextField m_tbName;
        private Ticker m_ticHint;
        private ChoiceGroup m_chList;
        private String[] m_asNames = new String[16];
        private String[] m_asPhones = new String[16];

        private void readBook() {
            RecordStore recordStore;
            int n;
            block11: {
                n = 0;
                this.m_iCount = 0;
                try {
                    recordStore = RecordStore.openRecordStore((String)"phonebook", (boolean)false);
                    this.m_iCount = recordStore.getNumRecords();
                    if (this.m_iCount != 0) break block11;
                    try {
                        recordStore.closeRecordStore();
                    }
                    catch (RecordStoreException recordStoreException) {
                        // empty catch block
                    }
                    return;
                }
                catch (RecordStoreException recordStoreException) {
                    this.m_iCount = 0;
                    return;
                }
            }
            if (this.m_iCount > 16) {
                this.m_iCount = 16;
            }
            try {
                RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
                while (recordEnumeration.hasNextElement() && n < this.m_iCount) {
                    int n2 = recordEnumeration.nextRecordId();
                    byte[] byArray = recordStore.getRecord(n2);
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                    this.m_asNames[n] = dataInputStream.readUTF();
                    this.m_asPhones[n] = dataInputStream.readUTF();
                    ++n;
                    dataInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_iCount > n) {
                this.m_iCount = n;
            }
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }

        public void saveBook() {
            RecordStore recordStore;
            try {
                RecordStore.deleteRecordStore((String)"phonebook");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                recordStore = RecordStore.openRecordStore((String)"phonebook", (boolean)true);
            }
            catch (RecordStoreException recordStoreException) {
                return;
            }
            for (int i = 0; i < this.m_iCount; ++i) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                try {
                    dataOutputStream.writeUTF(this.m_asNames[i]);
                    dataOutputStream.writeUTF(this.m_asPhones[i]);
                    dataOutputStream.close();
                }
                catch (Exception exception) {
                    continue;
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                try {
                    recordStore.addRecord(byArray, 0, byArray.length);
                    continue;
                }
                catch (RecordStoreException recordStoreException) {
                    // empty catch block
                }
            }
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }

        public void itemStateChanged(Item item) {
            if (item == this.m_chList) {
                int n = this.m_chList.getSelectedIndex();
                this.m_tbPhone.setString(this.m_asPhones[n]);
                this.m_tbName.setString(this.m_asNames[n]);
            }
        }

        public KPhoneBook() {
            super("Select Phone");
            this.m_ticHint = new Ticker("input new or select exists phone");
            this.setTicker(this.m_ticHint);
            this.m_tbPhone = new TextField("Phone", "", 20, 3);
            this.m_tbName = new TextField("Name", "", 20, 0);
            this.m_chList = new ChoiceGroup("sent:", 1);
            this.append((Item)this.m_tbPhone);
            this.append((Item)this.m_tbName);
            this.append((Item)this.m_chList);
            this.setItemStateListener(this);
            this.readBook();
            this.resortPhones();
        }

        private void resortPhones() {
            this.delete(this.size() - 1);
            while (this.m_chList.size() > 0) {
                this.m_chList.delete(0);
            }
            for (int i = 0; i < this.m_iCount; ++i) {
                this.m_chList.append(this.m_asNames[i], null);
            }
            this.append((Item)this.m_chList);
            if (this.m_iCount > 0) {
                this.m_tbPhone.setString(this.m_asPhones[0]);
                this.m_tbName.setString(this.m_asNames[0]);
            } else {
                this.m_tbPhone.setString("");
                this.m_tbName.setString("");
            }
        }

        public String getPhone() {
            return this.m_tbPhone.getString().replace('+', ' ').trim();
        }

        public String getName() {
            String string = this.m_tbName.getString();
            if (string.trim().length() == 0) {
                this.m_tbName.setString(this.m_tbPhone.getString());
            }
            return this.m_tbName.getString();
        }

        public void savePhoneAndName() {
            int n;
            String string = this.m_tbName.getString();
            String string2 = this.m_tbPhone.getString();
            int n2 = -1;
            for (n = 0; n < this.m_iCount; ++n) {
                if (string2.compareTo(this.m_asPhones[n]) != 0) continue;
                n2 = n;
            }
            if (n2 == -1) {
                if (string.trim().length() == 0) {
                    string = string2;
                }
                if (this.m_iCount < 16) {
                    ++this.m_iCount;
                }
                for (n = this.m_iCount - 1; n > 0; --n) {
                    this.m_asPhones[n] = this.m_asPhones[n - 1];
                    this.m_asNames[n] = this.m_asNames[n - 1];
                }
            } else {
                if (string.trim().length() == 0) {
                    string = this.m_asNames[n2];
                }
                for (n = n2; n >= 1; --n) {
                    this.m_asPhones[n] = this.m_asPhones[n - 1];
                    this.m_asNames[n] = this.m_asNames[n - 1];
                }
            }
            this.m_asPhones[0] = string2;
            this.m_asNames[0] = string;
            this.resortPhones();
        }
    }

    class KOptions
    extends Form {
        private TextField m_tbSign = new TextField("Sign", "(your sign)", 15, 0);
        private TextField m_tbUrl = new TextField("Gate", "http://allsms.spb.ru/java.php", 128, 4);
        private TextField m_tbPassword;
        private TextField m_tbLogin = new TextField("Login", "", 64, 0);

        public void readOptions() {
            RecordStore recordStore;
            String string;
            String string2;
            String string3;
            String string4;
            block9: {
                string4 = new String();
                string3 = new String();
                string2 = new String();
                string = new String();
                try {
                    recordStore = RecordStore.openRecordStore((String)"options", (boolean)false);
                    if (recordStore.getNumRecords() != 0) break block9;
                    try {
                        recordStore.closeRecordStore();
                    }
                    catch (RecordStoreException recordStoreException) {
                        // empty catch block
                    }
                    return;
                }
                catch (RecordStoreException recordStoreException) {
                    return;
                }
            }
            try {
                RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
                if (recordEnumeration.hasNextElement()) {
                    int n = recordEnumeration.nextRecordId();
                    byte[] byArray = recordStore.getRecord(n);
                    DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                    string4 = dataInputStream.readUTF();
                    string3 = dataInputStream.readUTF();
                    string2 = dataInputStream.readUTF();
                    string = dataInputStream.readUTF();
                    dataInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            this.m_tbSign.setString(string4);
            this.m_tbUrl.setString(string3);
            this.m_tbLogin.setString(string2);
            this.m_tbPassword.setString(string);
        }

        public void saveOptions() {
            RecordStore recordStore;
            try {
                RecordStore.deleteRecordStore((String)"options");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                recordStore = RecordStore.openRecordStore((String)"options", (boolean)true);
            }
            catch (RecordStoreException recordStoreException) {
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeUTF(this.getSign());
                dataOutputStream.writeUTF(this.getUrl());
                dataOutputStream.writeUTF(this.getLogin());
                dataOutputStream.writeUTF(this.getPassword());
                dataOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            try {
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }

        public KOptions() {
            super("Options");
            this.m_tbPassword = new TextField("Password", "", 64, 65536);
            this.append((Item)this.m_tbSign);
            this.append((Item)this.m_tbUrl);
            this.append((Item)this.m_tbLogin);
            this.append((Item)this.m_tbPassword);
            this.readOptions();
        }

        public String getUrl() {
            String string = new String(this.m_tbUrl.getString().toLowerCase());
            if (string.indexOf("http://") < 0) {
                string = "http://" + string;
            }
            this.m_tbUrl.setString(string);
            return string;
        }

        public String getSign() {
            return this.m_tbSign.getString();
        }

        public String getLogin() {
            return this.m_tbLogin.getString();
        }

        public String getPassword() {
            return this.m_tbPassword.getString();
        }
    }
}

