/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app.calculatorconverter;

import com.siemens.mp.app.Application;
import com.siemens.mp.app.MessageBox;
import com.siemens.mp.app.UIException;
import com.siemens.mp.app.calculatorconverter.AddOrEditCurrency;
import com.siemens.mp.app.calculatorconverter.BaseChoice;
import com.siemens.mp.app.calculatorconverter.CalcConvApp;
import com.siemens.mp.app.calculatorconverter.Category;
import com.siemens.mp.app.calculatorconverter.ChoiceUI;
import com.siemens.mp.app.calculatorconverter.NameList;
import com.siemens.mp.app.calculatorconverter.Unit;
import com.siemens.mp.app.calculatorconverter.UnitConverterCore;
import com.siemens.mp.app.calculatorconverter.UnitConverterData;
import com.siemens.mp.app.calculatorconverter.UnitConverterTextField;
import java.util.Hashtable;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Spacer;

public class UnitConverterUI
extends Form
implements CommandListener,
ItemStateListener,
ItemCommandListener {
    private static final int BID_NFO_NEW_BASE_SET = 1;
    private static final int BID_ASK_DELETE_ALL = 2;
    private static final int BID_ASK_DELETE = 3;
    private static final int BID_NFO_DELETE = 4;
    private static final int ITM_UNKNOWN = -1;
    private static final int ITM_CATEGORY = 0;
    private static final int ITM_NUMBER_INPUT = 1;
    private static final int ITM_FIRST_UNIT = 2;
    private static final int ITM_SECOND_UNIT = 3;
    private static final int ITM_NUMBER_OUTPUT = 4;
    private static final int MAX_ITEM = 5;
    private static final Command CMD_CALCULATOR = new Command(Application.getLocalizedText(104), 4, 8);
    private static final Command CMD_EDIT_RATE = new Command(Application.getLocalizedText(105), 4, 4);
    private static final Command CMD_SIGN_CHANGE = new Command(Application.getLocalizedText(106), 4, 1);
    private static final Command CMD_MEM_SAVE = new Command(Application.getLocalizedText(9), 4, 2);
    private static final Command CMD_MEM_RECALL = new Command(Application.getLocalizedText(10), 4, 3);
    private static final Command CMD_ADD_CURRENCY = new Command(Application.getLocalizedText(107), Application.getLocalizedText(108), 4, 3);
    private static final Command CMD_SET_AS_BASE = new Command(Application.getLocalizedText(109), 4, 5);
    private static final Command CMD_DELETE = new Command(Application.getLocalizedText(110), 4, 6);
    private static final Command CMD_DELETE_ALL = new Command(Application.getLocalizedText(111), 4, 7);
    private static final Command CMD_HELP = new Command(Application.getLocalizedText(1), 4, 8);
    private static final Command CMD_LSK_CLEAR = new Command(Application.getLocalizedText(5), 2, 1);
    private static final Command CMD_EXIT = new Command(Application.getLocalizedText(133), 4, 10);
    private static final Command CMD_LSK_EXIT = new Command(Application.getLocalizedText(133), 2, 1);
    private static final Command CMD_CHANGE = new Command(Application.getLocalizedText(135), 4, 0);
    private static final Command SELECT_COMMAND = new Command(Application.getLocalizedText(117), 4, 0);
    private UnitConverterCore mCore;
    private ChoiceGroup mCategories;
    private ChoiceUI choiceCategories;
    private ChoiceUI choiceFirstUnit;
    private ChoiceUI choiceSecondUnit;
    private UnitConverterTextField mNumberInput;
    private UnitConverterTextField mNumberOutput;
    private Item[] mAllItems;
    private Item mLastActiveItem;
    private int mCurrencyIndex;
    private Image mIcon;
    private boolean mCalcDirection;
    private List listCategories;
    private List listFirstUnit;
    private List listSecondUnit;
    private Hashtable mCommandHash = new Hashtable();
    private static UnitConverterUI instance;
    static final int TOP_SPACE;
    static final int ITEM_SPACING;

    static {
        if (CalcConvApp.getInstance().isSmallDisplay()) {
            ITEM_SPACING = 6;
            TOP_SPACE = 0;
        } else {
            ITEM_SPACING = 13;
            TOP_SPACE = 0;
        }
    }

    public UnitConverterUI(UnitConverterCore pCore) {
        super(CalcConvApp.getInstance().getAppTitle());
        this.mCore = pCore;
        this.mIcon = Application.getBitmap(3);
        this.mCategories = new ChoiceGroup(null, 4);
        this.listCategories = new List("", 3);
        this.listCategories.setCommandListener((CommandListener)this);
        this.listCategories.setSelectCommand(SELECT_COMMAND);
        this.listFirstUnit = new List("", 3);
        this.listFirstUnit.setCommandListener((CommandListener)this);
        this.listFirstUnit.setSelectCommand(SELECT_COMMAND);
        this.listSecondUnit = new List("", 3);
        this.listSecondUnit.setCommandListener((CommandListener)this);
        this.listSecondUnit.setSelectCommand(SELECT_COMMAND);
        this.choiceCategories = new ChoiceUI("", this.listCategories, true);
        this.choiceCategories.setReference();
        this.choiceCategories.setItemCommandListener(this);
        this.mCategories.setLayout(512);
        this.mCategories.setItemCommandListener((ItemCommandListener)this);
        this.choiceFirstUnit = new ChoiceUI("", this.listFirstUnit, false);
        this.choiceFirstUnit.setItemCommandListener(this);
        this.choiceSecondUnit = new ChoiceUI("", this.listSecondUnit, false);
        this.choiceSecondUnit.setItemCommandListener(this);
        this.mNumberInput = new UnitConverterTextField((Displayable)this, "", 16, 1, this);
        this.mNumberInput.setReference();
        this.mNumberInput.setLayout(512);
        this.mNumberInput.setItemCommandListener(this);
        this.mNumberOutput = new UnitConverterTextField((Displayable)this, "", 16, 1);
        this.mNumberOutput.setReference();
        this.mNumberOutput.setReference();
        this.mNumberOutput.setLayout(512);
        this.mNumberOutput.setItemCommandListener(this);
        if (TOP_SPACE != 0) {
            this.append((Item)new Spacer(TOP_SPACE, TOP_SPACE));
        }
        this.append((Item)this.choiceCategories);
        this.append((Item)new Spacer(ITEM_SPACING, ITEM_SPACING));
        this.append((Item)this.mNumberInput);
        this.append((Item)this.choiceFirstUnit);
        this.append((Item)this.choiceSecondUnit);
        this.append((Item)this.mNumberOutput);
        this.mCommandHash.put(this.choiceCategories, new Hashtable());
        this.mCommandHash.put(this.mNumberInput, new Hashtable());
        this.mCommandHash.put(this.mNumberOutput, new Hashtable());
        this.mCommandHash.put(this.choiceFirstUnit, new Hashtable());
        this.mCommandHash.put(this.choiceSecondUnit, new Hashtable());
        this.mAllItems = new Item[5];
        this.mAllItems[0] = this.choiceCategories;
        this.mAllItems[2] = this.choiceFirstUnit;
        this.mAllItems[3] = this.choiceSecondUnit;
        this.mAllItems[1] = this.mNumberInput;
        this.mAllItems[4] = this.mNumberOutput;
        this.mLastActiveItem = null;
        this.mCalcDirection = true;
        this.mNumberInput.addCommand(CMD_MEM_SAVE);
        this.mNumberInput.addCommand(CMD_MEM_RECALL);
        this.mNumberOutput.addCommand(CMD_MEM_SAVE);
        this.mNumberOutput.addCommand(CMD_MEM_RECALL);
        this.mCategories.addCommand(CMD_CALCULATOR);
        this.choiceCategories.addCommand(CMD_CALCULATOR);
        this.choiceCategories.addCommand(CMD_CHANGE);
        this.choiceCategories.setDefaultCommand(CMD_CHANGE);
        this.choiceFirstUnit.addCommand(CMD_CALCULATOR);
        this.choiceFirstUnit.addCommand(CMD_CHANGE);
        this.choiceFirstUnit.setDefaultCommand(CMD_CHANGE);
        this.choiceSecondUnit.addCommand(CMD_CALCULATOR);
        this.choiceSecondUnit.addCommand(CMD_CHANGE);
        this.choiceSecondUnit.setDefaultCommand(CMD_CHANGE);
        this.mNumberInput.addCommand(CMD_CALCULATOR);
        this.mNumberOutput.addCommand(CMD_CALCULATOR);
        this.addCommand(CMD_LSK_EXIT);
        this.addCommand(CMD_HELP);
        this.addCommand(CMD_EXIT);
        this.setCommandListener(this);
        this.setItemStateListener(this);
        instance = this;
    }

    public static UnitConverterUI getInstance() {
        return instance;
    }

    public void show() {
        this.updateControls();
        this.choiceFirstUnit.location = 0;
        this.choiceSecondUnit.location = 0;
        this.mCalcDirection = true;
    }

    private void smartAddCommand(Item pItem, Command pCmd) {
        Hashtable cmdHash = (Hashtable)this.mCommandHash.get(pItem);
        if (!cmdHash.containsKey(pCmd)) {
            pItem.addCommand(pCmd);
            cmdHash.put(pCmd, pCmd);
        }
    }

    private void smartRemoveCommand(Item pItem, Command pCmd) {
        Hashtable cmdHash = (Hashtable)this.mCommandHash.get(pItem);
        if (cmdHash.containsKey(pCmd)) {
            pItem.removeCommand(pCmd);
            cmdHash.remove(pCmd);
        }
    }

    public void recalc(boolean pIsDirFromTo, double pValue) {
        UnitConverterData data = this.mCore.getDataObject();
        CalcConvApp app = CalcConvApp.getInstance();
        Category cat = data.getSelectedCategory();
        try {
            UnitConverterTextField destinationTextField;
            Unit to;
            Unit from;
            if (pIsDirFromTo) {
                from = cat.getFirstUnit();
                to = cat.getSecondUnit();
                destinationTextField = this.mNumberOutput;
            } else {
                from = cat.getSecondUnit();
                to = cat.getFirstUnit();
                destinationTextField = this.mNumberInput;
            }
            double result = UnitConverterUI.convert(pValue, from, to);
            try {
                destinationTextField.setString(CalcConvApp.getFormattedValue(result));
            }
            catch (Exception tfe) {
                destinationTextField.setString("-0.0");
                if (tfe instanceof UIException) {
                    if (CalcConvApp.getInstance().inTransition()) {
                        CalcConvApp.getInstance().setTransition(false);
                        CalcConvApp.getInstance().setTooBigValueException((UIException)tfe);
                    }
                    this.choiceCategories.isInChoice = true;
                    this.mNumberInput.setInChoice(true);
                    this.mNumberInput.initialize();
                    this.mNumberOutput.setInChoice(true);
                    this.mNumberOutput.initialize();
                    app.showAlert((UIException)tfe, (Displayable)this);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static double convert(double oprnd, Unit pFrom, Unit pTo) throws UIException {
        try {
            double factor = pTo.getFactor() / pFrom.getFactor();
            double offset = pTo.getOffset() - factor * pFrom.getOffset();
            return oprnd * factor + offset;
        }
        catch (Exception e) {
            throw new UIException(130);
        }
    }

    protected void updateGroup(BaseChoice choice, NameList list, int index) {
        if (choice == this.choiceCategories && choice.size() > 0) {
            choice.setSelectedIndex(index, true);
            return;
        }
        choice.deleteAll();
        if (index >= 0) {
            choice.append(list.getNameListEntry(index), null);
        }
        int i = 0;
        while (i < index) {
            choice.insert(i, list.getNameListEntry(i), null);
            ++i;
        }
        i = index + 1;
        while (i < list.getNameListSize()) {
            choice.append(list.getNameListEntry(i), null);
            ++i;
        }
        choice.setSelectedIndex(index, true);
    }

    protected void updateTable(ChoiceUI choice, NameList list, int index) {
        if (choice == this.choiceCategories && choice.size() > 0) {
            choice.setSelectedIndex(index, true);
            return;
        }
        choice.deleteAll();
        if (index >= 0) {
            choice.append(list.getNameListEntry(index), null);
        }
        int i = 0;
        while (i < index) {
            choice.insert(i, list.getNameListEntry(i), null);
            ++i;
        }
        i = index + 1;
        while (i < list.getNameListSize()) {
            choice.append(list.getNameListEntry(i), null);
            ++i;
        }
        choice.setSelectedIndex(index, true);
    }

    public void updateControls() {
        try {
            UnitConverterData data = this.mCore.getDataObject();
            int activeCategory = data.getSelectedCategoryIndex();
            Category cat = data.getCategory(activeCategory);
            try {
                CalcConvApp.getInstance().getPersistenceManager().waitForReadComplete(data, -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cat.size() == 0) {
                CalcConvApp.getInstance().enterState(3);
                return;
            }
            this.updateTable(this.choiceCategories, data, activeCategory);
            this.updateTable(this.choiceFirstUnit, cat, cat.getFirstIndex());
            this.updateTable(this.choiceSecondUnit, cat, cat.getSecondIndex());
            this.mNumberInput.setString(CalcConvApp.getFormattedValue(cat.getLastValue()));
            this.recalc(true, cat.getLastValue());
            this.updateCommands();
            if (this.mLastActiveItem != null) {
                CalcConvApp.getInstance().getDisplay().setCurrentItem(this.mLastActiveItem);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateCommands() {
        int activeCategory;
        UnitConverterData data = this.mCore.getDataObject();
        Category cat = data.getCategory(activeCategory = data.getSelectedCategoryIndex());
        if (cat.getChangeBaseAllowed()) {
            Unit from = cat.getFirstUnit();
            Unit to = cat.getSecondUnit();
            if (!from.isBaseUnit()) {
                this.smartAddCommand((Item)this.choiceFirstUnit, CMD_EDIT_RATE);
                this.smartAddCommand((Item)this.choiceFirstUnit, CMD_SET_AS_BASE);
                this.smartAddCommand((Item)this.choiceFirstUnit, CMD_DELETE);
            } else {
                this.smartRemoveCommand((Item)this.choiceFirstUnit, CMD_EDIT_RATE);
                this.smartRemoveCommand((Item)this.choiceFirstUnit, CMD_SET_AS_BASE);
                this.smartRemoveCommand((Item)this.choiceFirstUnit, CMD_DELETE);
            }
            if (!to.isBaseUnit()) {
                this.smartAddCommand((Item)this.choiceSecondUnit, CMD_EDIT_RATE);
                this.smartAddCommand((Item)this.choiceSecondUnit, CMD_SET_AS_BASE);
                this.smartAddCommand((Item)this.choiceSecondUnit, CMD_DELETE);
            } else {
                this.smartRemoveCommand((Item)this.choiceSecondUnit, CMD_EDIT_RATE);
                this.smartRemoveCommand((Item)this.choiceSecondUnit, CMD_SET_AS_BASE);
                this.smartRemoveCommand((Item)this.choiceSecondUnit, CMD_DELETE);
            }
            this.smartAddCommand((Item)this.choiceFirstUnit, CMD_ADD_CURRENCY);
            this.smartAddCommand((Item)this.choiceSecondUnit, CMD_ADD_CURRENCY);
            this.smartAddCommand((Item)this.mNumberInput, CMD_SIGN_CHANGE);
            this.smartAddCommand((Item)this.mNumberOutput, CMD_SIGN_CHANGE);
            this.smartAddCommand((Item)this.choiceFirstUnit, CMD_DELETE_ALL);
            this.smartAddCommand((Item)this.choiceSecondUnit, CMD_DELETE_ALL);
            this.smartAddCommand((Item)this.choiceCategories, CMD_ADD_CURRENCY);
        } else {
            this.smartAddCommand((Item)this.mNumberInput, CMD_SIGN_CHANGE);
            this.smartAddCommand((Item)this.mNumberOutput, CMD_SIGN_CHANGE);
            this.smartRemoveCommand((Item)this.mNumberInput, CMD_ADD_CURRENCY);
            this.smartRemoveCommand((Item)this.mNumberOutput, CMD_ADD_CURRENCY);
            this.smartRemoveCommand((Item)this.choiceCategories, CMD_ADD_CURRENCY);
            this.smartRemoveCommand((Item)this.choiceFirstUnit, CMD_EDIT_RATE);
            this.smartRemoveCommand((Item)this.choiceFirstUnit, CMD_SET_AS_BASE);
            this.smartRemoveCommand((Item)this.choiceFirstUnit, CMD_ADD_CURRENCY);
            this.smartRemoveCommand((Item)this.choiceFirstUnit, CMD_DELETE);
            this.smartRemoveCommand((Item)this.choiceFirstUnit, CMD_DELETE_ALL);
            this.smartRemoveCommand((Item)this.choiceSecondUnit, CMD_EDIT_RATE);
            this.smartRemoveCommand((Item)this.choiceSecondUnit, CMD_SET_AS_BASE);
            this.smartRemoveCommand((Item)this.choiceSecondUnit, CMD_ADD_CURRENCY);
            this.smartRemoveCommand((Item)this.choiceSecondUnit, CMD_DELETE);
            this.smartRemoveCommand((Item)this.choiceSecondUnit, CMD_DELETE_ALL);
        }
    }

    public void commandAction(Command pCommand, Displayable pDisplayable) {
        block22: {
            UnitConverterData data;
            CalcConvApp app;
            block21: {
                app = CalcConvApp.getInstance();
                data = this.mCore.getDataObject();
                if (!(pDisplayable instanceof MessageBox)) break block21;
                MessageBox box = (MessageBox)pDisplayable;
                switch (box.getBoxId()) {
                    case 1: {
                        break;
                    }
                    case 4: {
                        if (box.getResult() == 0) {
                            Application.openHelpResource(115);
                            break;
                        }
                        break block22;
                    }
                    case 3: {
                        if (box.getResult() == 1) {
                            Category cat = data.getSelectedCategory();
                            cat.deleteUnit(this.mCurrencyIndex);
                            app.getPersistenceManager().addToWriteQueue(data);
                            this.updateControls();
                            break;
                        }
                        break block22;
                    }
                    case 2: {
                        if (box.getResult() != 1) break block22;
                        Category cat = data.getSelectedCategory();
                        cat.deleteAll();
                        app.getPersistenceManager().addToWriteQueue(data);
                        this.mLastActiveItem = this.choiceCategories;
                        this.updateControls();
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block22;
            }
            if (pCommand == SELECT_COMMAND) {
                Category cat = data.getSelectedCategory();
                if (pDisplayable == this.listCategories) {
                    this.choiceCategories.isInChoice = false;
                    this.choiceCategories.location = 0;
                    data.setSelectedCategoryIndex(this.listCategories.getSelectedIndex());
                    this.updateControls();
                } else if (pDisplayable == this.listFirstUnit) {
                    cat.setFirstUnit(this.listFirstUnit.getSelectedIndex());
                    this.updateControls();
                } else if (pDisplayable == this.listSecondUnit) {
                    cat.setSecondUnit(this.listSecondUnit.getSelectedIndex());
                    this.updateControls();
                }
            } else if (pCommand == CMD_HELP) {
                Application.openHelpResource(131);
            } else if (pCommand == CMD_EXIT || pCommand == CMD_LSK_EXIT) {
                app.back();
                return;
            }
        }
    }

    public void commandAction(Command pCommand, Item pItem) {
        UnitConverterData data = this.mCore.getDataObject();
        CalcConvApp app = CalcConvApp.getInstance();
        Category cat = data.getSelectedCategory();
        this.mLastActiveItem = pItem;
        if (pCommand == CMD_EDIT_RATE) {
            ChoiceUI choiceGroup = (ChoiceUI)pItem;
            Unit unit = cat.getUnit(choiceGroup.getSelectedIndex());
            app.setDisplayable((Displayable)new AddOrEditCurrency(this.mCore, unit, 0));
            this.choiceCategories.isInChoice = true;
        } else if (pCommand == CMD_SIGN_CHANGE) {
            UnitConverterTextField textField = (UnitConverterTextField)pItem;
            if (textField.getString().length() != 0) {
                double value = -Double.parseDouble(textField.getString());
                try {
                    textField.setString(CalcConvApp.getFormattedValue(value));
                    this.recalc(pItem == this.mNumberInput, value);
                    cat.setLastValue(Double.parseDouble(this.mNumberInput.getString()));
                }
                catch (UIException uie) {
                    textField.setString("-0.0");
                }
            }
        } else if (pCommand == CMD_MEM_SAVE) {
            UnitConverterTextField textField = (UnitConverterTextField)pItem;
            if ("".equals(textField.getString())) {
                app.getShared().setMemoryValue(0.0);
            } else {
                app.getShared().setMemoryValue(Double.parseDouble(textField.getString()));
            }
        } else if (pCommand == CMD_MEM_RECALL) {
            UnitConverterTextField textField = (UnitConverterTextField)pItem;
            double value = app.getShared().getMemoryValue();
            if (Double.isNaN(value)) {
                value = 0.0;
            }
            try {
                textField.setString(CalcConvApp.getFormattedValue(value));
                this.recalc(pItem == this.mNumberInput, value);
                cat.setLastValue(Double.parseDouble(this.mNumberInput.getString()));
            }
            catch (UIException exc) {
                textField.setString("-0.0");
            }
        } else if (pCommand == CMD_ADD_CURRENCY) {
            int UnitIndex = 0;
            if (pItem == this.choiceFirstUnit) {
                UnitIndex = 1;
            }
            if (pItem == this.choiceSecondUnit) {
                UnitIndex = 2;
            }
            this.choiceCategories.isInChoice = true;
            app.setDisplayable((Displayable)new AddOrEditCurrency(this.mCore, null, UnitIndex));
        } else if (pCommand == CMD_SET_AS_BASE) {
            ChoiceUI choiceGroup = (ChoiceUI)pItem;
            Unit unit = cat.getUnit(choiceGroup.getSelectedIndex());
            if (!unit.isBaseUnit() && cat.getChangeBaseAllowed()) {
                this.mCurrencyIndex = choiceGroup.getSelectedIndex();
                cat = data.getSelectedCategory();
                try {
                    cat.changeBaseUnit(this.mCurrencyIndex);
                    app.getPersistenceManager().addToWriteQueue(this.mCore.getDataObject());
                    this.updateControls();
                    app.showMessageBox(1, -1, 123, AlertType.INFO, -1, 117, this, (Displayable)this);
                }
                catch (UIException uie) {
                    app.showAlert(uie, (Displayable)this);
                }
            }
        } else if (pCommand == CMD_DELETE) {
            ChoiceUI choiceGroup = (ChoiceUI)pItem;
            Unit unit = cat.getUnit(choiceGroup.getSelectedIndex());
            if (!unit.isBaseUnit()) {
                this.mCurrencyIndex = choiceGroup.getSelectedIndex();
                app.showMessageBoxPlainYesNo(3, null, String.valueOf(Application.getLocalizedText(110)) + " " + unit.getDisplayName(), this, (Displayable)this);
            } else {
                app.showMessageBox(4, -1, 124, AlertType.INFO, 1, 117, this, (Displayable)this);
            }
        } else if (pCommand == CMD_DELETE_ALL) {
            app.showMessageBoxYesNo(2, -1, 132, this, (Displayable)this);
        } else if (pCommand == CMD_CALCULATOR) {
            String number;
            this.choiceCategories.isInChoice = true;
            this.choiceFirstUnit.location = 0;
            this.choiceSecondUnit.location = 0;
            if (!(pItem != this.mNumberInput && pItem != this.mNumberOutput || "".equals(number = ((UnitConverterTextField)pItem).getString()))) {
                app.setTransferValue(Double.parseDouble(number));
            }
            app.enterState(1);
        } else if (pCommand == CMD_LSK_CLEAR) {
            UnitConverterTextField t = (UnitConverterTextField)pItem;
            t.clearLastDigit();
            t.modifyState();
        } else if (pCommand == CMD_CHANGE) {
            if (pItem == this.choiceCategories) {
                this.choiceCategories.isInChoice = true;
                this.mNumberInput.setInChoice(true);
                this.choiceCategories.location = 0;
                app.getDisplay().setCurrent((Displayable)this.choiceCategories.tempList);
            } else if (pItem == this.choiceFirstUnit) {
                this.choiceCategories.isInChoice = true;
                this.mNumberInput.setInChoice(true);
                this.choiceFirstUnit.location = 0;
                app.getDisplay().setCurrent((Displayable)this.choiceFirstUnit.tempList);
            } else if (pItem == this.choiceSecondUnit) {
                this.choiceCategories.isInChoice = true;
                this.mNumberInput.setInChoice(true);
                this.choiceFirstUnit.location = 0;
                this.choiceSecondUnit.location = 0;
                app.getDisplay().setCurrent((Displayable)this.choiceSecondUnit.tempList);
            }
        }
    }

    public void itemStateChanged(Item pItem) {
        UnitConverterData data = this.mCore.getDataObject();
        this.mLastActiveItem = pItem;
        try {
            if (pItem == this.choiceCategories) {
                data.setSelectedCategoryIndex(this.choiceCategories.getSelectedIndex());
                this.updateControls();
            } else if (pItem == this.choiceFirstUnit) {
                Category cat = data.getSelectedCategory();
                cat.setFirstUnit(this.choiceFirstUnit.getSelectedIndex());
                if (this.mCalcDirection) {
                    this.recalc(true, Double.parseDouble(this.mNumberInput.getString()));
                } else {
                    this.recalc(false, Double.parseDouble(this.mNumberOutput.getString()));
                }
                if (cat.getChangeBaseAllowed()) {
                    this.updateCommands();
                }
            } else if (pItem == this.choiceSecondUnit) {
                Category cat = data.getSelectedCategory();
                cat.setSecondUnit(this.choiceSecondUnit.getSelectedIndex());
                if (this.mCalcDirection) {
                    this.recalc(true, Double.parseDouble(this.mNumberInput.getString()));
                } else {
                    this.recalc(false, Double.parseDouble(this.mNumberOutput.getString()));
                }
                if (cat.getChangeBaseAllowed()) {
                    this.updateCommands();
                }
            } else if (pItem == this.mNumberInput) {
                Category cat = data.getSelectedCategory();
                double value = Double.parseDouble(this.mNumberInput.getString());
                this.mCalcDirection = true;
                if (!Double.isNaN(value)) {
                    this.recalc(this.mCalcDirection, value);
                    cat.setLastValue(value);
                }
            } else if (pItem == this.mNumberOutput) {
                Category cat = data.getSelectedCategory();
                double value = Double.parseDouble(this.mNumberOutput.getString());
                this.mCalcDirection = false;
                if (!Double.isNaN(value)) {
                    this.recalc(this.mCalcDirection, value);
                    cat.setLastValue(Double.parseDouble(this.mNumberInput.getString()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCategories() {
        this.choiceCategories.isInChoice = true;
    }

    public ChoiceUI getChoiceFirstUnit() {
        return this.choiceFirstUnit;
    }

    public ChoiceUI getChoiceCategories() {
        return this.choiceCategories;
    }
}

