/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app.calculatorconverter;

import com.siemens.mp.app.Application;
import com.siemens.mp.app.MessageBox;
import com.siemens.mp.app.calculatorconverter.CalcConvApp;
import com.siemens.mp.app.calculatorconverter.Category;
import com.siemens.mp.app.calculatorconverter.ChoiceCurrency;
import com.siemens.mp.app.calculatorconverter.UnitConverterCore;
import com.siemens.mp.app.calculatorconverter.UnitConverterData;
import com.siemens.mp.app.calculatorconverter.UnitConverterUI;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Spacer;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public class EnterNewBaseCurrency
extends Form
implements CommandListener,
ItemStateListener,
ItemCommandListener {
    private ChoiceGroup mCategory;
    private ChoiceCurrency mCat;
    private TextField mCurrencyName;
    private Command mCommandSave;
    private Command mCommandCalculator;
    private Command mCommandHelp;
    private Command mCommandExit;
    private Command mLSKCommandClear;
    private UnitConverterCore mCore;
    private boolean mQuitAfterConfirm;
    private static final int BOX_ID_SAVE = 0;
    private static final int BOX_ID_ERROR = 1;
    private List list;
    private static final Command CMD_CHANGE = new Command(Application.getLocalizedText(135), 4, 0);
    private static final Command SELECT_COMMAND = new Command(Application.getLocalizedText(117), 4, 0);
    private static EnterNewBaseCurrency instance;

    EnterNewBaseCurrency(UnitConverterCore pCore) {
        super(CalcConvApp.getInstance().getAppTitle());
        this.mCore = pCore;
        UnitConverterData data = this.mCore.getDataObject();
        this.mCommandSave = new Command(Application.getLocalizedText(0), 4, 1);
        this.mCommandCalculator = new Command(Application.getLocalizedText(104), 4, 2);
        this.mCommandHelp = new Command(Application.getLocalizedText(1), 4, 3);
        this.mCommandExit = new Command(Application.getLocalizedText(133), 4, 4);
        this.mLSKCommandClear = new Command(Application.getLocalizedText(5), 2, 1);
        this.mCategory = new ChoiceGroup(null, 4);
        this.mCategory.setLayout(512);
        this.list = new List("", 3);
        this.list.setCommandListener((CommandListener)this);
        this.list.setSelectCommand(SELECT_COMMAND);
        this.mCat = new ChoiceCurrency("", this.list, true);
        this.mCat.setReference();
        int i = 0;
        while (i < data.size()) {
            Category c = data.getCategory(i);
            this.mCat.append(c.getDisplayName(), null);
            ++i;
        }
        this.mCat.setSelectedIndex(data.getSelectedCategoryIndex(), true);
        this.mCat.setItemCommandListener(this);
        this.mCat.addCommand(CMD_CHANGE);
        this.mCat.setDefaultCommand(CMD_CHANGE);
        this.mCurrencyName = new TextField("", "", 10, 0);
        this.mCurrencyName.setLayout(512);
        this.mCurrencyName.addCommand(this.mLSKCommandClear);
        this.mCurrencyName.setItemCommandListener((ItemCommandListener)this);
        String text = Application.getLocalizedText(102);
        StringItem title = new StringItem("", text);
        if (UnitConverterUI.TOP_SPACE > 0) {
            this.append((Item)new Spacer(UnitConverterUI.TOP_SPACE, UnitConverterUI.TOP_SPACE));
        }
        this.append((Item)this.mCat);
        this.append((Item)new Spacer(UnitConverterUI.ITEM_SPACING, UnitConverterUI.ITEM_SPACING));
        this.append((Item)title);
        this.append((Item)new Spacer(UnitConverterUI.ITEM_SPACING, UnitConverterUI.ITEM_SPACING));
        this.append((Item)this.mCurrencyName);
        this.addCommand(this.mCommandSave);
        this.addCommand(this.mCommandCalculator);
        this.addCommand(this.mCommandHelp);
        this.addCommand(this.mCommandExit);
        this.setCommandListener(this);
        this.setItemStateListener(this);
        instance = this;
    }

    public static EnterNewBaseCurrency getInstance() {
        return instance;
    }

    private void askSave(boolean pQuitAfterConfirm) {
        CalcConvApp app = CalcConvApp.getInstance();
        this.mQuitAfterConfirm = pQuitAfterConfirm;
        app.showMessageBoxYesNo(0, -1, 128, this, (Displayable)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void commandAction(Command pCommand, Displayable pDisplayable) {
        UnitConverterData data = this.mCore.getDataObject();
        Category cat = data.getSelectedCategory();
        String name = this.mCurrencyName.getString().replace(',', '.');
        CalcConvApp app = CalcConvApp.getInstance();
        if (pDisplayable instanceof MessageBox) {
            MessageBox msg = (MessageBox)pDisplayable;
            if (msg.getBoxId() != 0) return;
            if (msg.getResult() == 1) {
                cat.addUnit(String.valueOf(name) + ",1,0,true", false);
                cat.setFirstUnit(0);
                cat.setSecondUnit(0);
                app.getPersistenceManager().addToWriteQueue(data);
            }
            if (this.mQuitAfterConfirm) {
                data.setSelectedCategoryIndex(0);
                app.enterState(2);
                return;
            }
            data.setSelectedCategoryIndex(this.mCategory.getSelectedIndex());
            app.enterState(2);
            return;
        }
        if (pCommand == this.mCommandSave) {
            UnitConverterUI.getInstance().getChoiceCategories().isInChoice = false;
            if (name.length() > 0) {
                cat.addUnit(String.valueOf(name) + ",1,0,true", false);
                cat.setFirstUnit(0);
                cat.setSecondUnit(0);
                app.getPersistenceManager().addToWriteQueue(data);
                app.enterState(2);
                return;
            }
            app.showMessageBox(1, -1, 121, AlertType.ERROR, -1, 117, this, (Displayable)this);
            return;
        }
        if (pCommand == this.mCommandCalculator) {
            app.enterState(1);
            return;
        }
        if (pCommand == this.mCommandHelp) {
            Application.openHelpResource(131);
            return;
        }
        if (pCommand != this.mCommandExit) {
            if (pCommand != SELECT_COMMAND) return;
            cat = data.getSelectedCategory();
            if (pDisplayable != this.list) return;
            data.setSelectedCategoryIndex(this.list.getSelectedIndex());
            UnitConverterUI.getInstance().updateControls();
            return;
        }
        if (name.length() > 0) {
            this.askSave(true);
            return;
        }
        app.quitApp();
    }

    public final void itemStateChanged(Item pItem) {
        UnitConverterData data = this.mCore.getDataObject();
        CalcConvApp app = CalcConvApp.getInstance();
        if (pItem == this.mCat) {
            if (this.mCurrencyName.getString().length() > 0) {
                this.askSave(false);
            } else {
                UnitConverterUI.getInstance().setCategories();
                data.setSelectedCategoryIndex(this.mCat.getSelectedIndex());
                app.enterState(2);
            }
        }
    }

    public final void commandAction(Command command, Item item) {
        if (item instanceof TextField) {
            TextField field = (TextField)item;
            if (command == this.mLSKCommandClear && field.getString().length() > 0) {
                field.delete(field.getCaretPosition() - 1, 1);
            }
        } else if (command == CMD_CHANGE && item == this.mCat) {
            CalcConvApp app = CalcConvApp.getInstance();
            app.getDisplay().setCurrent((Displayable)this.mCat.tempList);
        }
    }
}

