/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app.calculatorconverter;

import com.siemens.mp.app.Application;
import com.siemens.mp.app.UIException;
import com.siemens.mp.app.calculatorconverter.CalculatorCore;
import com.siemens.mp.app.calculatorconverter.EnterNewBaseCurrency;
import com.siemens.mp.app.calculatorconverter.SharedData;
import com.siemens.mp.app.calculatorconverter.UnitConverterCore;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;

public class CalcConvApp
extends Application
implements Runnable {
    static final int STATE_NONE = 0;
    public static final int STATE_CALC = 1;
    public static final int STATE_CONV = 2;
    static final int STATE_CONV_ENTER_BASE = 3;
    static final int STATE_CONV_BGLAUNCH = 4;
    private int mInitialState = 0;
    int mCurrentState = 0;
    private CalculatorCore mCalculatorCore = null;
    private UnitConverterCore mUnitConverterCore = null;
    private SharedData mSharedData;
    private double mTransferValue;
    static final int LIMES_0 = 0;
    static final int MAX_OUTPUT_DIGITS = 10;
    static final int MAX_DIGITS = 20;
    public static boolean SHOW_ALERT = false;
    private UIException tooBigValueException;
    private static boolean calledFromConv;
    private boolean inTransition;

    protected void initializeApp() {
        this.mSharedData = new SharedData();
        this.getPersistenceManager().addToReadQueue(this.mSharedData);
        this.mTransferValue = Double.NaN;
        this.enterState(this.mInitialState);
    }

    protected void suspendApp() {
    }

    protected void resumeApp() {
    }

    protected final void finalizeApp() {
        if (this.mUnitConverterCore != null) {
            this.mUnitConverterCore.saveData();
        }
        if (this.mCalculatorCore != null) {
            this.mCalculatorCore.saveData();
            this.mCalculatorCore.getUI().shutdown();
        }
    }

    protected final int getAppTitleResId() {
        return this.mCurrentState == 1 ? 104 : 112;
    }

    public static CalcConvApp getInstance() {
        return (CalcConvApp)Application.sThis;
    }

    public final void setInitialState(int pInitialState) {
        if (this.mInitialState == 0) {
            this.mInitialState = pInitialState;
        } else {
            System.err.println("CalcConvApp.setInitialState called twice.");
        }
    }

    public final void run() {
        this.mUnitConverterCore = new UnitConverterCore();
        this.enterState(2);
    }

    public final void enterState(int pNewState) {
        switch (pNewState) {
            case 1: {
                this.mCurrentState = pNewState;
                if (this.mCalculatorCore == null) {
                    this.mCalculatorCore = new CalculatorCore();
                }
                if (!Double.isNaN(this.mTransferValue)) {
                    this.mCalculatorCore.getUI().setInputLine(this.mTransferValue);
                    this.mTransferValue = Double.NaN;
                }
                if (this.mInitialState == 2) {
                    CalcConvApp.setCalledFromConverter(true);
                }
                this.mCalculatorCore.activate();
                break;
            }
            case 2: {
                if (this.mUnitConverterCore == null) {
                    this.mCurrentState = 4;
                    Form f = new Form(CalcConvApp.getInstance().getAppTitle());
                    this.mDisplay.setCurrent((Displayable)f);
                    new Thread(this).start();
                    break;
                }
                this.mCurrentState = pNewState;
                if (!Double.isNaN(this.mTransferValue)) {
                    this.mUnitConverterCore.getDataObject().getSelectedCategory().setLastValue(this.mTransferValue);
                    this.mTransferValue = Double.NaN;
                    this.inTransition = true;
                }
                this.mUnitConverterCore.activate();
                break;
            }
            case 3: {
                this.mCurrentState = pNewState;
                if (this.mUnitConverterCore == null) {
                    this.mUnitConverterCore = new UnitConverterCore();
                }
                this.mUnitConverterCore.setChoice();
                this.setDisplayable((Displayable)new EnterNewBaseCurrency(this.mUnitConverterCore));
            }
        }
    }

    public final SharedData getShared() {
        return this.mSharedData;
    }

    public final void setTransferValue(double pValue) {
        this.mTransferValue = pValue;
    }

    public final Display getDisplay() {
        return this.mDisplay;
    }

    public static String[] splitString(String pText, String pDelimiter) {
        int pos;
        Vector<String> v = new Vector<String>();
        int startPos = 0;
        while ((pos = pText.indexOf(pDelimiter, startPos)) >= 0) {
            v.addElement(pText.substring(startPos, pos).trim());
            startPos = pos + pDelimiter.length();
        }
        if (startPos < pText.length()) {
            v.addElement(pText.substring(startPos).trim());
        }
        Object[] strList = new String[v.size()];
        v.copyInto(strList);
        return strList;
    }

    public final void back() {
        if (this.mCurrentState == this.mInitialState) {
            this.quitApp();
        } else {
            this.enterState(this.mInitialState);
        }
    }

    public static String getFormattedValue(double value) throws UIException {
        int i;
        byte[] digits = new byte[20];
        double absValue = Math.abs(value);
        if (absValue <= 0.0) {
            return "0";
        }
        String sign = value < 0.0 ? "-" : "";
        String numStr = Double.toString(absValue);
        if (Double.isInfinite(absValue)) {
            throw new UIException(129);
        }
        boolean fixedPoint = absValue >= 1.0E-5 && absValue <= 9.999999999E9;
        int decimalAt = -1;
        int count = 0;
        int exponent = 0;
        int leadingZerosAfterDecimal = 0;
        boolean nonZeroDigitSeen = false;
        int i2 = 0;
        while (i2 < numStr.length()) {
            char c = numStr.charAt(i2);
            if (c == '.') {
                decimalAt = count;
            } else {
                if (c == 'e' || c == 'E') {
                    exponent = Integer.valueOf(numStr.substring(i2 + 1));
                    break;
                }
                if (count < 20) {
                    if (!nonZeroDigitSeen) {
                        boolean bl = nonZeroDigitSeen = c != '0';
                        if (!nonZeroDigitSeen && decimalAt != -1) {
                            ++leadingZerosAfterDecimal;
                        }
                    }
                    if (nonZeroDigitSeen) {
                        digits[count++] = (byte)c;
                    }
                }
            }
            ++i2;
        }
        if (decimalAt == -1) {
            decimalAt = count;
        }
        if (nonZeroDigitSeen) {
            decimalAt += exponent - leadingZerosAfterDecimal;
        }
        boolean needRounding = true;
        if (fixedPoint) {
            if (-decimalAt > 10) {
                count = 0;
                needRounding = false;
            } else if (-decimalAt == 10) {
                if (digits[0] >= 53) {
                    count = 1;
                    ++decimalAt;
                    digits[0] = 49;
                } else {
                    count = 0;
                }
                needRounding = false;
            }
        }
        while (count > 1 && digits[count - 1] == 48) {
            --count;
        }
        int maximumDigits = 10;
        if (needRounding && maximumDigits >= 0 && maximumDigits < count) {
            if (digits[maximumDigits] >= 53) {
                do {
                    if (--maximumDigits < 0) {
                        digits[0] = 49;
                        ++decimalAt;
                        maximumDigits = 0;
                        break;
                    }
                    int n = maximumDigits;
                    digits[n] = (byte)(digits[n] + 1);
                } while (digits[maximumDigits] > 57);
                ++maximumDigits;
            }
            count = maximumDigits;
            while (count > 1 && digits[count - 1] == 48) {
                --count;
            }
        }
        if (decimalAt > 100) {
            throw new UIException(129);
        }
        if (decimalAt < -98) {
            return "0";
        }
        StringBuffer output = new StringBuffer(sign);
        if (fixedPoint) {
            if (decimalAt <= 0) {
                output.append("0.");
                i = 0;
                while (i < -decimalAt) {
                    output.append("0");
                    ++i;
                }
                int loops = Math.min(count, 10 + decimalAt - 1);
                int i3 = 0;
                while (i3 < loops) {
                    output.append((char)digits[i3]);
                    ++i3;
                }
            } else {
                i = 0;
                while (i < count) {
                    if (i == decimalAt) {
                        output.append(".");
                    }
                    output.append((char)digits[i]);
                    ++i;
                }
                i = count;
                while (i < decimalAt) {
                    output.append("0");
                    ++i;
                }
            }
        } else {
            --decimalAt;
            output.append((char)digits[0]);
            if (count > 1) {
                output.append(".");
            }
            i = 1;
            while (i < count) {
                output.append((char)digits[i]);
                ++i;
            }
            output.append("e").append(decimalAt);
        }
        return output.toString();
    }

    public final void setTooBigValueException(UIException e) {
        SHOW_ALERT = true;
        this.tooBigValueException = e;
    }

    public final UIException getTooBigValueException() {
        return this.tooBigValueException;
    }

    public final void setTransition(boolean inTransition) {
        this.inTransition = inTransition;
    }

    public final boolean inTransition() {
        return this.inTransition;
    }

    public final int getInitialState() {
        return this.mInitialState;
    }

    public static boolean isCalcCalledFromConv() {
        return calledFromConv;
    }

    static void setCalledFromConverter(boolean isCalledFromConv) {
        calledFromConv = isCalledFromConv;
    }
}

