/*
 * Decompiled with CFR 0.152.
 */
package com.innograte.j2me.games.minefield;

import com.innograte.j2me.games.minefield.MinefieldMidlet;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MineCanvas
extends Canvas
implements CommandListener {
    public static byte[] NUM_OF_MINES = new byte[]{10, 40, 99};
    public static byte[] NUM_CELL_X = new byte[]{9, 16, 30};
    public static byte[] NUM_CELL_Y = new byte[]{9, 16, 16};
    public byte curNumOfMines;
    public byte curNumCellsX;
    public byte curNumCellsY;
    public static final byte UNKNOWN = -1;
    public static final byte FLAGGED = 16;
    public static final byte UNCOVERED = 0;
    private byte[][] flagPosition;
    public static final byte CLEAR = 3;
    public static final byte MINE = 4;
    private byte[][] minePosition;
    public static final byte PLAYING = 5;
    public static final byte GAMEOVER = 6;
    public static final byte COMPLETED = 7;
    private Command quitCommand = new Command("Menu", 6, 3);
    private Command restartCommand = new Command("Restart", 1, 1);
    private short canvasWidth;
    private short canvasHeight;
    private short viewStartX;
    private short viewStartY;
    private short viewWidth;
    private short viewHeight;
    private short halfViewWidth;
    private short halfViewHeight;
    private short boardWidth;
    private short boardHeight;
    private short boardStartX;
    private short boardStartY;
    private short boardEndX;
    private short boardEndY;
    private short cellWidth;
    private short cellHeight;
    private short halfCellWidth;
    private short halfCellHeight;
    private short hudStartX;
    private short hudStartY;
    private short hudWidth;
    private short hudHeight;
    private Random rand = new Random();
    private Font font;
    private Image button;
    private Image[] numberImages;
    private Image flagImage;
    private Image mineImage;
    private Image boomImage;
    private Image boardImage;
    private Graphics boardImageGraphics;
    private Image frameBuffer;
    private Graphics frameBufferGraphics;
    private MinefieldMidlet minesMidlet;
    private byte selectionX;
    private byte selectionY;
    public byte currentMode;
    private byte bombsLeft;
    public int timeElapsed;
    public long lastEventTime = 0L;
    public long lastSelectionBoxDrawTime = 0L;
    public boolean updateHud;
    public boolean drawSelectionBox;
    public int inputBuffer = -1;
    public int played = 0;

    public MineCanvas(MinefieldMidlet aMinesMidlet) throws Exception {
        int i;
        this.minesMidlet = aMinesMidlet;
        this.curNumOfMines = NUM_OF_MINES[this.minesMidlet.difficultyLevel];
        this.curNumCellsX = NUM_CELL_X[this.minesMidlet.difficultyLevel];
        this.curNumCellsY = NUM_CELL_Y[this.minesMidlet.difficultyLevel];
        this.currentMode = (byte)5;
        this.canvasWidth = (short)this.getWidth();
        this.canvasHeight = (short)this.getHeight();
        this.flagPosition = new byte[this.curNumCellsX][this.curNumCellsY];
        this.minePosition = new byte[this.curNumCellsX][this.curNumCellsY];
        this.button = Image.createImage((String)"/images/uncovered.png");
        this.flagImage = Image.createImage((String)"/images/flag.png");
        this.mineImage = Image.createImage((String)"/images/mine.png");
        this.boomImage = Image.createImage((String)"/images/boom.png");
        this.numberImages = new Image[9];
        for (i = 0; i < 9; i = (int)((byte)(i + 1))) {
            this.numberImages[i] = Image.createImage((String)String.valueOf(String.valueOf(new StringBuffer("/images/").append(i).append(".png"))));
        }
        this.font = Font.getFont((int)0, (int)0, (int)8);
        this.cellWidth = (short)this.button.getWidth();
        this.cellHeight = (short)this.button.getHeight();
        this.halfCellWidth = (short)(this.cellWidth / 2);
        this.halfCellHeight = (short)(this.cellHeight / 2);
        this.boardWidth = (short)(this.cellWidth * this.curNumCellsX + 1);
        this.boardHeight = (short)(this.cellHeight * this.curNumCellsY + 1);
        this.hudHeight = (short)this.font.getHeight();
        this.viewStartX = 0;
        this.viewWidth = this.canvasWidth;
        short s = this.hudWidth = this.viewWidth > this.boardWidth ? this.boardWidth : this.viewWidth;
        if (this.boardHeight >= this.canvasHeight - this.hudHeight) {
            this.viewStartY = 0;
            this.viewHeight = (short)(this.canvasHeight - this.hudHeight);
        } else {
            this.viewStartY = (short)((this.canvasHeight - this.boardHeight - this.hudHeight) / 2);
            this.viewHeight = this.boardHeight;
        }
        this.halfViewWidth = (short)(this.viewWidth / 2);
        this.halfViewHeight = (short)(this.viewHeight / 2);
        this.hudStartX = this.viewStartX;
        this.hudStartY = (short)(this.viewStartY + this.viewHeight);
        this.selectionX = 0;
        this.selectionY = 0;
        i = this.selectionY * this.cellWidth;
        this.boardStartX = this.boardWidth <= this.canvasWidth ? (short)((this.canvasWidth - this.boardWidth) / 2) : (i + this.cellWidth / 2 <= this.halfViewWidth ? (short)0 : (i + this.cellWidth / 2 >= this.boardWidth - this.halfViewWidth ? (short)(this.viewWidth - this.boardWidth) : (short)(this.halfViewWidth - i - this.cellWidth / 2)));
        this.hudStartX = this.boardStartX;
        int j = this.selectionY * this.cellHeight;
        this.boardStartY = this.boardHeight <= this.canvasHeight - this.hudHeight ? (short)((this.canvasHeight - this.boardHeight - this.hudHeight) / 2) : (j + this.cellHeight / 2 <= this.halfViewHeight ? (short)0 : (j + this.cellHeight / 2 >= this.boardHeight - this.halfViewHeight ? (short)(this.viewHeight - this.boardHeight) : (short)(this.halfViewHeight - j - this.cellHeight / 2)));
        this.boardEndX = (short)(this.boardStartX + this.boardWidth);
        this.boardEndY = (short)(this.boardStartY + this.boardHeight);
        this.boardImage = Image.createImage((int)this.boardWidth, (int)this.boardHeight);
        this.boardImageGraphics = this.boardImage.getGraphics();
        this.frameBuffer = Image.createImage((int)this.canvasWidth, (int)this.canvasHeight);
        this.frameBufferGraphics = this.frameBuffer.getGraphics();
        this.frameBufferGraphics.setFont(this.font);
        this.frameBufferGraphics.setColor(255, 255, 255);
        this.frameBufferGraphics.fillRect(0, 0, (int)this.canvasWidth, (int)this.canvasHeight);
        this.bombsLeft = this.curNumOfMines;
        this.timeElapsed = 0;
        this.resetPosition();
        this.setCommandListener(this);
        this.addCommand(this.quitCommand);
        this.repaintAll();
    }

    protected void showNotify() {
        this.lastEventTime = System.currentTimeMillis();
        this.minesMidlet.animator.enable();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.quitCommand) {
            MinefieldMidlet.restart();
        } else if (command == this.restartCommand) {
            this.currentMode = (byte)5;
            this.inputBuffer = -1;
            this.played = 0;
            this.selectionX = 0;
            this.selectionY = 0;
            this.bombsLeft = this.curNumOfMines;
            this.timeElapsed = 0;
            this.resetPosition();
            this.frameBufferGraphics.setColor(255, 255, 255);
            this.frameBufferGraphics.fillRect(0, 0, (int)this.canvasWidth, (int)this.canvasHeight);
            this.removeCommand(this.restartCommand);
            this.repaintAll();
            this.lastEventTime = System.currentTimeMillis();
            this.minesMidlet.animator.enable();
        }
    }

    public synchronized void updateWorld() {
        this.isShown();
        this.updateHud = false;
        if (this.processPlayerInput(this.inputBuffer)) {
            this.drawSelectionBox = true;
            this.lastSelectionBoxDrawTime = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.lastSelectionBoxDrawTime >= 500L) {
            this.drawSelectionBox = !this.drawSelectionBox;
            this.lastSelectionBoxDrawTime = System.currentTimeMillis();
        }
        if (this.currentMode != 5) {
            return;
        }
        int y = this.selectionY * this.cellHeight + this.cellHeight / 2;
        if (this.boardEndY > this.hudStartY && y + this.boardStartY > this.halfViewHeight) {
            this.boardStartY = (short)(this.boardStartY - this.cellHeight / 3);
            this.boardEndY = (short)(this.boardStartY + this.boardHeight);
            if (this.boardEndY < this.hudStartY) {
                this.boardEndY = this.hudStartY;
                this.boardStartY = (short)(this.boardEndY - this.boardHeight);
            } else if (y + this.boardStartY < this.halfViewHeight) {
                this.boardStartY = (short)(this.halfViewHeight - y);
                this.boardEndY = (short)(this.boardStartY + this.boardHeight);
            }
        } else if (this.boardStartY < 0 && y + this.boardStartY < this.halfViewHeight) {
            this.boardStartY = (short)(this.boardStartY + this.cellHeight / 3);
            if (this.boardStartY > 0) {
                this.boardStartY = 0;
            } else if (y + this.boardStartY > this.halfViewHeight) {
                this.boardStartY = (short)(this.halfViewHeight - y);
            }
            this.boardEndY = (short)(this.boardStartY + this.boardHeight);
        }
        int x = this.selectionX * this.cellWidth + this.cellWidth / 2;
        if (this.boardEndX > this.viewStartX + this.viewWidth && x + this.boardStartX > this.halfViewWidth) {
            this.boardStartX = (short)(this.boardStartX - this.cellWidth / 3);
            this.boardEndX = (short)(this.boardStartX + this.boardWidth);
            if (this.boardEndX < this.viewStartX + this.viewWidth) {
                this.boardEndX = (short)(this.viewStartX + this.viewWidth);
                this.boardStartX = (short)(this.boardEndX - this.boardWidth);
            } else if (x + this.boardStartX < this.halfViewWidth) {
                this.boardStartX = (short)(this.halfViewWidth - x);
                this.boardEndX = (short)(this.boardStartX + this.boardWidth);
            }
        } else if (this.boardStartX < 0 && x + this.boardStartX < this.halfViewWidth) {
            this.boardStartX = (short)(this.boardStartX + this.cellWidth / 3);
            if (this.boardStartX > 0) {
                this.boardStartX = 0;
            } else if (x + this.boardStartX > this.halfViewWidth) {
                this.boardStartX = (short)(this.halfViewWidth - x);
            }
            this.boardEndX = (short)(this.boardStartX + this.boardWidth);
        }
        this.frameBufferGraphics.setClip((int)this.viewStartX, (int)this.viewStartY, (int)this.viewWidth, (int)this.viewHeight);
        this.frameBufferGraphics.drawImage(this.boardImage, (int)this.boardStartX, (int)this.boardStartY, 20);
        if (this.drawSelectionBox) {
            this.frameBufferGraphics.setColor(0, 0, 0);
        } else {
            this.frameBufferGraphics.setColor(255, 255, 255);
        }
        this.frameBufferGraphics.drawRect(this.selectionX * this.cellWidth + this.boardStartX, this.selectionY * this.cellHeight + this.boardStartY, this.cellWidth - 1, this.cellHeight - 1);
        long now = System.currentTimeMillis();
        int k = (int)(now - this.lastEventTime);
        int i1 = k / 1000;
        if (i1 >= 1) {
            this.lastEventTime = now - (long)(k % 1000);
            this.timeElapsed += i1;
            this.updateHud = true;
        }
        if (this.updateHud) {
            this.frameBufferGraphics.setClip((int)this.viewStartX, (int)this.viewStartY, (int)this.viewWidth, this.viewHeight + this.hudHeight);
            this.frameBufferGraphics.setClip(0, 0, (int)this.canvasWidth, (int)this.canvasHeight);
            this.repaintHud();
            this.repaint(this.viewStartX, this.viewStartY, this.viewWidth, this.viewHeight + this.hudHeight);
        } else {
            this.repaint(this.viewStartX, this.viewStartY, this.viewWidth, this.viewHeight);
        }
    }

    public void resetPosition() {
        int x;
        for (int x2 = 0; x2 < this.curNumCellsX; ++x2) {
            for (int y = 0; y < this.curNumCellsY; ++y) {
                this.flagPosition[x2][y] = -1;
                this.minePosition[x2][y] = 3;
            }
        }
        for (int i = 0; i < this.curNumOfMines; ++i) {
            int y;
            int n;
            while (this.minePosition[x = (n = Math.abs(this.rand.nextInt() % (this.curNumCellsX * this.curNumCellsY))) % this.curNumCellsX][y = n / this.curNumCellsX] == 4) {
            }
            this.minePosition[x][y] = 4;
        }
        this.boardImageGraphics.setColor(0, 0, 0);
        this.boardImageGraphics.drawRect(0, 0, this.boardWidth - 1, this.boardHeight - 1);
        for (int nx = 0; nx < this.curNumCellsX; ++nx) {
            x = nx * this.cellWidth;
            for (int ny = 0; ny < this.curNumCellsY; ++ny) {
                int y = ny * this.cellHeight;
                this.boardImageGraphics.drawImage(this.button, x, y, 20);
            }
        }
        this.frameBufferGraphics.setFont(this.font);
    }

    public void repaintHud() {
        this.frameBufferGraphics.setColor(255, 255, 255);
        this.frameBufferGraphics.fillRect((int)this.hudStartX, (int)this.hudStartY, (int)this.hudWidth, (int)this.hudHeight);
        this.frameBufferGraphics.setColor(0, 0, 0);
        this.frameBufferGraphics.drawString(String.valueOf(String.valueOf(new StringBuffer("").append(this.bombsLeft).append(" left"))), (int)this.hudStartX, (int)this.hudStartY, 20);
        this.frameBufferGraphics.drawString(String.valueOf(String.valueOf(new StringBuffer("").append(this.timeElapsed).append(" secs"))), this.hudStartX + this.hudWidth, (int)this.hudStartY, 24);
    }

    public synchronized void repaintAll() {
        this.frameBufferGraphics.setClip((int)this.viewStartX, (int)this.viewStartY, (int)this.viewWidth, (int)this.viewHeight);
        this.frameBufferGraphics.drawImage(this.boardImage, (int)this.boardStartX, (int)this.boardStartY, 20);
        this.frameBufferGraphics.drawRect(this.selectionX * this.cellWidth + this.boardStartX + 1, this.selectionY * this.cellHeight + this.boardStartY + 1, this.cellWidth - 2, this.cellHeight - 2);
        this.frameBufferGraphics.setClip(0, 0, (int)this.canvasWidth, (int)this.canvasHeight);
        this.repaintHud();
        if (this.currentMode == 6) {
            String s = "Game Over!";
            short w = (short)(this.font.stringWidth(s) + 4);
            short h = (short)(this.font.getHeight() + 2);
            short x = (short)((this.canvasWidth - w) / 2);
            short y = (short)((this.canvasHeight - h) / 2);
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.frameBufferGraphics.setColor(255, 255, 255);
            this.frameBufferGraphics.fillRect((int)x, (int)y, (int)w, (int)h);
            this.frameBufferGraphics.setColor(0, 0, 0);
            this.frameBufferGraphics.drawString(s, this.canvasWidth / 2, y + 2, 17);
            this.frameBufferGraphics.drawRect((int)x, (int)y, w - 1, (int)h);
        } else if (this.currentMode == 7) {
            String s1 = "CLEARED!";
            String s2 = String.valueOf(String.valueOf(new StringBuffer("in ").append(this.timeElapsed).append(" secs")));
            short w = (short)(this.font.stringWidth(s1) + 4);
            short h = (short)(this.font.getHeight() * 2 + 2);
            short x = (short)((this.canvasWidth - w) / 2);
            short y = (short)((this.canvasHeight - h) / 2);
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.frameBufferGraphics.setColor(255, 255, 255);
            this.frameBufferGraphics.fillRect((int)x, (int)y, (int)w, (int)h);
            this.frameBufferGraphics.setColor(0, 0, 0);
            this.frameBufferGraphics.drawString(s1, this.canvasWidth / 2, y + 2, 17);
            this.frameBufferGraphics.drawString(s2, this.canvasWidth / 2, y + this.font.getHeight() + 1, 17);
            this.frameBufferGraphics.drawRect((int)x, (int)y, w - 1, (int)h);
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        g.drawImage(this.frameBuffer, 0, 0, 20);
    }

    protected void keyRepeated(int key) {
        this.keyPressed(key);
    }

    protected void keyPressed(int key) {
        switch (key) {
            case 50: {
                this.inputBuffer = 1;
                break;
            }
            case 52: {
                this.inputBuffer = 2;
                break;
            }
            case 54: {
                this.inputBuffer = 5;
                break;
            }
            case 56: {
                this.inputBuffer = 6;
                break;
            }
            case 49: {
                this.inputBuffer = 10;
                break;
            }
            case 55: {
                this.inputBuffer = 11;
                break;
            }
            default: {
                this.inputBuffer = this.getGameAction(key);
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        if (x >= this.boardStartX && x < this.boardEndX && y >= this.boardStartY && y < this.boardEndY) {
            this.selectionX = (byte)((x - this.boardStartX) / this.cellWidth);
            this.selectionY = (byte)((y - this.boardStartY) / this.cellHeight);
            this.inputBuffer = 8;
        }
    }

    protected boolean processPlayerInput(int i) {
        if (this.currentMode == 5) {
            switch (i) {
                case 1: {
                    if (this.selectionY > 0) {
                        this.selectionY = (byte)(this.selectionY - 1);
                    }
                    this.inputBuffer = -1;
                    return true;
                }
                case 6: {
                    if (this.selectionY < this.curNumCellsY - 1) {
                        this.selectionY = (byte)(this.selectionY + 1);
                    }
                    this.inputBuffer = -1;
                    return true;
                }
                case 2: {
                    if (this.selectionX > 0) {
                        this.selectionX = (byte)(this.selectionX - 1);
                    }
                    this.inputBuffer = -1;
                    return true;
                }
                case 5: {
                    if (this.selectionX < this.curNumCellsX - 1) {
                        this.selectionX = (byte)(this.selectionX + 1);
                    }
                    this.inputBuffer = -1;
                    return true;
                }
                case 8: 
                case 9: {
                    if (this.minePosition[this.selectionX][this.selectionY] == 4) {
                        for (int x = 0; x < this.curNumCellsX; ++x) {
                            for (int y = 0; y < this.curNumCellsY; ++y) {
                                if (this.minePosition[x][y] != 4) continue;
                                this.flagPosition[x][y] = 0;
                                this.boardImageGraphics.drawImage(this.mineImage, this.cellWidth * x, this.cellHeight * y, 20);
                            }
                        }
                        this.boardImageGraphics.drawImage(this.boomImage, this.cellWidth * this.selectionX, this.cellHeight * this.selectionY, 20);
                        this.currentMode = (byte)6;
                        this.gameOver();
                        this.inputBuffer = -1;
                        return true;
                    }
                    ++this.played;
                    this.uncoverCell(this.selectionX, this.selectionY);
                    for (int x = 0; x < this.curNumCellsX; ++x) {
                        for (int y = 0; y < this.curNumCellsY; ++y) {
                            if (this.flagPosition[x][y] != -1 || this.minePosition[x][y] == 4) continue;
                            this.inputBuffer = -1;
                            return true;
                        }
                    }
                    this.currentMode = (byte)7;
                    this.gameOver();
                    this.inputBuffer = -1;
                    return true;
                }
                case 10: {
                    if (this.flagPosition[this.selectionX][this.selectionY] == -1) {
                        this.flagPosition[this.selectionX][this.selectionY] = 16;
                        this.boardImageGraphics.drawImage(this.flagImage, this.cellWidth * this.selectionX, this.cellHeight * this.selectionY, 20);
                        this.bombsLeft = (byte)(this.bombsLeft - 1);
                        this.updateHud = true;
                    } else if (this.flagPosition[this.selectionX][this.selectionY] == 16) {
                        this.flagPosition[this.selectionX][this.selectionY] = -1;
                        this.boardImageGraphics.drawImage(this.button, this.cellWidth * this.selectionX, this.cellHeight * this.selectionY, 20);
                        this.bombsLeft = (byte)(this.bombsLeft + 1);
                        this.updateHud = true;
                    }
                    this.inputBuffer = -1;
                    return true;
                }
                case 11: {
                    if (this.flagPosition[this.selectionX][this.selectionY] != -1 && this.flagPosition[this.selectionX][this.selectionY] != 16 && this.minePosition[this.selectionX][this.selectionY] != 4 && this.countNumCloseMines(this.selectionX, this.selectionY) <= this.countNumCloseFlags(this.selectionX, this.selectionY)) {
                        this.uncoverNeighbors(this.selectionX, this.selectionY);
                    }
                    this.inputBuffer = -1;
                    return true;
                }
            }
        }
        this.inputBuffer = -1;
        return false;
    }

    protected byte countNumCloseMines(byte x, byte y) {
        byte numCloseMines = 0;
        for (int dx = -1; dx <= 1; dx = (int)((byte)(dx + 1))) {
            byte cx = (byte)(dx + x);
            if (cx < 0 || cx >= this.curNumCellsX) continue;
            for (int dy = -1; dy <= 1; dy = (int)((byte)(dy + 1))) {
                byte cy;
                if (dx == 0 && dy == 0 || (cy = (byte)(dy + y)) < 0 || cy >= this.curNumCellsY || this.minePosition[cx][cy] != 4) continue;
                numCloseMines = (byte)(numCloseMines + 1);
            }
        }
        return numCloseMines;
    }

    protected byte countNumCloseFlags(byte x, byte y) {
        byte num = 0;
        for (int dx = -1; dx <= 1; dx = (int)((byte)(dx + 1))) {
            byte cx = (byte)(dx + x);
            if (cx < 0 || cx >= this.curNumCellsX) continue;
            for (int dy = -1; dy <= 1; dy = (int)((byte)(dy + 1))) {
                byte cy;
                if (dx == 0 && dy == 0 || (cy = (byte)(dy + y)) < 0 || cy >= this.curNumCellsY || this.flagPosition[cx][cy] != 16) continue;
                num = (byte)(num + 1);
            }
        }
        return num;
    }

    protected void uncoverCell(byte x, byte y) {
        if (this.flagPosition[x][y] == -1) {
            byte numNeighbors;
            this.flagPosition[x][y] = numNeighbors = this.countNumCloseMines(x, y);
            this.boardImageGraphics.drawImage(this.numberImages[numNeighbors], x * this.cellWidth, y * this.cellHeight, 20);
            if (numNeighbors == 0) {
                this.uncoverNeighbors(x, y);
                return;
            }
        }
    }

    protected void uncoverNeighbors(byte x, byte y) {
        for (int dx = -1; dx <= 1; dx = (int)((byte)(dx + 1))) {
            byte cx = (byte)(dx + x);
            if (cx < 0 || cx >= this.curNumCellsX) continue;
            for (int dy = -1; dy <= 1; dy = (int)((byte)(dy + 1))) {
                byte cy;
                if (dx == 0 && dy == 0 || (cy = (byte)(dy + y)) < 0 || cy >= this.curNumCellsY) continue;
                this.uncoverCell(cx, cy);
            }
        }
    }

    protected void gameOver() {
        this.minesMidlet.animator.disable();
        for (byte x = 0; x < this.curNumCellsX; x = (byte)(x + 1)) {
            for (byte y = 0; y < this.curNumCellsY; y = (byte)(y + 1)) {
                if (this.minePosition[x][y] != 4 || this.flagPosition[x][y] != -1) continue;
                this.flagPosition[x][y] = 16;
            }
        }
        this.addCommand(this.restartCommand);
        if (this.currentMode == 7) {
            this.repaintAll();
            this.minesMidlet.highScore.processNewScore(this.timeElapsed, (Displayable)this);
        } else {
            this.repaintAll();
        }
        this.lastEventTime = System.currentTimeMillis();
    }

    static {
        UNKNOWN = (byte)-1;
        FLAGGED = (byte)16;
        UNCOVERED = 0;
        CLEAR = (byte)3;
        MINE = (byte)4;
        PLAYING = (byte)5;
        GAMEOVER = (byte)6;
        COMPLETED = (byte)7;
    }
}

