/*
 * Decompiled with CFR 0.152.
 */
package com.innograte.j2me.games.minefield;

import com.innograte.j2me.games.minefield.MinefieldMidlet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class HighScore
extends Canvas
implements CommandListener {
    public final String HIGH_SCORE_RS_NAME;
    public final int numOfHighScores;
    public String[] highScoreNames;
    public int[] highScores;
    private Command backCommand = new Command("Back", 2, 1);
    private Command nameInputConfirmCommand = new Command("OK", 4, 1);
    public MinefieldMidlet minesMidlet;
    public Displayable previousDisplayable = null;
    public int newHighScoreIndex;
    public TextField userInputName;

    public HighScore(MinefieldMidlet aMinesMidlet) {
        this.HIGH_SCORE_RS_NAME = "MinesHighScore";
        this.numOfHighScores = 12;
        this.minesMidlet = aMinesMidlet;
        this.highScoreNames = new String[12];
        this.highScores = new int[12];
        Object obj = null;
        try {
            RecordStore recordstore = RecordStore.openRecordStore((String)"MinesHighScore", (boolean)true);
            if (recordstore.getNumRecords() == 0) {
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                DataOutputStream dataoutputstream = new DataOutputStream(bytearrayoutputstream);
                dataoutputstream.writeInt(999);
                String s = "Empty.";
                for (int i = 0; i < 12; ++i) {
                    this.highScores[i] = 999;
                    this.highScoreNames[i] = s;
                    recordstore.addRecord(s.getBytes(), 0, s.getBytes().length);
                    recordstore.addRecord(bytearrayoutputstream.toByteArray(), 0, 4);
                }
                recordstore.closeRecordStore();
            } else {
                for (int j = 0; j < 12; ++j) {
                    ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(recordstore.getRecord(j * 2 + 2));
                    DataInputStream datainputstream = new DataInputStream(bytearrayinputstream);
                    this.highScores[j] = datainputstream.readInt();
                    this.highScoreNames[j] = new String(recordstore.getRecord(j * 2 + 1));
                }
                recordstore.closeRecordStore();
            }
            this.addCommand(this.backCommand);
            this.setCommandListener(this);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            exception.printStackTrace();
        }
    }

    protected void showNotify() {
        this.repaint();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backCommand) {
            Display.getDisplay((MIDlet)this.minesMidlet).setCurrent(this.previousDisplayable);
        } else if (command == this.nameInputConfirmCommand) {
            try {
                this.highScoreNames[this.newHighScoreIndex] = this.userInputName.getString().length() > 0 ? this.userInputName.getString() : " ";
                RecordStore recordstore = RecordStore.openRecordStore((String)"MinesHighScore", (boolean)true);
                int i = this.minesMidlet.difficultyLevel * 4;
                int j = i + 4;
                for (int k = i; k < j; ++k) {
                    ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                    DataOutputStream dataoutputstream = new DataOutputStream(bytearrayoutputstream);
                    dataoutputstream.writeInt(this.highScores[k]);
                    recordstore.setRecord(k * 2 + 2, bytearrayoutputstream.toByteArray(), 0, 4);
                    recordstore.setRecord(k * 2 + 1, this.highScoreNames[k].getBytes(), 0, this.highScoreNames[k].getBytes().length);
                }
                recordstore.closeRecordStore();
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                exception.printStackTrace();
            }
            Display.getDisplay((MIDlet)this.minesMidlet).setCurrent((Displayable)this);
        }
    }

    public void paint(Graphics g) {
        int byte0 = 2;
        int y = 3;
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), byte0);
        g.fillRect(0, byte0, byte0, this.getHeight());
        g.fillRect(this.getWidth() - byte0, 0, byte0, this.getHeight());
        g.fillRect(0, this.getHeight() - byte0, this.getWidth(), byte0);
        Font font = Font.getFont((int)0, (int)1, (int)0);
        g.setFont(font);
        g.drawString("High Scores", this.getWidth() / 2, y, 17);
        g.drawString(MinefieldMidlet.DIFFICULTY_STRINGS[this.minesMidlet.difficultyLevel], this.getWidth() / 2, y += font.getHeight(), 17);
        g.fillRect(byte0, y += font.getHeight(), this.getWidth(), byte0);
        y += byte0 + 1;
        font = Font.getFont((int)0, (int)0, (int)0);
        g.setFont(font);
        int j = this.minesMidlet.difficultyLevel * 4;
        int k = j + 4;
        for (int l = j; l < k; ++l) {
            g.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(l - j + 1))).append("-").append(this.highScoreNames[l]))), byte0 + 1, y, 20);
            g.drawString(String.valueOf(String.valueOf(this.highScores[l])).concat(" s"), this.getWidth() - byte0 - 1, y, 24);
            y += 12;
        }
    }

    public void processNewScore(int i, Displayable displayable) {
        this.previousDisplayable = displayable;
        int j = this.minesMidlet.difficultyLevel * 4;
        int k = j + 4;
        for (int l = j; l < k; ++l) {
            if (i >= this.highScores[l]) continue;
            for (byte byte0 = (byte)(k - 1); byte0 > l; byte0 = (byte)(byte0 - 1)) {
                this.highScores[byte0] = this.highScores[byte0 - 1];
                this.highScoreNames[byte0] = this.highScoreNames[byte0 - 1];
            }
            this.newHighScoreIndex = l;
            this.highScores[l] = i;
            Form form = new Form("New HighScore!");
            this.userInputName = new TextField(String.valueOf(String.valueOf(new StringBuffer("No.").append(l - j + 1).append(" ").append(i).append(" secs"))), "", 10, 0);
            form.append((Item)this.userInputName);
            form.addCommand(this.nameInputConfirmCommand);
            form.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this.minesMidlet).setCurrent((Displayable)form);
            break;
        }
    }

    public void displayHighScore(Displayable displayable) {
        this.previousDisplayable = displayable;
        Display.getDisplay((MIDlet)this.minesMidlet).setCurrent((Displayable)this);
    }
}

