/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.util.TimeZone;
import sun.util.calendar.BaseCalendar;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.Era;

public class JulianCalendar
extends BaseCalendar {
    private static final int BCE = 0;
    private static final int CE = 1;
    private static final Era[] eras = new Era[]{new Era("BeforeCommonEra", "B.C.E.", Long.MIN_VALUE, false), new Era("CommonEra", "C.E.", -62135709175808L, true)};
    private static final int JULIAN_EPOCH = -1;

    JulianCalendar() {
        this.setEras(eras);
    }

    public String getName() {
        return "julian";
    }

    public CalendarDate newCalendarDate() {
        return new Date();
    }

    public CalendarDate newCalendarDate(TimeZone timeZone) {
        return new Date(timeZone);
    }

    public long getFixedDate(int n2, int n3, int n4, BaseCalendar.Date date) {
        boolean bl2;
        boolean bl3 = bl2 = n3 == 1 && n4 == 1;
        if (date != null && date.hit(n2)) {
            if (bl2) {
                return date.getCachedJan1();
            }
            return date.getCachedJan1() + this.getDayOfYear(n2, n3, n4) - 1L;
        }
        long l2 = n2;
        long l3 = -2L + 365L * (l2 - 1L) + (long)n4;
        l3 = l2 > 0L ? (l3 += (l2 - 1L) / 4L) : (l3 += CalendarUtils.floorDivide(l2 - 1L, 4L));
        l3 = n3 >= 0 ? (l3 += (367L * (long)n3 - 362L) / 12L) : (l3 += CalendarUtils.floorDivide(367L * (long)n3 - 362L, 12L));
        if (n3 > 2) {
            l3 -= CalendarUtils.isJulianLeapYear(n2) ? 1L : 2L;
        }
        if (date != null && bl2) {
            date.setCache(n2, l3, CalendarUtils.isJulianLeapYear(n2) ? 366 : 365);
        }
        return l3;
    }

    public void getCalendarDateFromFixedDate(CalendarDate calendarDate, long l2) {
        int n2;
        Date date = (Date)calendarDate;
        long l3 = 4L * (l2 - -1L) + 1464L;
        int n3 = l3 >= 0L ? (int)(l3 / 1461L) : (int)CalendarUtils.floorDivide(l3, 1461L);
        int n4 = (int)(l2 - this.getFixedDate(n3, 1, 1, date));
        boolean bl2 = CalendarUtils.isJulianLeapYear(n3);
        if (l2 >= this.getFixedDate(n3, 3, 1, date)) {
            n4 += bl2 ? 1 : 2;
        }
        n2 = (n2 = 12 * n4 + 373) > 0 ? (n2 /= 367) : CalendarUtils.floorDivide(n2, 367);
        int n5 = (int)(l2 - this.getFixedDate(n3, n2, 1, date)) + 1;
        int n6 = JulianCalendar.getDayOfWeekFromFixedDate(l2);
        assert (n6 > 0) : "negative day of week " + n6;
        date.setNormalizedYear(n3);
        date.setMonth(n2);
        date.setDayOfMonth(n5);
        date.setDayOfWeek(n6);
        date.setLeapYear(bl2);
        date.setNormalized(true);
    }

    public int getYearFromFixedDate(long l2) {
        int n2 = (int)CalendarUtils.floorDivide(4L * (l2 - -1L) + 1464L, 1461L);
        return n2;
    }

    public int getDayOfWeek(CalendarDate calendarDate) {
        long l2 = this.getFixedDate(calendarDate);
        return JulianCalendar.getDayOfWeekFromFixedDate(l2);
    }

    boolean isLeapYear(int n2) {
        return CalendarUtils.isJulianLeapYear(n2);
    }

    private static class Date
    extends BaseCalendar.Date {
        protected Date() {
            this.setCache(1, -1L, 365);
        }

        protected Date(TimeZone timeZone) {
            super(timeZone);
            this.setCache(1, -1L, 365);
        }

        public Date setEra(Era era) {
            if (era == null) {
                throw new NullPointerException();
            }
            if (era != eras[0] || era != eras[1]) {
                throw new IllegalArgumentException("unknown era: " + era);
            }
            super.setEra(era);
            return this;
        }

        protected void setKnownEra(Era era) {
            super.setEra(era);
        }

        public int getNormalizedYear() {
            if (this.getEra() == eras[0]) {
                return 1 - this.getYear();
            }
            return this.getYear();
        }

        public void setNormalizedYear(int n2) {
            if (n2 <= 0) {
                this.setYear(1 - n2);
                this.setKnownEra(eras[0]);
            } else {
                this.setYear(n2);
                this.setKnownEra(eras[1]);
            }
        }

        public String toString() {
            String string;
            String string2 = super.toString();
            string2 = string2.substring(string2.indexOf(84));
            StringBuffer stringBuffer = new StringBuffer();
            Era era = this.getEra();
            if (era != null && (string = era.getAbbreviation()) != null) {
                stringBuffer.append(string).append(' ');
            }
            stringBuffer.append(this.getYear()).append('-');
            CalendarUtils.sprintf0d(stringBuffer, this.getMonth(), 2).append('-');
            CalendarUtils.sprintf0d(stringBuffer, this.getDayOfMonth(), 2);
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
    }
}

