/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.reflectiveObjects;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.reflectiveObjects.LazyReflectiveObjectGenerator;
import sun.reflect.generics.tree.FieldTypeSignature;
import sun.reflect.generics.visitor.Reifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeVariableImpl<D extends GenericDeclaration>
extends LazyReflectiveObjectGenerator
implements TypeVariable<D> {
    D genericDeclaration;
    private String name;
    private Type[] bounds;
    private FieldTypeSignature[] boundASTs;

    private TypeVariableImpl(D d2, String string, FieldTypeSignature[] fieldTypeSignatureArray, GenericsFactory genericsFactory) {
        super(genericsFactory);
        this.genericDeclaration = d2;
        this.name = string;
        this.boundASTs = fieldTypeSignatureArray;
    }

    private FieldTypeSignature[] getBoundASTs() {
        assert (this.bounds == null);
        return this.boundASTs;
    }

    public static <T extends GenericDeclaration> TypeVariableImpl<T> make(T t2, String string, FieldTypeSignature[] fieldTypeSignatureArray, GenericsFactory genericsFactory) {
        return new TypeVariableImpl<T>(t2, string, fieldTypeSignatureArray, genericsFactory);
    }

    @Override
    public Type[] getBounds() {
        if (this.bounds == null) {
            FieldTypeSignature[] fieldTypeSignatureArray = this.getBoundASTs();
            Type[] typeArray = new Type[fieldTypeSignatureArray.length];
            for (int i2 = 0; i2 < fieldTypeSignatureArray.length; ++i2) {
                Reifier reifier = this.getReifier();
                fieldTypeSignatureArray[i2].accept(reifier);
                typeArray[i2] = reifier.getResult();
            }
            this.bounds = typeArray;
        }
        return (Type[])this.bounds.clone();
    }

    @Override
    public D getGenericDeclaration() {
        return this.genericDeclaration;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (object instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)object;
            Object d2 = typeVariable.getGenericDeclaration();
            String string = typeVariable.getName();
            return (this.genericDeclaration == null ? d2 == null : this.genericDeclaration.equals(d2)) && (this.name == null ? string == null : this.name.equals(string)) && this.lazyBounds(typeVariable);
        }
        return false;
    }

    private boolean lazyBounds(TypeVariable typeVariable) {
        Object[] objectArray = this.getBounds();
        Object[] objectArray2 = typeVariable.getBounds();
        return Arrays.equals(objectArray, objectArray2);
    }

    public int hashCode() {
        return Arrays.hashCode(this.getBounds()) ^ this.genericDeclaration.hashCode() ^ this.name.hashCode();
    }
}

