/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.HashMap;
import sun.awt.DebugHelper;
import sun.awt.windows.WToolkit;

class WDesktopProperties {
    private static final DebugHelper dbg = DebugHelper.create(WDesktopProperties.class);
    private static final String PREFIX = "win.";
    private static final String FILE_PREFIX = "awt.file.";
    private static final String PROP_NAMES = "win.propNames";
    private long pData;
    private PropertyChangeSupport prChgSupport = new PropertyChangeSupport(this);
    private WToolkit wToolkit;
    private HashMap map = new HashMap();

    private static native void initIDs();

    static boolean isWindowsProperty(String string) {
        return string.startsWith(PREFIX) || string.startsWith(FILE_PREFIX);
    }

    WDesktopProperties(WToolkit wToolkit) {
        this.wToolkit = wToolkit;
        this.init();
        this.getWindowsParameters();
    }

    protected native void finalize();

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        this.prChgSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        this.prChgSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    private native void init();

    synchronized Object getProperty(String string) {
        if (string.equals(PROP_NAMES)) {
            return this.getKeyNames();
        }
        return this.map.get(string);
    }

    private String[] getKeyNames() {
        Object[] objectArray = this.map.keySet().toArray();
        Object[] objectArray2 = new String[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray2[i2] = objectArray[i2].toString();
        }
        Arrays.sort(objectArray2);
        return objectArray2;
    }

    private native void getWindowsParameters();

    private synchronized void setBooleanProperty(String string, boolean bl2) {
        this.map.put(string, new Boolean(bl2));
    }

    private synchronized void setIntegerProperty(String string, int n2) {
        this.map.put(string, new Integer(n2));
    }

    private synchronized void setStringProperty(String string, String string2) {
        this.map.put(string, string2);
    }

    private synchronized void setColorProperty(String string, int n2, int n3, int n4) {
        Color color = new Color(n2, n3, n4);
        this.map.put(string, color);
    }

    private synchronized void setFontProperty(String string, String string2, int n2, int n3) {
        Font font = new Font(string2, n2, n3);
        this.map.put(string, font);
        String string3 = string + ".height";
        Integer n4 = new Integer(n3);
        this.map.put(string3, n4);
    }

    private synchronized void setSoundProperty(String string, String string2) {
        WinPlaySound winPlaySound = new WinPlaySound(string2);
        this.map.put(string, winPlaySound);
    }

    private native void playWindowsSound(String var1);

    synchronized void firePropertyChanges() {
        EventQueue.invokeLater(new DiffPropertyChanges());
    }

    private synchronized void diffPropertyChanges() {
        HashMap hashMap = this.map;
        this.map = new HashMap();
        this.getWindowsParameters();
        String[] stringArray = this.getKeyNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Object v2;
            String string = stringArray[i2];
            Object v3 = hashMap.get(string);
            if (v3 == null == ((v2 = this.map.get(string)) == null) && (v3 == null || v3.equals(v2))) continue;
            this.wToolkit.clearDesktopProperty(string);
            this.prChgSupport.firePropertyChange(string, v3, v2);
        }
    }

    static {
        WDesktopProperties.initIDs();
    }

    class DiffPropertyChanges
    implements Runnable {
        DiffPropertyChanges() {
        }

        public void run() {
            WDesktopProperties.this.diffPropertyChanges();
        }
    }

    class WinPlaySound
    implements Runnable {
        String winEventName;

        WinPlaySound(String string) {
            this.winEventName = string;
        }

        public void run() {
            WDesktopProperties.this.playWindowsSound(this.winEventName);
        }

        public String toString() {
            return "WinPlaySound(" + this.winEventName + ")";
        }
    }
}

