/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

public class DefaultHighlighter
extends LayeredHighlighter {
    private static final Highlighter.Highlight[] noHighlights = new Highlighter.Highlight[0];
    private Vector highlights = new Vector();
    private JTextComponent component;
    private boolean drawsLayeredHighlights = true;
    private SafeDamager safeDamager = new SafeDamager();
    public static final LayeredHighlighter.LayerPainter DefaultPainter = new DefaultHighlightPainter(null);

    public void paint(Graphics graphics) {
        int n2 = this.highlights.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            HighlightInfo highlightInfo = (HighlightInfo)this.highlights.elementAt(i2);
            if (highlightInfo instanceof LayeredHighlightInfo) continue;
            Rectangle rectangle = this.component.getBounds();
            Insets insets = this.component.getInsets();
            rectangle.x = insets.left;
            rectangle.y = insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            while (i2 < n2) {
                highlightInfo = (HighlightInfo)this.highlights.elementAt(i2);
                if (!(highlightInfo instanceof LayeredHighlightInfo)) {
                    Highlighter.HighlightPainter highlightPainter = highlightInfo.getPainter();
                    highlightPainter.paint(graphics, highlightInfo.getStartOffset(), highlightInfo.getEndOffset(), rectangle, this.component);
                }
                ++i2;
            }
        }
    }

    public void install(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        this.removeAllHighlights();
    }

    public void deinstall(JTextComponent jTextComponent) {
        this.component = null;
    }

    public Object addHighlight(int n2, int n3, Highlighter.HighlightPainter highlightPainter) throws BadLocationException {
        Document document = this.component.getDocument();
        HighlightInfo highlightInfo = this.getDrawsLayeredHighlights() && highlightPainter instanceof LayeredHighlighter.LayerPainter ? new LayeredHighlightInfo() : new HighlightInfo();
        highlightInfo.painter = highlightPainter;
        highlightInfo.p0 = document.createPosition(n2);
        highlightInfo.p1 = document.createPosition(n3);
        this.highlights.addElement(highlightInfo);
        this.safeDamageRange(n2, n3);
        return highlightInfo;
    }

    public void removeHighlight(Object object) {
        if (object instanceof LayeredHighlightInfo) {
            LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)object;
            if (layeredHighlightInfo.width > 0 && layeredHighlightInfo.height > 0) {
                this.component.repaint(layeredHighlightInfo.x, layeredHighlightInfo.y, layeredHighlightInfo.width, layeredHighlightInfo.height);
            }
        } else {
            HighlightInfo highlightInfo = (HighlightInfo)object;
            this.safeDamageRange(highlightInfo.p0, highlightInfo.p1);
        }
        this.highlights.removeElement(object);
    }

    public void removeAllHighlights() {
        int n2;
        TextUI textUI = this.component.getUI();
        if (this.getDrawsLayeredHighlights()) {
            int n3 = this.highlights.size();
            if (n3 != 0) {
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = -1;
                int n9 = -1;
                for (int i2 = 0; i2 < n3; ++i2) {
                    HighlightInfo highlightInfo = (HighlightInfo)this.highlights.elementAt(i2);
                    if (highlightInfo instanceof LayeredHighlightInfo) {
                        LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)highlightInfo;
                        n4 = Math.min(n4, layeredHighlightInfo.x);
                        n5 = Math.min(n5, layeredHighlightInfo.y);
                        n6 = Math.max(n6, layeredHighlightInfo.x + layeredHighlightInfo.width);
                        n7 = Math.max(n7, layeredHighlightInfo.y + layeredHighlightInfo.height);
                        continue;
                    }
                    if (n8 == -1) {
                        n8 = highlightInfo.p0.getOffset();
                        n9 = highlightInfo.p1.getOffset();
                        continue;
                    }
                    n8 = Math.min(n8, highlightInfo.p0.getOffset());
                    n9 = Math.max(n9, highlightInfo.p1.getOffset());
                }
                if (n4 != n6 && n5 != n7) {
                    this.component.repaint(n4, n5, n6 - n4, n7 - n5);
                }
                if (n8 != -1) {
                    try {
                        this.safeDamageRange(n8, n9);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                this.highlights.removeAllElements();
            }
        } else if (textUI != null && (n2 = this.highlights.size()) != 0) {
            int n10 = Integer.MAX_VALUE;
            int n11 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                HighlightInfo highlightInfo = (HighlightInfo)this.highlights.elementAt(i3);
                n10 = Math.min(n10, highlightInfo.p0.getOffset());
                n11 = Math.max(n11, highlightInfo.p1.getOffset());
            }
            try {
                this.safeDamageRange(n10, n11);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.highlights.removeAllElements();
        }
    }

    public void changeHighlight(Object object, int n2, int n3) throws BadLocationException {
        Document document = this.component.getDocument();
        if (object instanceof LayeredHighlightInfo) {
            LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)object;
            if (layeredHighlightInfo.width > 0 && layeredHighlightInfo.height > 0) {
                this.component.repaint(layeredHighlightInfo.x, layeredHighlightInfo.y, layeredHighlightInfo.width, layeredHighlightInfo.height);
            }
            layeredHighlightInfo.height = 0;
            layeredHighlightInfo.width = 0;
            layeredHighlightInfo.p0 = document.createPosition(n2);
            layeredHighlightInfo.p1 = document.createPosition(n3);
            this.safeDamageRange(Math.min(n2, n3), Math.max(n2, n3));
        } else {
            HighlightInfo highlightInfo = (HighlightInfo)object;
            int n4 = highlightInfo.p0.getOffset();
            int n5 = highlightInfo.p1.getOffset();
            if (n2 == n4) {
                this.safeDamageRange(Math.min(n5, n3), Math.max(n5, n3));
            } else if (n3 == n5) {
                this.safeDamageRange(Math.min(n2, n4), Math.max(n2, n4));
            } else {
                this.safeDamageRange(n4, n5);
                this.safeDamageRange(n2, n3);
            }
            highlightInfo.p0 = document.createPosition(n2);
            highlightInfo.p1 = document.createPosition(n3);
        }
    }

    public Highlighter.Highlight[] getHighlights() {
        int n2 = this.highlights.size();
        if (n2 == 0) {
            return noHighlights;
        }
        Object[] objectArray = new Highlighter.Highlight[n2];
        this.highlights.copyInto(objectArray);
        return objectArray;
    }

    public void paintLayeredHighlights(Graphics graphics, int n2, int n3, Shape shape, JTextComponent jTextComponent, View view) {
        for (int i2 = this.highlights.size() - 1; i2 >= 0; --i2) {
            Object e2 = this.highlights.elementAt(i2);
            if (!(e2 instanceof LayeredHighlightInfo)) continue;
            LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)e2;
            int n4 = layeredHighlightInfo.getStartOffset();
            int n5 = layeredHighlightInfo.getEndOffset();
            if ((n2 >= n4 || n3 <= n4) && (n2 < n4 || n2 >= n5)) continue;
            layeredHighlightInfo.paintLayeredHighlights(graphics, n2, n3, shape, jTextComponent, view);
        }
    }

    private void safeDamageRange(Position position, Position position2) {
        this.safeDamager.damageRange(position, position2);
    }

    private void safeDamageRange(int n2, int n3) throws BadLocationException {
        Document document = this.component.getDocument();
        this.safeDamageRange(document.createPosition(n2), document.createPosition(n3));
    }

    public void setDrawsLayeredHighlights(boolean bl2) {
        this.drawsLayeredHighlights = bl2;
    }

    public boolean getDrawsLayeredHighlights() {
        return this.drawsLayeredHighlights;
    }

    public static class DefaultHighlightPainter
    extends LayeredHighlighter.LayerPainter {
        private Color color;

        public DefaultHighlightPainter(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        public void paint(Graphics graphics, int n2, int n3, Shape shape, JTextComponent jTextComponent) {
            Rectangle rectangle = shape.getBounds();
            try {
                TextUI textUI = jTextComponent.getUI();
                Rectangle rectangle2 = textUI.modelToView(jTextComponent, n2);
                Rectangle rectangle3 = textUI.modelToView(jTextComponent, n3);
                Color color = this.getColor();
                if (color == null) {
                    graphics.setColor(jTextComponent.getSelectionColor());
                } else {
                    graphics.setColor(color);
                }
                if (rectangle2.y == rectangle3.y) {
                    Rectangle rectangle4 = rectangle2.union(rectangle3);
                    graphics.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                } else {
                    int n4 = rectangle.x + rectangle.width - rectangle2.x;
                    graphics.fillRect(rectangle2.x, rectangle2.y, n4, rectangle2.height);
                    if (rectangle2.y + rectangle2.height != rectangle3.y) {
                        graphics.fillRect(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle3.y - (rectangle2.y + rectangle2.height));
                    }
                    graphics.fillRect(rectangle.x, rectangle3.y, rectangle3.x - rectangle.x, rectangle3.height);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public Shape paintLayer(Graphics graphics, int n2, int n3, Shape shape, JTextComponent jTextComponent, View view) {
            Color color = this.getColor();
            if (color == null) {
                graphics.setColor(jTextComponent.getSelectionColor());
            } else {
                graphics.setColor(color);
            }
            if (n2 == view.getStartOffset() && n3 == view.getEndOffset()) {
                Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                return rectangle;
            }
            try {
                Shape shape2 = view.modelToView(n2, Position.Bias.Forward, n3, Position.Bias.Backward, shape);
                Rectangle rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                return rectangle;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
    }

    class HighlightInfo
    implements Highlighter.Highlight {
        Position p0;
        Position p1;
        Highlighter.HighlightPainter painter;

        HighlightInfo() {
        }

        public int getStartOffset() {
            return this.p0.getOffset();
        }

        public int getEndOffset() {
            return this.p1.getOffset();
        }

        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }
    }

    class LayeredHighlightInfo
    extends HighlightInfo {
        int x;
        int y;
        int width;
        int height;

        LayeredHighlightInfo() {
        }

        void union(Shape shape) {
            if (shape == null) {
                return;
            }
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (this.width == 0 || this.height == 0) {
                this.x = rectangle.x;
                this.y = rectangle.y;
                this.width = rectangle.width;
                this.height = rectangle.height;
            } else {
                this.width = Math.max(this.x + this.width, rectangle.x + rectangle.width);
                this.height = Math.max(this.y + this.height, rectangle.y + rectangle.height);
                this.x = Math.min(this.x, rectangle.x);
                this.width -= this.x;
                this.y = Math.min(this.y, rectangle.y);
                this.height -= this.y;
            }
        }

        void paintLayeredHighlights(Graphics graphics, int n2, int n3, Shape shape, JTextComponent jTextComponent, View view) {
            int n4 = this.getStartOffset();
            int n5 = this.getEndOffset();
            n2 = Math.max(n4, n2);
            n3 = Math.min(n5, n3);
            this.union(((LayeredHighlighter.LayerPainter)this.painter).paintLayer(graphics, n2, n3, shape, jTextComponent, view));
        }
    }

    class SafeDamager
    implements Runnable {
        private Vector p0 = new Vector(10);
        private Vector p1 = new Vector(10);
        private Document lastDoc = null;

        SafeDamager() {
        }

        public synchronized void run() {
            TextUI textUI;
            if (DefaultHighlighter.this.component != null && (textUI = DefaultHighlighter.this.component.getUI()) != null && this.lastDoc == DefaultHighlighter.this.component.getDocument()) {
                int n2 = this.p0.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    textUI.damageRange(DefaultHighlighter.this.component, ((Position)this.p0.get(i2)).getOffset(), ((Position)this.p1.get(i2)).getOffset());
                }
            }
            this.p0.clear();
            this.p1.clear();
            this.lastDoc = null;
        }

        public synchronized void damageRange(Position position, Position position2) {
            if (DefaultHighlighter.this.component == null) {
                this.p0.clear();
                this.lastDoc = null;
                return;
            }
            boolean bl2 = this.p0.isEmpty();
            Document document = DefaultHighlighter.this.component.getDocument();
            if (document != this.lastDoc) {
                if (!this.p0.isEmpty()) {
                    this.p0.clear();
                    this.p1.clear();
                }
                this.lastDoc = document;
            }
            this.p0.add(position);
            this.p1.add(position2);
            if (bl2) {
                SwingUtilities.invokeLater(this);
            }
        }
    }
}

