/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.bs;
import sun.security.krb5.internal.crypto.k;

public class Config {
    private static Config a = null;
    private Hashtable b;
    private static boolean c = bs.ed;
    private static final int d = 1;
    private static final int e = 16;
    private static final int f = 256;
    private static final int g = 4096;
    private String h;

    public static synchronized Config getInstance() throws KrbException {
        if (a == null) {
            a = new Config();
        }
        return a;
    }

    public static synchronized void refresh() throws KrbException {
        a = new Config();
    }

    private Config() throws KrbException {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.security.krb5.kdc"));
        this.h = (String)AccessController.doPrivileged(new GetPropertyAction("java.security.krb5.realm"));
        if (string == null && this.h != null || this.h == null && string != null) {
            throw new KrbException("System property java.security.krb5.kdc and java.security.krb5.realm both must be set or neither must be set.");
        }
        if (string != null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("default_realm", this.h);
            string = string.replace(':', ' ');
            hashtable.put("kdc", string);
            this.b = new Hashtable();
            this.b.put("libdefaults", hashtable);
        } else {
            try {
                Vector vector = this.a();
                this.b = this.a(vector);
            }
            catch (IOException iOException) {
                KrbException krbException = new KrbException("Could not load configuration file " + iOException.getMessage());
                krbException.initCause(iOException);
                throw krbException;
            }
        }
    }

    public int getDefaultIntValue(String string) {
        String string2 = null;
        int n2 = Integer.MIN_VALUE;
        string2 = this.getDefault(string);
        if (string2 != null) {
            try {
                n2 = this.a(string2);
            }
            catch (NumberFormatException numberFormatException) {
                if (c) {
                    System.out.println("Exception in getting value of " + string + " " + numberFormatException.getMessage());
                    System.out.println("Setting " + string + " to minimum value");
                }
                n2 = Integer.MIN_VALUE;
            }
        }
        return n2;
    }

    public int getDefaultIntValue(String string, String string2) {
        String string3 = null;
        int n2 = Integer.MIN_VALUE;
        string3 = this.getDefault(string, string2);
        if (string3 != null) {
            try {
                n2 = this.a(string3);
            }
            catch (NumberFormatException numberFormatException) {
                if (c) {
                    System.out.println("Exception in getting value of " + string + " in section " + string2 + " " + numberFormatException.getMessage());
                    System.out.println("Setting " + string + " to minimum value");
                }
                n2 = Integer.MIN_VALUE;
            }
        }
        return n2;
    }

    public String getDefault(String string) {
        if (this.b == null) {
            return null;
        }
        return this.a(string, this.b);
    }

    private String a(String string, Hashtable hashtable) {
        String string2 = null;
        if (this.b != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                Object v2 = hashtable.get(string3);
                if (v2 instanceof Hashtable) {
                    string2 = this.a(string, (Hashtable)v2);
                    if (string2 == null) continue;
                    return string2;
                }
                if (!string3.equalsIgnoreCase(string)) continue;
                if (v2 instanceof String) {
                    return (String)hashtable.get(string3);
                }
                if (!(v2 instanceof Vector)) continue;
                string2 = "";
                int n2 = ((Vector)v2).size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    string2 = i2 == n2 - 1 ? string2 + (String)((Vector)v2).elementAt(i2) : string2 + (String)((Vector)v2).elementAt(i2) + " ";
                }
                return string2;
            }
        }
        return string2;
    }

    public String getDefault(String string, String string2) {
        String string3 = null;
        if (string.equalsIgnoreCase("kdc") && !string2.equalsIgnoreCase("libdefaults") && (String)AccessController.doPrivileged(new GetPropertyAction("java.security.krb5.kdc")) != null) {
            string3 = this.getDefault("kdc", "libdefaults");
            return string3;
        }
        if (this.b != null) {
            Enumeration enumeration = this.b.keys();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable;
                Object v2;
                String string4 = (String)enumeration.nextElement();
                Hashtable hashtable2 = (Hashtable)this.b.get(string4);
                if (string4.equalsIgnoreCase(string2)) {
                    if (!hashtable2.containsKey(string)) continue;
                    return (String)hashtable2.get(string);
                }
                if (!hashtable2.containsKey(string2) || !((v2 = hashtable2.get(string2)) instanceof Hashtable) || !(hashtable = (Hashtable)v2).containsKey(string)) continue;
                Object v3 = hashtable.get(string);
                if (v3 instanceof Vector) {
                    string3 = "";
                    int n2 = ((Vector)v3).size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        string3 = i2 == n2 - 1 ? string3 + (String)((Vector)v3).elementAt(i2) : string3 + (String)((Vector)v3).elementAt(i2) + " ";
                    }
                    continue;
                }
                string3 = (String)v3;
            }
        }
        return string3;
    }

    public boolean getDefaultBooleanValue(String string) {
        String string2 = null;
        string2 = this.b == null ? null : this.a(string, this.b);
        return string2 != null && string2.equalsIgnoreCase("true");
    }

    public boolean getDefaultBooleanValue(String string, String string2) {
        String string3 = this.getDefault(string, string2);
        return string3 != null && string3.equalsIgnoreCase("true");
    }

    private int a(String string) throws NumberFormatException {
        int n2 = 0;
        if (string.startsWith("+")) {
            String string2 = string.substring(1);
            return Integer.parseInt(string2);
        }
        if (string.startsWith("0x")) {
            String string3 = string.substring(2);
            char[] cArray = string3.toCharArray();
            if (cArray.length > 8) {
                throw new NumberFormatException();
            }
            block18: for (int i2 = 0; i2 < cArray.length; ++i2) {
                int n3 = cArray.length - i2 - 1;
                switch (cArray[i2]) {
                    case '0': {
                        n2 += 0;
                        continue block18;
                    }
                    case '1': {
                        n2 += 1 * this.a(n3);
                        continue block18;
                    }
                    case '2': {
                        n2 += 2 * this.a(n3);
                        continue block18;
                    }
                    case '3': {
                        n2 += 3 * this.a(n3);
                        continue block18;
                    }
                    case '4': {
                        n2 += 4 * this.a(n3);
                        continue block18;
                    }
                    case '5': {
                        n2 += 5 * this.a(n3);
                        continue block18;
                    }
                    case '6': {
                        n2 += 6 * this.a(n3);
                        continue block18;
                    }
                    case '7': {
                        n2 += 7 * this.a(n3);
                        continue block18;
                    }
                    case '8': {
                        n2 += 8 * this.a(n3);
                        continue block18;
                    }
                    case '9': {
                        n2 += 9 * this.a(n3);
                        continue block18;
                    }
                    case 'A': 
                    case 'a': {
                        n2 += 10 * this.a(n3);
                        continue block18;
                    }
                    case 'B': 
                    case 'b': {
                        n2 += 11 * this.a(n3);
                        continue block18;
                    }
                    case 'C': 
                    case 'c': {
                        n2 += 12 * this.a(n3);
                        continue block18;
                    }
                    case 'D': 
                    case 'd': {
                        n2 += 13 * this.a(n3);
                        continue block18;
                    }
                    case 'E': 
                    case 'e': {
                        n2 += 14 * this.a(n3);
                        continue block18;
                    }
                    case 'F': 
                    case 'f': {
                        n2 += 15 * this.a(n3);
                        continue block18;
                    }
                    default: {
                        throw new NumberFormatException("Invalid numerical format");
                    }
                }
            }
            if (n2 < 0) {
                throw new NumberFormatException("Data overflow.");
            }
        } else {
            n2 = Integer.parseInt(string);
        }
        return n2;
    }

    private int a(int n2) {
        int n3 = 16;
        switch (n2) {
            case 0: {
                n3 = 1;
                break;
            }
            case 1: {
                n3 = 16;
                break;
            }
            case 2: {
                n3 = 256;
                break;
            }
            case 3: {
                n3 = 4096;
                break;
            }
            default: {
                for (int i2 = 1; i2 < n2; ++i2) {
                    n3 *= 16;
                }
            }
        }
        return n3;
    }

    private String a(String string, String string2) {
        String string3;
        if (this.b != null && (string3 = (String)((Hashtable)this.b.get(string)).get(string2)) != null) {
            return string3;
        }
        return "";
    }

    private Vector a() throws IOException {
        try {
            final String string = this.b();
            if (!string.equals("")) {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new FileInputStream(string);
                    }
                })));
                Vector<String> vector = new Vector<String>();
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.startsWith("#")) continue;
                    vector.addElement(string2.trim());
                }
                bufferedReader.close();
                return vector;
            }
            return null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private Hashtable a(Vector vector) throws KrbException {
        if (vector == null) {
            throw new KrbException("I/O error while reading configuration file.");
        }
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        block0: for (int i2 = 0; i2 < vector.size(); ++i2) {
            String string = ((String)vector.elementAt(i2)).trim();
            if (string.equalsIgnoreCase("[realms]")) {
                for (int i3 = i2 + 1; i3 < vector.size() + 1; ++i3) {
                    if (i3 != vector.size() && !((String)vector.elementAt(i3)).startsWith("[")) continue;
                    Hashtable hashtable2 = new Hashtable();
                    hashtable2 = this.b(vector, i2 + 1, i3);
                    hashtable.put("realms", hashtable2);
                    i2 = i3 - 1;
                    continue block0;
                }
                continue;
            }
            if (string.equalsIgnoreCase("[capaths]")) {
                for (int i4 = i2 + 1; i4 < vector.size() + 1; ++i4) {
                    if (i4 != vector.size() && !((String)vector.elementAt(i4)).startsWith("[")) continue;
                    Hashtable hashtable3 = new Hashtable();
                    hashtable3 = this.b(vector, i2 + 1, i4);
                    hashtable.put("capaths", hashtable3);
                    i2 = i4 - 1;
                    continue block0;
                }
                continue;
            }
            if (!string.startsWith("[") || !string.endsWith("]")) continue;
            String string2 = string.substring(1, string.length() - 1);
            for (int i5 = i2 + 1; i5 < vector.size() + 1; ++i5) {
                if (i5 != vector.size() && !((String)vector.elementAt(i5)).startsWith("[")) continue;
                Hashtable hashtable4 = this.a(vector, i2 + 1, i5);
                hashtable.put(string2, hashtable4);
                i2 = i5 - 1;
                continue block0;
            }
        }
        return hashtable;
    }

    private String b() {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.security.krb5.conf"));
        if (string != null) {
            Boolean bl2 = (Boolean)AccessController.doPrivileged(new FileExistsAction(string));
            if (bl2.booleanValue()) {
                return string;
            }
        } else {
            string = (String)AccessController.doPrivileged(new GetPropertyAction("java.home")) + File.separator + "lib" + File.separator + "security" + File.separator + "krb5.conf";
            Boolean bl3 = (Boolean)AccessController.doPrivileged(new FileExistsAction(string));
            if (bl3.booleanValue()) {
                return string;
            }
            String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string2.startsWith("Windows")) {
                string = "c:\\winnt\\krb5.ini";
            } else if (string2.startsWith("SunOS")) {
                string = "/etc/krb5/krb5.conf";
            } else if (string2.startsWith("Linux")) {
                string = "/etc/krb5.conf";
            }
        }
        if (c) {
            System.out.println("Config name: " + string);
        }
        return string;
    }

    private Hashtable a(Vector vector, int n2, int n3) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        block0: for (int i2 = n2; i2 < n3; ++i2) {
            String string = (String)vector.elementAt(i2);
            for (int i3 = 0; i3 < string.length(); ++i3) {
                if (string.charAt(i3) != '=') continue;
                String string2 = string.substring(0, i3).trim();
                String string3 = string.substring(i3 + 1).trim();
                hashtable.put(string2, string3);
                continue block0;
            }
        }
        return hashtable;
    }

    private Hashtable b(Vector vector, int n2, int n3) {
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        block0: for (int i2 = n2; i2 < n3; ++i2) {
            int n4;
            String string = ((String)vector.elementAt(i2)).trim();
            if (!string.endsWith("{")) continue;
            String string2 = "";
            for (n4 = 0; n4 < string.length(); ++n4) {
                if (string.charAt(n4) != '=') continue;
                string2 = string.substring(0, n4).trim();
                break;
            }
            for (n4 = i2 + 1; n4 < n3; ++n4) {
                boolean bl2 = false;
                string = ((String)vector.elementAt(n4)).trim();
                for (int i3 = 0; i3 < string.length(); ++i3) {
                    if (string.charAt(i3) != '}') continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) continue;
                Hashtable hashtable2 = this.c(vector, i2 + 1, n4);
                hashtable.put(string2, hashtable2);
                i2 = n4;
                bl2 = false;
                continue block0;
            }
        }
        return hashtable;
    }

    private Hashtable c(Vector vector, int n2, int n3) {
        Hashtable<String, Vector<String>> hashtable = new Hashtable<String, Vector<String>>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        String string = "";
        block0: for (int i2 = n2; i2 < n3; ++i2) {
            string = (String)vector.elementAt(i2);
            for (int i3 = 0; i3 < string.length(); ++i3) {
                if (string.charAt(i3) != '=') continue;
                String string2 = string.substring(0, i3 - 1).trim();
                if (!this.a(string2, vector2)) {
                    vector2.addElement(string2);
                    vector3 = new Vector<String>();
                } else {
                    vector3 = (Vector<String>)hashtable.get(string2);
                }
                vector3.addElement(string.substring(i3 + 1).trim());
                hashtable.put(string2, vector3);
                continue block0;
            }
        }
        return hashtable;
    }

    private boolean a(String string, Vector vector) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            if (!((String)vector.elementAt(i2)).equals(string)) continue;
            bl2 = true;
        }
        return bl2;
    }

    public void listTable() {
        this.a(this.b);
    }

    private void a(Hashtable hashtable) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        if (this.b != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v2 = hashtable.get(string);
                if (hashtable == this.b) {
                    System.out.println("[" + string + "]");
                }
                if (v2 instanceof Hashtable) {
                    if (hashtable != this.b) {
                        System.out.println("\t" + string + " = {");
                    }
                    this.a((Hashtable)v2);
                    if (hashtable == this.b) continue;
                    System.out.println("\t}");
                    continue;
                }
                if (v2 instanceof String) {
                    System.out.println("\t" + string + " = " + (String)hashtable.get(string));
                    continue;
                }
                if (!(v2 instanceof Vector)) continue;
                vector = (Vector)v2;
                for (int i2 = 0; i2 < vector.size(); ++i2) {
                    System.out.println("\t" + string + " = " + (String)vector.elementAt(i2));
                }
            }
        } else {
            System.out.println("Configuration file not found.");
        }
    }

    public int[] defaultEtype(String string) {
        int n2;
        int[] nArray;
        String string2 = this.getDefault(string, "libdefaults");
        String string3 = " ";
        if (string2 == null) {
            if (c) {
                System.out.println("Using builtin default etypes for " + string);
            }
            nArray = k.k();
        } else {
            int n3;
            for (n2 = 0; n2 < string2.length(); ++n2) {
                if (!string2.substring(n2, n2 + 1).equals(",")) continue;
                string3 = ",";
                break;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            n2 = stringTokenizer.countTokens();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n2);
            for (n3 = 0; n3 < n2; ++n3) {
                int n4 = this.getType(stringTokenizer.nextToken());
                if (n4 == -1) continue;
                arrayList.add(new Integer(n4));
            }
            if (arrayList.size() == 0) {
                if (c) {
                    System.out.println("no supported default etypes for " + string);
                }
                return null;
            }
            nArray = new int[arrayList.size()];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                nArray[n3] = (Integer)arrayList.get(n3);
            }
        }
        if (c) {
            System.out.print("default etypes for " + string + ":");
            for (n2 = 0; n2 < nArray.length; ++n2) {
                System.out.print(" " + nArray[n2]);
            }
            System.out.println(".");
        }
        return nArray;
    }

    public int getType(String string) {
        int n2 = -1;
        if (string == null) {
            return n2;
        }
        if (string.startsWith("d") || string.startsWith("D")) {
            if (string.equalsIgnoreCase("des-cbc-crc")) {
                n2 = 1;
            } else if (string.equalsIgnoreCase("des-cbc-md5")) {
                n2 = 3;
            } else if (string.equalsIgnoreCase("des-mac")) {
                n2 = 4;
            } else if (string.equalsIgnoreCase("des-mac-k")) {
                n2 = 5;
            } else if (string.equalsIgnoreCase("des-cbc-md4")) {
                n2 = 2;
            } else if (string.equalsIgnoreCase("des3-cbc-sha1") || string.equalsIgnoreCase("des3-hmac-sha1") || string.equalsIgnoreCase("des3-cbc-sha1-kd") || string.equalsIgnoreCase("des3-cbc-hmac-sha1-kd")) {
                n2 = 16;
            }
        } else if (string.equalsIgnoreCase("CRC32")) {
            n2 = 1;
        } else if (string.startsWith("r") || string.startsWith("R")) {
            if (string.equalsIgnoreCase("rsa-md5")) {
                n2 = 7;
            } else if (string.equalsIgnoreCase("rsa-md5-des")) {
                n2 = 8;
            }
        } else if (string.equalsIgnoreCase("hmac-sha1-des3-kd")) {
            n2 = 12;
        } else if (string.equalsIgnoreCase("NULL")) {
            n2 = 0;
        }
        return n2;
    }

    public void resetDefaultRealm(String string) {
        this.h = string;
        if (c) {
            System.out.println(">>> Config reset default kdc " + this.h);
        }
    }

    public String getDefaultRealm() {
        return this.getDefault("default_realm", "libdefaults");
    }

    public String getKDCList(String string) {
        String string2;
        if (string == null) {
            string = this.getDefaultRealm();
        }
        if ((string2 = this.getDefault("kdc", string)) == null) {
            return null;
        }
        return string2;
    }

    static class FileExistsAction
    implements PrivilegedAction {
        private String a;

        public FileExistsAction(String string) {
            this.a = string;
        }

        public Object run() {
            return new Boolean(new File(this.a).exists());
        }
    }
}

