/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSName;
import sun.security.jgss.GSSCredentialImpl;
import sun.security.jgss.GSSNameImpl;
import sun.security.jgss.krb5.Krb5NameElement;

public class GSSUtil {
    public static Subject getSubject(GSSName gSSName, GSSCredential gSSCredential) {
        HashSet hashSet = null;
        HashSet hashSet2 = null;
        HashSet hashSet3 = new HashSet();
        Set set = null;
        Set set2 = null;
        if (gSSName instanceof GSSNameImpl) {
            set = ((GSSNameImpl)gSSName).getElements();
            hashSet = new HashSet(set.size());
            GSSUtil.populatePrincipals(hashSet, set);
        } else {
            hashSet = new HashSet();
        }
        if (gSSCredential instanceof GSSCredentialImpl) {
            set2 = ((GSSCredentialImpl)gSSCredential).getElements();
            hashSet2 = new HashSet(set2.size());
            GSSUtil.populateCredentials(hashSet2, set2);
        } else {
            hashSet2 = new HashSet();
        }
        return new Subject(false, hashSet, hashSet3, hashSet2);
    }

    private static void populatePrincipals(Set set, Set set2) {
        for (Object e2 : set2) {
            if (e2 instanceof Krb5NameElement) {
                KerberosPrincipal kerberosPrincipal = new KerberosPrincipal(((Krb5NameElement)e2).getKrb5PrincipalName().getName());
                set.add(kerberosPrincipal);
                continue;
            }
            throw new UnsupportedOperationException("Unknown principal class: " + e2.getClass().getName());
        }
    }

    private static void populateCredentials(Set set, Set set2) {
        for (Object e2 : set2) {
            Serializable serializable;
            if (e2 instanceof KerberosTicket && !e2.getClass().getName().equals("javax.security.auth.kerberos.KerberosTicket")) {
                KerberosTicket kerberosTicket = (KerberosTicket)e2;
                serializable = new KerberosTicket(kerberosTicket.getEncoded(), kerberosTicket.getClient(), kerberosTicket.getServer(), kerberosTicket.getSessionKey().getEncoded(), kerberosTicket.getSessionKeyType(), kerberosTicket.getFlags(), kerberosTicket.getAuthTime(), kerberosTicket.getStartTime(), kerberosTicket.getEndTime(), kerberosTicket.getRenewTill(), kerberosTicket.getClientAddresses());
                set.add(serializable);
                continue;
            }
            if (e2 instanceof KerberosKey && !e2.getClass().getName().equals("javax.security.auth.kerberos.KerberosKey")) {
                KerberosKey kerberosKey = (KerberosKey)e2;
                serializable = new KerberosKey(kerberosKey.getPrincipal(), kerberosKey.getEncoded(), kerberosKey.getKeyType(), kerberosKey.getVersionNumber());
                set.add(serializable);
                continue;
            }
            set.add(e2);
        }
    }
}

