/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LRUCache<N, V> {
    private V[] oa = null;
    private final int size;

    public LRUCache(int n2) {
        this.size = n2;
    }

    protected abstract V create(N var1);

    protected abstract boolean hasName(V var1, N var2);

    public static void moveToFront(Object[] objectArray, int n2) {
        Object object = objectArray[n2];
        for (int i2 = n2; i2 > 0; --i2) {
            objectArray[i2] = objectArray[i2 - 1];
        }
        objectArray[0] = object;
    }

    public V forName(N n2) {
        if (this.oa == null) {
            this.oa = new Object[this.size];
        } else {
            for (int i2 = 0; i2 < this.oa.length; ++i2) {
                V v2 = this.oa[i2];
                if (v2 == null || !this.hasName(v2, n2)) continue;
                if (i2 > 0) {
                    LRUCache.moveToFront(this.oa, i2);
                }
                return v2;
            }
        }
        V v3 = this.create(n2);
        this.oa[this.oa.length - 1] = v3;
        LRUCache.moveToFront(this.oa, this.oa.length - 1);
        return v3;
    }
}

