/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import java.text.CharacterIterator;
import sun.font.DelegatingShape;
import sun.font.Font2D;
import sun.font.FontManager;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.StrikeMetrics;

public class StandardGlyphVector
extends GlyphVector {
    private Font font;
    private FontRenderContext frc;
    private int[] glyphs;
    private int[] userGlyphs;
    private float[] positions;
    private int[] charIndices;
    private int flags;
    private static final int UNINITIALIZED_FLAGS = -1;
    private GlyphTransformInfo gti;
    private AffineTransform ftx;
    private AffineTransform dtx;
    private AffineTransform invdtx;
    private AffineTransform frctx;
    private Font2D font2D;
    private SoftReference fsref;
    private SoftReference lbcacheRef;
    private SoftReference vbcacheRef;
    public static final int FLAG_USES_VERTICAL_BASELINE = 128;
    public static final int FLAG_USES_VERTICAL_METRICS = 256;
    public static final int FLAG_USES_ALTERNATE_ORIENTATION = 512;

    public StandardGlyphVector(Font font, String string, FontRenderContext fontRenderContext) {
        this.init(font, string.toCharArray(), 0, string.length(), fontRenderContext, -1);
    }

    public StandardGlyphVector(Font font, char[] cArray, FontRenderContext fontRenderContext) {
        this.init(font, cArray, 0, cArray.length, fontRenderContext, -1);
    }

    public StandardGlyphVector(Font font, char[] cArray, int n2, int n3, FontRenderContext fontRenderContext) {
        this.init(font, cArray, n2, n3, fontRenderContext, -1);
    }

    public StandardGlyphVector(Font font, FontRenderContext fontRenderContext, int[] nArray, float[] fArray, int[] nArray2, int n2) {
        this.initGlyphVector(font, fontRenderContext, nArray, fArray, nArray2, n2);
    }

    public void initGlyphVector(Font font, FontRenderContext fontRenderContext, int[] nArray, float[] fArray, int[] nArray2, int n2) {
        this.font = font;
        this.frc = fontRenderContext;
        this.glyphs = nArray;
        this.userGlyphs = nArray;
        this.positions = fArray;
        this.charIndices = nArray2;
        this.flags = n2;
        this.initFontData();
    }

    public StandardGlyphVector(Font font, CharacterIterator characterIterator, FontRenderContext fontRenderContext) {
        int n2 = characterIterator.getBeginIndex();
        char[] cArray = new char[characterIterator.getEndIndex() - n2];
        char c2 = characterIterator.first();
        while (c2 != '\uffff') {
            cArray[characterIterator.getIndex() - n2] = c2;
            c2 = characterIterator.next();
        }
        this.init(font, cArray, 0, cArray.length, fontRenderContext, -1);
    }

    public StandardGlyphVector(Font font, int[] nArray, FontRenderContext fontRenderContext) {
        this.font = font;
        this.frc = fontRenderContext;
        this.flags = -1;
        this.initFontData();
        this.userGlyphs = nArray;
        this.glyphs = this.getValidatedGlyphs(this.userGlyphs);
    }

    public static StandardGlyphVector getStandardGV(GlyphVector glyphVector) {
        if (glyphVector instanceof StandardGlyphVector) {
            return (StandardGlyphVector)glyphVector;
        }
        return new StandardGlyphVector(glyphVector);
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public void performDefaultLayout() {
        this.positions = null;
        this.clearFlags(2);
    }

    public int getNumGlyphs() {
        return this.glyphs.length;
    }

    public int getGlyphCode(int n2) {
        return this.userGlyphs[n2];
    }

    public int[] getGlyphCodes(int n2, int n3, int[] nArray) {
        if (n3 < 0) {
            throw new IllegalArgumentException("count = " + n3);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("start = " + n2);
        }
        if (n2 > this.glyphs.length - n3) {
            throw new IndexOutOfBoundsException("start + count = " + (n2 + n3));
        }
        if (nArray == null) {
            nArray = new int[n3];
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = this.userGlyphs[i2 + n2];
        }
        return nArray;
    }

    public int getGlyphCharIndex(int n2) {
        if (n2 < 0 && n2 >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("" + n2);
        }
        if (this.charIndices == null) {
            if ((this.flags & 4) != 0) {
                return this.glyphs.length - 1 - n2;
            }
            return n2;
        }
        return this.charIndices[n2];
    }

    public int[] getGlyphCharIndices(int n2, int n3, int[] nArray) {
        if (n2 < 0 || n3 < 0 || n3 > this.glyphs.length - n2) {
            throw new IndexOutOfBoundsException("" + n2 + ", " + n3);
        }
        if (nArray == null) {
            nArray = new int[n3];
        }
        if (this.charIndices == null) {
            if ((this.flags & 4) != 0) {
                int n4 = this.glyphs.length - 1 - n2;
                for (int i2 = 0; i2 < n3; ++i2) {
                    nArray[i2] = n4--;
                }
            } else {
                int n5 = n2;
                for (int i3 = 0; i3 < n3; ++i3) {
                    nArray[i3] = n5++;
                }
            }
        } else {
            for (int i4 = 0; i4 < n3; ++i4) {
                nArray[i4] = this.charIndices[i4 + n2];
            }
        }
        return nArray;
    }

    public Rectangle2D getLogicalBounds() {
        this.setFRCTX();
        this.initPositions();
        LineMetrics lineMetrics = this.font.getLineMetrics("", this.frc);
        float f2 = 0.0f;
        float f3 = -lineMetrics.getAscent();
        float f4 = 0.0f;
        float f5 = lineMetrics.getDescent() + lineMetrics.getLeading();
        if (this.glyphs.length > 0) {
            f4 = this.positions[this.positions.length - 2];
        }
        return new Rectangle2D.Float(f2, f3, f4 - f2, f5 - f3);
    }

    public Rectangle2D getVisualBounds() {
        return this.getGlyphsVisualBounds(0, this.glyphs.length);
    }

    public Rectangle getPixelBounds(FontRenderContext fontRenderContext, float f2, float f3) {
        return this.getGlyphsPixelBounds(fontRenderContext, f2, f3, 0, this.glyphs.length);
    }

    public Shape getOutline() {
        return this.getGlyphsOutline(0, this.glyphs.length, 0.0f, 0.0f);
    }

    public Shape getOutline(float f2, float f3) {
        return this.getGlyphsOutline(0, this.glyphs.length, f2, f3);
    }

    public Shape getGlyphOutline(int n2) {
        return this.getGlyphsOutline(n2, 1, 0.0f, 0.0f);
    }

    public Shape getGlyphOutline(int n2, float f2, float f3) {
        return this.getGlyphsOutline(n2, 1, f2, f3);
    }

    public Point2D getGlyphPosition(int n2) {
        this.initPositions();
        return new Point2D.Float(this.positions[n2 *= 2], this.positions[n2 + 1]);
    }

    public void setGlyphPosition(int n2, Point2D point2D) {
        this.initPositions();
        int n3 = n2 << 1;
        this.positions[n3] = (float)point2D.getX();
        this.positions[n3 + 1] = (float)point2D.getY();
        this.clearCaches(n2);
        this.addFlags(2);
    }

    public AffineTransform getGlyphTransform(int n2) {
        if (n2 < 0 || n2 >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("ix = " + n2);
        }
        if (this.gti != null) {
            return this.gti.getGlyphTransform(n2);
        }
        return null;
    }

    public void setGlyphTransform(int n2, AffineTransform affineTransform) {
        if (n2 < 0 || n2 >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("ix = " + n2);
        }
        if (this.gti == null) {
            if (affineTransform == null || affineTransform.isIdentity()) {
                return;
            }
            this.gti = new GlyphTransformInfo(this);
        }
        this.gti.setGlyphTransform(n2, affineTransform);
        if (this.gti.transformCount() == 0) {
            this.gti = null;
        }
    }

    public int getLayoutFlags() {
        if (this.flags == -1) {
            this.flags = 0;
            if (this.charIndices != null && this.glyphs.length > 1) {
                boolean bl2 = true;
                boolean bl3 = true;
                int n2 = this.charIndices.length;
                for (int i2 = 0; i2 < this.charIndices.length && (bl2 || bl3); ++i2) {
                    int n3 = this.charIndices[i2];
                    bl2 = bl2 && n3 == i2;
                    bl3 = bl3 && n3 == --n2;
                }
                if (bl3) {
                    this.flags |= 4;
                }
                if (!bl3 && !bl2) {
                    this.flags |= 8;
                }
            }
        }
        return this.flags;
    }

    public float[] getGlyphPositions(int n2, int n3, float[] fArray) {
        if (n3 < 0) {
            throw new IllegalArgumentException("count = " + n3);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("start = " + n2);
        }
        if (n2 > this.glyphs.length + 1 - n3) {
            throw new IndexOutOfBoundsException("start + count = " + (n2 + n3));
        }
        return this.internalGetGlyphPositions(n2, n3, 0, fArray);
    }

    public Shape getGlyphLogicalBounds(int n2) {
        Shape shape;
        Shape[] shapeArray;
        if (n2 < 0 || n2 >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("ix = " + n2);
        }
        if (this.lbcacheRef == null || (shapeArray = (Shape[])this.lbcacheRef.get()) == null) {
            shapeArray = new Shape[this.glyphs.length];
            this.lbcacheRef = new SoftReference<Shape[]>(shapeArray);
        }
        if ((shape = shapeArray[n2]) == null) {
            this.setFRCTX();
            this.initPositions();
            ADL aDL = new ADL();
            GlyphStrike glyphStrike = this.getGlyphStrike(n2);
            glyphStrike.getADL(aDL);
            Point2D.Float float_ = glyphStrike.strike.getGlyphMetrics(this.glyphs[n2]);
            float f2 = float_.x;
            float f3 = float_.y;
            float f4 = aDL.descentX + aDL.leadingX + aDL.ascentX;
            float f5 = aDL.descentY + aDL.leadingY + aDL.ascentY;
            float f6 = this.positions[n2 * 2] + glyphStrike.dx - aDL.ascentX;
            float f7 = this.positions[n2 * 2 + 1] + glyphStrike.dy - aDL.ascentY;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f6, f7);
            generalPath.lineTo(f6 + f2, f7 + f3);
            generalPath.lineTo(f6 + f2 + f4, f7 + f3 + f5);
            generalPath.lineTo(f6 + f4, f7 + f5);
            generalPath.closePath();
            shapeArray[n2] = shape = new DelegatingShape(generalPath);
        }
        return shape;
    }

    public Shape getGlyphVisualBounds(int n2) {
        Shape shape;
        Shape[] shapeArray;
        if (n2 < 0 || n2 >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("ix = " + n2);
        }
        if (this.vbcacheRef == null || (shapeArray = (Shape[])this.vbcacheRef.get()) == null) {
            shapeArray = new Shape[this.glyphs.length];
            this.vbcacheRef = new SoftReference<Shape[]>(shapeArray);
        }
        if ((shape = shapeArray[n2]) == null) {
            shapeArray[n2] = shape = new DelegatingShape(this.getGlyphsVisualBounds(n2, 1));
        }
        return shape;
    }

    public Rectangle getGlyphPixelBounds(int n2, FontRenderContext fontRenderContext, float f2, float f3) {
        return this.getGlyphsPixelBounds(fontRenderContext, f2, f3, n2, 1);
    }

    public GlyphMetrics getGlyphMetrics(int n2) {
        if (n2 < 0 || n2 >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("ix = " + n2);
        }
        Rectangle2D rectangle2D = this.getGlyphVisualBounds(n2).getBounds2D();
        Point2D point2D = this.getGlyphPosition(n2);
        rectangle2D.setRect(rectangle2D.getMinX() - point2D.getX(), rectangle2D.getMinY() - point2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        Point2D.Float float_ = this.getGlyphStrike((int)n2).strike.getGlyphMetrics(this.glyphs[n2]);
        GlyphMetrics glyphMetrics = new GlyphMetrics(true, float_.x, float_.y, rectangle2D, 0);
        return glyphMetrics;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n2) {
        if (n2 < 0 || n2 >= this.glyphs.length) {
            throw new IndexOutOfBoundsException("ix = " + n2);
        }
        return null;
    }

    public boolean equals(GlyphVector glyphVector) {
        if (this == glyphVector) {
            return true;
        }
        if (glyphVector == null) {
            return false;
        }
        try {
            int n2;
            StandardGlyphVector standardGlyphVector = (StandardGlyphVector)glyphVector;
            if (this.glyphs.length != standardGlyphVector.glyphs.length) {
                return false;
            }
            for (n2 = 0; n2 < this.glyphs.length; ++n2) {
                if (this.glyphs[n2] == standardGlyphVector.glyphs[n2]) continue;
                return false;
            }
            if (!this.font.equals(standardGlyphVector.font)) {
                return false;
            }
            if (!this.frc.equals(standardGlyphVector.frc)) {
                return false;
            }
            if (standardGlyphVector.positions == null != (this.positions == null)) {
                if (this.positions == null) {
                    this.initPositions();
                } else {
                    standardGlyphVector.initPositions();
                }
            }
            if (this.positions != null) {
                for (n2 = 0; n2 < this.positions.length; ++n2) {
                    if (this.positions[n2] == standardGlyphVector.positions[n2]) continue;
                    return false;
                }
            }
            if (this.gti == null) {
                return standardGlyphVector.gti == null;
            }
            return this.gti.equals(standardGlyphVector.gti);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.font.hashCode() ^ this.glyphs.length;
    }

    public boolean equals(Object object) {
        try {
            return this.equals((GlyphVector)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public StandardGlyphVector copy() {
        return (StandardGlyphVector)this.clone();
    }

    public Object clone() {
        try {
            StandardGlyphVector standardGlyphVector = (StandardGlyphVector)super.clone();
            standardGlyphVector.clearCaches();
            if (this.positions != null) {
                standardGlyphVector.positions = (float[])this.positions.clone();
            }
            if (this.gti != null) {
                standardGlyphVector.gti = new GlyphTransformInfo(standardGlyphVector, this.gti);
            }
            return standardGlyphVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public void setGlyphPositions(float[] fArray, int n2, int n3, int n4) {
        if (n4 < 0) {
            throw new IllegalArgumentException("count = " + n4);
        }
        this.initPositions();
        int n5 = n3 * 2;
        int n6 = n5 + n4 * 2;
        int n7 = n2;
        while (n5 < n6) {
            this.positions[n5] = fArray[n7];
            ++n5;
            ++n7;
        }
        this.clearCaches();
        this.addFlags(2);
    }

    public void setGlyphPositions(float[] fArray) {
        int n2 = this.glyphs.length * 2 + 2;
        if (fArray.length != n2) {
            throw new IllegalArgumentException("srcPositions.length != " + n2);
        }
        this.positions = (float[])fArray.clone();
        this.clearCaches();
        this.addFlags(2);
    }

    public float[] getGlyphPositions(float[] fArray) {
        return this.internalGetGlyphPositions(0, this.glyphs.length + 1, 0, fArray);
    }

    public AffineTransform[] getGlyphTransforms(int n2, int n3, AffineTransform[] affineTransformArray) {
        if (n2 < 0 || n3 < 0 || n2 + n3 > this.glyphs.length) {
            throw new IllegalArgumentException("start: " + n2 + " count: " + n3);
        }
        if (this.gti == null) {
            return null;
        }
        if (affineTransformArray == null) {
            affineTransformArray = new AffineTransform[n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            affineTransformArray[n4] = this.gti.getGlyphTransform(n2);
            ++n4;
            ++n2;
        }
        return affineTransformArray;
    }

    public AffineTransform[] getGlyphTransforms() {
        return this.getGlyphTransforms(0, this.glyphs.length, null);
    }

    public void setGlyphTransforms(AffineTransform[] affineTransformArray, int n2, int n3, int n4) {
        int n5 = n3 + n4;
        for (int i2 = n3; i2 < n5; ++i2) {
            this.setGlyphTransform(i2, affineTransformArray[n2 + i2]);
        }
    }

    public void setGlyphTransforms(AffineTransform[] affineTransformArray) {
        this.setGlyphTransforms(affineTransformArray, 0, 0, this.glyphs.length);
    }

    public float[] getGlyphInfo() {
        this.setFRCTX();
        this.initPositions();
        float[] fArray = new float[this.glyphs.length * 8];
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.glyphs.length) {
            float f2 = this.positions[n2 * 2];
            float f3 = this.positions[n2 * 2 + 1];
            fArray[n3] = f2;
            fArray[n3 + 1] = f3;
            int n4 = this.glyphs[n2];
            GlyphStrike glyphStrike = this.getGlyphStrike(n2);
            Point2D.Float float_ = glyphStrike.strike.getGlyphMetrics(n4);
            fArray[n3 + 2] = float_.x;
            fArray[n3 + 3] = float_.y;
            Rectangle2D rectangle2D = this.getGlyphsVisualBounds(n2, 1).getBounds2D();
            fArray[n3 + 4] = (float)rectangle2D.getMinX();
            fArray[n3 + 5] = (float)rectangle2D.getMinY();
            fArray[n3 + 6] = (float)rectangle2D.getWidth();
            fArray[n3 + 7] = (float)rectangle2D.getHeight();
            ++n2;
            n3 += 8;
        }
        return fArray;
    }

    public void pixellate(FontRenderContext fontRenderContext, Point2D point2D, Point point) {
        if (fontRenderContext == null) {
            fontRenderContext = this.frc;
        }
        AffineTransform affineTransform = fontRenderContext.getTransform();
        affineTransform.transform(point2D, point2D);
        point.x = (int)point2D.getX();
        point.y = (int)point2D.getY();
        point2D.setLocation(point.x, point.y);
        try {
            affineTransform.inverseTransform(point2D, point2D);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalArgumentException("must be able to invert frc transform");
        }
    }

    boolean needsPositions(double[] dArray) {
        return this.gti != null || (this.getLayoutFlags() & 2) != 0 || !StandardGlyphVector.matchTX(dArray, this.frctx);
    }

    Object setupGlyphImages(long[] lArray, float[] fArray, double[] dArray) {
        this.initPositions();
        this.setRenderTransform(dArray);
        if (this.gti != null) {
            return this.gti.setupGlyphImages(lArray, fArray, this.dtx);
        }
        GlyphStrike glyphStrike = this.getDefaultStrike();
        glyphStrike.strike.getGlyphImagePtrs(this.glyphs, lArray, this.glyphs.length);
        if (fArray != null) {
            if (this.dtx.isIdentity()) {
                System.arraycopy(this.positions, 0, fArray, 0, this.glyphs.length * 2);
            } else {
                this.dtx.transform(this.positions, 0, fArray, 0, this.glyphs.length);
            }
        }
        return glyphStrike;
    }

    private static boolean matchTX(double[] dArray, AffineTransform affineTransform) {
        return dArray[0] == affineTransform.getScaleX() && dArray[1] == affineTransform.getShearY() && dArray[2] == affineTransform.getShearX() && dArray[3] == affineTransform.getScaleY();
    }

    private static AffineTransform getNonTranslateTX(AffineTransform affineTransform) {
        if (affineTransform.getTranslateX() != 0.0 || affineTransform.getTranslateY() != 0.0) {
            affineTransform = new AffineTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), 0.0, 0.0);
        }
        return affineTransform;
    }

    private static boolean equalNonTranslateTX(AffineTransform affineTransform, AffineTransform affineTransform2) {
        return affineTransform.getScaleX() == affineTransform2.getScaleX() && affineTransform.getShearY() == affineTransform2.getShearY() && affineTransform.getShearX() == affineTransform2.getShearX() && affineTransform.getScaleY() == affineTransform2.getScaleY();
    }

    private void setRenderTransform(double[] dArray) {
        assert (dArray.length == 4);
        if (!StandardGlyphVector.matchTX(dArray, this.dtx)) {
            this.resetDTX(new AffineTransform(dArray));
        }
    }

    private final void setDTX(AffineTransform affineTransform) {
        if (!StandardGlyphVector.equalNonTranslateTX(this.dtx, affineTransform)) {
            this.resetDTX(StandardGlyphVector.getNonTranslateTX(affineTransform));
        }
    }

    private final void setFRCTX() {
        if (!StandardGlyphVector.equalNonTranslateTX(this.frctx, this.dtx)) {
            this.resetDTX(StandardGlyphVector.getNonTranslateTX(this.frctx));
        }
    }

    private final void resetDTX(AffineTransform affineTransform) {
        this.fsref = null;
        this.dtx = affineTransform;
        this.invdtx = null;
        if (!this.dtx.isIdentity()) {
            try {
                this.invdtx = this.dtx.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        if (this.gti != null) {
            this.gti.strikesRef = null;
        }
    }

    private StandardGlyphVector(GlyphVector glyphVector) {
        this.font = glyphVector.getFont();
        this.frc = glyphVector.getFontRenderContext();
        this.initFontData();
        int n2 = glyphVector.getNumGlyphs();
        this.userGlyphs = glyphVector.getGlyphCodes(0, n2, null);
        this.glyphs = this.getValidatedGlyphs(this.userGlyphs);
        this.flags = glyphVector.getLayoutFlags() & 0xF;
        if ((this.flags & 2) != 0) {
            this.positions = glyphVector.getGlyphPositions(0, n2 + 1, null);
        }
        if ((this.flags & 8) != 0) {
            this.charIndices = glyphVector.getGlyphCharIndices(0, n2, null);
        }
        if ((this.flags & 1) != 0) {
            AffineTransform[] affineTransformArray = new AffineTransform[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                affineTransformArray[i2] = glyphVector.getGlyphTransform(i2);
            }
            this.setGlyphTransforms(affineTransformArray);
        }
    }

    int[] getValidatedGlyphs(int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray2[i2] = this.font2D.getValidatedGlyphCode(nArray[i2]);
        }
        return nArray2;
    }

    private void init(Font font, char[] cArray, int n2, int n3, FontRenderContext fontRenderContext, int n4) {
        if (n2 < 0 || n3 < 0 || n2 + n3 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException("start or count out of bounds");
        }
        this.font = font;
        this.frc = fontRenderContext;
        this.flags = n4;
        if (n2 != 0) {
            char[] cArray2 = new char[n3];
            System.arraycopy(cArray, n2, cArray2, 0, n3);
            cArray = cArray2;
        }
        this.initFontData();
        this.glyphs = new int[n3];
        this.userGlyphs = this.glyphs;
        this.font2D.getMapper().charsToGlyphs(n3, cArray, this.glyphs);
    }

    private void initFontData() {
        this.font2D = FontManager.getFont2D(this.font);
        float f2 = this.font.getSize2D();
        if (this.font.isTransformed()) {
            this.ftx = this.font.getTransform();
            if (this.ftx.getTranslateX() != 0.0 || this.ftx.getTranslateY() != 0.0) {
                this.addFlags(2);
            }
            this.ftx.setTransform(this.ftx.getScaleX(), this.ftx.getShearY(), this.ftx.getShearX(), this.ftx.getScaleY(), 0.0, 0.0);
            this.ftx.scale(f2, f2);
        } else {
            this.ftx = AffineTransform.getScaleInstance(f2, f2);
        }
        this.frctx = this.frc.getTransform();
        this.resetDTX(StandardGlyphVector.getNonTranslateTX(this.frctx));
    }

    private Rectangle2D getGlyphsVisualBounds(int n2, int n3) {
        this.setFRCTX();
        this.initPositions();
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        float f5 = Float.NEGATIVE_INFINITY;
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        int n4 = n2;
        int n5 = n2 * 2;
        int n6 = n2 + n3;
        while (n4 < n6) {
            this.getGlyphStrike(n4).getGlyphOutlineBounds(this.glyphs[n4], float_, this.invdtx);
            if (!float_.isEmpty()) {
                float f6;
                float f7 = this.positions[n5];
                float f8 = this.positions[n5 + 1];
                float f9 = f7 + float_.x;
                if (f9 < f2) {
                    f2 = f9;
                }
                if ((f9 += float_.width) > f4) {
                    f4 = f9;
                }
                if ((f6 = f8 + float_.y) < f3) {
                    f3 = f6;
                }
                if ((f6 += float_.height) > f5) {
                    f5 = f6;
                }
            }
            ++n4;
            n5 += 2;
        }
        Rectangle2D.Float float_2 = f2 >= f4 || f3 >= f5 ? new Rectangle2D.Float(this.positions[n2 * 2], this.positions[n2 * 2 + 1], 0.0f, 0.0f) : new Rectangle2D.Float(f2, f3, f4 - f2, f5 - f3);
        return float_2;
    }

    private float[] internalGetGlyphPositions(int n2, int n3, int n4, float[] fArray) {
        if (fArray == null) {
            fArray = new float[n4 + n3 * 2];
        }
        this.initPositions();
        int n5 = n4;
        int n6 = n4 + n3 * 2;
        int n7 = n2 * 2;
        while (n5 < n6) {
            fArray[n5] = this.positions[n7];
            ++n5;
            ++n7;
        }
        return fArray;
    }

    private Shape getGlyphsOutline(int n2, int n3, float f2, float f3) {
        this.setFRCTX();
        this.initPositions();
        GeneralPath generalPath = new GeneralPath(1);
        int n4 = n2;
        int n5 = n2 + n3;
        int n6 = n2 * 2;
        while (n4 < n5) {
            float f4 = f2 + this.positions[n6];
            float f5 = f3 + this.positions[n6 + 1];
            this.getGlyphStrike(n4).appendGlyphOutline(this.glyphs[n4], generalPath, f4, f5);
            ++n4;
            n6 += 2;
        }
        return generalPath;
    }

    private Rectangle getGlyphsPixelBounds(FontRenderContext fontRenderContext, float f2, float f3, int n2, int n3) {
        this.initPositions();
        AffineTransform affineTransform = null;
        affineTransform = fontRenderContext == null || fontRenderContext.equals(this.frc) ? this.frctx : fontRenderContext.getTransform();
        this.setDTX(affineTransform);
        if (this.gti != null) {
            return this.gti.getGlyphsPixelBounds(affineTransform, f2, f3, n2, n3);
        }
        FontStrike fontStrike = this.getDefaultStrike().strike;
        Rectangle rectangle = null;
        Rectangle rectangle2 = new Rectangle();
        Point2D.Float float_ = new Point2D.Float();
        int n4 = n2 * 2;
        while (--n3 >= 0) {
            float_.x = f2 + this.positions[n4++];
            float_.y = f3 + this.positions[n4++];
            affineTransform.transform(float_, float_);
            fontStrike.getGlyphImageBounds(this.glyphs[n2++], float_, rectangle2);
            if (rectangle2.isEmpty()) continue;
            if (rectangle == null) {
                rectangle = new Rectangle(rectangle2);
                continue;
            }
            rectangle.add(rectangle2);
        }
        return rectangle != null ? rectangle : rectangle2;
    }

    private void clearCaches(int n2) {
        Shape[] shapeArray;
        if (this.lbcacheRef != null && (shapeArray = (Shape[])this.lbcacheRef.get()) != null) {
            shapeArray[n2] = null;
        }
        if (this.vbcacheRef != null && (shapeArray = (Shape[])this.vbcacheRef.get()) != null) {
            shapeArray[n2] = null;
        }
    }

    private void clearCaches() {
        this.lbcacheRef = null;
        this.vbcacheRef = null;
    }

    private void initPositions() {
        if (this.positions == null) {
            this.setFRCTX();
            this.positions = new float[this.glyphs.length * 2 + 2];
            Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
            if (this.font.isTransformed()) {
                AffineTransform affineTransform = this.font.getTransform();
                affineTransform.transform(float_, float_);
                this.positions[0] = float_.x;
                this.positions[1] = float_.y;
            }
            int n2 = 0;
            int n3 = 2;
            while (n2 < this.glyphs.length) {
                this.getGlyphStrike(n2).addDefaultGlyphAdvance(this.glyphs[n2], float_);
                this.positions[n3] = float_.x;
                this.positions[n3 + 1] = float_.y;
                ++n2;
                n3 += 2;
            }
        }
    }

    private void addFlags(int n2) {
        this.flags = this.getLayoutFlags() | n2;
    }

    private void clearFlags(int n2) {
        this.flags = this.getLayoutFlags() & ~n2;
    }

    private GlyphStrike getGlyphStrike(int n2) {
        if (this.gti == null) {
            return this.getDefaultStrike();
        }
        return this.gti.getStrike(n2);
    }

    private GlyphStrike getDefaultStrike() {
        GlyphStrike glyphStrike = null;
        if (this.fsref != null) {
            glyphStrike = (GlyphStrike)this.fsref.get();
        }
        if (glyphStrike == null) {
            glyphStrike = GlyphStrike.create(this, this.dtx, null);
            this.fsref = new SoftReference<GlyphStrike>(glyphStrike);
        }
        return glyphStrike;
    }

    public String toString() {
        return this.appendString(null).toString();
    }

    StringBuffer appendString(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        try {
            int n2;
            stringBuffer.append("SGV{font: ");
            stringBuffer.append(this.font.toString());
            stringBuffer.append(", frc: ");
            stringBuffer.append(this.frc.toString());
            stringBuffer.append(", glyphs: (");
            stringBuffer.append(this.glyphs.length);
            stringBuffer.append(")[");
            for (n2 = 0; n2 < this.glyphs.length; ++n2) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(Integer.toHexString(this.glyphs[n2]));
            }
            stringBuffer.append("]");
            if (this.positions != null) {
                stringBuffer.append(", positions: (");
                stringBuffer.append(this.positions.length);
                stringBuffer.append(")[");
                for (n2 = 0; n2 < this.positions.length; n2 += 2) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.positions[n2]);
                    stringBuffer.append("@");
                    stringBuffer.append(this.positions[n2 + 1]);
                }
                stringBuffer.append("]");
            }
            if (this.charIndices != null) {
                stringBuffer.append(", indices: (");
                stringBuffer.append(this.charIndices.length);
                stringBuffer.append(")[");
                for (n2 = 0; n2 < this.charIndices.length; ++n2) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.charIndices[n2]);
                }
                stringBuffer.append("]");
            }
            stringBuffer.append(", flags:");
            if (this.getLayoutFlags() == 0) {
                stringBuffer.append(" default");
            } else {
                if ((this.flags & 1) != 0) {
                    stringBuffer.append(" tx");
                }
                if ((this.flags & 2) != 0) {
                    stringBuffer.append(" pos");
                }
                if ((this.flags & 4) != 0) {
                    stringBuffer.append(" rtl");
                }
                if ((this.flags & 8) != 0) {
                    stringBuffer.append(" complex");
                }
            }
        }
        catch (Exception exception) {
            stringBuffer.append(" " + exception.getMessage());
        }
        stringBuffer.append("}");
        return stringBuffer;
    }

    static class ADL {
        public float ascentX;
        public float ascentY;
        public float descentX;
        public float descentY;
        public float leadingX;
        public float leadingY;

        ADL() {
        }

        public String toString() {
            return this.toStringBuffer(null).toString();
        }

        protected StringBuffer toStringBuffer(StringBuffer stringBuffer) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append("ax: ");
            stringBuffer.append(this.ascentX);
            stringBuffer.append(" ay: ");
            stringBuffer.append(this.ascentY);
            stringBuffer.append(" dx: ");
            stringBuffer.append(this.descentX);
            stringBuffer.append(" dy: ");
            stringBuffer.append(this.descentY);
            stringBuffer.append(" lx: ");
            stringBuffer.append(this.leadingX);
            stringBuffer.append(" ly: ");
            stringBuffer.append(this.leadingY);
            return stringBuffer;
        }
    }

    public static final class GlyphStrike {
        StandardGlyphVector sgv;
        FontStrike strike;
        float dx;
        float dy;

        static GlyphStrike create(StandardGlyphVector standardGlyphVector, AffineTransform affineTransform, AffineTransform affineTransform2) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            AffineTransform affineTransform3 = standardGlyphVector.ftx;
            if (!affineTransform.isIdentity() || affineTransform2 != null) {
                affineTransform3 = new AffineTransform(standardGlyphVector.ftx);
                if (affineTransform2 != null) {
                    affineTransform3.preConcatenate(affineTransform2);
                    f2 = (float)affineTransform3.getTranslateX();
                    f3 = (float)affineTransform3.getTranslateY();
                }
                if (!affineTransform.isIdentity()) {
                    affineTransform3.preConcatenate(affineTransform);
                }
            }
            FontStrikeDesc fontStrikeDesc = new FontStrikeDesc(affineTransform, affineTransform3, standardGlyphVector.font.getStyle(), standardGlyphVector.frc.isAntiAliased(), standardGlyphVector.frc.usesFractionalMetrics());
            FontStrike fontStrike = standardGlyphVector.font2D.getStrike(fontStrikeDesc);
            return new GlyphStrike(standardGlyphVector, fontStrike, f2, f3);
        }

        private GlyphStrike(StandardGlyphVector standardGlyphVector, FontStrike fontStrike, float f2, float f3) {
            this.sgv = standardGlyphVector;
            this.strike = fontStrike;
            this.dx = f2;
            this.dy = f3;
        }

        void getADL(ADL aDL) {
            StrikeMetrics strikeMetrics = this.strike.getFontMetrics();
            Point2D.Float float_ = null;
            if (this.sgv.font.isTransformed()) {
                float_ = new Point2D.Float();
                float_.x = (float)this.sgv.font.getTransform().getTranslateX();
                float_.y = (float)this.sgv.font.getTransform().getTranslateY();
            }
            aDL.ascentX = -strikeMetrics.ascentX;
            aDL.ascentY = -strikeMetrics.ascentY;
            aDL.descentX = strikeMetrics.descentX;
            aDL.descentY = strikeMetrics.descentY;
            aDL.leadingX = strikeMetrics.leadingX;
            aDL.leadingY = strikeMetrics.leadingY;
        }

        void getGlyphPosition(int n2, int n3, float[] fArray, float[] fArray2) {
            fArray2[n3] = fArray[n3] + this.dx;
            fArray2[++n3] = fArray[n3] + this.dy;
        }

        void addDefaultGlyphAdvance(int n2, Point2D.Float float_) {
            Point2D.Float float_2 = this.strike.getGlyphMetrics(n2);
            float_.x += float_2.x + this.dx;
            float_.y += float_2.y + this.dy;
        }

        void getGlyphOutlineBounds(int n2, Rectangle2D.Float float_, AffineTransform affineTransform) {
            Rectangle2D.Float float_2 = this.strike.getGlyphOutlineBounds(n2);
            if (float_2.isEmpty()) {
                float_.height = 0.0f;
                float_.width = 0.0f;
                float_.y = 0.0f;
                float_.x = 0.0f;
            } else if (affineTransform == null) {
                float_.x = float_2.x + this.dx;
                float_.y = float_2.y + this.dy;
                float_.width = float_2.width;
                float_.height = float_2.height;
            } else {
                float_2.x += this.dx;
                float_2.y += this.dy;
                double[] dArray = new double[]{float_2.x, float_2.y, float_2.x + float_2.width, float_2.y, float_2.x + float_2.width, float_2.y + float_2.height, float_2.x, float_2.y + float_2.height};
                affineTransform.transform(dArray, 0, dArray, 0, 4);
                double d2 = dArray[0];
                double d3 = dArray[1];
                double d4 = d2;
                double d5 = d3;
                for (int i2 = 2; i2 < 8; i2 += 2) {
                    double d6 = dArray[i2];
                    if (d6 < d2) {
                        d2 = d6;
                    } else if (d6 > d4) {
                        d4 = d6;
                    }
                    d6 = dArray[i2 + 1];
                    if (d6 < d3) {
                        d3 = d6;
                        continue;
                    }
                    if (!(d6 > d5)) continue;
                    d5 = d6;
                }
                float_.x = (float)d2;
                float_.y = (float)d3;
                float_.width = (float)(d4 - d2);
                float_.height = (float)(d5 - d3);
            }
        }

        void appendGlyphOutline(int n2, GeneralPath generalPath, float f2, float f3) {
            GeneralPath generalPath2 = null;
            if (this.sgv.invdtx == null) {
                generalPath2 = this.strike.getGlyphOutline(n2, f2 + this.dx, f3 + this.dy);
            } else {
                generalPath2 = this.strike.getGlyphOutline(n2, 0.0f, 0.0f);
                generalPath2.transform(this.sgv.invdtx);
                generalPath2.transform(AffineTransform.getTranslateInstance(f2 + this.dx, f3 + this.dy));
            }
            PathIterator pathIterator = generalPath2.getPathIterator(null);
            generalPath.append(pathIterator, false);
        }
    }

    static final class GlyphTransformInfo {
        StandardGlyphVector sgv;
        int[] indices;
        double[] transforms;
        SoftReference strikesRef;
        boolean haveAllStrikes;

        GlyphTransformInfo(StandardGlyphVector standardGlyphVector) {
            this.sgv = standardGlyphVector;
        }

        GlyphTransformInfo(StandardGlyphVector standardGlyphVector, GlyphTransformInfo glyphTransformInfo) {
            this.sgv = standardGlyphVector;
            this.indices = glyphTransformInfo.indices == null ? null : (int[])glyphTransformInfo.indices.clone();
            this.transforms = glyphTransformInfo.transforms == null ? null : (double[])glyphTransformInfo.transforms.clone();
            this.strikesRef = null;
        }

        public boolean equals(GlyphTransformInfo glyphTransformInfo) {
            if (glyphTransformInfo == null) {
                return false;
            }
            if (glyphTransformInfo == this) {
                return true;
            }
            if (this.indices.length != glyphTransformInfo.indices.length) {
                return false;
            }
            if (this.transforms.length != glyphTransformInfo.transforms.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.indices.length; ++i2) {
                int n2;
                int n3 = this.indices[i2];
                if (n3 == 0 != ((n2 = glyphTransformInfo.indices[i2]) == 0)) {
                    return false;
                }
                if (n3 == 0) continue;
                n3 *= 6;
                n2 *= 6;
                for (int i3 = 6; i3 > 0; --i3) {
                    if (this.indices[--n3] == glyphTransformInfo.indices[--n2]) continue;
                    return false;
                }
            }
            return true;
        }

        void setGlyphTransform(int n2, AffineTransform affineTransform) {
            double[] dArray = new double[6];
            boolean bl2 = true;
            if (affineTransform == null || affineTransform.isIdentity()) {
                dArray[3] = 1.0;
                dArray[0] = 1.0;
            } else {
                bl2 = false;
                affineTransform.getMatrix(dArray);
            }
            if (this.indices == null) {
                if (bl2) {
                    return;
                }
                this.indices = new int[this.sgv.glyphs.length];
                this.indices[n2] = 1;
                this.transforms = dArray;
            } else {
                int n3;
                int n4;
                boolean bl3 = false;
                int n5 = -1;
                if (bl2) {
                    n5 = 0;
                } else {
                    bl3 = true;
                    block0: for (n4 = 0; n4 < this.transforms.length; n4 += 6) {
                        for (n3 = 0; n3 < 6; ++n3) {
                            if (this.transforms[n4 + n3] != dArray[n3]) continue block0;
                        }
                        bl3 = false;
                        break;
                    }
                    n5 = n4 / 6 + 1;
                }
                n4 = this.indices[n2];
                if (n5 != n4) {
                    n3 = 0;
                    if (n4 != 0) {
                        n3 = 1;
                        for (int i2 = 0; i2 < this.indices.length; ++i2) {
                            if (this.indices[i2] != n4 || i2 == n2) continue;
                            n3 = 0;
                            break;
                        }
                    }
                    if (n3 != 0 && bl3) {
                        n5 = n4;
                        System.arraycopy(dArray, 0, this.transforms, (n5 - 1) * 6, 6);
                    } else if (n3 != 0) {
                        if (this.transforms.length == 6) {
                            this.indices = null;
                            this.transforms = null;
                            this.sgv.clearCaches(n2);
                            this.sgv.clearFlags(1);
                            this.strikesRef = null;
                            return;
                        }
                        double[] dArray2 = new double[this.transforms.length - 6];
                        System.arraycopy(this.transforms, 0, dArray2, 0, (n4 - 1) * 6);
                        System.arraycopy(this.transforms, n4 * 6, dArray2, (n4 - 1) * 6, this.transforms.length - n4 * 6);
                        this.transforms = dArray2;
                        for (int i3 = 0; i3 < this.indices.length; ++i3) {
                            if (this.indices[i3] <= n4) continue;
                            int n6 = i3;
                            this.indices[n6] = this.indices[n6] - 1;
                        }
                        if (n5 > n4) {
                            // empty if block
                        }
                    } else if (bl3) {
                        double[] dArray3 = new double[this.transforms.length + 6];
                        System.arraycopy(this.transforms, 0, dArray3, 0, this.transforms.length);
                        System.arraycopy(dArray, 0, dArray3, this.transforms.length, 6);
                        this.transforms = dArray3;
                    }
                    this.indices[n2] = --n5;
                }
            }
            this.sgv.clearCaches(n2);
            this.sgv.addFlags(1);
            this.strikesRef = null;
        }

        AffineTransform getGlyphTransform(int n2) {
            int n3 = this.indices[n2];
            if (n3 == 0) {
                return null;
            }
            int n4 = (n3 - 1) * 6;
            return new AffineTransform(this.transforms[n4 + 0], this.transforms[n4 + 1], this.transforms[n4 + 2], this.transforms[n4 + 3], this.transforms[n4 + 4], this.transforms[n4 + 5]);
        }

        int transformCount() {
            if (this.transforms == null) {
                return 0;
            }
            return this.transforms.length / 6;
        }

        Object setupGlyphImages(long[] lArray, float[] fArray, AffineTransform affineTransform) {
            int n2 = this.sgv.glyphs.length;
            GlyphStrike[] glyphStrikeArray = this.getAllStrikes();
            for (int i2 = 0; i2 < n2; ++i2) {
                GlyphStrike glyphStrike = glyphStrikeArray[this.indices[i2]];
                int n3 = this.sgv.glyphs[i2];
                lArray[i2] = glyphStrike.strike.getGlyphImagePtr(n3);
                glyphStrike.getGlyphPosition(n3, i2 * 2, this.sgv.positions, fArray);
            }
            affineTransform.transform(fArray, 0, fArray, 0, n2);
            return glyphStrikeArray;
        }

        Rectangle getGlyphsPixelBounds(AffineTransform affineTransform, float f2, float f3, int n2, int n3) {
            Rectangle rectangle = null;
            Rectangle rectangle2 = new Rectangle();
            Point2D.Float float_ = new Point2D.Float();
            int n4 = n2 * 2;
            while (--n3 >= 0) {
                GlyphStrike glyphStrike = this.getStrike(n2);
                float_.x = f2 + this.sgv.positions[n4++] + glyphStrike.dx;
                float_.y = f3 + this.sgv.positions[n4++] + glyphStrike.dy;
                affineTransform.transform(float_, float_);
                glyphStrike.strike.getGlyphImageBounds(this.sgv.glyphs[n2++], float_, rectangle2);
                if (rectangle2.isEmpty()) continue;
                if (rectangle == null) {
                    rectangle = new Rectangle(rectangle2);
                    continue;
                }
                rectangle.add(rectangle2);
            }
            return rectangle != null ? rectangle : rectangle2;
        }

        GlyphStrike getStrike(int n2) {
            if (this.indices != null) {
                GlyphStrike[] glyphStrikeArray = this.getStrikeArray();
                return this.getStrikeAtIndex(glyphStrikeArray, this.indices[n2]);
            }
            return this.sgv.getDefaultStrike();
        }

        private GlyphStrike[] getAllStrikes() {
            if (this.indices == null) {
                return null;
            }
            GlyphStrike[] glyphStrikeArray = this.getStrikeArray();
            if (!this.haveAllStrikes) {
                for (int i2 = 0; i2 < glyphStrikeArray.length; ++i2) {
                    this.getStrikeAtIndex(glyphStrikeArray, i2);
                }
                this.haveAllStrikes = true;
            }
            return glyphStrikeArray;
        }

        private GlyphStrike[] getStrikeArray() {
            GlyphStrike[] glyphStrikeArray = null;
            if (this.strikesRef != null) {
                glyphStrikeArray = (GlyphStrike[])this.strikesRef.get();
            }
            if (glyphStrikeArray == null) {
                this.haveAllStrikes = false;
                glyphStrikeArray = new GlyphStrike[this.transformCount() + 1];
                this.strikesRef = new SoftReference<GlyphStrike[]>(glyphStrikeArray);
            }
            return glyphStrikeArray;
        }

        private GlyphStrike getStrikeAtIndex(GlyphStrike[] glyphStrikeArray, int n2) {
            GlyphStrike glyphStrike = glyphStrikeArray[n2];
            if (glyphStrike == null) {
                if (n2 == 0) {
                    glyphStrike = this.sgv.getDefaultStrike();
                } else {
                    int n3 = (n2 - 1) * 6;
                    AffineTransform affineTransform = new AffineTransform(this.transforms[n3], this.transforms[n3 + 1], this.transforms[n3 + 2], this.transforms[n3 + 3], this.transforms[n3 + 4], this.transforms[n3 + 5]);
                    glyphStrike = GlyphStrike.create(this.sgv, this.sgv.dtx, affineTransform);
                }
                glyphStrikeArray[n2] = glyphStrike;
            }
            return glyphStrike;
        }
    }
}

