/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.geom;

import java.awt.geom.PathIterator;
import java.util.Enumeration;
import java.util.Vector;
import sun.awt.geom.Curve;

public abstract class Crossings {
    public static final boolean debug = false;
    int limit = 0;
    double[] yranges = new double[10];
    double xlo;
    double ylo;
    double xhi;
    double yhi;
    private Vector tmp = new Vector();

    public Crossings(double d2, double d3, double d4, double d5) {
        this.xlo = d2;
        this.ylo = d3;
        this.xhi = d4;
        this.yhi = d5;
    }

    public final double getXLo() {
        return this.xlo;
    }

    public final double getYLo() {
        return this.ylo;
    }

    public final double getXHi() {
        return this.xhi;
    }

    public final double getYHi() {
        return this.yhi;
    }

    public abstract void record(double var1, double var3, int var5);

    public void print() {
        System.out.println("Crossings [");
        System.out.println("  bounds = [" + this.ylo + ", " + this.yhi + "]");
        for (int i2 = 0; i2 < this.limit; i2 += 2) {
            System.out.println("  [" + this.yranges[i2] + ", " + this.yranges[i2 + 1] + "]");
        }
        System.out.println("]");
    }

    public final boolean isEmpty() {
        return this.limit == 0;
    }

    public abstract boolean covers(double var1, double var3);

    public static Crossings findCrossings(Vector vector, double d2, double d3, double d4, double d5) {
        EvenOdd evenOdd = new EvenOdd(d2, d3, d4, d5);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Curve curve = (Curve)enumeration.nextElement();
            if (!curve.accumulateCrossings(evenOdd)) continue;
            return null;
        }
        return evenOdd;
    }

    public static Crossings findCrossings(PathIterator pathIterator, double d2, double d3, double d4, double d5) {
        Crossings crossings = pathIterator.getWindingRule() == 0 ? new EvenOdd(d2, d3, d4, d5) : new NonZero(d2, d3, d4, d5);
        double[] dArray = new double[23];
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(dArray);
            switch (n2) {
                case 0: {
                    if (d7 != d9 && crossings.accumulateLine(d8, d9, d6, d7)) {
                        return null;
                    }
                    d6 = d8 = dArray[0];
                    d7 = d9 = dArray[1];
                    break;
                }
                case 1: {
                    double d10 = dArray[0];
                    double d11 = dArray[1];
                    if (crossings.accumulateLine(d8, d9, d10, d11)) {
                        return null;
                    }
                    d8 = d10;
                    d9 = d11;
                    break;
                }
                case 2: {
                    double d10 = dArray[2];
                    double d11 = dArray[3];
                    if (crossings.accumulateQuad(d8, d9, dArray)) {
                        return null;
                    }
                    d8 = d10;
                    d9 = d11;
                    break;
                }
                case 3: {
                    double d10 = dArray[4];
                    double d11 = dArray[5];
                    if (crossings.accumulateCubic(d8, d9, dArray)) {
                        return null;
                    }
                    d8 = d10;
                    d9 = d11;
                    break;
                }
                case 4: {
                    if (d7 != d9 && crossings.accumulateLine(d8, d9, d6, d7)) {
                        return null;
                    }
                    d8 = d6;
                    d9 = d7;
                }
            }
            pathIterator.next();
        }
        if (d7 != d9 && crossings.accumulateLine(d8, d9, d6, d7)) {
            return null;
        }
        return crossings;
    }

    public boolean accumulateLine(double d2, double d3, double d4, double d5) {
        if (d3 <= d5) {
            return this.accumulateLine(d2, d3, d4, d5, 1);
        }
        return this.accumulateLine(d4, d5, d2, d3, -1);
    }

    public boolean accumulateLine(double d2, double d3, double d4, double d5, int n2) {
        double d6;
        double d7;
        double d8;
        double d9;
        if (this.yhi <= d3 || this.ylo >= d5) {
            return false;
        }
        if (d2 >= this.xhi && d4 >= this.xhi) {
            return false;
        }
        if (d3 == d5) {
            return d2 >= this.xlo || d4 >= this.xlo;
        }
        double d10 = d4 - d2;
        double d11 = d5 - d3;
        if (d3 < this.ylo) {
            d9 = d2 + (this.ylo - d3) * d10 / d11;
            d8 = this.ylo;
        } else {
            d9 = d2;
            d8 = d3;
        }
        if (this.yhi < d5) {
            d7 = d2 + (this.yhi - d3) * d10 / d11;
            d6 = this.yhi;
        } else {
            d7 = d4;
            d6 = d5;
        }
        if (d9 >= this.xhi && d7 >= this.xhi) {
            return false;
        }
        if (d9 > this.xlo || d7 > this.xlo) {
            return true;
        }
        this.record(d8, d6, n2);
        return false;
    }

    public boolean accumulateQuad(double d2, double d3, double[] dArray) {
        if (d3 < this.ylo && dArray[1] < this.ylo && dArray[3] < this.ylo) {
            return false;
        }
        if (d3 > this.yhi && dArray[1] > this.yhi && dArray[3] > this.yhi) {
            return false;
        }
        if (d2 > this.xhi && dArray[0] > this.xhi && dArray[2] > this.xhi) {
            return false;
        }
        if (d2 < this.xlo && dArray[0] < this.xlo && dArray[2] < this.xlo) {
            if (d3 < dArray[3]) {
                this.record(Math.max(d3, this.ylo), Math.min(dArray[3], this.yhi), 1);
            } else if (d3 > dArray[3]) {
                this.record(Math.max(dArray[3], this.ylo), Math.min(d3, this.yhi), -1);
            }
            return false;
        }
        Curve.insertQuad(this.tmp, d2, d3, dArray);
        Enumeration enumeration = this.tmp.elements();
        while (enumeration.hasMoreElements()) {
            Curve curve = (Curve)enumeration.nextElement();
            if (!curve.accumulateCrossings(this)) continue;
            return true;
        }
        this.tmp.clear();
        return false;
    }

    public boolean accumulateCubic(double d2, double d3, double[] dArray) {
        if (d3 < this.ylo && dArray[1] < this.ylo && dArray[3] < this.ylo && dArray[5] < this.ylo) {
            return false;
        }
        if (d3 > this.yhi && dArray[1] > this.yhi && dArray[3] > this.yhi && dArray[5] > this.yhi) {
            return false;
        }
        if (d2 > this.xhi && dArray[0] > this.xhi && dArray[2] > this.xhi && dArray[4] > this.xhi) {
            return false;
        }
        if (d2 < this.xlo && dArray[0] < this.xlo && dArray[2] < this.xlo && dArray[4] < this.xlo) {
            if (d3 <= dArray[5]) {
                this.record(Math.max(d3, this.ylo), Math.min(dArray[5], this.yhi), 1);
            } else {
                this.record(Math.max(dArray[5], this.ylo), Math.min(d3, this.yhi), -1);
            }
            return false;
        }
        Curve.insertCubic(this.tmp, d2, d3, dArray);
        Enumeration enumeration = this.tmp.elements();
        while (enumeration.hasMoreElements()) {
            Curve curve = (Curve)enumeration.nextElement();
            if (!curve.accumulateCrossings(this)) continue;
            return true;
        }
        this.tmp.clear();
        return false;
    }

    public static final class EvenOdd
    extends Crossings {
        public EvenOdd(double d2, double d3, double d4, double d5) {
            super(d2, d3, d4, d5);
        }

        public final boolean covers(double d2, double d3) {
            return this.limit == 2 && this.yranges[0] <= d2 && this.yranges[1] >= d3;
        }

        public void record(double d2, double d3, int n2) {
            int n3;
            if (d2 >= d3) {
                return;
            }
            for (n3 = 0; n3 < this.limit && d2 > this.yranges[n3 + 1]; n3 += 2) {
            }
            int n4 = n3;
            while (n3 < this.limit) {
                double d4;
                double d5;
                double d6;
                double d7;
                double d8 = this.yranges[n3++];
                double d9 = this.yranges[n3++];
                if (d3 < d8) {
                    this.yranges[n4++] = d2;
                    this.yranges[n4++] = d3;
                    d2 = d8;
                    d3 = d9;
                    continue;
                }
                if (d2 < d8) {
                    d7 = d2;
                    d6 = d8;
                } else {
                    d7 = d8;
                    d6 = d2;
                }
                if (d3 < d9) {
                    d5 = d3;
                    d4 = d9;
                } else {
                    d5 = d9;
                    d4 = d3;
                }
                if (d6 == d5) {
                    d2 = d7;
                    d3 = d4;
                } else {
                    if (d6 > d5) {
                        d2 = d5;
                        d5 = d6;
                        d6 = d2;
                    }
                    if (d7 != d6) {
                        this.yranges[n4++] = d7;
                        this.yranges[n4++] = d6;
                    }
                    d2 = d5;
                    d3 = d4;
                }
                if (!(d2 >= d3)) continue;
                break;
            }
            if (n4 < n3 && n3 < this.limit) {
                System.arraycopy(this.yranges, n3, this.yranges, n4, this.limit - n3);
            }
            n4 += this.limit - n3;
            if (d2 < d3) {
                if (n4 >= this.yranges.length) {
                    double[] dArray = new double[n4 + 10];
                    System.arraycopy(this.yranges, 0, dArray, 0, n4);
                    this.yranges = dArray;
                }
                this.yranges[n4++] = d2;
                this.yranges[n4++] = d3;
            }
            this.limit = n4;
        }
    }

    public static final class NonZero
    extends Crossings {
        private int[] crosscounts;

        public NonZero(double d2, double d3, double d4, double d5) {
            super(d2, d3, d4, d5);
            this.crosscounts = new int[this.yranges.length / 2];
        }

        public final boolean covers(double d2, double d3) {
            int n2 = 0;
            while (n2 < this.limit) {
                double d4;
                double d5 = this.yranges[n2++];
                if (d2 >= (d4 = this.yranges[n2++])) continue;
                if (d2 < d5) {
                    return false;
                }
                if (d3 <= d4) {
                    return true;
                }
                d2 = d4;
            }
            return d2 >= d3;
        }

        public void remove(int n2) {
            this.limit -= 2;
            int n3 = this.limit - n2;
            if (n3 > 0) {
                System.arraycopy(this.yranges, n2 + 2, this.yranges, n2, n3);
                System.arraycopy(this.crosscounts, n2 / 2 + 1, this.crosscounts, n2 / 2, n3 / 2);
            }
        }

        public void insert(int n2, double d2, double d3, int n3) {
            int n4 = this.limit - n2;
            double[] dArray = this.yranges;
            int[] nArray = this.crosscounts;
            if (this.limit >= this.yranges.length) {
                this.yranges = new double[this.limit + 10];
                System.arraycopy(dArray, 0, this.yranges, 0, n2);
                this.crosscounts = new int[(this.limit + 10) / 2];
                System.arraycopy(nArray, 0, this.crosscounts, 0, n2 / 2);
            }
            if (n4 > 0) {
                System.arraycopy(dArray, n2, this.yranges, n2 + 2, n4);
                System.arraycopy(nArray, n2 / 2, this.crosscounts, n2 / 2 + 1, n4 / 2);
            }
            this.yranges[n2 + 0] = d2;
            this.yranges[n2 + 1] = d3;
            this.crosscounts[n2 / 2] = n3;
            this.limit += 2;
        }

        public void record(double d2, double d3, int n2) {
            int n3;
            if (d2 >= d3) {
                return;
            }
            for (n3 = 0; n3 < this.limit && d2 > this.yranges[n3 + 1]; n3 += 2) {
            }
            if (n3 < this.limit) {
                int n4 = this.crosscounts[n3 / 2];
                double d4 = this.yranges[n3 + 0];
                double d5 = this.yranges[n3 + 1];
                if (d5 == d2 && n4 == n2) {
                    if (n3 + 2 == this.limit) {
                        this.yranges[n3 + 1] = d3;
                        return;
                    }
                    this.remove(n3);
                    d2 = d4;
                    n4 = this.crosscounts[n3 / 2];
                    d4 = this.yranges[n3 + 0];
                    d5 = this.yranges[n3 + 1];
                }
                if (d3 < d4) {
                    this.insert(n3, d2, d3, n2);
                    return;
                }
                if (d3 == d4 && n4 == n2) {
                    this.yranges[n3] = d2;
                    return;
                }
                if (d2 < d4) {
                    this.insert(n3, d2, d4, n2);
                    n3 += 2;
                    d2 = d4;
                } else if (d4 < d2) {
                    this.insert(n3, d4, d2, n4);
                    n3 += 2;
                    d4 = d2;
                }
                int n5 = n4 + n2;
                double d6 = Math.min(d3, d5);
                if (n5 == 0) {
                    this.remove(n3);
                } else {
                    this.crosscounts[n3 / 2] = n5;
                    this.yranges[n3++] = d2;
                    this.yranges[n3++] = d6;
                }
                d2 = d4 = d6;
                if (d4 < d5) {
                    this.insert(n3, d4, d5, n4);
                }
            }
            if (d2 < d3) {
                this.insert(n3, d2, d3, n2);
            }
        }
    }
}

