/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html.parser;

import java.io.IOException;
import java.io.Reader;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.Element;
import javax.swing.text.html.parser.Parser;
import javax.swing.text.html.parser.TagElement;

public class DocumentParser
extends Parser {
    private int inbody;
    private int intitle;
    private int inhead;
    private int instyle;
    private int inscript;
    private boolean seentitle;
    private HTMLEditorKit.ParserCallback callback = null;
    private boolean ignoreCharSet = false;
    private static final boolean debugFlag = false;

    public DocumentParser(DTD dTD) {
        super(dTD);
    }

    public void parse(Reader reader, HTMLEditorKit.ParserCallback parserCallback, boolean bl2) throws IOException {
        this.ignoreCharSet = bl2;
        this.callback = parserCallback;
        this.parse(reader);
        parserCallback.handleEndOfLineString(this.getEndOfLineString());
    }

    protected void handleStartTag(TagElement tagElement) {
        Element element = tagElement.getElement();
        if (element == this.dtd.body) {
            ++this.inbody;
        } else if (element != this.dtd.html) {
            if (element == this.dtd.head) {
                ++this.inhead;
            } else if (element == this.dtd.title) {
                ++this.intitle;
            } else if (element == this.dtd.style) {
                ++this.instyle;
            } else if (element == this.dtd.script) {
                ++this.inscript;
            }
        }
        if (tagElement.fictional()) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(HTMLEditorKit.ParserCallback.IMPLIED, Boolean.TRUE);
            this.callback.handleStartTag(tagElement.getHTMLTag(), simpleAttributeSet, this.getBlockStartPosition());
        } else {
            this.callback.handleStartTag(tagElement.getHTMLTag(), this.getAttributes(), this.getBlockStartPosition());
            this.flushAttributes();
        }
    }

    protected void handleComment(char[] cArray) {
        this.callback.handleComment(cArray, this.getBlockStartPosition());
    }

    protected void handleEmptyTag(TagElement tagElement) throws ChangedCharSetException {
        String string;
        SimpleAttributeSet simpleAttributeSet;
        Element element = tagElement.getElement();
        if (element == this.dtd.meta && !this.ignoreCharSet && (simpleAttributeSet = this.getAttributes()) != null && (string = (String)simpleAttributeSet.getAttribute(HTML.Attribute.CONTENT)) != null) {
            if ("content-type".equalsIgnoreCase((String)simpleAttributeSet.getAttribute(HTML.Attribute.HTTPEQUIV))) {
                if (!string.equalsIgnoreCase("text/html") && !string.equalsIgnoreCase("text/plain")) {
                    throw new ChangedCharSetException(string, false);
                }
            } else if ("charset".equalsIgnoreCase((String)simpleAttributeSet.getAttribute(HTML.Attribute.HTTPEQUIV))) {
                throw new ChangedCharSetException(string, true);
            }
        }
        if (this.inbody != 0 || element == this.dtd.meta || element == this.dtd.base || element == this.dtd.isindex || element == this.dtd.style || element == this.dtd.link) {
            if (tagElement.fictional()) {
                simpleAttributeSet = new SimpleAttributeSet();
                simpleAttributeSet.addAttribute(HTMLEditorKit.ParserCallback.IMPLIED, Boolean.TRUE);
                this.callback.handleSimpleTag(tagElement.getHTMLTag(), simpleAttributeSet, this.getBlockStartPosition());
            } else {
                this.callback.handleSimpleTag(tagElement.getHTMLTag(), this.getAttributes(), this.getBlockStartPosition());
                this.flushAttributes();
            }
        }
    }

    protected void handleEndTag(TagElement tagElement) {
        Element element = tagElement.getElement();
        if (element == this.dtd.body) {
            --this.inbody;
        } else if (element == this.dtd.title) {
            --this.intitle;
            this.seentitle = true;
        } else if (element == this.dtd.head) {
            --this.inhead;
        } else if (element == this.dtd.style) {
            --this.instyle;
        } else if (element == this.dtd.script) {
            --this.inscript;
        }
        this.callback.handleEndTag(tagElement.getHTMLTag(), this.getBlockStartPosition());
    }

    protected void handleText(char[] cArray) {
        if (cArray != null) {
            if (this.inscript != 0) {
                this.callback.handleComment(cArray, this.getBlockStartPosition());
                return;
            }
            if (this.inbody != 0 || this.instyle != 0 || this.intitle != 0 && !this.seentitle) {
                this.callback.handleText(cArray, this.getBlockStartPosition());
            }
        }
    }

    protected void handleError(int n2, String string) {
        this.callback.handleError(string, this.getCurrentPos());
    }

    private void debug(String string) {
        System.out.println(string);
    }
}

