/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class String
implements Serializable,
Comparable<String>,
CharSequence {
    private final char[] value;
    private final int offset;
    private final int count;
    private int hash;
    private static final long serialVersionUID = -6849794470754667710L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();

    public String() {
        this.offset = 0;
        this.count = 0;
        this.value = new char[0];
    }

    public String(String string) {
        char[] cArray;
        int n2 = string.count;
        char[] cArray2 = string.value;
        if (cArray2.length > n2) {
            cArray = new char[n2];
            System.arraycopy(cArray2, string.offset, cArray, 0, n2);
        } else {
            cArray = cArray2;
        }
        this.offset = 0;
        this.count = n2;
        this.value = cArray;
    }

    public String(char[] cArray) {
        int n2 = cArray.length;
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        this.offset = 0;
        this.count = n2;
        this.value = cArray2;
    }

    public String(char[] cArray, int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > cArray.length - n3) {
            throw new StringIndexOutOfBoundsException(n2 + n3);
        }
        char[] cArray2 = new char[n3];
        System.arraycopy(cArray, n2, cArray2, 0, n3);
        this.offset = 0;
        this.count = n3;
        this.value = cArray2;
    }

    public String(int[] nArray, int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > nArray.length - n3) {
            throw new StringIndexOutOfBoundsException(n2 + n3);
        }
        int n4 = 0;
        int n5 = 1;
        char[] cArray = new char[n3 + n5];
        int n6 = n2;
        int n7 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n8;
            if ((n8 = nArray[n6++]) < 0) {
                throw new IllegalArgumentException();
            }
            if (n5 <= 0 && n7 + 1 >= cArray.length) {
                if (n4 == 0) {
                    n4 = ((-n5 + 1) * n3 << 10) / i2;
                    if ((n4 >>= 10) <= 0) {
                        n4 = 1;
                    }
                } else {
                    n4 *= 2;
                }
                char[] cArray2 = new char[Math.min(cArray.length + n4, n3 * 2)];
                n5 = cArray2.length - cArray.length - (n3 - i2);
                System.arraycopy(cArray, 0, cArray2, 0, n7);
                cArray = cArray2;
            }
            if (n8 < 65536) {
                cArray[n7++] = (char)n8;
                continue;
            }
            if (n8 <= 0x10FFFF) {
                Character.toSurrogates(n8, cArray, n7);
                n7 += 2;
                --n5;
                continue;
            }
            throw new IllegalArgumentException();
        }
        this.offset = 0;
        this.value = cArray;
        this.count = n7;
    }

    @Deprecated
    public String(byte[] byArray, int n2, int n3, int n4) {
        String.checkBounds(byArray, n3, n4);
        char[] cArray = new char[n4];
        if (n2 == 0) {
            int n5 = n4;
            while (n5-- > 0) {
                cArray[n5] = (char)(byArray[n5 + n3] & 0xFF);
            }
        } else {
            n2 <<= 8;
            int n6 = n4;
            while (n6-- > 0) {
                cArray[n6] = (char)(n2 | byArray[n6 + n3] & 0xFF);
            }
        }
        this.offset = 0;
        this.count = n4;
        this.value = cArray;
    }

    @Deprecated
    public String(byte[] byArray, int n2) {
        this(byArray, n2, 0, byArray.length);
    }

    private static void checkBounds(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n2 > byArray.length - n3) {
            throw new StringIndexOutOfBoundsException(n2 + n3);
        }
    }

    public String(byte[] byArray, int n2, int n3, String string) throws UnsupportedEncodingException {
        if (string == null) {
            throw new NullPointerException("charsetName");
        }
        String.checkBounds(byArray, n2, n3);
        char[] cArray = StringCoding.decode(string, byArray, n2, n3);
        this.offset = 0;
        this.count = cArray.length;
        this.value = cArray;
    }

    public String(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(byArray, 0, byArray.length, string);
    }

    public String(byte[] byArray, int n2, int n3) {
        String.checkBounds(byArray, n2, n3);
        char[] cArray = StringCoding.decode(byArray, n2, n3);
        this.offset = 0;
        this.count = cArray.length;
        this.value = cArray;
    }

    public String(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public String(StringBuffer stringBuffer) {
        String string = stringBuffer.toString();
        this.value = string.value;
        this.count = string.count;
        this.offset = string.offset;
    }

    public String(StringBuilder stringBuilder) {
        String string = stringBuilder.toString();
        this.value = string.value;
        this.count = string.count;
        this.offset = string.offset;
    }

    String(int n2, int n3, char[] cArray) {
        this.value = cArray;
        this.offset = n2;
        this.count = n3;
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public char charAt(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        return this.value[n2 + this.offset];
    }

    public int codePointAt(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        return Character.codePointAtImpl(this.value, this.offset + n2, this.offset + this.count);
    }

    public int codePointBefore(int n2) {
        int n3 = n2 - 1;
        if (n3 < 0 || n3 >= this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        return Character.codePointBeforeImpl(this.value, this.offset + n2, this.offset);
    }

    public int codePointCount(int n2, int n3) {
        if (n2 < 0 || n3 > this.count || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointCountImpl(this.value, this.offset + n2, n3 - n2);
    }

    public int offsetByCodePoints(int n2, int n3) {
        if (n2 < 0 || n2 > this.count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePointsImpl(this.value, this.offset, this.count, this.offset + n2, n3);
    }

    void getChars(char[] cArray, int n2) {
        System.arraycopy(this.value, this.offset, cArray, n2, this.count);
    }

    public void getChars(int n2, int n3, char[] cArray, int n4) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.count) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException(n3 - n2);
        }
        System.arraycopy(this.value, this.offset + n2, cArray, n4, n3 - n2);
    }

    @Deprecated
    public void getBytes(int n2, int n3, byte[] byArray, int n4) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.count) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException(n3 - n2);
        }
        int n5 = n4;
        int n6 = this.offset + n3;
        int n7 = this.offset + n2;
        char[] cArray = this.value;
        while (n7 < n6) {
            byArray[n5++] = (byte)cArray[n7++];
        }
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        if (string == null) {
            throw new NullPointerException();
        }
        return StringCoding.encode(string, this.value, this.offset, this.count);
    }

    public byte[] getBytes() {
        return StringCoding.encode(this.value, this.offset, this.count);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            int n2 = this.count;
            if (n2 == string.count) {
                char[] cArray = this.value;
                char[] cArray2 = string.value;
                int n3 = this.offset;
                int n4 = string.offset;
                while (n2-- != 0) {
                    if (cArray[n3++] == cArray2[n4++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            return this.contentEquals((CharSequence)stringBuffer);
        }
    }

    public boolean contentEquals(CharSequence charSequence) {
        int n2;
        int n3;
        char[] cArray;
        if (this.count != charSequence.length()) {
            return false;
        }
        if (charSequence instanceof AbstractStringBuilder) {
            cArray = this.value;
            char[] cArray2 = ((AbstractStringBuilder)charSequence).getValue();
            n3 = this.offset;
            n2 = 0;
            int n4 = this.count;
            while (n4-- != 0) {
                if (cArray[n3++] == cArray2[n2++]) continue;
                return false;
            }
        }
        if (charSequence.equals(this)) {
            return true;
        }
        cArray = this.value;
        int n5 = this.offset;
        n3 = 0;
        n2 = this.count;
        while (n2-- != 0) {
            if (cArray[n5++] == charSequence.charAt(n3++)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String string) {
        return this == string ? true : string != null && string.count == this.count && this.regionMatches(true, 0, string, 0, this.count);
    }

    @Override
    public int compareTo(String string) {
        int n2 = this.count;
        int n3 = string.count;
        int n4 = Math.min(n2, n3);
        char[] cArray = this.value;
        char[] cArray2 = string.value;
        int n5 = this.offset;
        int n6 = string.offset;
        if (n5 == n6) {
            int n7 = n4 + n5;
            for (int i2 = n5; i2 < n7; ++i2) {
                char c2 = cArray[i2];
                char c3 = cArray2[i2];
                if (c2 == c3) continue;
                return c2 - c3;
            }
        } else {
            while (n4-- != 0) {
                char c4;
                char c5;
                if ((c5 = cArray[n5++]) == (c4 = cArray2[n6++])) continue;
                return c5 - c4;
            }
        }
        return n2 - n3;
    }

    public int compareToIgnoreCase(String string) {
        return CASE_INSENSITIVE_ORDER.compare(this, string);
    }

    public boolean regionMatches(int n2, String string, int n3, int n4) {
        char[] cArray = this.value;
        int n5 = this.offset + n2;
        char[] cArray2 = string.value;
        int n6 = string.offset + n3;
        if (n3 < 0 || n2 < 0 || (long)n2 > (long)this.count - (long)n4 || (long)n3 > (long)string.count - (long)n4) {
            return false;
        }
        while (n4-- > 0) {
            if (cArray[n5++] == cArray2[n6++]) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(boolean bl2, int n2, String string, int n3, int n4) {
        char[] cArray = this.value;
        int n5 = this.offset + n2;
        char[] cArray2 = string.value;
        int n6 = string.offset + n3;
        if (n3 < 0 || n2 < 0 || (long)n2 > (long)this.count - (long)n4 || (long)n3 > (long)string.count - (long)n4) {
            return false;
        }
        while (n4-- > 0) {
            char c2;
            char c3;
            char c4;
            char c5;
            if ((c5 = cArray[n5++]) == (c4 = cArray2[n6++]) || bl2 && ((c3 = Character.toUpperCase(c5)) == (c2 = Character.toUpperCase(c4)) || Character.toLowerCase(c3) == Character.toLowerCase(c2))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string, int n2) {
        char[] cArray = this.value;
        int n3 = this.offset + n2;
        char[] cArray2 = string.value;
        int n4 = string.offset;
        int n5 = string.count;
        if (n2 < 0 || n2 > this.count - n5) {
            return false;
        }
        while (--n5 >= 0) {
            if (cArray[n3++] == cArray2[n4++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, 0);
    }

    public boolean endsWith(String string) {
        return this.startsWith(string, this.count - string.count);
    }

    public int hashCode() {
        int n2 = this.hash;
        if (n2 == 0) {
            int n3 = this.offset;
            char[] cArray = this.value;
            int n4 = this.count;
            for (int i2 = 0; i2 < n4; ++i2) {
                n2 = 31 * n2 + cArray[n3++];
            }
            this.hash = n2;
        }
        return n2;
    }

    public int indexOf(int n2) {
        return this.indexOf(n2, 0);
    }

    public int indexOf(int n2, int n3) {
        int n4;
        int n5 = this.offset + this.count;
        char[] cArray = this.value;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= this.count) {
            return -1;
        }
        if (n2 < 65536) {
            for (n4 = this.offset + n3; n4 < n5; ++n4) {
                if (cArray[n4] != n2) continue;
                return n4 - this.offset;
            }
            return -1;
        }
        if (n2 <= 0x10FFFF) {
            char[] cArray2 = Character.toChars(n2);
            while (n4 < n5) {
                if (cArray[n4] == cArray2[0]) {
                    if (n4 + 1 == n5) break;
                    if (cArray[n4 + 1] == cArray2[1]) {
                        return n4 - this.offset;
                    }
                }
                ++n4;
            }
        }
        return -1;
    }

    public int lastIndexOf(int n2) {
        return this.lastIndexOf(n2, this.count - 1);
    }

    public int lastIndexOf(int n2, int n3) {
        int n4;
        int n5 = this.offset;
        char[] cArray = this.value;
        if (n2 < 65536) {
            for (n4 = this.offset + (n3 >= this.count ? this.count - 1 : n3); n4 >= n5; --n4) {
                if (cArray[n4] != n2) continue;
                return n4 - this.offset;
            }
            return -1;
        }
        int n6 = this.offset + this.count;
        if (n2 <= 0x10FFFF) {
            char[] cArray2 = Character.toChars(n2);
            while (n4 >= n5) {
                if (cArray[n4] == cArray2[0]) {
                    if (n4 + 1 == n6) break;
                    if (cArray[n4 + 1] == cArray2[1]) {
                        return n4 - this.offset;
                    }
                }
                --n4;
            }
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n2) {
        return String.indexOf(this.value, this.offset, this.count, string.value, string.offset, string.count, n2);
    }

    static int indexOf(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, int n6) {
        if (n6 >= n3) {
            return n5 == 0 ? n3 : -1;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 == 0) {
            return n6;
        }
        char c2 = cArray2[n4];
        int n7 = n2 + (n3 - n5);
        for (int i2 = n2 + n6; i2 <= n7; ++i2) {
            if (cArray[i2] != c2) {
                while (++i2 <= n7 && cArray[i2] != c2) {
                }
            }
            if (i2 > n7) continue;
            int n8 = i2 + 1;
            int n9 = n8 + n5 - 1;
            int n10 = n4 + 1;
            while (n8 < n9 && cArray[n8] == cArray2[n10]) {
                ++n8;
                ++n10;
            }
            if (n8 != n9) continue;
            return i2 - n2;
        }
        return -1;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String string, int n2) {
        return String.lastIndexOf(this.value, this.offset, this.count, string.value, string.offset, string.count, n2);
    }

    static int lastIndexOf(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, int n6) {
        int n7;
        int n8 = n3 - n5;
        if (n6 < 0) {
            return -1;
        }
        if (n6 > n8) {
            n6 = n8;
        }
        if (n5 == 0) {
            return n6;
        }
        int n9 = n4 + n5 - 1;
        char c2 = cArray2[n9];
        int n10 = n2 + n5 - 1;
        int n11 = n10 + n6;
        block0: while (true) {
            if (n11 >= n10 && cArray[n11] != c2) {
                --n11;
                continue;
            }
            if (n11 < n10) {
                return -1;
            }
            int n12 = n11 - 1;
            n7 = n12 - (n5 - 1);
            int n13 = n9 - 1;
            while (n12 > n7) {
                if (cArray[n12--] == cArray2[n13--]) continue;
                --n11;
                continue block0;
            }
            break;
        }
        return n7 - n2 + 1;
    }

    public String substring(int n2) {
        return this.substring(n2, this.count);
    }

    public String substring(int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.count) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException(n3 - n2);
        }
        return n2 == 0 && n3 == this.count ? this : new String(this.offset + n2, n3 - n2, this.value);
    }

    @Override
    public CharSequence subSequence(int n2, int n3) {
        return this.substring(n2, n3);
    }

    public String concat(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return this;
        }
        char[] cArray = new char[this.count + n2];
        this.getChars(0, this.count, cArray, 0);
        string.getChars(0, n2, cArray, this.count);
        return new String(0, this.count + n2, cArray);
    }

    public String replace(char c2, char n2) {
        if (c2 != n2) {
            int n3 = this.count;
            int n4 = -1;
            char[] cArray = this.value;
            int n5 = this.offset;
            while (++n4 < n3 && cArray[n5 + n4] != c2) {
            }
            if (n4 < n3) {
                int n6;
                char[] cArray2 = new char[n3];
                for (n6 = 0; n6 < n4; ++n6) {
                    cArray2[n6] = cArray[n5 + n6];
                }
                while (n4 < n3) {
                    n6 = cArray[n5 + n4];
                    cArray2[n4] = n6 == c2 ? n2 : n6;
                    ++n4;
                }
                return new String(0, n3, cArray2);
            }
        }
        return this;
    }

    public boolean matches(String string) {
        return Pattern.matches(string, this);
    }

    public boolean contains(CharSequence charSequence) {
        return this.indexOf(((Object)charSequence).toString()) > -1;
    }

    public String replaceFirst(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceFirst(string2);
    }

    public String replaceAll(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceAll(string2);
    }

    public String replace(CharSequence charSequence, CharSequence charSequence2) {
        return Pattern.compile(((Object)charSequence).toString(), 16).matcher(this).replaceAll(Matcher.quoteReplacement(((Object)charSequence2).toString()));
    }

    public String[] split(String string, int n2) {
        return Pattern.compile(string).split(this, n2);
    }

    public String[] split(String string) {
        return this.split(string, 0);
    }

    public String toLowerCase(Locale locale) {
        int n2;
        int n3;
        block6: {
            int n4;
            if (locale == null) {
                throw new NullPointerException();
            }
            for (n3 = 0; n3 < this.count; n3 += Character.charCount(n4)) {
                n4 = this.codePointAt(n3);
                if (n4 == Character.toLowerCase(n4)) {
                    continue;
                }
                break block6;
            }
            return this;
        }
        char[] cArray = new char[this.count];
        int n5 = 0;
        System.arraycopy(this.value, this.offset, cArray, 0, n3);
        String string = locale.getLanguage().intern();
        boolean bl2 = string == "tr" || string == "az" || string == "lt";
        for (int i2 = n3; i2 < this.count; i2 += n2) {
            int n6 = this.codePointAt(i2);
            n2 = Character.charCount(n6);
            int n7 = bl2 || n6 == 931 ? ConditionalSpecialCasing.toLowerCaseEx(this, i2, locale) : Character.toLowerCase(n6);
            if (n7 == 65535 || Character.isSupplementaryCodePoint(n7)) {
                char[] cArray2 = n7 == 65535 ? ConditionalSpecialCasing.toLowerCaseCharArray(this, i2, locale) : Character.toChars(n7);
                int n8 = cArray2.length;
                char[] cArray3 = new char[cArray.length + n8 - n2];
                System.arraycopy(cArray, 0, cArray3, 0, i2 + n5);
                for (int i3 = 0; i3 < n8; ++i3) {
                    cArray3[i2 + n5 + i3] = cArray2[i3];
                }
                n5 += n8 - n2;
                cArray = cArray3;
                continue;
            }
            cArray[i2 + n5] = (char)n7;
        }
        return new String(0, cArray.length, cArray);
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public String toUpperCase(Locale locale) {
        int n2;
        int n3;
        int n4;
        block6: {
            int n5;
            if (locale == null) {
                throw new NullPointerException();
            }
            for (n4 = 0; n4 < this.count; n4 += Character.charCount(n5)) {
                n5 = this.codePointAt(n4);
                n3 = Character.toUpperCaseEx(n5);
                if (n3 != 65535 && n5 == n3) {
                    continue;
                }
                break block6;
            }
            return this;
        }
        char[] cArray = new char[this.count];
        n3 = 0;
        System.arraycopy(this.value, this.offset, cArray, 0, n4);
        String string = locale.getLanguage().intern();
        boolean bl2 = string == "tr" || string == "az" || string == "lt";
        for (int i2 = n4; i2 < this.count; i2 += n2) {
            int n6 = this.codePointAt(i2);
            n2 = Character.charCount(n6);
            int n7 = bl2 ? ConditionalSpecialCasing.toUpperCaseEx(this, i2, locale) : Character.toUpperCaseEx(n6);
            if (n7 == 65535 || Character.isSupplementaryCodePoint(n7)) {
                char[] cArray2 = n7 == 65535 ? (bl2 ? ConditionalSpecialCasing.toUpperCaseCharArray(this, i2, locale) : Character.toUpperCaseCharArray(n6)) : Character.toChars(n7);
                int n8 = cArray2.length;
                char[] cArray3 = new char[cArray.length + n8 - n2];
                System.arraycopy(cArray, 0, cArray3, 0, i2 + n3);
                for (int i3 = 0; i3 < n8; ++i3) {
                    cArray3[i2 + n3 + i3] = cArray2[i3];
                }
                n3 += n8 - n2;
                cArray = cArray3;
                continue;
            }
            cArray[i2 + n3] = (char)n7;
        }
        return new String(0, cArray.length, cArray);
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public String trim() {
        int n2;
        int n3 = this.count;
        int n4 = this.offset;
        char[] cArray = this.value;
        for (n2 = 0; n2 < n3 && cArray[n4 + n2] <= ' '; ++n2) {
        }
        while (n2 < n3 && cArray[n4 + n3 - 1] <= ' ') {
            --n3;
        }
        return n2 > 0 || n3 < this.count ? this.substring(n2, n3) : this;
    }

    @Override
    public String toString() {
        return this;
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.count];
        this.getChars(0, this.count, cArray, 0);
        return cArray;
    }

    public static String format(String string, Object ... objectArray) {
        return new Formatter().format(string, objectArray).toString();
    }

    public static String format(Locale locale, String string, Object ... objectArray) {
        return new Formatter(locale).format(string, objectArray).toString();
    }

    public static String valueOf(Object object) {
        return object == null ? "null" : object.toString();
    }

    public static String valueOf(char[] cArray) {
        return new String(cArray);
    }

    public static String valueOf(char[] cArray, int n2, int n3) {
        return new String(cArray, n2, n3);
    }

    public static String copyValueOf(char[] cArray, int n2, int n3) {
        return new String(cArray, n2, n3);
    }

    public static String copyValueOf(char[] cArray) {
        return String.copyValueOf(cArray, 0, cArray.length);
    }

    public static String valueOf(boolean bl2) {
        return bl2 ? "true" : "false";
    }

    public static String valueOf(char c2) {
        char[] cArray = new char[]{c2};
        return new String(0, 1, cArray);
    }

    public static String valueOf(int n2) {
        return Integer.toString(n2, 10);
    }

    public static String valueOf(long l2) {
        return Long.toString(l2, 10);
    }

    public static String valueOf(float f2) {
        return Float.toString(f2);
    }

    public static String valueOf(double d2) {
        return Double.toString(d2);
    }

    public native String intern();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            int n2 = string.length();
            int n3 = string2.length();
            int n4 = 0;
            for (int i2 = 0; n4 < n2 && i2 < n3; ++n4, ++i2) {
                char c2;
                char c3 = string.charAt(n4);
                if (c3 == (c2 = string2.charAt(i2)) || (c3 = Character.toUpperCase(c3)) == (c2 = Character.toUpperCase(c2)) || (c3 = Character.toLowerCase(c3)) == (c2 = Character.toLowerCase(c2))) continue;
                return c3 - c2;
            }
            return n2 - n3;
        }
    }
}

