/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.sun.beans.ObjectHandler;
import java.beans.ExceptionListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;

class ReflectionUtils {
    private static Reference methodCacheRef;

    ReflectionUtils() {
    }

    public static Class typeToClass(Class clazz) {
        return clazz.isPrimitive() ? ObjectHandler.typeNameToClass(clazz.getName()) : clazz;
    }

    public static boolean isPrimitive(Class clazz) {
        return ReflectionUtils.primitiveTypeFor(clazz) != null;
    }

    public static Class primitiveTypeFor(Class clazz) {
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Void.class) {
            return Void.TYPE;
        }
        return null;
    }

    private static boolean matchArguments(Class[] classArray, Class[] classArray2) {
        return ReflectionUtils.matchArguments(classArray, classArray2, false);
    }

    private static boolean matchExplicitArguments(Class[] classArray, Class[] classArray2) {
        return ReflectionUtils.matchArguments(classArray, classArray2, true);
    }

    private static boolean matchArguments(Class[] classArray, Class[] classArray2, boolean bl2) {
        boolean bl3 = classArray.length == classArray2.length;
        for (int i2 = 0; i2 < classArray.length && bl3; ++i2) {
            Class clazz = classArray2[i2];
            if (clazz.isPrimitive()) {
                clazz = ReflectionUtils.typeToClass(clazz);
            }
            if (bl2) {
                if (classArray[i2] == clazz) continue;
                bl3 = false;
                continue;
            }
            if (classArray[i2] == null || clazz.isAssignableFrom(classArray[i2])) continue;
            bl3 = false;
        }
        return bl3;
    }

    public static Method findPublicMethod(Class clazz, String string, Class[] classArray) {
        Method method;
        if (classArray.length == 0) {
            try {
                return clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        Method[] methodArray = clazz.getMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            method = methodArray[i2];
            if (!method.getName().equals(string) || !ReflectionUtils.matchArguments(classArray, method.getParameterTypes())) continue;
            arrayList.add(method);
        }
        if (arrayList.size() > 0) {
            if (arrayList.size() == 1) {
                return (Method)arrayList.get(0);
            }
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                method = (Method)listIterator.next();
                if (!ReflectionUtils.matchExplicitArguments(classArray, method.getParameterTypes())) continue;
                return method;
            }
            return ReflectionUtils.getMostSpecificMethod(arrayList, classArray);
        }
        return null;
    }

    private static Method getMostSpecificMethod(List list, Class[] classArray) {
        int n2;
        Method method = null;
        int n3 = n2 = 0;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Method method2 = (Method)listIterator.next();
            Class<?>[] classArray2 = method2.getParameterTypes();
            n2 = 0;
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                Class clazz = classArray2[i2];
                if (clazz.isPrimitive()) {
                    clazz = ReflectionUtils.typeToClass(clazz);
                }
                if (classArray[i2] != clazz) continue;
                ++n2;
            }
            if (n2 == 0 && n3 == 0) {
                if (method == null) {
                    method = method2;
                    continue;
                }
                if (ReflectionUtils.matchArguments(method.getParameterTypes(), method2.getParameterTypes())) continue;
                method = method2;
                continue;
            }
            if (n2 > n3) {
                n3 = n2;
                method = method2;
                continue;
            }
            if (n2 != n3) continue;
            method = null;
        }
        return method;
    }

    public static Method findMethod(Class clazz, String string, Class[] classArray) {
        Method method = ReflectionUtils.findPublicMethod(clazz, string, classArray);
        if (method != null && Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            return method;
        }
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Class[] classArray2 = clazz2.getInterfaces();
            for (int i2 = 0; i2 < classArray2.length; ++i2) {
                method = ReflectionUtils.findPublicMethod(classArray2[i2], string, classArray);
                if (method == null) continue;
                return method;
            }
        }
        return null;
    }

    public static synchronized Method getMethod(Class clazz, String string, Class[] classArray) {
        Signature signature = new Signature(clazz, string, classArray);
        Method method = null;
        HashMap<Signature, Method> hashMap = null;
        if (methodCacheRef != null && (hashMap = (HashMap<Signature, Method>)methodCacheRef.get()) != null && (method = (Method)hashMap.get(signature)) != null) {
            return method;
        }
        method = ReflectionUtils.findMethod(clazz, string, classArray);
        if (method != null) {
            if (hashMap == null) {
                hashMap = new HashMap<Signature, Method>();
                methodCacheRef = new SoftReference(hashMap);
            }
            hashMap.put(signature, method);
        }
        return method;
    }

    public static Constructor getConstructor(Class clazz, Class[] classArray) {
        Constructor constructor = null;
        Constructor[] constructorArray = clazz.getConstructors();
        for (int i2 = 0; i2 < constructorArray.length; ++i2) {
            if (!ReflectionUtils.matchArguments(classArray, constructorArray[i2].getParameterTypes())) continue;
            constructor = constructorArray[i2];
        }
        return constructor;
    }

    public static Object getPrivateField(Object object, Class clazz, String string) {
        return ReflectionUtils.getPrivateField(object, clazz, string);
    }

    public static Object getPrivateField(Object object, Class clazz, String string, ExceptionListener exceptionListener) {
        try {
            Field field = clazz.getDeclaredField(string);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception exception) {
            if (exceptionListener != null) {
                exceptionListener.exceptionThrown(exception);
            }
            return null;
        }
    }

    private static class Signature {
        private Class targetClass;
        private String methodName;
        private Class[] argClasses;
        private volatile int hashCode = 0;

        public Signature(Class clazz, String string, Class[] classArray) {
            this.targetClass = clazz;
            this.methodName = string;
            this.argClasses = classArray;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            Signature signature = (Signature)object;
            if (this.targetClass != signature.targetClass) {
                return false;
            }
            if (!this.methodName.equals(signature.methodName)) {
                return false;
            }
            if (this.argClasses.length != signature.argClasses.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.argClasses.length; ++i2) {
                if (this.argClasses[i2] == signature.argClasses[i2]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int n2 = 17;
                n2 = 37 * n2 + this.targetClass.hashCode();
                n2 = 37 * n2 + this.methodName.hashCode();
                if (this.argClasses != null) {
                    for (int i2 = 0; i2 < this.argClasses.length; ++i2) {
                        n2 = 37 * n2 + (this.argClasses[i2] == null ? 0 : this.argClasses[i2].hashCode());
                    }
                }
                this.hashCode = n2;
            }
            return this.hashCode;
        }
    }
}

