/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class ComponentColorModel
extends ColorModel {
    private boolean signed;
    private boolean is_sRGB_stdScale;
    private boolean is_LinearRGB_stdScale;
    private boolean is_LinearGray_stdScale;
    private boolean is_ICCGray_stdScale;
    private byte[] tosRGB8LUT;
    private byte[] fromsRGB8LUT8;
    private short[] fromsRGB8LUT16;
    private byte[] fromLinearGray16ToOtherGray8LUT;
    private short[] fromLinearGray16ToOtherGray16LUT;
    private boolean needScaleInit;
    private boolean noUnnorm;
    private boolean nonStdScale;
    private float[] min;
    private float[] diffMinMax;
    private float[] compOffset;
    private float[] compScale;

    public ComponentColorModel(ColorSpace colorSpace, int[] nArray, boolean bl2, boolean bl3, int n2, int n3) {
        super(ComponentColorModel.bitsHelper(n3, colorSpace, bl2), ComponentColorModel.bitsArrayHelper(nArray, n3, colorSpace, bl2), colorSpace, bl2, bl3, n2, n3);
        switch (n3) {
            case 0: 
            case 1: 
            case 3: {
                this.signed = false;
                this.needScaleInit = true;
                break;
            }
            case 2: {
                this.signed = true;
                this.needScaleInit = true;
                break;
            }
            case 4: 
            case 5: {
                this.signed = true;
                this.needScaleInit = false;
                this.noUnnorm = true;
                this.nonStdScale = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("This constructor is not compatible with transferType " + n3);
            }
        }
        this.setupLUTs();
    }

    public ComponentColorModel(ColorSpace colorSpace, boolean bl2, boolean bl3, int n2, int n3) {
        this(colorSpace, null, bl2, bl3, n2, n3);
    }

    private static int bitsHelper(int n2, ColorSpace colorSpace, boolean bl2) {
        int n3 = DataBuffer.getDataTypeSize(n2);
        int n4 = colorSpace.getNumComponents();
        if (bl2) {
            ++n4;
        }
        return n3 * n4;
    }

    private static int[] bitsArrayHelper(int[] nArray, int n2, ColorSpace colorSpace, boolean bl2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 3: {
                if (nArray == null) break;
                return nArray;
            }
        }
        int n3 = DataBuffer.getDataTypeSize(n2);
        int n4 = colorSpace.getNumComponents();
        if (bl2) {
            ++n4;
        }
        int[] nArray2 = new int[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray2[i2] = n3;
        }
        return nArray2;
    }

    private void setupLUTs() {
        if (this.is_sRGB) {
            this.is_sRGB_stdScale = true;
            this.nonStdScale = false;
        } else if (ColorModel.isLinearRGBspace(this.colorSpace)) {
            this.is_LinearRGB_stdScale = true;
            this.nonStdScale = false;
            if (this.transferType == 0) {
                this.tosRGB8LUT = ColorModel.getLinearRGB8TosRGB8LUT();
                this.fromsRGB8LUT8 = ColorModel.getsRGB8ToLinearRGB8LUT();
            } else {
                this.tosRGB8LUT = ColorModel.getLinearRGB16TosRGB8LUT();
                this.fromsRGB8LUT16 = ColorModel.getsRGB8ToLinearRGB16LUT();
            }
        } else if (this.colorSpaceType == 6 && this.colorSpace instanceof ICC_ColorSpace && this.colorSpace.getMinValue(0) == 0.0f && this.colorSpace.getMaxValue(0) == 1.0f) {
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)this.colorSpace;
            this.is_ICCGray_stdScale = true;
            this.nonStdScale = false;
            this.fromsRGB8LUT16 = ColorModel.getsRGB8ToLinearRGB16LUT();
            if (ColorModel.isLinearGRAYspace(iCC_ColorSpace)) {
                this.is_LinearGray_stdScale = true;
                this.tosRGB8LUT = this.transferType == 0 ? ColorModel.getGray8TosRGB8LUT(iCC_ColorSpace) : ColorModel.getGray16TosRGB8LUT(iCC_ColorSpace);
            } else if (this.transferType == 0) {
                this.tosRGB8LUT = ColorModel.getGray8TosRGB8LUT(iCC_ColorSpace);
                this.fromLinearGray16ToOtherGray8LUT = ColorModel.getLinearGray16ToOtherGray8LUT(iCC_ColorSpace);
            } else {
                this.tosRGB8LUT = ColorModel.getGray16TosRGB8LUT(iCC_ColorSpace);
                this.fromLinearGray16ToOtherGray16LUT = ColorModel.getLinearGray16ToOtherGray16LUT(iCC_ColorSpace);
            }
        } else if (this.needScaleInit) {
            int n2;
            this.nonStdScale = false;
            for (n2 = 0; n2 < this.numColorComponents; ++n2) {
                if (this.colorSpace.getMinValue(n2) == 0.0f && this.colorSpace.getMaxValue(n2) == 1.0f) continue;
                this.nonStdScale = true;
                break;
            }
            if (this.nonStdScale) {
                this.min = new float[this.numColorComponents];
                this.diffMinMax = new float[this.numColorComponents];
                for (n2 = 0; n2 < this.numColorComponents; ++n2) {
                    this.min[n2] = this.colorSpace.getMinValue(n2);
                    this.diffMinMax[n2] = this.colorSpace.getMaxValue(n2) - this.min[n2];
                }
            }
        }
    }

    private void initScale() {
        int n2;
        float[] fArray;
        float[] fArray2;
        this.needScaleInit = false;
        this.noUnnorm = this.nonStdScale || this.signed;
        switch (this.transferType) {
            case 0: {
                int n3;
                Object[] objectArray = new byte[this.numComponents];
                for (n3 = 0; n3 < this.numColorComponents; ++n3) {
                    objectArray[n3] = 0;
                }
                if (this.supportsAlpha) {
                    objectArray[this.numColorComponents] = (byte)((1 << this.nBits[this.numColorComponents]) - 1);
                }
                fArray2 = this.getNormalizedComponents(objectArray, null, 0);
                for (n3 = 0; n3 < this.numColorComponents; ++n3) {
                    objectArray[n3] = (byte)((1 << this.nBits[n3]) - 1);
                }
                fArray = this.getNormalizedComponents(objectArray, null, 0);
                break;
            }
            case 1: {
                int n3;
                Object[] objectArray = new short[this.numComponents];
                for (n3 = 0; n3 < this.numColorComponents; ++n3) {
                    objectArray[n3] = 0;
                }
                if (this.supportsAlpha) {
                    objectArray[this.numColorComponents] = (short)((1 << this.nBits[this.numColorComponents]) - 1);
                }
                fArray2 = this.getNormalizedComponents(objectArray, null, 0);
                for (n3 = 0; n3 < this.numColorComponents; ++n3) {
                    objectArray[n3] = (short)((1 << this.nBits[n3]) - 1);
                }
                fArray = this.getNormalizedComponents(objectArray, null, 0);
                break;
            }
            case 3: {
                int n3;
                Object[] objectArray = new int[this.numComponents];
                for (n3 = 0; n3 < this.numColorComponents; ++n3) {
                    objectArray[n3] = 0;
                }
                if (this.supportsAlpha) {
                    objectArray[this.numColorComponents] = (1 << this.nBits[this.numColorComponents]) - 1;
                }
                fArray2 = this.getNormalizedComponents(objectArray, null, 0);
                for (n3 = 0; n3 < this.numColorComponents; ++n3) {
                    objectArray[n3] = (1 << this.nBits[n3]) - 1;
                }
                fArray = this.getNormalizedComponents(objectArray, null, 0);
                break;
            }
            case 2: {
                int n3;
                Object[] objectArray = new short[this.numComponents];
                for (n3 = 0; n3 < this.numColorComponents; ++n3) {
                    objectArray[n3] = 0;
                }
                if (this.supportsAlpha) {
                    objectArray[this.numColorComponents] = Short.MAX_VALUE;
                }
                fArray2 = this.getNormalizedComponents(objectArray, null, 0);
                for (n3 = 0; n3 < this.numColorComponents; ++n3) {
                    objectArray[n3] = Short.MAX_VALUE;
                }
                fArray = this.getNormalizedComponents(objectArray, null, 0);
                break;
            }
            default: {
                fArray = null;
                fArray2 = null;
            }
        }
        this.nonStdScale = false;
        for (n2 = 0; n2 < this.numColorComponents; ++n2) {
            if (fArray2[n2] == 0.0f && fArray[n2] == 1.0f) continue;
            this.nonStdScale = true;
            break;
        }
        if (this.nonStdScale) {
            this.noUnnorm = true;
            this.is_sRGB_stdScale = false;
            this.is_LinearRGB_stdScale = false;
            this.is_LinearGray_stdScale = false;
            this.is_ICCGray_stdScale = false;
            this.compOffset = new float[this.numColorComponents];
            this.compScale = new float[this.numColorComponents];
            for (n2 = 0; n2 < this.numColorComponents; ++n2) {
                this.compOffset[n2] = fArray2[n2];
                this.compScale[n2] = 1.0f / (fArray[n2] - fArray2[n2]);
            }
        }
    }

    private int getRGBComponent(int n2, int n3) {
        Object[] objectArray;
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        if (this.signed) {
            throw new IllegalArgumentException("Component value is signed");
        }
        if (this.needScaleInit) {
            this.initScale();
        }
        Object[] objectArray2 = null;
        switch (this.transferType) {
            case 0: {
                objectArray2 = objectArray = (Object[])new byte[]{(byte)n2};
                break;
            }
            case 1: {
                objectArray2 = objectArray = (Object[])new short[]{(short)n2};
                break;
            }
            case 3: {
                objectArray2 = objectArray = (Object[])new int[]{n2};
            }
        }
        objectArray = this.getNormalizedComponents(objectArray2, null, 0);
        float[] fArray = this.colorSpace.toRGB((float[])objectArray);
        return (int)(fArray[n3] * 255.0f + 0.5f);
    }

    public int getRed(int n2) {
        return this.getRGBComponent(n2, 0);
    }

    public int getGreen(int n2) {
        return this.getRGBComponent(n2, 1);
    }

    public int getBlue(int n2) {
        return this.getRGBComponent(n2, 2);
    }

    public int getAlpha(int n2) {
        if (!this.supportsAlpha) {
            return 255;
        }
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        if (this.signed) {
            throw new IllegalArgumentException("Component value is signed");
        }
        return (int)((float)n2 / (float)((1 << this.nBits[0]) - 1) * 255.0f + 0.5f);
    }

    public int getRGB(int n2) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        if (this.signed) {
            throw new IllegalArgumentException("Component value is signed");
        }
        return this.getAlpha(n2) << 24 | this.getRed(n2) << 16 | this.getGreen(n2) << 8 | this.getBlue(n2) << 0;
    }

    private int extractComponent(Object object, int n2, int n3) {
        int n4;
        boolean bl2 = this.supportsAlpha && this.isAlphaPremultiplied;
        int n5 = 0;
        int n6 = (1 << this.nBits[n2]) - 1;
        switch (this.transferType) {
            case 2: {
                short[] sArray = (short[])object;
                float f2 = (1 << n3) - 1;
                if (bl2) {
                    short s2 = sArray[this.numColorComponents];
                    if (s2 != 0) {
                        return (int)((float)sArray[n2] / (float)s2 * f2 + 0.5f);
                    }
                    return 0;
                }
                return (int)((float)sArray[n2] / 32767.0f * f2 + 0.5f);
            }
            case 4: {
                float[] fArray = (float[])object;
                float f3 = (1 << n3) - 1;
                if (bl2) {
                    float f4 = fArray[this.numColorComponents];
                    if (f4 != 0.0f) {
                        return (int)(fArray[n2] / f4 * f3 + 0.5f);
                    }
                    return 0;
                }
                return (int)(fArray[n2] * f3 + 0.5f);
            }
            case 5: {
                double[] dArray = (double[])object;
                double d2 = (1 << n3) - 1;
                if (bl2) {
                    double d3 = dArray[this.numColorComponents];
                    if (d3 != 0.0) {
                        return (int)(dArray[n2] / d3 * d2 + 0.5);
                    }
                    return 0;
                }
                return (int)(dArray[n2] * d2 + 0.5);
            }
            case 0: {
                byte[] byArray = (byte[])object;
                n4 = byArray[n2] & n6;
                n3 = 8;
                if (!bl2) break;
                n5 = byArray[this.numColorComponents] & n6;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n4 = sArray[n2] & n6;
                if (!bl2) break;
                n5 = sArray[this.numColorComponents] & n6;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n4 = nArray[n2];
                if (!bl2) break;
                n5 = nArray[this.numColorComponents];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (bl2) {
            if (n5 != 0) {
                float f5 = (1 << n3) - 1;
                float f6 = (float)n4 / (float)n6;
                float f7 = (float)((1 << this.nBits[this.numColorComponents]) - 1) / (float)n5;
                return (int)(f6 * f7 * f5 + 0.5f);
            }
            return 0;
        }
        if (this.nBits[n2] != n3) {
            float f8 = (1 << n3) - 1;
            float f9 = (float)n4 / (float)n6;
            return (int)(f9 * f8 + 0.5f);
        }
        return n4;
    }

    private int getRGBComponent(Object object, int n2) {
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.is_sRGB_stdScale) {
            return this.extractComponent(object, n2, 8);
        }
        if (this.is_LinearRGB_stdScale) {
            int n3 = this.extractComponent(object, n2, 16);
            return this.tosRGB8LUT[n3] & 0xFF;
        }
        if (this.is_ICCGray_stdScale) {
            int n4 = this.extractComponent(object, 0, 16);
            return this.tosRGB8LUT[n4] & 0xFF;
        }
        float[] fArray = this.getNormalizedComponents(object, null, 0);
        float[] fArray2 = this.colorSpace.toRGB(fArray);
        return (int)(fArray2[n2] * 255.0f + 0.5f);
    }

    public int getRed(Object object) {
        return this.getRGBComponent(object, 0);
    }

    public int getGreen(Object object) {
        return this.getRGBComponent(object, 1);
    }

    public int getBlue(Object object) {
        return this.getRGBComponent(object, 2);
    }

    public int getAlpha(Object object) {
        if (!this.supportsAlpha) {
            return 255;
        }
        int n2 = 0;
        int n3 = this.numColorComponents;
        int n4 = (1 << this.nBits[n3]) - 1;
        switch (this.transferType) {
            case 2: {
                short[] sArray = (short[])object;
                n2 = (int)((float)sArray[n3] / 32767.0f * 255.0f + 0.5f);
                return n2;
            }
            case 4: {
                float[] fArray = (float[])object;
                n2 = (int)(fArray[n3] * 255.0f + 0.5f);
                return n2;
            }
            case 5: {
                double[] dArray = (double[])object;
                n2 = (int)(dArray[n3] * 255.0 + 0.5);
                return n2;
            }
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[n3] & n4;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[n3] & n4;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n2 = nArray[n3];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (this.nBits[n3] == 8) {
            return n2;
        }
        return (int)((float)n2 / (float)((1 << this.nBits[n3]) - 1) * 255.0f + 0.5f);
    }

    public int getRGB(Object object) {
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.is_sRGB_stdScale || this.is_LinearRGB_stdScale) {
            return this.getAlpha(object) << 24 | this.getRed(object) << 16 | this.getGreen(object) << 8 | this.getBlue(object);
        }
        if (this.colorSpaceType == 6) {
            int n2 = this.getRed(object);
            return this.getAlpha(object) << 24 | n2 << 16 | n2 << 8 | n2;
        }
        float[] fArray = this.getNormalizedComponents(object, null, 0);
        float[] fArray2 = this.colorSpace.toRGB(fArray);
        return this.getAlpha(object) << 24 | (int)(fArray2[0] * 255.0f + 0.5f) << 16 | (int)(fArray2[1] * 255.0f + 0.5f) << 8 | (int)(fArray2[2] * 255.0f + 0.5f) << 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getDataElements(int n2, Object object) {
        int n3;
        float f2;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.signed) {
            switch (this.transferType) {
                case 2: {
                    short[] sArray = object == null ? new short[this.numComponents] : (short[])object;
                    if (this.is_sRGB_stdScale || this.is_LinearRGB_stdScale) {
                        float f3 = 128.49803f;
                        if (this.is_LinearRGB_stdScale) {
                            n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                            n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                            n6 = this.fromsRGB8LUT16[n6] & 0xFFFF;
                            f3 = 0.49999237f;
                        }
                        if (this.supportsAlpha) {
                            int n7 = n2 >> 24 & 0xFF;
                            sArray[3] = (short)((float)n7 * 128.49803f + 0.5f);
                            if (this.isAlphaPremultiplied) {
                                f3 = (float)n7 * f3 * 0.003921569f;
                            }
                        }
                        sArray[0] = (short)((float)n4 * f3 + 0.5f);
                        sArray[1] = (short)((float)n5 * f3 + 0.5f);
                        sArray[2] = (short)((float)n6 * f3 + 0.5f);
                        return sArray;
                    } else if (this.is_LinearGray_stdScale) {
                        n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                        n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                        n6 = this.fromsRGB8LUT16[n6] & 0xFFFF;
                        float f4 = (0.2125f * (float)n4 + 0.7154f * (float)n5 + 0.0721f * (float)n6) / 65535.0f;
                        float f5 = 32767.0f;
                        if (this.supportsAlpha) {
                            int n8 = n2 >> 24 & 0xFF;
                            sArray[1] = (short)((float)n8 * 128.49803f + 0.5f);
                            if (this.isAlphaPremultiplied) {
                                f5 = (float)n8 * f5 * 0.003921569f;
                            }
                        }
                        sArray[0] = (short)(f4 * f5 + 0.5f);
                        return sArray;
                    } else if (this.is_ICCGray_stdScale) {
                        n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                        n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                        n6 = this.fromsRGB8LUT16[n6] & 0xFFFF;
                        int n9 = (int)(0.2125f * (float)n4 + 0.7154f * (float)n5 + 0.0721f * (float)n6 + 0.5f);
                        n9 = this.fromLinearGray16ToOtherGray16LUT[n9] & 0xFFFF;
                        float f6 = 0.49999237f;
                        if (this.supportsAlpha) {
                            int n10 = n2 >> 24 & 0xFF;
                            sArray[1] = (short)((float)n10 * 128.49803f + 0.5f);
                            if (this.isAlphaPremultiplied) {
                                f6 = (float)n10 * f6 * 0.003921569f;
                            }
                        }
                        sArray[0] = (short)((float)n9 * f6 + 0.5f);
                        return sArray;
                    } else {
                        int n11;
                        float f7 = 0.003921569f;
                        float[] fArray = new float[]{(float)n4 * f7, (float)n5 * f7, (float)n6 * f7};
                        fArray = this.colorSpace.fromRGB(fArray);
                        if (this.nonStdScale) {
                            for (n11 = 0; n11 < this.numColorComponents; ++n11) {
                                fArray[n11] = (fArray[n11] - this.compOffset[n11]) * this.compScale[n11];
                                if (fArray[n11] < 0.0f) {
                                    fArray[n11] = 0.0f;
                                }
                                if (!(fArray[n11] > 1.0f)) continue;
                                fArray[n11] = 1.0f;
                            }
                        }
                        f7 = 32767.0f;
                        if (this.supportsAlpha) {
                            int n12 = n2 >> 24 & 0xFF;
                            sArray[this.numColorComponents] = (short)((float)n12 * 128.49803f + 0.5f);
                            if (this.isAlphaPremultiplied) {
                                f7 *= (float)n12 * 0.003921569f;
                            }
                        }
                        for (n11 = 0; n11 < this.numColorComponents; ++n11) {
                            sArray[n11] = (short)(fArray[n11] * f7 + 0.5f);
                        }
                    }
                    return sArray;
                }
                case 4: {
                    float[] fArray = object == null ? new float[this.numComponents] : (float[])object;
                    if (this.is_sRGB_stdScale || this.is_LinearRGB_stdScale) {
                        float f8;
                        if (this.is_LinearRGB_stdScale) {
                            n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                            n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                            n6 = this.fromsRGB8LUT16[n6] & 0xFFFF;
                            f8 = 1.5259022E-5f;
                        } else {
                            f8 = 0.003921569f;
                        }
                        if (this.supportsAlpha) {
                            int n13 = n2 >> 24 & 0xFF;
                            fArray[3] = (float)n13 * 0.003921569f;
                            if (this.isAlphaPremultiplied) {
                                f8 *= fArray[3];
                            }
                        }
                        fArray[0] = (float)n4 * f8;
                        fArray[1] = (float)n5 * f8;
                        fArray[2] = (float)n6 * f8;
                        return fArray;
                    } else if (this.is_LinearGray_stdScale) {
                        n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                        n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                        n6 = this.fromsRGB8LUT16[n6] & 0xFFFF;
                        fArray[0] = (0.2125f * (float)n4 + 0.7154f * (float)n5 + 0.0721f * (float)n6) / 65535.0f;
                        if (!this.supportsAlpha) return fArray;
                        int n14 = n2 >> 24 & 0xFF;
                        fArray[1] = (float)n14 * 0.003921569f;
                        if (!this.isAlphaPremultiplied) return fArray;
                        fArray[0] = fArray[0] * fArray[1];
                        return fArray;
                    } else if (this.is_ICCGray_stdScale) {
                        n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                        n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                        n6 = this.fromsRGB8LUT16[n6] & 0xFFFF;
                        int n15 = (int)(0.2125f * (float)n4 + 0.7154f * (float)n5 + 0.0721f * (float)n6 + 0.5f);
                        fArray[0] = (float)(this.fromLinearGray16ToOtherGray16LUT[n15] & 0xFFFF) / 65535.0f;
                        if (!this.supportsAlpha) return fArray;
                        int n16 = n2 >> 24 & 0xFF;
                        fArray[1] = (float)n16 * 0.003921569f;
                        if (!this.isAlphaPremultiplied) return fArray;
                        fArray[0] = fArray[0] * fArray[1];
                        return fArray;
                    } else {
                        int n17;
                        float[] fArray2 = new float[3];
                        float f9 = 0.003921569f;
                        fArray2[0] = (float)n4 * f9;
                        fArray2[1] = (float)n5 * f9;
                        fArray2[2] = (float)n6 * f9;
                        fArray2 = this.colorSpace.fromRGB(fArray2);
                        if (this.supportsAlpha) {
                            int n18 = n2 >> 24 & 0xFF;
                            fArray[this.numColorComponents] = (float)n18 * f9;
                            if (this.isAlphaPremultiplied) {
                                f9 *= (float)n18;
                                n17 = 0;
                                while (n17 < this.numColorComponents) {
                                    int n19 = n17++;
                                    fArray2[n19] = fArray2[n19] * f9;
                                }
                            }
                        }
                        for (n17 = 0; n17 < this.numColorComponents; ++n17) {
                            fArray[n17] = fArray2[n17];
                        }
                    }
                    return fArray;
                }
                case 5: {
                    double[] dArray = object == null ? new double[this.numComponents] : (double[])object;
                    if (this.is_sRGB_stdScale || this.is_LinearRGB_stdScale) {
                        double d2;
                        if (this.is_LinearRGB_stdScale) {
                            n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                            n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                            n6 = this.fromsRGB8LUT16[n6] & 0xFFFF;
                            d2 = 1.5259021896696422E-5;
                        } else {
                            d2 = 0.00392156862745098;
                        }
                        if (this.supportsAlpha) {
                            int n20 = n2 >> 24 & 0xFF;
                            dArray[3] = (double)n20 * 0.00392156862745098;
                            if (this.isAlphaPremultiplied) {
                                d2 *= dArray[3];
                            }
                        }
                        dArray[0] = (double)n4 * d2;
                        dArray[1] = (double)n5 * d2;
                        dArray[2] = (double)n6 * d2;
                        return dArray;
                    } else if (this.is_LinearGray_stdScale) {
                        n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                        n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                        n6 = this.fromsRGB8LUT16[n6] & 0xFFFF;
                        dArray[0] = (0.2125 * (double)n4 + 0.7154 * (double)n5 + 0.0721 * (double)n6) / 65535.0;
                        if (!this.supportsAlpha) return dArray;
                        int n21 = n2 >> 24 & 0xFF;
                        dArray[1] = (double)n21 * 0.00392156862745098;
                        if (!this.isAlphaPremultiplied) return dArray;
                        dArray[0] = dArray[0] * dArray[1];
                        return dArray;
                    } else if (this.is_ICCGray_stdScale) {
                        n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                        n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                        n6 = this.fromsRGB8LUT16[n6] & 0xFFFF;
                        int n22 = (int)(0.2125f * (float)n4 + 0.7154f * (float)n5 + 0.0721f * (float)n6 + 0.5f);
                        dArray[0] = (double)(this.fromLinearGray16ToOtherGray16LUT[n22] & 0xFFFF) / 65535.0;
                        if (!this.supportsAlpha) return dArray;
                        int n23 = n2 >> 24 & 0xFF;
                        dArray[1] = (double)n23 * 0.00392156862745098;
                        if (!this.isAlphaPremultiplied) return dArray;
                        dArray[0] = dArray[0] * dArray[1];
                        return dArray;
                    } else {
                        int n24;
                        float f10 = 0.003921569f;
                        float[] fArray = new float[]{(float)n4 * f10, (float)n5 * f10, (float)n6 * f10};
                        fArray = this.colorSpace.fromRGB(fArray);
                        if (this.supportsAlpha) {
                            int n25 = n2 >> 24 & 0xFF;
                            dArray[this.numColorComponents] = (double)n25 * 0.00392156862745098;
                            if (this.isAlphaPremultiplied) {
                                f10 *= (float)n25;
                                n24 = 0;
                                while (n24 < this.numColorComponents) {
                                    int n26 = n24++;
                                    fArray[n26] = fArray[n26] * f10;
                                }
                            }
                        }
                        for (n24 = 0; n24 < this.numColorComponents; ++n24) {
                            dArray[n24] = fArray[n24];
                        }
                    }
                    return dArray;
                }
            }
        }
        int[] nArray = this.transferType == 3 && object != null ? (int[])object : new int[this.numComponents];
        if (this.is_sRGB_stdScale || this.is_LinearRGB_stdScale) {
            int n27;
            if (this.is_LinearRGB_stdScale) {
                if (this.transferType == 0) {
                    n4 = this.fromsRGB8LUT8[n4] & 0xFF;
                    n5 = this.fromsRGB8LUT8[n5] & 0xFF;
                    n6 = this.fromsRGB8LUT8[n6] & 0xFF;
                    n27 = 8;
                    f2 = 0.003921569f;
                } else {
                    n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                    n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                    n6 = this.fromsRGB8LUT16[n6] & 0xFFFF;
                    n27 = 16;
                    f2 = 1.5259022E-5f;
                }
            } else {
                n27 = 8;
                f2 = 0.003921569f;
            }
            if (this.supportsAlpha) {
                n3 = n2 >> 24 & 0xFF;
                nArray[3] = this.nBits[3] == 8 ? n3 : (int)((float)n3 * 0.003921569f * (float)((1 << this.nBits[3]) - 1) + 0.5f);
                if (this.isAlphaPremultiplied) {
                    f2 *= (float)n3 * 0.003921569f;
                    n27 = -1;
                }
            }
            nArray[0] = this.nBits[0] == n27 ? n4 : (int)((float)n4 * f2 * (float)((1 << this.nBits[0]) - 1) + 0.5f);
            nArray[1] = this.nBits[1] == n27 ? n5 : (int)((float)n5 * f2 * (float)((1 << this.nBits[1]) - 1) + 0.5f);
            nArray[2] = this.nBits[2] == n27 ? n6 : (int)((float)n6 * f2 * (float)((1 << this.nBits[2]) - 1) + 0.5f);
        } else if (this.is_LinearGray_stdScale) {
            n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
            n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
            n6 = this.fromsRGB8LUT16[n6] & 0xFFFF;
            float f11 = (0.2125f * (float)n4 + 0.7154f * (float)n5 + 0.0721f * (float)n6) / 65535.0f;
            if (this.supportsAlpha) {
                n3 = n2 >> 24 & 0xFF;
                nArray[1] = this.nBits[1] == 8 ? n3 : (int)((float)n3 * 0.003921569f * (float)((1 << this.nBits[1]) - 1) + 0.5f);
                if (this.isAlphaPremultiplied) {
                    f11 *= (float)n3 * 0.003921569f;
                }
            }
            nArray[0] = (int)(f11 * (float)((1 << this.nBits[0]) - 1) + 0.5f);
        } else if (this.is_ICCGray_stdScale) {
            n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
            n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
            n6 = this.fromsRGB8LUT16[n6] & 0xFFFF;
            int n28 = (int)(0.2125f * (float)n4 + 0.7154f * (float)n5 + 0.0721f * (float)n6 + 0.5f);
            f2 = (float)(this.fromLinearGray16ToOtherGray16LUT[n28] & 0xFFFF) / 65535.0f;
            if (this.supportsAlpha) {
                n3 = n2 >> 24 & 0xFF;
                nArray[1] = this.nBits[1] == 8 ? n3 : (int)((float)n3 * 0.003921569f * (float)((1 << this.nBits[1]) - 1) + 0.5f);
                if (this.isAlphaPremultiplied) {
                    f2 *= (float)n3 * 0.003921569f;
                }
            }
            nArray[0] = (int)(f2 * (float)((1 << this.nBits[0]) - 1) + 0.5f);
        } else {
            int n29;
            float[] fArray = new float[3];
            f2 = 0.003921569f;
            fArray[0] = (float)n4 * f2;
            fArray[1] = (float)n5 * f2;
            fArray[2] = (float)n6 * f2;
            fArray = this.colorSpace.fromRGB(fArray);
            if (this.nonStdScale) {
                for (n29 = 0; n29 < this.numColorComponents; ++n29) {
                    fArray[n29] = (fArray[n29] - this.compOffset[n29]) * this.compScale[n29];
                    if (fArray[n29] < 0.0f) {
                        fArray[n29] = 0.0f;
                    }
                    if (!(fArray[n29] > 1.0f)) continue;
                    fArray[n29] = 1.0f;
                }
            }
            if (this.supportsAlpha) {
                n3 = n2 >> 24 & 0xFF;
                nArray[this.numColorComponents] = this.nBits[this.numColorComponents] == 8 ? n3 : (int)((float)n3 * f2 * (float)((1 << this.nBits[this.numColorComponents]) - 1) + 0.5f);
                if (this.isAlphaPremultiplied) {
                    f2 *= (float)n3;
                    n29 = 0;
                    while (n29 < this.numColorComponents) {
                        int n30 = n29++;
                        fArray[n30] = fArray[n30] * f2;
                    }
                }
            }
            for (n29 = 0; n29 < this.numColorComponents; ++n29) {
                nArray[n29] = (int)(fArray[n29] * (float)((1 << this.nBits[n29]) - 1) + 0.5f);
            }
        }
        switch (this.transferType) {
            case 0: {
                byte[] byArray = object == null ? new byte[this.numComponents] : (byte[])object;
                for (int i2 = 0; i2 < this.numComponents; ++i2) {
                    byArray[i2] = (byte)(0xFF & nArray[i2]);
                }
                return byArray;
            }
            case 1: {
                short[] sArray = object == null ? new short[this.numComponents] : (short[])object;
                for (int i3 = 0; i3 < this.numComponents; ++i3) {
                    sArray[i3] = (short)(nArray[i3] & 0xFFFF);
                }
                return sArray;
            }
            case 3: {
                if (this.maxBits <= 23) return nArray;
                for (int i4 = 0; i4 < this.numComponents; ++i4) {
                    if (nArray[i4] <= (1 << this.nBits[i4]) - 1) continue;
                    nArray[i4] = (1 << this.nBits[i4]) - 1;
                }
                return nArray;
            }
        }
        throw new IllegalArgumentException("This method has not been implemented for transferType " + this.transferType);
    }

    public int[] getComponents(int n2, int[] nArray, int n3) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.noUnnorm) {
            throw new IllegalArgumentException("This ColorModel does not support the unnormalized form");
        }
        if (nArray == null) {
            nArray = new int[n3 + 1];
        }
        nArray[n3 + 0] = n2 & (1 << this.nBits[0]) - 1;
        return nArray;
    }

    public int[] getComponents(Object object, int[] nArray, int n2) {
        int[] nArray2;
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.noUnnorm) {
            throw new IllegalArgumentException("This ColorModel does not support the unnormalized form");
        }
        if (object instanceof int[]) {
            nArray2 = (int[])object;
        } else {
            nArray2 = DataBuffer.toIntArray(object);
            if (nArray2 == null) {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (nArray2.length < this.numComponents) {
            throw new IllegalArgumentException("Length of pixel array < number of components in model");
        }
        if (nArray == null) {
            nArray = new int[n2 + this.numComponents];
        } else if (nArray.length - n2 < this.numComponents) {
            throw new IllegalArgumentException("Length of components array < number of components in model");
        }
        System.arraycopy(nArray2, 0, nArray, n2, this.numComponents);
        return nArray;
    }

    public int[] getUnnormalizedComponents(float[] fArray, int n2, int[] nArray, int n3) {
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.noUnnorm) {
            throw new IllegalArgumentException("This ColorModel does not support the unnormalized form");
        }
        return super.getUnnormalizedComponents(fArray, n2, nArray, n3);
    }

    public float[] getNormalizedComponents(int[] nArray, int n2, float[] fArray, int n3) {
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.noUnnorm) {
            throw new IllegalArgumentException("This ColorModel does not support the unnormalized form");
        }
        return super.getNormalizedComponents(nArray, n2, fArray, n3);
    }

    public int getDataElement(int[] nArray, int n2) {
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.numComponents == 1) {
            if (this.noUnnorm) {
                throw new IllegalArgumentException("This ColorModel does not support the unnormalized form");
            }
            return nArray[n2 + 0];
        }
        throw new IllegalArgumentException("This model returns " + this.numComponents + " elements in the pixel array.");
    }

    public Object getDataElements(int[] nArray, int n2, Object object) {
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.noUnnorm) {
            throw new IllegalArgumentException("This ColorModel does not support the unnormalized form");
        }
        if (nArray.length - n2 < this.numComponents) {
            throw new IllegalArgumentException("Component array too small (should be " + this.numComponents);
        }
        switch (this.transferType) {
            case 3: {
                int[] nArray2 = object == null ? new int[this.numComponents] : (int[])object;
                System.arraycopy(nArray, n2, nArray2, 0, this.numComponents);
                return nArray2;
            }
            case 0: {
                byte[] byArray = object == null ? new byte[this.numComponents] : (byte[])object;
                for (int i2 = 0; i2 < this.numComponents; ++i2) {
                    byArray[i2] = (byte)(nArray[n2 + i2] & 0xFF);
                }
                return byArray;
            }
            case 1: {
                short[] sArray = object == null ? new short[this.numComponents] : (short[])object;
                for (int i3 = 0; i3 < this.numComponents; ++i3) {
                    sArray[i3] = (short)(nArray[n2 + i3] & 0xFFFF);
                }
                return sArray;
            }
        }
        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
    }

    public int getDataElement(float[] fArray, int n2) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        if (this.signed) {
            throw new IllegalArgumentException("Component value is signed");
        }
        if (this.needScaleInit) {
            this.initScale();
        }
        Object object = this.getDataElements(fArray, n2, null);
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                return byArray[0] & 0xFF;
            }
            case 1: {
                short[] sArray = (short[])object;
                return sArray[0] & 0xFFFF;
            }
            case 3: {
                int[] nArray = (int[])object;
                return nArray[0];
            }
        }
        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
    }

    public Object getDataElements(float[] fArray, int n2, Object object) {
        int n3;
        float[] fArray2;
        boolean bl2;
        boolean bl3 = bl2 = this.supportsAlpha && this.isAlphaPremultiplied;
        if (this.needScaleInit) {
            this.initScale();
        }
        if (this.nonStdScale) {
            fArray2 = new float[this.numComponents];
            int n4 = 0;
            n3 = n2;
            while (n4 < this.numColorComponents) {
                fArray2[n4] = (fArray[n3] - this.compOffset[n4]) * this.compScale[n4];
                if (fArray2[n4] < 0.0f) {
                    fArray2[n4] = 0.0f;
                }
                if (fArray2[n4] > 1.0f) {
                    fArray2[n4] = 1.0f;
                }
                ++n4;
                ++n3;
            }
            if (this.supportsAlpha) {
                fArray2[this.numColorComponents] = fArray[this.numColorComponents + n2];
            }
            n2 = 0;
        } else {
            fArray2 = fArray;
        }
        switch (this.transferType) {
            case 0: {
                byte[] byArray = object == null ? new byte[this.numComponents] : (byte[])object;
                if (bl2) {
                    float f2 = fArray2[this.numColorComponents + n2];
                    int n5 = 0;
                    int n6 = n2;
                    while (n5 < this.numColorComponents) {
                        byArray[n5] = (byte)(fArray2[n6] * f2 * (float)((1 << this.nBits[n5]) - 1) + 0.5f);
                        ++n5;
                        ++n6;
                    }
                    byArray[this.numColorComponents] = (byte)(f2 * (float)((1 << this.nBits[this.numColorComponents]) - 1) + 0.5f);
                } else {
                    n3 = 0;
                    int n7 = n2;
                    while (n3 < this.numComponents) {
                        byArray[n3] = (byte)(fArray2[n7] * (float)((1 << this.nBits[n3]) - 1) + 0.5f);
                        ++n3;
                        ++n7;
                    }
                }
                return byArray;
            }
            case 1: {
                short[] sArray = object == null ? new short[this.numComponents] : (short[])object;
                if (bl2) {
                    float f3 = fArray2[this.numColorComponents + n2];
                    int n8 = 0;
                    int n9 = n2;
                    while (n8 < this.numColorComponents) {
                        sArray[n8] = (short)(fArray2[n9] * f3 * (float)((1 << this.nBits[n8]) - 1) + 0.5f);
                        ++n8;
                        ++n9;
                    }
                    sArray[this.numColorComponents] = (short)(f3 * (float)((1 << this.nBits[this.numColorComponents]) - 1) + 0.5f);
                } else {
                    int n10 = 0;
                    int n11 = n2;
                    while (n10 < this.numComponents) {
                        sArray[n10] = (short)(fArray2[n11] * (float)((1 << this.nBits[n10]) - 1) + 0.5f);
                        ++n10;
                        ++n11;
                    }
                }
                return sArray;
            }
            case 3: {
                int[] nArray = object == null ? new int[this.numComponents] : (int[])object;
                if (bl2) {
                    float f4 = fArray2[this.numColorComponents + n2];
                    int n12 = 0;
                    int n13 = n2;
                    while (n12 < this.numColorComponents) {
                        nArray[n12] = (int)(fArray2[n13] * f4 * (float)((1 << this.nBits[n12]) - 1) + 0.5f);
                        ++n12;
                        ++n13;
                    }
                    nArray[this.numColorComponents] = (int)(f4 * (float)((1 << this.nBits[this.numColorComponents]) - 1) + 0.5f);
                } else {
                    int n14 = 0;
                    int n15 = n2;
                    while (n14 < this.numComponents) {
                        nArray[n14] = (int)(fArray2[n15] * (float)((1 << this.nBits[n14]) - 1) + 0.5f);
                        ++n14;
                        ++n15;
                    }
                }
                return nArray;
            }
            case 2: {
                short[] sArray = object == null ? new short[this.numComponents] : (short[])object;
                if (bl2) {
                    float f5 = fArray2[this.numColorComponents + n2];
                    int n16 = 0;
                    int n17 = n2;
                    while (n16 < this.numColorComponents) {
                        sArray[n16] = (short)(fArray2[n17] * f5 * 32767.0f + 0.5f);
                        ++n16;
                        ++n17;
                    }
                    sArray[this.numColorComponents] = (short)(f5 * 32767.0f + 0.5f);
                } else {
                    int n18 = 0;
                    int n19 = n2;
                    while (n18 < this.numComponents) {
                        sArray[n18] = (short)(fArray2[n19] * 32767.0f + 0.5f);
                        ++n18;
                        ++n19;
                    }
                }
                return sArray;
            }
            case 4: {
                float[] fArray3 = object == null ? new float[this.numComponents] : (float[])object;
                if (bl2) {
                    float f6 = fArray[this.numColorComponents + n2];
                    int n20 = 0;
                    int n21 = n2;
                    while (n20 < this.numColorComponents) {
                        fArray3[n20] = fArray[n21] * f6;
                        ++n20;
                        ++n21;
                    }
                    fArray3[this.numColorComponents] = f6;
                } else {
                    int n22 = 0;
                    int n23 = n2;
                    while (n22 < this.numComponents) {
                        fArray3[n22] = fArray[n23];
                        ++n22;
                        ++n23;
                    }
                }
                return fArray3;
            }
            case 5: {
                double[] dArray = object == null ? new double[this.numComponents] : (double[])object;
                if (bl2) {
                    double d2 = fArray[this.numColorComponents + n2];
                    int n24 = 0;
                    int n25 = n2;
                    while (n24 < this.numColorComponents) {
                        dArray[n24] = (double)fArray[n25] * d2;
                        ++n24;
                        ++n25;
                    }
                    dArray[this.numColorComponents] = d2;
                } else {
                    int n26 = 0;
                    int n27 = n2;
                    while (n26 < this.numComponents) {
                        dArray[n26] = fArray[n27];
                        ++n26;
                        ++n27;
                    }
                }
                return dArray;
            }
        }
        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
    }

    public float[] getNormalizedComponents(Object object, float[] fArray, int n2) {
        float f2;
        if (fArray == null) {
            fArray = new float[this.numComponents + n2];
        }
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                int n3 = 0;
                int n4 = n2;
                while (n3 < this.numComponents) {
                    fArray[n4] = (float)(byArray[n3] & 0xFF) / (float)((1 << this.nBits[n3]) - 1);
                    ++n3;
                    ++n4;
                }
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                int n5 = 0;
                int n6 = n2;
                while (n5 < this.numComponents) {
                    fArray[n6] = (float)(sArray[n5] & 0xFFFF) / (float)((1 << this.nBits[n5]) - 1);
                    ++n5;
                    ++n6;
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int n7 = 0;
                int n8 = n2;
                while (n7 < this.numComponents) {
                    fArray[n8] = (float)nArray[n7] / (float)((1 << this.nBits[n7]) - 1);
                    ++n7;
                    ++n8;
                }
                break;
            }
            case 2: {
                short[] sArray = (short[])object;
                int n9 = 0;
                int n10 = n2;
                while (n9 < this.numComponents) {
                    fArray[n10] = (float)sArray[n9] / 32767.0f;
                    ++n9;
                    ++n10;
                }
                break;
            }
            case 4: {
                float[] fArray2 = (float[])object;
                int n11 = 0;
                int n12 = n2;
                while (n11 < this.numComponents) {
                    fArray[n12] = fArray2[n11];
                    ++n11;
                    ++n12;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n12 = 0;
                int n13 = n2;
                while (n12 < this.numComponents) {
                    fArray[n13] = (float)dArray[n12];
                    ++n12;
                    ++n13;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (this.supportsAlpha && this.isAlphaPremultiplied && (f2 = fArray[this.numColorComponents + n2]) != 0.0f) {
            float f3 = 1.0f / f2;
            int n14 = n2;
            while (n14 < this.numColorComponents + n2) {
                int n15 = n14++;
                fArray[n15] = fArray[n15] * f3;
            }
        }
        if (this.min != null) {
            for (int i2 = 0; i2 < this.numColorComponents; ++i2) {
                fArray[i2 + n2] = this.min[i2] + this.diffMinMax[i2] * fArray[i2 + n2];
            }
        }
        return fArray;
    }

    public ColorModel coerceData(WritableRaster writableRaster, boolean bl2) {
        block79: {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block78: {
                if (!this.supportsAlpha || this.isAlphaPremultiplied == bl2) {
                    return this;
                }
                n6 = writableRaster.getWidth();
                n5 = writableRaster.getHeight();
                n4 = writableRaster.getNumBands() - 1;
                n3 = writableRaster.getMinX();
                n2 = writableRaster.getMinY();
                if (!bl2) break block78;
                switch (this.transferType) {
                    case 0: {
                        byte[] byArray = null;
                        byte[] byArray2 = null;
                        float f2 = 1.0f / (float)((1 << this.nBits[n4]) - 1);
                        int n7 = 0;
                        while (n7 < n5) {
                            int n8 = n3;
                            int n9 = 0;
                            while (n9 < n6) {
                                float f3 = (float)((byArray = (byte[])writableRaster.getDataElements(n8, n2, byArray))[n4] & 0xFF) * f2;
                                if (f3 != 0.0f) {
                                    for (int i2 = 0; i2 < n4; ++i2) {
                                        byArray[i2] = (byte)((float)(byArray[i2] & 0xFF) * f3 + 0.5f);
                                    }
                                    writableRaster.setDataElements(n8, n2, byArray);
                                } else {
                                    if (byArray2 == null) {
                                        byArray2 = new byte[this.numComponents];
                                        Arrays.fill(byArray2, (byte)0);
                                    }
                                    writableRaster.setDataElements(n8, n2, byArray2);
                                }
                                ++n9;
                                ++n8;
                            }
                            ++n7;
                            ++n2;
                        }
                        break block79;
                    }
                    case 1: {
                        short[] sArray = null;
                        short[] sArray2 = null;
                        float f4 = 1.0f / (float)((1 << this.nBits[n4]) - 1);
                        int n10 = 0;
                        while (n10 < n5) {
                            int n11 = n3;
                            int n12 = 0;
                            while (n12 < n6) {
                                float f5 = (float)((sArray = (short[])writableRaster.getDataElements(n11, n2, sArray))[n4] & 0xFFFF) * f4;
                                if (f5 != 0.0f) {
                                    for (int i3 = 0; i3 < n4; ++i3) {
                                        sArray[i3] = (short)((float)(sArray[i3] & 0xFFFF) * f5 + 0.5f);
                                    }
                                    writableRaster.setDataElements(n11, n2, sArray);
                                } else {
                                    if (sArray2 == null) {
                                        sArray2 = new short[this.numComponents];
                                        Arrays.fill(sArray2, (short)0);
                                    }
                                    writableRaster.setDataElements(n11, n2, sArray2);
                                }
                                ++n12;
                                ++n11;
                            }
                            ++n10;
                            ++n2;
                        }
                        break block79;
                    }
                    case 3: {
                        int[] nArray = null;
                        int[] nArray2 = null;
                        float f6 = 1.0f / (float)((1 << this.nBits[n4]) - 1);
                        int n13 = 0;
                        while (n13 < n5) {
                            int n14 = n3;
                            int n15 = 0;
                            while (n15 < n6) {
                                float f7 = (float)(nArray = (int[])writableRaster.getDataElements(n14, n2, nArray))[n4] * f6;
                                if (f7 != 0.0f) {
                                    for (int i4 = 0; i4 < n4; ++i4) {
                                        nArray[i4] = (int)((float)nArray[i4] * f7 + 0.5f);
                                    }
                                    writableRaster.setDataElements(n14, n2, nArray);
                                } else {
                                    if (nArray2 == null) {
                                        nArray2 = new int[this.numComponents];
                                        Arrays.fill(nArray2, 0);
                                    }
                                    writableRaster.setDataElements(n14, n2, nArray2);
                                }
                                ++n15;
                                ++n14;
                            }
                            ++n13;
                            ++n2;
                        }
                        break block79;
                    }
                    case 2: {
                        short[] sArray = null;
                        short[] sArray3 = null;
                        float f8 = 3.051851E-5f;
                        int n16 = 0;
                        while (n16 < n5) {
                            int n17 = n3;
                            int n18 = 0;
                            while (n18 < n6) {
                                float f9 = (float)(sArray = (short[])writableRaster.getDataElements(n17, n2, sArray))[n4] * f8;
                                if (f9 != 0.0f) {
                                    for (int i5 = 0; i5 < n4; ++i5) {
                                        sArray[i5] = (short)((float)sArray[i5] * f9 + 0.5f);
                                    }
                                    writableRaster.setDataElements(n17, n2, sArray);
                                } else {
                                    if (sArray3 == null) {
                                        sArray3 = new short[this.numComponents];
                                        Arrays.fill(sArray3, (short)0);
                                    }
                                    writableRaster.setDataElements(n17, n2, sArray3);
                                }
                                ++n18;
                                ++n17;
                            }
                            ++n16;
                            ++n2;
                        }
                        break block79;
                    }
                    case 4: {
                        float[] fArray = null;
                        float[] fArray2 = null;
                        int n19 = 0;
                        while (n19 < n5) {
                            int n20 = n3;
                            int n21 = 0;
                            while (n21 < n6) {
                                float f10 = (fArray = (float[])writableRaster.getDataElements(n20, n2, fArray))[n4];
                                if (f10 != 0.0f) {
                                    int n22 = 0;
                                    while (n22 < n4) {
                                        int n23 = n22++;
                                        fArray[n23] = fArray[n23] * f10;
                                    }
                                    writableRaster.setDataElements(n20, n2, fArray);
                                } else {
                                    if (fArray2 == null) {
                                        fArray2 = new float[this.numComponents];
                                        Arrays.fill(fArray2, 0.0f);
                                    }
                                    writableRaster.setDataElements(n20, n2, fArray2);
                                }
                                ++n21;
                                ++n20;
                            }
                            ++n19;
                            ++n2;
                        }
                        break block79;
                    }
                    case 5: {
                        double[] dArray = null;
                        double[] dArray2 = null;
                        int n24 = 0;
                        while (n24 < n5) {
                            int n25 = n3;
                            int n26 = 0;
                            while (n26 < n6) {
                                double d2 = (dArray = (double[])writableRaster.getDataElements(n25, n2, dArray))[n4];
                                if (d2 != 0.0) {
                                    int n27 = 0;
                                    while (n27 < n4) {
                                        int n28 = n27++;
                                        dArray[n28] = dArray[n28] * d2;
                                    }
                                    writableRaster.setDataElements(n25, n2, dArray);
                                } else {
                                    if (dArray2 == null) {
                                        dArray2 = new double[this.numComponents];
                                        Arrays.fill(dArray2, 0.0);
                                    }
                                    writableRaster.setDataElements(n25, n2, dArray2);
                                }
                                ++n26;
                                ++n25;
                            }
                            ++n24;
                            ++n2;
                        }
                        break block79;
                    }
                    default: {
                        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                    }
                }
            }
            switch (this.transferType) {
                case 0: {
                    byte[] byArray = null;
                    float f11 = 1.0f / (float)((1 << this.nBits[n4]) - 1);
                    int n29 = 0;
                    while (n29 < n5) {
                        int n30 = n3;
                        int n31 = 0;
                        while (n31 < n6) {
                            float f12 = (float)((byArray = (byte[])writableRaster.getDataElements(n30, n2, byArray))[n4] & 0xFF) * f11;
                            if (f12 != 0.0f) {
                                float f13 = 1.0f / f12;
                                for (int i6 = 0; i6 < n4; ++i6) {
                                    byArray[i6] = (byte)((float)(byArray[i6] & 0xFF) * f13 + 0.5f);
                                }
                                writableRaster.setDataElements(n30, n2, byArray);
                            }
                            ++n31;
                            ++n30;
                        }
                        ++n29;
                        ++n2;
                    }
                    break;
                }
                case 1: {
                    short[] sArray = null;
                    float f14 = 1.0f / (float)((1 << this.nBits[n4]) - 1);
                    int n32 = 0;
                    while (n32 < n5) {
                        int n33 = n3;
                        int n34 = 0;
                        while (n34 < n6) {
                            float f15 = (float)((sArray = (short[])writableRaster.getDataElements(n33, n2, sArray))[n4] & 0xFFFF) * f14;
                            if (f15 != 0.0f) {
                                float f16 = 1.0f / f15;
                                for (int i7 = 0; i7 < n4; ++i7) {
                                    sArray[i7] = (short)((float)(sArray[i7] & 0xFFFF) * f16 + 0.5f);
                                }
                                writableRaster.setDataElements(n33, n2, sArray);
                            }
                            ++n34;
                            ++n33;
                        }
                        ++n32;
                        ++n2;
                    }
                    break;
                }
                case 3: {
                    int[] nArray = null;
                    float f17 = 1.0f / (float)((1 << this.nBits[n4]) - 1);
                    int n35 = 0;
                    while (n35 < n5) {
                        int n36 = n3;
                        int n37 = 0;
                        while (n37 < n6) {
                            float f18 = (float)(nArray = (int[])writableRaster.getDataElements(n36, n2, nArray))[n4] * f17;
                            if (f18 != 0.0f) {
                                float f19 = 1.0f / f18;
                                for (int i8 = 0; i8 < n4; ++i8) {
                                    nArray[i8] = (int)((float)nArray[i8] * f19 + 0.5f);
                                }
                                writableRaster.setDataElements(n36, n2, nArray);
                            }
                            ++n37;
                            ++n36;
                        }
                        ++n35;
                        ++n2;
                    }
                    break;
                }
                case 2: {
                    short[] sArray = null;
                    float f20 = 3.051851E-5f;
                    int n38 = 0;
                    while (n38 < n5) {
                        int n39 = n3;
                        int n40 = 0;
                        while (n40 < n6) {
                            float f21 = (float)(sArray = (short[])writableRaster.getDataElements(n39, n2, sArray))[n4] * f20;
                            if (f21 != 0.0f) {
                                float f22 = 1.0f / f21;
                                for (int i9 = 0; i9 < n4; ++i9) {
                                    sArray[i9] = (short)((float)sArray[i9] * f22 + 0.5f);
                                }
                                writableRaster.setDataElements(n39, n2, sArray);
                            }
                            ++n40;
                            ++n39;
                        }
                        ++n38;
                        ++n2;
                    }
                    break;
                }
                case 4: {
                    float[] fArray = null;
                    int n41 = 0;
                    while (n41 < n5) {
                        int n42 = n3;
                        int n43 = 0;
                        while (n43 < n6) {
                            float f23 = (fArray = (float[])writableRaster.getDataElements(n42, n2, fArray))[n4];
                            if (f23 != 0.0f) {
                                float f24 = 1.0f / f23;
                                int n44 = 0;
                                while (n44 < n4) {
                                    int n45 = n44++;
                                    fArray[n45] = fArray[n45] * f24;
                                }
                                writableRaster.setDataElements(n42, n2, fArray);
                            }
                            ++n43;
                            ++n42;
                        }
                        ++n41;
                        ++n2;
                    }
                    break;
                }
                case 5: {
                    double[] dArray = null;
                    int n46 = 0;
                    while (n46 < n5) {
                        int n47 = n3;
                        int n48 = 0;
                        while (n48 < n6) {
                            double d3 = (dArray = (double[])writableRaster.getDataElements(n47, n2, dArray))[n4];
                            if (d3 != 0.0) {
                                double d4 = 1.0 / d3;
                                int n49 = 0;
                                while (n49 < n4) {
                                    int n50 = n49++;
                                    dArray[n50] = dArray[n50] * d4;
                                }
                                writableRaster.setDataElements(n47, n2, dArray);
                            }
                            ++n48;
                            ++n47;
                        }
                        ++n46;
                        ++n2;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                }
            }
        }
        if (!this.signed) {
            return new ComponentColorModel(this.colorSpace, this.nBits, this.supportsAlpha, bl2, this.transparency, this.transferType);
        }
        return new ComponentColorModel(this.colorSpace, this.supportsAlpha, bl2, this.transparency, this.transferType);
    }

    public boolean isCompatibleRaster(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel instanceof ComponentSampleModel) {
            if (sampleModel.getNumBands() != this.getNumComponents()) {
                return false;
            }
            for (int i2 = 0; i2 < this.nBits.length; ++i2) {
                if (sampleModel.getSampleSize(i2) >= this.nBits[i2]) continue;
                return false;
            }
            return raster.getTransferType() == this.transferType;
        }
        return false;
    }

    public WritableRaster createCompatibleWritableRaster(int n2, int n3) {
        int n4 = n2 * n3 * this.numComponents;
        WritableRaster writableRaster = null;
        switch (this.transferType) {
            case 0: 
            case 1: {
                writableRaster = Raster.createInterleavedRaster(this.transferType, n2, n3, this.numComponents, null);
                break;
            }
            default: {
                SampleModel sampleModel = this.createCompatibleSampleModel(n2, n3);
                DataBuffer dataBuffer = sampleModel.createDataBuffer();
                writableRaster = Raster.createWritableRaster(sampleModel, dataBuffer, null);
            }
        }
        return writableRaster;
    }

    public SampleModel createCompatibleSampleModel(int n2, int n3) {
        int[] nArray = new int[this.numComponents];
        for (int i2 = 0; i2 < this.numComponents; ++i2) {
            nArray[i2] = i2;
        }
        switch (this.transferType) {
            case 0: 
            case 1: {
                return new PixelInterleavedSampleModel(this.transferType, n2, n3, this.numComponents, n2 * this.numComponents, nArray);
            }
        }
        return new ComponentSampleModel(this.transferType, n2, n3, this.numComponents, n2 * this.numComponents, nArray);
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        if (this.numComponents != sampleModel.getNumBands()) {
            return false;
        }
        return sampleModel.getTransferType() == this.transferType;
    }

    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        if (!this.hasAlpha()) {
            return null;
        }
        int n2 = writableRaster.getMinX();
        int n3 = writableRaster.getMinY();
        int[] nArray = new int[]{writableRaster.getNumBands() - 1};
        return writableRaster.createWritableChild(n2, n3, writableRaster.getWidth(), writableRaster.getHeight(), n2, n3, nArray);
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        return object.getClass() == this.getClass();
    }
}

