/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jlex.internal;

import com.sun.jlex.internal.CDTrans;
import com.sun.jlex.internal.CSpec;
import com.sun.jlex.internal.CUtility;
import com.sun.jlex.internal.SparseBitSet;
import java.util.Vector;

class CMinimize {
    CSpec m_spec;
    Vector m_group;
    int[] m_ingroup;

    CMinimize() {
        this.reset();
    }

    private void reset() {
        this.m_spec = null;
        this.m_group = null;
        this.m_ingroup = null;
    }

    private void set(CSpec cSpec) {
        CUtility._assert(null != cSpec);
        this.m_spec = cSpec;
        this.m_group = null;
        this.m_ingroup = null;
    }

    void min_dfa(CSpec cSpec) {
        this.set(cSpec);
        this.minimize();
        this.reduce();
        this.reset();
    }

    private void col_copy(int n2, int n3) {
        int n4 = this.m_spec.m_dtrans_vector.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i2);
            cDTrans.m_dtrans[n2] = cDTrans.m_dtrans[n3];
        }
    }

    private void trunc_col() {
        int n2 = this.m_spec.m_dtrans_vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int[] nArray = new int[this.m_spec.m_dtrans_ncols];
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i2);
            System.arraycopy(cDTrans.m_dtrans, 0, nArray, 0, nArray.length);
            cDTrans.m_dtrans = nArray;
        }
    }

    private void row_copy(int n2, int n3) {
        CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n3);
        this.m_spec.m_dtrans_vector.setElementAt(cDTrans, n2);
    }

    private boolean col_equiv(int n2, int n3) {
        int n4 = this.m_spec.m_dtrans_vector.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i2);
            if (cDTrans.m_dtrans[n2] == cDTrans.m_dtrans[n3]) continue;
            return false;
        }
        return true;
    }

    private boolean row_equiv(int n2, int n3) {
        CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n2);
        CDTrans cDTrans2 = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n3);
        for (int i2 = 0; i2 < this.m_spec.m_dtrans_ncols; ++i2) {
            if (cDTrans.m_dtrans[i2] == cDTrans2.m_dtrans[i2]) continue;
            return false;
        }
        return true;
    }

    private void reduce() {
        int n2;
        int n3;
        SparseBitSet sparseBitSet = new SparseBitSet();
        int n4 = this.m_spec.m_dtrans_vector.size();
        this.m_spec.m_anchor_array = new int[n4];
        this.m_spec.m_accept_vector = new Vector();
        for (n3 = 0; n3 < n4; ++n3) {
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n3);
            this.m_spec.m_accept_vector.addElement(cDTrans.m_accept);
            this.m_spec.m_anchor_array[n3] = cDTrans.m_anchor;
            cDTrans.m_accept = null;
        }
        this.m_spec.m_col_map = new int[this.m_spec.m_dtrans_ncols];
        for (n3 = 0; n3 < this.m_spec.m_dtrans_ncols; ++n3) {
            this.m_spec.m_col_map[n3] = -1;
        }
        int n5 = 0;
        while (true) {
            for (n3 = 0; n3 < n5; ++n3) {
                CUtility._assert(-1 != this.m_spec.m_col_map[n3]);
            }
            for (n3 = n5; n3 < this.m_spec.m_dtrans_ncols && -1 != this.m_spec.m_col_map[n3]; ++n3) {
            }
            if (n3 >= this.m_spec.m_dtrans_ncols) break;
            CUtility._assert(false == sparseBitSet.get(n3));
            CUtility._assert(-1 == this.m_spec.m_col_map[n3]);
            sparseBitSet.set(n3);
            this.m_spec.m_col_map[n3] = n5;
            for (n2 = n3 + 1; n2 < this.m_spec.m_dtrans_ncols; ++n2) {
                if (-1 != this.m_spec.m_col_map[n2] || !this.col_equiv(n3, n2)) continue;
                this.m_spec.m_col_map[n2] = n5;
            }
            ++n5;
        }
        int n6 = 0;
        for (n3 = 0; n3 < this.m_spec.m_dtrans_ncols; ++n3) {
            if (!sparseBitSet.get(n3)) continue;
            ++n6;
            sparseBitSet.clear(n3);
            n2 = this.m_spec.m_col_map[n3];
            CUtility._assert(n2 <= n3);
            if (n2 == n3) continue;
            this.col_copy(n2, n3);
        }
        this.m_spec.m_dtrans_ncols = n5;
        this.trunc_col();
        CUtility._assert(n6 == n5);
        int n7 = this.m_spec.m_dtrans_vector.size();
        this.m_spec.m_row_map = new int[n7];
        for (n3 = 0; n3 < n7; ++n3) {
            this.m_spec.m_row_map[n3] = -1;
        }
        int n8 = 0;
        while (true) {
            for (n3 = 0; n3 < n8; ++n3) {
                CUtility._assert(-1 != this.m_spec.m_row_map[n3]);
            }
            for (n3 = n8; n3 < n7 && -1 != this.m_spec.m_row_map[n3]; ++n3) {
            }
            if (n3 >= n7) break;
            CUtility._assert(false == sparseBitSet.get(n3));
            CUtility._assert(-1 == this.m_spec.m_row_map[n3]);
            sparseBitSet.set(n3);
            this.m_spec.m_row_map[n3] = n8;
            for (n2 = n3 + 1; n2 < n7; ++n2) {
                if (-1 != this.m_spec.m_row_map[n2] || !this.row_equiv(n3, n2)) continue;
                this.m_spec.m_row_map[n2] = n8;
            }
            ++n8;
        }
        n6 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            if (!sparseBitSet.get(n3)) continue;
            ++n6;
            sparseBitSet.clear(n3);
            n2 = this.m_spec.m_row_map[n3];
            CUtility._assert(n2 <= n3);
            if (n2 == n3) continue;
            this.row_copy(n2, n3);
        }
        this.m_spec.m_dtrans_vector.setSize(n8);
        CUtility._assert(n6 == n8);
    }

    private void fix_dtrans() {
        int n2;
        Vector<CDTrans> vector = new Vector<CDTrans>();
        int n3 = this.m_spec.m_state_dtrans.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (-1 == this.m_spec.m_state_dtrans[n2]) continue;
            this.m_spec.m_state_dtrans[n2] = this.m_ingroup[this.m_spec.m_state_dtrans[n2]];
        }
        n3 = this.m_group.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Vector vector2 = (Vector)this.m_group.elementAt(n2);
            CDTrans cDTrans = (CDTrans)vector2.elementAt(0);
            vector.addElement(cDTrans);
            for (int i2 = 0; i2 < this.m_spec.m_dtrans_ncols; ++i2) {
                if (-1 == cDTrans.m_dtrans[i2]) continue;
                cDTrans.m_dtrans[i2] = this.m_ingroup[cDTrans.m_dtrans[i2]];
            }
        }
        this.m_group = null;
        this.m_spec.m_dtrans_vector = vector;
    }

    private void minimize() {
        this.init_groups();
        int n2 = this.m_group.size();
        int n3 = n2 - 1;
        while (n3 != n2) {
            n3 = n2;
            CUtility._assert(this.m_group.size() == n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                Vector vector = (Vector)this.m_group.elementAt(i2);
                int n4 = vector.size();
                if (n4 <= 1) continue;
                Vector<CDTrans> vector2 = new Vector<CDTrans>();
                boolean bl2 = false;
                CDTrans cDTrans = (CDTrans)vector.elementAt(0);
                block2: for (int i3 = 1; i3 < n4; ++i3) {
                    CDTrans cDTrans2 = (CDTrans)vector.elementAt(i3);
                    for (int i4 = 0; i4 < this.m_spec.m_dtrans_ncols; ++i4) {
                        int n5 = cDTrans.m_dtrans[i4];
                        int n6 = cDTrans2.m_dtrans[i4];
                        if (n5 == n6 || n5 != -1 && n6 != -1 && this.m_ingroup[n6] == this.m_ingroup[n5]) continue;
                        CUtility._assert(vector.elementAt(i3) == cDTrans2);
                        vector.removeElementAt(i3);
                        --i3;
                        --n4;
                        vector2.addElement(cDTrans2);
                        if (!bl2) {
                            bl2 = true;
                            ++n2;
                            this.m_group.addElement(vector2);
                        }
                        this.m_ingroup[cDTrans2.m_label] = this.m_group.size() - 1;
                        CUtility._assert(this.m_group.contains(vector2));
                        CUtility._assert(this.m_group.contains(vector));
                        CUtility._assert(vector.contains(cDTrans));
                        CUtility._assert(!vector.contains(cDTrans2));
                        CUtility._assert(!vector2.contains(cDTrans));
                        CUtility._assert(vector2.contains(cDTrans2));
                        CUtility._assert(vector.size() == n4);
                        CUtility._assert(i2 == this.m_ingroup[cDTrans.m_label]);
                        CUtility._assert(this.m_group.size() - 1 == this.m_ingroup[cDTrans2.m_label]);
                        continue block2;
                    }
                }
            }
        }
        System.out.println(this.m_group.size() + " states after removal of redundant states.");
        if (this.m_spec.m_verbose) {
            // empty if block
        }
        this.fix_dtrans();
    }

    private void init_groups() {
        this.m_group = new Vector();
        int n2 = 0;
        int n3 = this.m_spec.m_dtrans_vector.size();
        this.m_ingroup = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            Vector<CDTrans> vector;
            boolean bl2 = false;
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i2);
            CUtility._assert(i2 == cDTrans.m_label);
            CUtility._assert(false == bl2);
            CUtility._assert(n2 == this.m_group.size());
            for (int i3 = 0; i3 < n2; ++i3) {
                vector = (Vector<CDTrans>)this.m_group.elementAt(i3);
                CUtility._assert(false == bl2);
                CUtility._assert(0 < vector.size());
                CDTrans cDTrans2 = (CDTrans)vector.elementAt(0);
                int n4 = vector.size();
                CUtility._assert(0 < n4);
                for (int i4 = 1; i4 < n4; ++i4) {
                    CDTrans cDTrans3 = (CDTrans)vector.elementAt(i4);
                    CUtility._assert(cDTrans3.m_accept == cDTrans2.m_accept);
                }
                if (cDTrans2.m_accept != cDTrans.m_accept) continue;
                vector.addElement(cDTrans);
                this.m_ingroup[i2] = i3;
                bl2 = true;
                CUtility._assert(i3 == this.m_ingroup[cDTrans.m_label]);
                break;
            }
            if (bl2) continue;
            vector = new Vector<CDTrans>();
            vector.addElement(cDTrans);
            this.m_ingroup[i2] = this.m_group.size();
            this.m_group.addElement(vector);
            ++n2;
        }
        if (this.m_spec.m_verbose) {
            // empty if block
        }
    }

    private void pset(Vector vector) {
        int n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CDTrans cDTrans = (CDTrans)vector.elementAt(i2);
            System.out.print(cDTrans.m_label + " ");
        }
    }

    private void pgroups() {
        int n2;
        int n3 = this.m_group.size();
        for (n2 = 0; n2 < n3; ++n2) {
            System.out.print("\tGroup " + n2 + " {");
            this.pset((Vector)this.m_group.elementAt(n2));
            System.out.println("}");
            System.out.println();
        }
        System.out.println();
        int n4 = this.m_spec.m_dtrans_vector.size();
        for (n2 = 0; n2 < n4; ++n2) {
            System.out.println("\tstate " + n2 + " is in group " + this.m_ingroup[n2]);
        }
    }
}

