/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.io;

import com.sun.corba.se.impl.io.ObjectStreamClass;
import com.sun.corba.se.impl.io.ObjectStreamClassCorbaExt;
import com.sun.corba.se.impl.io.ObjectStreamField;
import com.sun.corba.se.impl.io.OutputStreamHook;
import com.sun.corba.se.impl.logging.UtilSystemException;
import com.sun.corba.se.impl.util.RepositoryId;
import com.sun.corba.se.impl.util.Utility;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Stack;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ValueOutputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import sun.corba.Bridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IIOPOutputStream
extends OutputStreamHook {
    private UtilSystemException wrapper = UtilSystemException.get("rpc.encoding");
    private static Bridge bridge = (Bridge)AccessController.doPrivileged(new PrivilegedAction(){

        public java.lang.Object run() {
            return Bridge.get();
        }
    });
    private OutputStream orbStream;
    private java.lang.Object currentObject = null;
    private ObjectStreamClass currentClassDesc = null;
    private int recursionDepth = 0;
    private int simpleWriteDepth = 0;
    private IOException abortIOException = null;
    private Stack classDescStack = new Stack();
    private java.lang.Object[] writeObjectArgList = new java.lang.Object[]{this};

    @Override
    protected void beginOptionalCustomData() {
        if (this.streamFormatVersion == 2) {
            ValueOutputStream valueOutputStream = (ValueOutputStream)((java.lang.Object)this.orbStream);
            valueOutputStream.start_value(this.currentClassDesc.getRMIIIOPOptionalDataRepId());
        }
    }

    public final void setOrbStream(OutputStream outputStream) {
        this.orbStream = outputStream;
    }

    @Override
    public final OutputStream getOrbStream() {
        return this.orbStream;
    }

    public final void increaseRecursionDepth() {
        ++this.recursionDepth;
    }

    public final int decreaseRecursionDepth() {
        return --this.recursionDepth;
    }

    @Override
    public final void writeObjectOverride(java.lang.Object object) throws IOException {
        this.writeObjectState.writeData(this);
        Util.writeAbstractObject(this.orbStream, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void simpleWriteObject(java.lang.Object object, byte by) {
        byte by2 = this.streamFormatVersion;
        this.streamFormatVersion = by;
        java.lang.Object object2 = this.currentObject;
        ObjectStreamClass objectStreamClass = this.currentClassDesc;
        ++this.simpleWriteDepth;
        try {
            this.outputObject(object);
        }
        catch (IOException iOException) {
            if (this.abortIOException == null) {
                this.abortIOException = iOException;
            }
        }
        finally {
            this.streamFormatVersion = by2;
            --this.simpleWriteDepth;
            this.currentObject = object2;
            this.currentClassDesc = objectStreamClass;
        }
        IOException iOException = this.abortIOException;
        if (this.simpleWriteDepth == 0) {
            this.abortIOException = null;
        }
        if (iOException != null) {
            bridge.throwException(iOException);
        }
    }

    @Override
    ObjectStreamField[] getFieldsNoCopy() {
        return this.currentClassDesc.getFieldsNoCopy();
    }

    @Override
    public final void defaultWriteObjectDelegate() {
        try {
            if (this.currentObject == null || this.currentClassDesc == null) {
                throw new NotActiveException("defaultWriteObjectDelegate");
            }
            ObjectStreamField[] objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
            if (objectStreamFieldArray.length > 0) {
                this.outputClassFields(this.currentObject, this.currentClassDesc.forClass(), objectStreamFieldArray);
            }
        }
        catch (IOException iOException) {
            bridge.throwException(iOException);
        }
    }

    public final boolean enableReplaceObjectDelegate(boolean bl2) {
        return false;
    }

    @Override
    protected final void annotateClass(Class<?> clazz) throws IOException {
        throw new IOException("Method annotateClass not supported");
    }

    @Override
    public final void close() throws IOException {
    }

    @Override
    protected final void drain() throws IOException {
    }

    @Override
    public final void flush() throws IOException {
        try {
            this.orbStream.flush();
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    @Override
    protected final java.lang.Object replaceObject(java.lang.Object object) throws IOException {
        throw new IOException("Method replaceObject not supported");
    }

    @Override
    public final void reset() throws IOException {
        try {
            if (this.currentObject != null || this.currentClassDesc != null) {
                throw new IOException("Illegal call to reset");
            }
            this.abortIOException = null;
            if (this.classDescStack == null) {
                this.classDescStack = new Stack();
            } else {
                this.classDescStack.setSize(0);
            }
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    @Override
    public final void write(byte[] byArray) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_octet_array(byArray, 0, byArray.length);
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    @Override
    public final void write(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_octet_array(byArray, n2, n3);
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    @Override
    public final void write(int n2) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_octet((byte)(n2 & 0xFF));
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    @Override
    public final void writeBoolean(boolean bl2) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_boolean(bl2);
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    @Override
    public final void writeByte(int n2) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_octet((byte)n2);
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    @Override
    public final void writeBytes(String string) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            byte[] byArray = string.getBytes();
            this.orbStream.write_octet_array(byArray, 0, byArray.length);
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    @Override
    public final void writeChar(int n2) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_wchar((char)n2);
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    @Override
    public final void writeChars(String string) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            char[] cArray = string.toCharArray();
            this.orbStream.write_wchar_array(cArray, 0, cArray.length);
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    @Override
    public final void writeDouble(double d2) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_double(d2);
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    @Override
    public final void writeFloat(float f2) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_float(f2);
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    @Override
    public final void writeInt(int n2) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_long(n2);
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    @Override
    public final void writeLong(long l2) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_longlong(l2);
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    @Override
    public final void writeShort(int n2) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.orbStream.write_short((short)n2);
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    @Override
    protected final void writeStreamHeader() throws IOException {
    }

    protected void internalWriteUTF(org.omg.CORBA.portable.OutputStream outputStream, String string) {
        outputStream.write_wstring(string);
    }

    @Override
    public final void writeUTF(String string) throws IOException {
        try {
            this.writeObjectState.writeData(this);
            this.internalWriteUTF(this.orbStream, string);
        }
        catch (Error error) {
            IOException iOException = new IOException(error.getMessage());
            iOException.initCause(error);
            throw iOException;
        }
    }

    private boolean checkSpecialClasses(java.lang.Object object) throws IOException {
        if (object instanceof ObjectStreamClass) {
            throw new IOException("Serialization of ObjectStreamClass not supported");
        }
        return false;
    }

    private boolean checkSubstitutableSpecialClasses(java.lang.Object object) throws IOException {
        if (object instanceof String) {
            this.orbStream.write_value((Serializable)object);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputObject(java.lang.Object object) throws IOException {
        this.currentObject = object;
        Class<? extends java.lang.Object> clazz = object.getClass();
        this.currentClassDesc = ObjectStreamClass.lookup(clazz);
        if (this.currentClassDesc == null) {
            throw new NotSerializableException(clazz.getName());
        }
        if (this.currentClassDesc.isExternalizable()) {
            this.orbStream.write_octet(this.streamFormatVersion);
            Externalizable externalizable = (Externalizable)object;
            externalizable.writeExternal(this);
        } else {
            int n2 = this.classDescStack.size();
            try {
                ObjectStreamClass objectStreamClass;
                while ((objectStreamClass = this.currentClassDesc.getSuperclass()) != null) {
                    this.classDescStack.push(this.currentClassDesc);
                    this.currentClassDesc = objectStreamClass;
                }
                do {
                    OutputStreamHook.WriteObjectState writeObjectState = this.writeObjectState;
                    try {
                        this.setState(NOT_IN_WRITE_OBJECT);
                        if (this.currentClassDesc.hasWriteObject()) {
                            this.invokeObjectWriter(this.currentClassDesc, object);
                            continue;
                        }
                        this.defaultWriteObjectDelegate();
                    }
                    finally {
                        this.setState(writeObjectState);
                    }
                } while (this.classDescStack.size() > n2 && (this.currentClassDesc = (ObjectStreamClass)this.classDescStack.pop()) != null);
            }
            finally {
                this.classDescStack.setSize(n2);
            }
        }
    }

    private void invokeObjectWriter(ObjectStreamClass objectStreamClass, java.lang.Object object) throws IOException {
        Class clazz = objectStreamClass.forClass();
        try {
            this.orbStream.write_octet(this.streamFormatVersion);
            this.writeObjectState.enterWriteObject(this);
            objectStreamClass.writeObjectMethod.invoke(object, this.writeObjectArgList);
            this.writeObjectState.exitWriteObject(this);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("invokeObjectWriter internal error", invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    void writeField(ObjectStreamField objectStreamField, java.lang.Object object) throws IOException {
        switch (objectStreamField.getTypeCode()) {
            case 'B': {
                if (object == null) {
                    this.orbStream.write_octet((byte)0);
                    break;
                }
                this.orbStream.write_octet((Byte)object);
                break;
            }
            case 'C': {
                if (object == null) {
                    this.orbStream.write_wchar('\u0000');
                    break;
                }
                this.orbStream.write_wchar(((Character)object).charValue());
                break;
            }
            case 'F': {
                if (object == null) {
                    this.orbStream.write_float(0.0f);
                    break;
                }
                this.orbStream.write_float(((Float)object).floatValue());
                break;
            }
            case 'D': {
                if (object == null) {
                    this.orbStream.write_double(0.0);
                    break;
                }
                this.orbStream.write_double((Double)object);
                break;
            }
            case 'I': {
                if (object == null) {
                    this.orbStream.write_long(0);
                    break;
                }
                this.orbStream.write_long((Integer)object);
                break;
            }
            case 'J': {
                if (object == null) {
                    this.orbStream.write_longlong(0L);
                    break;
                }
                this.orbStream.write_longlong((Long)object);
                break;
            }
            case 'S': {
                if (object == null) {
                    this.orbStream.write_short((short)0);
                    break;
                }
                this.orbStream.write_short((Short)object);
                break;
            }
            case 'Z': {
                if (object == null) {
                    this.orbStream.write_boolean(false);
                    break;
                }
                this.orbStream.write_boolean((Boolean)object);
                break;
            }
            case 'L': 
            case '[': {
                this.writeObjectField(objectStreamField, object);
                break;
            }
            default: {
                throw new InvalidClassException(this.currentClassDesc.getName());
            }
        }
    }

    private void writeObjectField(ObjectStreamField objectStreamField, java.lang.Object object) throws IOException {
        if (ObjectStreamClassCorbaExt.isAny(objectStreamField.getTypeString())) {
            Util.writeAny(this.orbStream, object);
        } else {
            Class clazz = objectStreamField.getType();
            int n2 = 2;
            if (clazz.isInterface()) {
                String string = clazz.getName();
                if (Remote.class.isAssignableFrom(clazz)) {
                    n2 = 0;
                } else if (Object.class.isAssignableFrom(clazz)) {
                    n2 = 0;
                } else if (RepositoryId.isAbstractBase(clazz)) {
                    n2 = 1;
                } else if (ObjectStreamClassCorbaExt.isAbstractInterface(clazz)) {
                    n2 = 1;
                }
            }
            switch (n2) {
                case 0: {
                    Util.writeRemoteObject(this.orbStream, object);
                    break;
                }
                case 1: {
                    Util.writeAbstractObject(this.orbStream, object);
                    break;
                }
                case 2: {
                    try {
                        this.orbStream.write_value((Serializable)object, clazz);
                        break;
                    }
                    catch (ClassCastException classCastException) {
                        if (object instanceof Serializable) {
                            throw classCastException;
                        }
                        Utility.throwNotSerializableForCorba(object.getClass().getName());
                    }
                }
            }
        }
    }

    private void outputClassFields(java.lang.Object object, Class clazz, ObjectStreamField[] objectStreamFieldArray) throws IOException, InvalidClassException {
        for (int i2 = 0; i2 < objectStreamFieldArray.length; ++i2) {
            if (objectStreamFieldArray[i2].getField() == null) {
                throw new InvalidClassException(clazz.getName(), "Nonexistent field " + objectStreamFieldArray[i2].getName());
            }
            try {
                switch (objectStreamFieldArray[i2].getTypeCode()) {
                    case 'B': {
                        byte by = objectStreamFieldArray[i2].getField().getByte(object);
                        this.orbStream.write_octet(by);
                        break;
                    }
                    case 'C': {
                        char c2 = objectStreamFieldArray[i2].getField().getChar(object);
                        this.orbStream.write_wchar(c2);
                        break;
                    }
                    case 'F': {
                        float f2 = objectStreamFieldArray[i2].getField().getFloat(object);
                        this.orbStream.write_float(f2);
                        break;
                    }
                    case 'D': {
                        double d2 = objectStreamFieldArray[i2].getField().getDouble(object);
                        this.orbStream.write_double(d2);
                        break;
                    }
                    case 'I': {
                        int n2 = objectStreamFieldArray[i2].getField().getInt(object);
                        this.orbStream.write_long(n2);
                        break;
                    }
                    case 'J': {
                        long l2 = objectStreamFieldArray[i2].getField().getLong(object);
                        this.orbStream.write_longlong(l2);
                        break;
                    }
                    case 'S': {
                        short s2 = objectStreamFieldArray[i2].getField().getShort(object);
                        this.orbStream.write_short(s2);
                        break;
                    }
                    case 'Z': {
                        boolean bl2 = objectStreamFieldArray[i2].getField().getBoolean(object);
                        this.orbStream.write_boolean(bl2);
                        break;
                    }
                    case 'L': 
                    case '[': {
                        java.lang.Object object2 = objectStreamFieldArray[i2].getField().get(object);
                        this.writeObjectField(objectStreamFieldArray[i2], object2);
                        break;
                    }
                    default: {
                        throw new InvalidClassException(clazz.getName());
                    }
                }
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw this.wrapper.illegalFieldAccess(illegalAccessException, (java.lang.Object)objectStreamFieldArray[i2].getName());
            }
        }
    }
}

