/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jazzlib;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import net.sf.jazzlib.CRC32;
import net.sf.jazzlib.Inflater;
import net.sf.jazzlib.InflaterInputStream;
import net.sf.jazzlib.ZipConstants;
import net.sf.jazzlib.ZipEntry;
import net.sf.jazzlib.ZipException;

public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private CRC32 _$9580 = new CRC32();
    private ZipEntry _$9675 = null;
    private int _$9687;
    private int _$527;
    private int _$9670;
    private int _$3792;
    private int _$9596;
    private boolean _$14276;

    public ZipInputStream(InputStream inputStream) {
        super(inputStream, new Inflater(true));
    }

    private void _$14277() throws IOException {
        this._$9596 = this.len = this.in.read(this.buf, 0, this.buf.length);
    }

    private int _$14278(byte[] byArray, int n, int n2) throws IOException {
        if (this._$9596 <= 0) {
            this._$14277();
            if (this._$9596 <= 0) {
                return -1;
            }
        }
        if (n2 > this._$9596) {
            n2 = this._$9596;
        }
        System.arraycopy(this.buf, this.len - this._$9596, byArray, n, n2);
        this._$9596 -= n2;
        return n2;
    }

    private void _$6831(byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        for (int i = byArray.length; i > 0; i -= n) {
            n = this._$14278(byArray, n2, i);
            if (n == -1) {
                throw new EOFException();
            }
            n2 += n;
        }
    }

    private final int _$14279() throws IOException {
        if (this._$9596 <= 0) {
            this._$14277();
            if (this._$9596 <= 0) {
                throw new ZipException("EOF in header");
            }
        }
        return this.buf[this.len - this._$9596--] & 0xFF;
    }

    private final int _$9794() throws IOException {
        return this._$14279() | this._$14279() << 8;
    }

    private final int _$9796() throws IOException {
        return this._$9794() | this._$9794() << 16;
    }

    public ZipEntry getNextEntry() throws IOException {
        int n;
        if (this._$9580 == null) {
            throw new IOException("Stream closed.");
        }
        if (this._$9675 != null) {
            this.closeEntry();
        }
        if ((n = this._$9796()) == 33639248) {
            this.close();
            return null;
        }
        if (n != 67324752) {
            throw new ZipException("Wrong Local header signature: " + Integer.toHexString(n));
        }
        this._$9794();
        this._$3792 = this._$9794();
        this._$9670 = this._$9794();
        int n2 = this._$9796();
        int n3 = this._$9796();
        this._$9687 = this._$9796();
        this._$527 = this._$9796();
        int n4 = this._$9794();
        int n5 = this._$9794();
        if (this._$9670 == 0 && this._$9687 != this._$527) {
            throw new ZipException("Stored, but compressed != uncompressed");
        }
        byte[] byArray = new byte[n4];
        this._$6831(byArray);
        String string = new String(byArray);
        this._$9675 = this.createZipEntry(string);
        this._$14276 = false;
        this._$9675.setMethod(this._$9670);
        if ((this._$3792 & 8) == 0) {
            this._$9675.setCrc((long)n3 & 0xFFFFFFFFL);
            this._$9675.setSize((long)this._$527 & 0xFFFFFFFFL);
            this._$9675.setCompressedSize((long)this._$9687 & 0xFFFFFFFFL);
        }
        this._$9675.setDOSTime(n2);
        if (n5 > 0) {
            byte[] byArray2 = new byte[n5];
            this._$6831(byArray2);
            this._$9675.setExtra(byArray2);
        }
        if (this._$9670 == 8 && this._$9596 > 0) {
            System.arraycopy(this.buf, this.len - this._$9596, this.buf, 0, this._$9596);
            this.len = this._$9596;
            this._$9596 = 0;
            this.inf.setInput(this.buf, 0, this.len);
        }
        return this._$9675;
    }

    private void _$14282() throws IOException {
        if (this._$9796() != 134695760) {
            throw new ZipException("Data descriptor signature not found");
        }
        this._$9675.setCrc((long)this._$9796() & 0xFFFFFFFFL);
        this._$9687 = this._$9796();
        this._$527 = this._$9796();
        this._$9675.setSize((long)this._$527 & 0xFFFFFFFFL);
        this._$9675.setCompressedSize((long)this._$9687 & 0xFFFFFFFFL);
    }

    public void closeEntry() throws IOException {
        if (this._$9580 == null) {
            throw new IOException("Stream closed.");
        }
        if (this._$9675 == null) {
            return;
        }
        if (this._$9670 == 8) {
            if ((this._$3792 & 8) != 0) {
                byte[] byArray = new byte[2048];
                while (this.read(byArray) > 0) {
                }
                return;
            }
            this._$9687 -= this.inf.getTotalIn();
            this._$9596 = this.inf.getRemaining();
        }
        if (this._$9596 > this._$9687 && this._$9687 >= 0) {
            this._$9596 -= this._$9687;
        } else {
            this._$9687 -= this._$9596;
            this._$9596 = 0;
            while (this._$9687 != 0) {
                long l = this.in.skip((long)this._$9687 & 0xFFFFFFFFL);
                if (l <= 0L) {
                    throw new ZipException("zip archive ends early.");
                }
                this._$9687 = (int)((long)this._$9687 - l);
            }
        }
        this._$527 = 0;
        this._$9580.reset();
        if (this._$9670 == 8) {
            this.inf.reset();
        }
        this._$9675 = null;
        this._$14276 = true;
    }

    public int available() throws IOException {
        return this._$14276 ? 0 : 1;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray, 0, 1) <= 0) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (this._$9580 == null) {
            throw new IOException("Stream closed.");
        }
        if (this._$9675 == null) {
            return -1;
        }
        boolean bl = false;
        switch (this._$9670) {
            case 8: {
                n2 = super.read(byArray, n, n2);
                if (n2 >= 0) break;
                if (!this.inf.finished()) {
                    throw new ZipException("Inflater not finished!?");
                }
                this._$9596 = this.inf.getRemaining();
                if ((this._$3792 & 8) != 0) {
                    this._$14282();
                }
                if (this.inf.getTotalIn() != this._$9687 || this.inf.getTotalOut() != this._$527) {
                    throw new ZipException("size mismatch: " + this._$9687 + ";" + this._$527 + " <-> " + this.inf.getTotalIn() + ";" + this.inf.getTotalOut());
                }
                this.inf.reset();
                bl = true;
                break;
            }
            case 0: {
                if (n2 > this._$9687 && this._$9687 >= 0) {
                    n2 = this._$9687;
                }
                if ((n2 = this._$14278(byArray, n, n2)) > 0) {
                    this._$9687 -= n2;
                    this._$527 -= n2;
                }
                if (this._$9687 == 0) {
                    bl = true;
                    break;
                }
                if (n2 >= 0) break;
                throw new ZipException("EOF in stored block");
            }
        }
        if (n2 > 0) {
            this._$9580.update(byArray, n, n2);
        }
        if (bl) {
            if ((this._$9580.getValue() & 0xFFFFFFFFL) != this._$9675.getCrc()) {
                throw new ZipException("CRC mismatch");
            }
            this._$9580.reset();
            this._$9675 = null;
            this._$14276 = true;
        }
        return n2;
    }

    public void close() throws IOException {
        super.close();
        this._$9580 = null;
        this._$9675 = null;
        this._$14276 = true;
    }

    protected ZipEntry createZipEntry(String string) {
        return new ZipEntry(string);
    }
}

