/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jazzlib;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.jazzlib.Inflater;
import net.sf.jazzlib.InflaterInputStream;
import net.sf.jazzlib.ZipConstants;
import net.sf.jazzlib.ZipEntry;
import net.sf.jazzlib.ZipException;
import org.apache.log4j.Logger;

public class ZipFile
implements ZipConstants {
    private Logger _$6536 = Logger.getLogger(ZipFile.class);
    private boolean _$10386 = false;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private final String _$46;
    private final RandomAccessFile _$10389;
    private HashMap _$9655;
    private boolean _$6801 = false;
    private String _$10390 = System.getProperty("file.encoding");
    private byte[] _$10406 = new byte[30];

    public ZipFile(String string) throws ZipException, IOException {
        this._$10389 = new RandomAccessFile(string, "r");
        this._$46 = string;
    }

    public ZipFile(File file) throws ZipException, IOException {
        this._$10389 = new RandomAccessFile(file, "r");
        this._$46 = file.getPath();
    }

    public ZipFile(File file, int n) throws ZipException, IOException {
        if ((n & 4) != 0) {
            throw new IllegalArgumentException("OPEN_DELETE mode not supported yet in net.sf.jazzlib.ZipFile");
        }
        this._$10389 = new RandomAccessFile(file, "r");
        this._$46 = file.getPath();
    }

    private final int _$9794(DataInput dataInput, byte[] byArray) throws IOException {
        dataInput.readFully(byArray, 0, 2);
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
    }

    private final int _$9796(DataInput dataInput, byte[] byArray) throws IOException {
        dataInput.readFully(byArray, 0, 4);
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8) << 16;
    }

    private final int _$9794(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private final int _$9796(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF | (byArray[n + 3] & 0xFF) << 8) << 16;
    }

    private static String _$10392(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n + n2;
        int n5 = n;
        block10: while (n5 < n4) {
            int n6 = byArray[n5++] & 0xFF;
            switch (n6 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n3;
                    continue block10;
                }
                case 12: 
                case 13: {
                    if ((byArray[n5++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++n3;
                    continue block10;
                }
                case 14: {
                    if ((byArray[n5++] & 0xC0) != 128 || (byArray[n5++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++n3;
                    continue block10;
                }
            }
            throw new IllegalArgumentException();
        }
        if (n5 != n4) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[n3];
        n5 = 0;
        block11: while (n < n4) {
            int n7 = byArray[n++] & 0xFF;
            switch (n7 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n5++] = (char)n7;
                    continue block11;
                }
                case 12: 
                case 13: {
                    cArray[n5++] = (char)((n7 & 0x1F) << 6 | byArray[n++] & 0x3F);
                    continue block11;
                }
                case 14: {
                    int n8 = (byArray[n++] & 0x3F) << 6;
                    cArray[n5++] = (char)((n7 & 0xF) << 12 | n8 | byArray[n++] & 0x3F);
                    continue block11;
                }
            }
            throw new IllegalArgumentException();
        }
        return new String(cArray, 0, n3);
    }

    private void _$10394() throws ZipException, IOException {
        long l = this._$10389.length() - 22L;
        byte[] byArray = new byte[46];
        do {
            if (l < 0L) {
                throw new ZipException("central directory not found, probably not a zip file: " + this._$46);
            }
            this._$10389.seek(l--);
        } while (this._$9796(this._$10389, byArray) != 101010256);
        if (this._$10389.skipBytes(6) != 6) {
            throw new EOFException(this._$46);
        }
        int n = this._$9794(this._$10389, byArray);
        if (this._$10389.skipBytes(4) != 4) {
            throw new EOFException(this._$46);
        }
        int n2 = this._$9796(this._$10389, byArray);
        this._$9655 = new HashMap(n + n / 2);
        this._$10389.seek(n2);
        byte[] byArray2 = new byte[16];
        for (int i = 0; i < n; ++i) {
            this._$10389.readFully(byArray);
            if (this._$9796(byArray, 0) != 33639248) {
                throw new ZipException("Wrong Central Directory signature: " + this._$46);
            }
            int n3 = this._$9794(byArray, 10);
            int n4 = this._$9796(byArray, 12);
            int n5 = this._$9796(byArray, 16);
            int n6 = this._$9796(byArray, 20);
            int n7 = this._$9796(byArray, 24);
            int n8 = this._$9794(byArray, 28);
            int n9 = this._$9794(byArray, 30);
            int n10 = this._$9794(byArray, 32);
            int n11 = this._$9796(byArray, 42);
            int n12 = Math.max(n8, n10);
            if (byArray2.length < n12) {
                byArray2 = new byte[n12];
            }
            this._$10389.readFully(byArray2, 0, n8);
            String string = null;
            try {
                string = ZipFile._$10392(byArray2, 0, n8);
            }
            catch (Exception exception) {
                this._$6536.error((Object)"File name not utf8 encode use local charset");
                string = new String(byArray2, 0, n8, System.getProperty("file.encoding"));
                this._$10386 = true;
            }
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setMethod(n3);
            zipEntry.setCrc((long)n5 & 0xFFFFFFFFL);
            zipEntry.setSize((long)n7 & 0xFFFFFFFFL);
            zipEntry.setCompressedSize((long)n6 & 0xFFFFFFFFL);
            zipEntry.setDOSTime(n4);
            if (n9 > 0) {
                byte[] byArray3 = new byte[n9];
                this._$10389.readFully(byArray3);
                zipEntry.setExtra(byArray3);
            }
            if (n10 > 0) {
                this._$10389.readFully(byArray2, 0, n10);
                zipEntry.setComment(new String(byArray2, 0, n10));
            }
            zipEntry.offset = n11;
            this._$9655.put(string, zipEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RandomAccessFile randomAccessFile = this._$10389;
        synchronized (randomAccessFile) {
            this._$6801 = true;
            this._$9655 = null;
            this._$10389.close();
        }
    }

    protected void finalize() throws IOException {
        if (!this._$6801 && this._$10389 != null) {
            this.close();
        }
    }

    public Enumeration entries() {
        try {
            return new ZipEntryEnumeration(this._$10404().values().iterator());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap _$10404() throws IOException {
        RandomAccessFile randomAccessFile = this._$10389;
        synchronized (randomAccessFile) {
            if (this._$6801) {
                throw new IllegalStateException("ZipFile has closed: " + this._$46);
            }
            if (this._$9655 == null) {
                this._$10394();
            }
            return this._$9655;
        }
    }

    public ZipEntry getEntry(String string) {
        try {
            HashMap hashMap = this._$10404();
            ZipEntry zipEntry = (ZipEntry)hashMap.get(string);
            return zipEntry != null ? (ZipEntry)zipEntry.clone() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long _$10407(ZipEntry zipEntry) throws IOException {
        RandomAccessFile randomAccessFile = this._$10389;
        synchronized (randomAccessFile) {
            this._$10389.seek(zipEntry.offset);
            this._$10389.readFully(this._$10406);
            if (this._$9796(this._$10406, 0) != 67324752) {
                throw new ZipException("Wrong Local header signature: " + this._$46);
            }
            if (zipEntry.getMethod() != this._$9794(this._$10406, 8)) {
                throw new ZipException("Compression method mismatch: " + this._$46);
            }
            int n = 0;
            n = this._$10386 ? zipEntry.getName().getBytes(System.getProperty("file.encoding")).length : zipEntry.getName().getBytes().length;
            if (n != this._$9794(this._$10406, 26)) {
                this._$6536.error((Object)("file name length mismatch: " + this._$46), (Throwable)new ZipException("file name length mismatch: " + this._$46));
            }
            int n2 = n + this._$9794(this._$10406, 28);
            return zipEntry.offset + 30 + n2;
        }
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        String string;
        HashMap hashMap = this._$10404();
        ZipEntry zipEntry2 = (ZipEntry)hashMap.get(string = zipEntry.getName());
        if (zipEntry2 == null) {
            throw new NoSuchElementException(string);
        }
        this._$6536.debug((Object)("ZipEntry filename:" + string));
        long l = this._$10407(zipEntry2);
        int n = zipEntry2.getMethod();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new PartialInputStream(this._$10389, l, zipEntry2.getCompressedSize()));
        switch (n) {
            case 0: {
                return bufferedInputStream;
            }
            case 8: {
                return new InflaterInputStream(bufferedInputStream, new Inflater(true));
            }
        }
        throw new ZipException("Unknown compression method " + n);
    }

    public String getName() {
        return this._$46;
    }

    public int size() {
        try {
            return this._$10404().size();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    private static class PartialInputStream
    extends InputStream {
        private final RandomAccessFile _$10389;
        long filepos;
        long end;

        public PartialInputStream(RandomAccessFile randomAccessFile, long l, long l2) {
            this._$10389 = randomAccessFile;
            this.filepos = l;
            this.end = l + l2;
        }

        public int available() {
            long l = this.end - this.filepos;
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            if (this.filepos == this.end) {
                return -1;
            }
            RandomAccessFile randomAccessFile = this._$10389;
            synchronized (randomAccessFile) {
                this._$10389.seek(this.filepos++);
                return this._$10389.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if ((long)n2 > this.end - this.filepos && (n2 = (int)(this.end - this.filepos)) == 0) {
                return -1;
            }
            RandomAccessFile randomAccessFile = this._$10389;
            synchronized (randomAccessFile) {
                this._$10389.seek(this.filepos);
                int n3 = this._$10389.read(byArray, n, n2);
                if (n3 > 0) {
                    this.filepos += (long)n2;
                }
                return n3;
            }
        }

        public long skip(long l) {
            if (l < 0L) {
                throw new IllegalArgumentException();
            }
            if (l > this.end - this.filepos) {
                l = this.end - this.filepos;
            }
            this.filepos += l;
            return l;
        }
    }

    private static class ZipEntryEnumeration
    implements Enumeration {
        private final Iterator _$2680;

        public ZipEntryEnumeration(Iterator iterator) {
            this._$2680 = iterator;
        }

        public boolean hasMoreElements() {
            return this._$2680.hasNext();
        }

        public Object nextElement() {
            return ((ZipEntry)this._$2680.next()).clone();
        }
    }
}

