/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jazzlib;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import net.sf.jazzlib.CRC32;
import net.sf.jazzlib.Deflater;
import net.sf.jazzlib.DeflaterOutputStream;
import net.sf.jazzlib.ZipConstants;
import net.sf.jazzlib.ZipEntry;
import net.sf.jazzlib.ZipException;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    private Vector _$9655 = new Vector();
    private CRC32 _$9580 = new CRC32();
    private ZipEntry _$12973 = null;
    private int _$12974;
    private int _$527;
    private int _$2706 = 0;
    private byte[] _$12975 = new byte[0];
    private int _$12976 = 8;
    private static final int _$12977 = 10;
    private static final int _$12978 = 20;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    public ZipOutputStream(OutputStream outputStream) {
        super(outputStream, new Deflater(-1, true));
    }

    public void setComment(String string) {
        byte[] byArray = string.getBytes();
        if (byArray.length > 65535) {
            throw new IllegalArgumentException("Comment too long.");
        }
        this._$12975 = byArray;
    }

    public void setMethod(int n) {
        if (n != 0 && n != 8) {
            throw new IllegalArgumentException("Method not supported.");
        }
        this._$12976 = n;
    }

    public void setLevel(int n) {
        this.def.setLevel(n);
    }

    private final void _$12981(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >> 8 & 0xFF);
    }

    private final void _$12982(int n) throws IOException {
        this._$12981(n);
        this._$12981(n >> 16);
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        if (this._$9655 == null) {
            throw new ZipException("ZipOutputStream was finished");
        }
        int n = zipEntry.getMethod();
        int n2 = 0;
        if (n == -1) {
            n = this._$12976;
        }
        if (n == 0) {
            if (zipEntry.getCompressedSize() >= 0L) {
                if (zipEntry.getSize() < 0L) {
                    zipEntry.setSize(zipEntry.getCompressedSize());
                } else if (zipEntry.getSize() != zipEntry.getCompressedSize()) {
                    throw new ZipException("Method STORED, but compressed size != size");
                }
            } else {
                zipEntry.setCompressedSize(zipEntry.getSize());
            }
            if (zipEntry.getSize() < 0L) {
                throw new ZipException("Method STORED, but size not set");
            }
            if (zipEntry.getCrc() < 0L) {
                throw new ZipException("Method STORED, but crc not set");
            }
        } else if (n == 8 && (zipEntry.getCompressedSize() < 0L || zipEntry.getSize() < 0L || zipEntry.getCrc() < 0L)) {
            n2 |= 8;
        }
        if (this._$12973 != null) {
            this.closeEntry();
        }
        if (zipEntry.getTime() < 0L) {
            zipEntry.setTime(System.currentTimeMillis());
        }
        zipEntry.flags = n2;
        zipEntry.offset = this._$2706;
        zipEntry.setMethod(n);
        this._$12974 = n;
        this._$12982(67324752);
        this._$12981(n == 0 ? 10 : 20);
        this._$12981(n2);
        this._$12981(n);
        this._$12982(zipEntry.getDOSTime());
        if ((n2 & 8) == 0) {
            this._$12982((int)zipEntry.getCrc());
            this._$12982((int)zipEntry.getCompressedSize());
            this._$12982((int)zipEntry.getSize());
        } else {
            this._$12982(0);
            this._$12982(0);
            this._$12982(0);
        }
        byte[] byArray = zipEntry.getName().getBytes();
        if (byArray.length > 65535) {
            throw new ZipException("Name too long.");
        }
        byte[] byArray2 = zipEntry.getExtra();
        if (byArray2 == null) {
            byArray2 = new byte[]{};
        }
        this._$12981(byArray.length);
        this._$12981(byArray2.length);
        this.out.write(byArray);
        this.out.write(byArray2);
        this._$2706 += 30 + byArray.length + byArray2.length;
        this._$12973 = zipEntry;
        this._$9580.reset();
        if (n == 8) {
            this.def.reset();
        }
        this._$527 = 0;
    }

    public void closeEntry() throws IOException {
        int n;
        if (this._$12973 == null) {
            throw new ZipException("No open entry");
        }
        if (this._$12974 == 8) {
            super.finish();
        }
        int n2 = n = this._$12974 == 8 ? this.def.getTotalOut() : this._$527;
        if (this._$12973.getSize() < 0L) {
            this._$12973.setSize(this._$527);
        } else if (this._$12973.getSize() != (long)this._$527) {
            throw new ZipException("size was " + this._$527 + ", but I expected " + this._$12973.getSize());
        }
        if (this._$12973.getCompressedSize() < 0L) {
            this._$12973.setCompressedSize(n);
        } else if (this._$12973.getCompressedSize() != (long)n) {
            throw new ZipException("compressed size was " + n + ", but I expected " + this._$12973.getSize());
        }
        if (this._$12973.getCrc() < 0L) {
            this._$12973.setCrc(this._$9580.getValue());
        } else if (this._$12973.getCrc() != this._$9580.getValue()) {
            throw new ZipException("crc was " + Long.toHexString(this._$9580.getValue()) + ", but I expected " + Long.toHexString(this._$12973.getCrc()));
        }
        this._$2706 += n;
        if (this._$12974 == 8 && (this._$12973.flags & 8) != 0) {
            this._$12982(134695760);
            this._$12982((int)this._$12973.getCrc());
            this._$12982((int)this._$12973.getCompressedSize());
            this._$12982((int)this._$12973.getSize());
            this._$2706 += 16;
        }
        this._$9655.addElement(this._$12973);
        this._$12973 = null;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this._$12973 == null) {
            throw new ZipException("No open entry.");
        }
        switch (this._$12974) {
            case 8: {
                super.write(byArray, n, n2);
                break;
            }
            case 0: {
                this.out.write(byArray, n, n2);
            }
        }
        this._$9580.update(byArray, n, n2);
        this._$527 += n2;
    }

    public void finish() throws IOException {
        if (this._$9655 == null) {
            return;
        }
        if (this._$12973 != null) {
            this.closeEntry();
        }
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this._$9655.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            byte[] byArray;
            ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
            int n3 = zipEntry.getMethod();
            this._$12982(33639248);
            this._$12981(n3 == 0 ? 10 : 20);
            this._$12981(n3 == 0 ? 10 : 20);
            this._$12981(zipEntry.flags);
            this._$12981(n3);
            this._$12982(zipEntry.getDOSTime());
            this._$12982((int)zipEntry.getCrc());
            this._$12982((int)zipEntry.getCompressedSize());
            this._$12982((int)zipEntry.getSize());
            byte[] byArray2 = zipEntry.getName().getBytes();
            if (byArray2.length > 65535) {
                throw new ZipException("Name too long.");
            }
            byte[] byArray3 = zipEntry.getExtra();
            if (byArray3 == null) {
                byArray3 = new byte[]{};
            }
            byte[] byArray4 = byArray = (string = zipEntry.getComment()) != null ? string.getBytes() : new byte[]{};
            if (byArray.length > 65535) {
                throw new ZipException("Comment too long.");
            }
            this._$12981(byArray2.length);
            this._$12981(byArray3.length);
            this._$12981(byArray.length);
            this._$12981(0);
            this._$12981(0);
            this._$12982(0);
            this._$12982(zipEntry.offset);
            this.out.write(byArray2);
            this.out.write(byArray3);
            this.out.write(byArray);
            ++n;
            n2 += 46 + byArray2.length + byArray3.length + byArray.length;
        }
        this._$12982(101010256);
        this._$12981(0);
        this._$12981(0);
        this._$12981(n);
        this._$12981(n);
        this._$12982(n2);
        this._$12982(this._$2706);
        this._$12981(this._$12975.length);
        this.out.write(this._$12975);
        this.out.flush();
        this._$9655 = null;
    }
}

