/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.furby;

import com.lemonquest.furby.GameCanvas;
import com.lemonquest.furby.GameEngine;
import com.lemonquest.furby.IsoEngine;
import com.lemonquest.furby.Items;
import com.lemonquest.utils.SSAnimation;
import com.lemonquest.utils.SSResourceManager;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Map {
    public static final int MAP_FOREST_INDEX = 0;
    public static final int MAP_BEACH_INDEX = 1;
    public static final int MAP_RIVER_INDEX = 2;
    public static final int MAP_GARDEN_INDEX = 3;
    public static final int MAP_LAKE_INDEX = 4;
    public static final int MAP_PORT_INDEX = 5;
    public static final int MAP_CAVE_INDEX = 6;
    public static final int MAP_TOWN_INDEX = 7;
    public static final int MAP_HOUSE_INDEX = 8;
    public static final int MAP_HOUSE_SLEEP_X = 6;
    public static final int MAP_HOUSE_SLEEP_Y = 2;
    public static final int MAP_HOUSE_HUNGRY_X = 2;
    public static final int MAP_HOUSE_HUNGRY_Y = 7;
    public static final int MAP_HOUSE_FUN_X = 4;
    public static final int MAP_HOUSE_FUN_Y = 3;
    public static final int POINT_DIAMETER = 14;
    public static final int POINT_SELECTED_GAP_SIZE = 2;
    public static final int POINT_SELECTED_TIME = 2000;
    public final int[] MAP_POINTS = new int[]{130, 25, 6, 88, 60, 2, 38, 80, 0, 120, 86, 4, 37, 140, 5, 75, 142, 7, 140, 124, 1, 70, 170, 3};
    public final int[] MAP_POINTS_TILE = new int[]{0, 3, 3, 7, 0, 2, 7, 4, 1, 9, 9, 1, 9, 1, 1, 9, 2, 1, 2, 9, 0, 0, 8, 3};
    private static final String WORLD_NAME = "w";
    private static final String OBJECT_NAME = "o";
    private static final int MASK_NUM_TILE = 31;
    private static final int OFFSET_NUM_TILE = 0;
    private static final int MASK_NUM_TILESET = 7;
    private static final int OFFSET_NUM_TILESET = 5;
    private static final int MASK_NUM_TILE_REPAINT = 7;
    private static final int OFFSET_NUM_TILE_REPAINT = 8;
    private static final int MASK_TILE_HEIGHT = 15;
    private static final int OFFSET_TILE_HEIGHT = 11;
    private static final int MASK_WALKABLE = 1;
    private static final int OFFSET_WALKABLE = 15;
    public static final int OBJECT_IDGROUP = 0;
    public static final int OBJECT_IDOBJECT = 1;
    public static final int OBJECT_X = 2;
    public static final int OBJECT_Y = 3;
    private static final int OBJECT_ID = 1;
    private static final int OBJECT_COLLISION = 2;
    private static final int OBJECT_REPAINT = 3;
    public static final int TILE_IMAGE_X = 0;
    public static final int TILE_IMAGE_Y = 1;
    public static final int TILE_WIDTH = 2;
    public static final int TILE_HEIGHT = 3;
    public static final int TILE_OFFSET_X = 4;
    public static final int TILE_OFFSET_Y = 5;
    public static final int WALL_IMAGE_X = 0;
    public static final int WALL_IMAGE_Y = 1;
    public static final int WALL_WIDTH = 2;
    public static final int WALL_HEIGHT = 3;
    public static final int WALL_OFFSET_X = 4;
    public static final int WALL_OFFSET_Y = 5;
    public IsoEngine isoEngine;
    private int tileWidth;
    private int tileHeight;
    private int tileGapX;
    private int tileGapY;
    private int tileGapHeight;
    private int numTileSets = 7;
    private int numAnimations;
    private int numGroups = 29;
    private int numMaps;
    private byte[] numWalls;
    private byte[] numTiles;
    private int[] sTileSets;
    private int[] sObjects;
    private int[] sAnimations;
    private byte[][] tilesWallsOffset;
    private short[][] tilesWallsSpriteData;
    private byte[][] tilesIndexWall;
    private Image[] images;
    private int mapWidth;
    private int mapHeight;
    private short[] map;
    private short[] objectsMap;
    private short[][] tilesRepaint;
    private byte[][] listObjectsMap;
    public Image[] imageObjects;
    private short[][] objectsOffset;
    private short[][] objectsSpriteData;
    private byte[][] objectsFixedWalkable;
    private byte[][][] objectsCollision;
    private byte[][][] objectsRepaint;
    private SSAnimation[] animations;
    public static final int GATE_TILE_X = 0;
    public static final int GATE_TILE_Y = 1;
    public static final int GATE_TARGET_TILE_X = 2;
    public static final int GATE_TARGET_TILE_Y = 3;
    public static final int GATE_TARGET_INDEX_MAP = 4;
    private byte[] gates;
    public static final int FISHER_FILE_ID_ANIMATION = 6;
    public static final int FISHER_FILE_NUM_ANIMATION = 0;
    public static final int FURBY1_ID_ANIMATION = 16;
    public static final int FURBY1_NUM_ANIMATION = 0;
    public static final int FURBY2_ID_ANIMATION = 17;
    public static final int FURBY2_NUM_ANIMATION = 0;
    public static final int FURBY3_ID_ANIMATION = 25;
    public static final int FURBY3_NUM_ANIMATION = 0;
    public static final int FURBY4_ID_ANIMATION = 18;
    public static final int FURBY4_NUM_ANIMATION = 0;
    public static final int FURBY5_ID_ANIMATION = 19;
    public static final int FURBY5_NUM_ANIMATION = 0;
    public static final int FURBY6_ID_ANIMATION = 20;
    public static final int FURBY6_NUM_ANIMATION = 0;
    public static final int FURBY7_ID_ANIMATION = 21;
    public static final int FURBY7_NUM_ANIMATION = 0;
    public static final int FURBY8_ID_ANIMATION = 22;
    public static final int FURBY8_NUM_ANIMATION = 0;
    public static final int FURBY9_ID_ANIMATION = 26;
    public static final int FURBY9_NUM_ANIMATION = 0;
    public static final int FURBY10_ID_ANIMATION = 23;
    public static final int FURBY10_NUM_ANIMATION = 0;
    public static final int FURBY11_ID_ANIMATION = 24;
    public static final int FURBY11_NUM_ANIMATION = 0;
    public static final int FURBY12_ID_ANIMATION = 27;
    public static final int FURBY12_NUM_ANIMATION = 0;
    public final int[] furbyFriends = new int[]{16, 0, 17, 0, 25, 0, 18, 0, 19, 0, 20, 0, 21, 0, 22, 0, 26, 0, 23, 0, 24, 0, 27, 0};
    public static final String[] furbyFriendsName = new String[]{"$FURBY2$", "THE WITCH", "$FURBY51$", "THE COOK", "$FURBY32$", "THE SPORTSMAN", "$FURBY41$", "THE FOREST RANGER", "$FURBY12$", "THE FARMER", "$FURBY22$", "THE FISHERMAN", "$FURBY1$", "THE WISEMAN", "$FURBY42$", "THE FOODIE", "$FURBY11$", "THE NEIGHBOUR", "$FURBY3$", "THE SHOPKEEPER", "$FURBY31$", "THE CARPENTER", "$FURBY21$", "THE COLLECTOR"};
    public static final int FURBY_BRUJA = 0;
    public static final int FURBY_COCINERO = 1;
    public static final int FURBY_DEPORTISTA = 2;
    public static final int FURBY_GUARDABOSQUES = 3;
    public static final int FURBY_GRANJERO = 4;
    public static final int FURBY_PESCADOR = 5;
    public static final int FURBY_SABIO = 6;
    public static final int FURBY_COMILON = 7;
    public static final int FURBY_VECINO = 8;
    public static final int FURBY_TENDERO = 9;
    public static final int FURBY_CARPINTERO = 10;
    public static final int FURBY_COLECCIONISTA = 11;
    public static final int MAX_FURBYS = 12;
    public static final int ROCKS_ID_ANIMATION = 3;
    public static final int ROCKS_NUM_ANIMATION = 0;
    public static final int SHELL_ID_ANIMATION = 2;
    public static final int SHELL_NUM_ANIMATION = 0;
    public static final int PLANT_ID_ANIMATION = 5;
    public static final int PLANT_NUM_ANIMATION = 0;
    public static final int WOOD_ID_ANIMATION = 4;
    public static final int WOOD_NUM_ANIMATION = 0;
    public final int[] rocksItems = new int[]{3, 0};
    public final int[] shellsItems = new int[]{2, 0};
    public final int[] plantItems = new int[]{5, 0};
    public final int[] woodItems = new int[]{4, 0};
    private Items items;
    private GameEngine ge;
    private GameCanvas gc;

    public Map(GameCanvas gc) {
        this.gc = gc;
    }

    public void unloadAll() {
        int j;
        int i;
        this.numTiles = null;
        this.numWalls = null;
        for (i = 0; i < this.tilesIndexWall.length; ++i) {
            this.tilesIndexWall[i] = null;
        }
        this.tilesIndexWall = null;
        for (i = 0; i < this.tilesRepaint.length; ++i) {
            this.tilesRepaint[i] = null;
        }
        this.tilesRepaint = null;
        for (i = 0; i < this.tilesWallsOffset.length; ++i) {
            this.tilesWallsOffset[i] = null;
        }
        this.tilesWallsOffset = null;
        for (i = 0; i < this.tilesWallsSpriteData.length; ++i) {
            this.tilesWallsSpriteData[i] = null;
        }
        this.tilesWallsSpriteData = null;
        for (i = 0; i < this.images.length; ++i) {
            this.images[i] = null;
        }
        this.images = null;
        this.map = null;
        this.objectsMap = null;
        for (i = 0; i < this.listObjectsMap.length; ++i) {
            this.listObjectsMap[i] = null;
        }
        this.listObjectsMap = null;
        this.objectsMap = null;
        for (i = 0; i < this.objectsOffset.length; ++i) {
            this.objectsOffset[i] = null;
        }
        this.objectsOffset = null;
        for (i = 0; i < this.objectsSpriteData.length; ++i) {
            this.objectsSpriteData[i] = null;
        }
        this.objectsSpriteData = null;
        for (i = 0; i < this.objectsFixedWalkable.length; ++i) {
            this.objectsFixedWalkable[i] = null;
        }
        this.objectsFixedWalkable = null;
        for (i = 0; i < this.objectsCollision.length; ++i) {
            for (j = 0; j < this.objectsCollision[i].length; ++j) {
                this.objectsCollision[i][j] = null;
            }
            this.objectsCollision[i] = null;
        }
        this.objectsCollision = null;
        for (i = 0; i < this.objectsRepaint.length; ++i) {
            for (j = 0; j < this.objectsRepaint[i].length; ++j) {
                this.objectsRepaint[i][j] = null;
            }
            this.objectsRepaint[i] = null;
        }
        this.objectsRepaint = null;
        for (i = 0; i < this.animations.length; ++i) {
            this.animations[i] = null;
        }
        this.animations = null;
        this.gates = null;
    }

    public SSAnimation getAnimation(int numFile) {
        return this.animations[numFile];
    }

    public void setGameEngine(GameEngine ge) {
        this.ge = ge;
    }

    public void setItems(Items items) {
        this.items = items;
    }

    public int getNumResourcesToLoad() {
        return this.numTileSets + this.numGroups;
    }

    private void loadTileSets(DataInputStream dis, SSResourceManager resManager, int sTileSets) throws Exception {
        int i;
        if (this.images == null) {
            this.numTileSets = dis.readUnsignedByte();
            this.images = new Image[this.numTileSets];
            this.tilesWallsOffset = new byte[this.numTileSets][];
            this.tilesWallsSpriteData = new short[this.numTileSets][];
            this.tilesIndexWall = new byte[this.numTileSets][];
            this.numTiles = new byte[this.numTileSets];
            this.numWalls = new byte[this.numTileSets];
            for (i = 0; i < this.numTileSets; ++i) {
                int j;
                this.numTiles[i] = (byte)dis.readUnsignedByte();
                this.numWalls[i] = (byte)dis.readUnsignedByte();
                this.tilesWallsOffset[i] = new byte[(this.numTiles[i] + this.numWalls[i]) * 2];
                this.tilesWallsSpriteData[i] = new short[(this.numTiles[i] + this.numWalls[i]) * 4];
                this.tilesIndexWall[i] = new byte[this.numTiles[i]];
                for (j = 0; j < this.numWalls[i]; ++j) {
                    this.tilesWallsOffset[i][j * 2 + 0] = dis.readByte();
                    this.tilesWallsOffset[i][j * 2 + 1] = dis.readByte();
                    this.tilesWallsSpriteData[i][j * 4 + 0] = dis.readShort();
                    this.tilesWallsSpriteData[i][j * 4 + 1] = dis.readShort();
                    this.tilesWallsSpriteData[i][j * 4 + 2] = dis.readShort();
                    this.tilesWallsSpriteData[i][j * 4 + 3] = dis.readShort();
                }
                for (j = 0; j < this.numTiles[i]; ++j) {
                    this.tilesIndexWall[i][j] = (byte)dis.readUnsignedByte();
                    this.tilesWallsOffset[i][this.numWalls[i] * 2 + j * 2 + 0] = dis.readByte();
                    this.tilesWallsOffset[i][this.numWalls[i] * 2 + j * 2 + 1] = dis.readByte();
                    this.tilesWallsSpriteData[i][this.numWalls[i] * 4 + j * 4 + 0] = dis.readShort();
                    this.tilesWallsSpriteData[i][this.numWalls[i] * 4 + j * 4 + 1] = dis.readShort();
                    this.tilesWallsSpriteData[i][this.numWalls[i] * 4 + j * 4 + 2] = dis.readShort();
                    this.tilesWallsSpriteData[i][this.numWalls[i] * 4 + j * 4 + 3] = dis.readShort();
                }
            }
        }
        for (i = 0; i < this.numTileSets; ++i) {
            if ((sTileSets >> i & 1) == 1) continue;
            this.images[i] = null;
        }
        System.gc();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i2 = 0; i2 < this.numTileSets; ++i2) {
            if (this.images[i2] == null && (sTileSets >> i2 & 1) == 1) {
                this.images[i2] = resManager.getImage(WORLD_NAME + i2 + ".png");
            }
            this.gc.resourceLoaded();
        }
    }

    private void loadObjects(DataInputStream dis, SSResourceManager resManager, int sObjects) throws Exception {
        int g;
        if (this.imageObjects == null) {
            this.numGroups = dis.readUnsignedByte();
            this.imageObjects = new Image[this.numGroups - this.numAnimations];
            this.objectsOffset = new short[this.numGroups][];
            this.objectsSpriteData = new short[this.numGroups][];
            this.objectsFixedWalkable = new byte[this.numGroups][];
            this.objectsRepaint = new byte[this.numGroups][][];
            this.objectsCollision = new byte[this.numGroups][][];
            for (g = 0; g < this.numGroups; ++g) {
                int numObjects = dis.readUnsignedByte();
                this.objectsOffset[g] = new short[numObjects << 1];
                this.objectsSpriteData[g] = new short[numObjects << 2];
                this.objectsFixedWalkable[g] = new byte[numObjects];
                this.objectsRepaint[g] = new byte[numObjects << 1][];
                this.objectsCollision[g] = new byte[numObjects << 1][];
                for (int j = 0; j < numObjects; ++j) {
                    int k;
                    this.objectsOffset[g][(j << 1) + 0] = dis.readShort();
                    this.objectsOffset[g][(j << 1) + 1] = dis.readShort();
                    this.objectsSpriteData[g][(j << 2) + 0] = dis.readShort();
                    this.objectsSpriteData[g][(j << 2) + 1] = dis.readShort();
                    this.objectsSpriteData[g][(j << 2) + 2] = dis.readShort();
                    this.objectsSpriteData[g][(j << 2) + 3] = dis.readShort();
                    this.objectsFixedWalkable[g][j] = dis.readByte();
                    int numRepaint = dis.readUnsignedByte();
                    this.objectsRepaint[g][j] = new byte[numRepaint << 1];
                    for (k = 0; k < numRepaint * 2; ++k) {
                        this.objectsRepaint[g][j][k] = dis.readByte();
                    }
                    int numCollision = dis.readUnsignedByte();
                    this.objectsCollision[g][j] = new byte[numCollision << 1];
                    for (k = 0; k < numCollision * 2; ++k) {
                        this.objectsCollision[g][j][k] = dis.readByte();
                    }
                }
            }
            this.numGroups -= this.numAnimations;
        }
        for (g = 0; g < this.imageObjects.length; ++g) {
            if ((sObjects >> g & 1) != 0) continue;
            this.imageObjects[g] = null;
        }
        System.gc();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int g2 = 0; g2 < this.imageObjects.length; ++g2) {
            if (this.imageObjects[g2] == null && (sObjects >> g2 & 1) == 1) {
                this.imageObjects[g2] = resManager.getImage("wo" + g2 + ".png");
            }
            this.gc.resourceLoaded();
        }
    }

    private void loadAnimations(SSResourceManager resManager, int sAnimations) throws Exception {
        if (this.animations == null) {
            this.animations = new SSAnimation[this.numAnimations];
        }
        for (int i = 0; i < this.numAnimations; ++i) {
            if ((sAnimations >> i & 1) != 0) continue;
            this.animations[i] = null;
        }
        System.gc();
        try {
            Thread.sleep(20L);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < this.numAnimations; ++i) {
            if ((sAnimations >> i & 1) == 1) {
                this.animations[i] = new SSAnimation(resManager.getResourceAsStream("wo" + i + ".lqa"));
            }
            this.gc.resourceLoaded();
        }
    }

    public void loadMap(DataInputStream dis, SSResourceManager resManager, int numMap) {
        try {
            int i;
            int j;
            if (this.tileWidth <= 0 && this.tileHeight <= 0) {
                this.tileWidth = dis.readUnsignedByte();
                this.tileHeight = dis.readUnsignedByte();
                this.tileGapX = dis.readUnsignedByte();
                this.tileGapY = dis.readUnsignedByte();
                this.tileGapHeight = dis.readUnsignedByte();
                this.numAnimations = dis.readUnsignedByte();
                this.numMaps = dis.readUnsignedByte();
                this.sTileSets = new int[this.numMaps];
                this.sObjects = new int[this.numMaps];
                this.sAnimations = new int[this.numMaps];
                for (int i2 = 0; i2 < this.numMaps; ++i2) {
                    this.sTileSets[i2] = dis.readInt();
                    this.sObjects[i2] = dis.readInt();
                    this.sAnimations[i2] = dis.readInt();
                }
            }
            this.tileWidth = this.tileGapX * 2;
            this.tileHeight = this.tileGapY * 2;
            this.loadTileSets(dis, resManager, this.sTileSets[numMap]);
            this.loadObjects(dis, resManager, this.sObjects[numMap]);
            this.loadAnimations(resManager, this.sAnimations[numMap]);
            dis.close();
            dis = resManager.getResourceAsStream("wmaps");
            this.numMaps = dis.readUnsignedByte();
            this.skipMaps(dis, numMap);
            this.mapWidth = dis.readUnsignedByte();
            this.mapHeight = dis.readUnsignedByte();
            int numGates = dis.readUnsignedByte();
            this.map = new short[this.mapWidth * this.mapHeight];
            this.objectsMap = new short[this.mapWidth * this.mapHeight];
            this.gates = new byte[numGates * 5];
            for (j = 0; j < numGates; ++j) {
                this.gates[j * 5 + 0] = (byte)dis.readUnsignedByte();
                this.gates[j * 5 + 1] = (byte)dis.readUnsignedByte();
                this.gates[j * 5 + 2] = (byte)dis.readUnsignedByte();
                this.gates[j * 5 + 3] = (byte)dis.readUnsignedByte();
                this.gates[j * 5 + 4] = (byte)dis.readUnsignedByte();
            }
            for (j = 0; j < this.mapHeight; ++j) {
                for (i = 0; i < this.mapWidth; ++i) {
                    short compressedTile = dis.readShort();
                    this.setTile(i, j, compressedTile);
                }
            }
            int numTilesRepaint = dis.readUnsignedByte();
            this.tilesRepaint = new short[numTilesRepaint][];
            for (i = 0; i < numTilesRepaint; ++i) {
                int numRepaints = dis.readUnsignedByte();
                this.tilesRepaint[i] = new short[numRepaints];
                for (int j2 = 0; j2 < numRepaints; ++j2) {
                    this.tilesRepaint[i][j2] = (short)dis.readUnsignedShort();
                }
            }
            int numObjects = dis.readUnsignedByte();
            this.listObjectsMap = new byte[numObjects][4];
            for (i = 0; i < numObjects; ++i) {
                this.listObjectsMap[i][0] = dis.readByte();
                this.listObjectsMap[i][1] = (byte)dis.readUnsignedByte();
                this.listObjectsMap[i][2] = (byte)dis.readUnsignedByte();
                this.listObjectsMap[i][3] = (byte)dis.readUnsignedByte();
                this.addObjectInMap(this.listObjectsMap[i][2], this.listObjectsMap[i][3], i);
            }
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void skipMaps(DataInputStream dis, int mapsToSkip) throws Exception {
        for (int m = 0; m < mapsToSkip; ++m) {
            int i;
            int mTiles = dis.readUnsignedByte() * dis.readUnsignedByte();
            int mGates = dis.readUnsignedByte() * 5;
            for (i = 0; i < mGates; ++i) {
                dis.readUnsignedByte();
            }
            for (i = 0; i < mTiles; ++i) {
                dis.readShort();
            }
            int mTilesRepaint = dis.readUnsignedByte();
            for (i = 0; i < mTilesRepaint; ++i) {
                int mNumRepaints = dis.readUnsignedByte();
                for (int j = 0; j < mNumRepaints; ++j) {
                    dis.readUnsignedShort();
                }
            }
            int mObjects = dis.readUnsignedByte() * 4;
            for (i = 0; i < mObjects; ++i) {
                dis.readByte();
            }
        }
    }

    public int getNumGates() {
        return this.gates.length / 5;
    }

    public int getGate(int numGate, int type) {
        return this.gates[numGate * 5 + type];
    }

    public void removeObjectInMap(int idList, boolean checkCollision) {
        byte idGroup = (byte)(this.listObjectsMap[idList][0] & 0x7F);
        byte idObject = this.listObjectsMap[idList][1];
        for (int j = 0; j < this.mapHeight; ++j) {
            for (int i = 0; i < this.mapWidth; ++i) {
                int k;
                int lowPart = this.objectsMap[this.getCoordUniDim(i, j)] & 0xFF;
                int highPart = (this.objectsMap[this.getCoordUniDim(i, j)] & 0xFF00) >> 8;
                if ((lowPart >> 6 & 3) == 1 && (lowPart &= 0x3F) == idList) {
                    this.objectsMap[this.getCoordUniDim((int)i, (int)j)] = (short)(this.objectsMap[this.getCoordUniDim(i, j)] & 0xFF00);
                    if (checkCollision) {
                        for (k = 0; k < this.objectsCollision[idGroup][idObject].length; k += 2) {
                            this.setWalkable(i + this.objectsCollision[idGroup][idObject][k], j + this.objectsCollision[idGroup][idObject][k + 1], true);
                        }
                        this.setWalkable(i, j, true);
                    }
                }
                if ((highPart >> 6 & 3) != 1 || (highPart &= 0x3F) != idList) continue;
                int n = this.getCoordUniDim(i, j);
                this.objectsMap[n] = (short)(this.objectsMap[n] & 0xFF);
                if (!checkCollision) continue;
                for (k = 0; k < this.objectsCollision[idGroup][idObject].length; k += 2) {
                    this.setWalkable(i + this.objectsCollision[idGroup][idObject][k], j + this.objectsCollision[idGroup][idObject][k + 1], true);
                }
                this.setWalkable(i, j, true);
            }
        }
        this.listObjectsMap[idList][0] = -1;
        this.listObjectsMap[idList][1] = -1;
    }

    private void addObjectInMap(int x, int y, int idList) {
        int exist;
        int i;
        byte idGroup = (byte)(this.listObjectsMap[idList][0] & 0x7F);
        byte idObject = this.listObjectsMap[idList][1];
        for (i = 0; i < this.objectsRepaint[idGroup][idObject].length; i += 2) {
            byte xRepaint = this.objectsRepaint[idGroup][idObject][i];
            byte yRepaint = this.objectsRepaint[idGroup][idObject][i + 1];
            exist = this.existTile(x + xRepaint, y + yRepaint);
            if (exist == 0) {
                this.objectsMap[this.getCoordUniDim((int)(x + xRepaint), (int)(y + yRepaint))] = (short)(0xC0 | idList);
                continue;
            }
            if (exist == 1) {
                this.objectsMap[this.getCoordUniDim((int)(x + xRepaint), (int)(y + yRepaint))] = (short)((0xC0 | idList) << 8 | this.objectsMap[this.getCoordUniDim(x + xRepaint, y + yRepaint)]);
                continue;
            }
            if (exist != -1) continue;
            System.out.println("COLISION REPAINT EN: " + (x + xRepaint) + ", " + (y + yRepaint));
        }
        for (i = 0; i < this.objectsCollision[idGroup][idObject].length; i += 2) {
            byte xCollision = this.objectsCollision[idGroup][idObject][i];
            byte yCollision = this.objectsCollision[idGroup][idObject][i + 1];
            exist = this.existTile(x + xCollision, y + yCollision);
            if (exist == 0) {
                this.objectsMap[this.getCoordUniDim((int)(x + xCollision), (int)(y + yCollision))] = (short)(0x80 | idList);
            } else if (exist == 1) {
                this.objectsMap[this.getCoordUniDim((int)(x + xCollision), (int)(y + yCollision))] = (short)((0x80 | idList) << 8 | this.objectsMap[this.getCoordUniDim(x + xCollision, y + yCollision)]);
            } else if (exist == -1) {
                System.out.println("COLISION COLISION EN: " + (x + xCollision) + ", " + (y + yCollision));
            }
            if (exist == -1) continue;
            this.setWalkable(x + xCollision, y + yCollision, false);
        }
        if (!this.isObjectWalkable(idGroup, idObject)) {
            this.setWalkable(x, y, false);
        }
        if ((exist = this.existTile(x, y)) == 0) {
            this.objectsMap[this.getCoordUniDim((int)x, (int)y)] = (short)(0x40 | idList);
        } else if (exist == 1) {
            this.objectsMap[this.getCoordUniDim((int)x, (int)y)] = (short)((0x40 | idList) << 8 | this.objectsMap[this.getCoordUniDim(x, y)]);
        } else if (exist == -1) {
            System.out.println("COLISION OBJETO EN: " + x + ", " + y);
        }
    }

    private boolean isObjectFixed(int idGroup, int idObject) {
        return (this.objectsFixedWalkable[idGroup][idObject] & 1) == 1;
    }

    private boolean isObjectWalkable(int idGroup, int idObject) {
        return (this.objectsFixedWalkable[idGroup][idObject] >> 1 & 1) == 1;
    }

    private int existTile(int x, int y) {
        if (this.isTileInMap(x, y)) {
            int pos = this.getCoordUniDim(x, y);
            int small = this.objectsMap[pos] & 0xFF;
            int big = this.objectsMap[pos] >> 8 & 0xFF;
            if (small == 0) {
                return 0;
            }
            if (big == 0) {
                return 1;
            }
            return -1;
        }
        return -2;
    }

    private void setWalkable(int x, int y, boolean walkable) {
        if (this.isTileInMap(x, y) && this.map[this.getCoordUniDim(x, y)] != -1) {
            if (walkable) {
                int n = this.getCoordUniDim(x, y);
                this.map[n] = (short)(this.map[n] | 0x8000);
            } else {
                int n = this.getCoordUniDim(x, y);
                this.map[n] = (short)(this.map[n] & Short.MAX_VALUE);
            }
        }
    }

    public int getNumObjectsMap() {
        return this.listObjectsMap.length;
    }

    public int getFirstObjectRepaint(int tileX, int tileY) {
        if (this.isTileInMap(tileX, tileY)) {
            short object = (short)(this.objectsMap[this.getCoordUniDim(tileX, tileY)] & 0xFF);
            if (object >> 6 == 3) {
                return object & 0x3F;
            }
            return -1;
        }
        return -1;
    }

    public int getSecondObjectRepaint(int tileX, int tileY) {
        short object = (short)(this.objectsMap[this.getCoordUniDim(tileX, tileY)] >> 8 & 0xFF);
        if (object >> 6 == 3) {
            return object & 0x3F;
        }
        return -1;
    }

    public void paintObject(Graphics g, int idList, int xWorld, int yWorld, int minClipX, int minClipY, int maxClipX, int maxClipY) {
        byte idGroup = this.listObjectsMap[idList][0];
        byte idObject = this.listObjectsMap[idList][1];
        if (idGroup != -1 && idObject != -1) {
            int height;
            int width;
            int incy;
            int incx;
            boolean animObject;
            byte tileX = this.listObjectsMap[idList][2];
            byte tileY = this.listObjectsMap[idList][3];
            int x = xWorld + this.isoEngine.getWorldCoordinateXFromTile(tileX, tileY) - this.tileGapX;
            int y = yWorld + this.isoEngine.getWorldCoordinateYFromTile(tileX, tileY);
            y -= this.getHeightMapTile(tileX, tileY) * this.tileGapHeight;
            boolean bl = animObject = (idGroup & 0x80) >> 7 == 1;
            if (animObject) {
                idGroup = (byte)(idGroup & 0x7F);
                incx = this.animations[idGroup - this.numGroups].minX;
                incy = this.animations[idGroup - this.numGroups].minY;
                width = this.animations[idGroup - this.numGroups].getFrameWidth((int)idObject, System.currentTimeMillis());
                height = this.animations[idGroup - this.numGroups].getFrameHeight((int)idObject, System.currentTimeMillis());
            } else {
                incy = 0;
                incx = 0;
                width = this.objectsSpriteData[idGroup][(idObject << 2) + 2];
                height = this.objectsSpriteData[idGroup][(idObject << 2) + 3];
            }
            if (this.isObjectInScreen((x += this.objectsOffset[idGroup][(idObject << 1) + 0]) + incx, (y += this.objectsOffset[idGroup][(idObject << 1) + 1]) + incy, width, height)) {
                if (!animObject) {
                    g.setClip(x, y, width, height);
                    g.clipRect(minClipX, minClipY, maxClipX - minClipX, maxClipY - minClipY);
                    g.drawImage(this.imageObjects[idGroup], x - this.objectsSpriteData[idGroup][(idObject << 2) + 0], y - this.objectsSpriteData[idGroup][(idObject << 2) + 1], 20);
                } else {
                    this.animations[idGroup - this.numGroups].drawAnimation(g, idObject, System.currentTimeMillis(), x, y, true, 0);
                }
            }
        }
    }

    public int getIdListObject(int tileX, int tileY) {
        for (int i = 0; i < this.listObjectsMap.length; ++i) {
            if (this.listObjectsMap[i][2] != tileX || this.listObjectsMap[i][3] != tileY) continue;
            return i;
        }
        return -1;
    }

    public int getPropertyObject(int idList, int property) {
        return this.listObjectsMap[idList][property];
    }

    public void paintAnimation(Graphics g, int x, int y, int numFile, int numAnimation, boolean cyclical) {
        this.animations[numFile].drawAnimation(g, numAnimation, System.currentTimeMillis(), x, y, cyclical, 0);
    }

    public void paintObject(Graphics g, int idList, int xWorld, int yWorld) {
        byte idGroup = this.listObjectsMap[idList][0];
        byte idObject = this.listObjectsMap[idList][1];
        if (idGroup != -1 && idObject != -1) {
            int height;
            int width;
            int incy;
            int incx;
            boolean animObject;
            byte tileX = this.listObjectsMap[idList][2];
            byte tileY = this.listObjectsMap[idList][3];
            int x = xWorld + this.isoEngine.getWorldCoordinateXFromTile(tileX, tileY) - this.tileGapX;
            int y = yWorld + this.isoEngine.getWorldCoordinateYFromTile(tileX, tileY);
            y -= this.getHeightMapTile(tileX, tileY) * this.tileGapHeight;
            boolean bl = animObject = (idGroup & 0x80) >> 7 == 1;
            if (animObject) {
                idGroup = (byte)(idGroup & 0x7F);
                incx = this.animations[idGroup - this.numGroups].minX;
                incy = this.animations[idGroup - this.numGroups].minY;
                width = this.animations[idGroup - this.numGroups].getFrameWidth((int)idObject, System.currentTimeMillis());
                height = this.animations[idGroup - this.numGroups].getFrameHeight((int)idObject, System.currentTimeMillis());
            } else {
                incy = 0;
                incx = 0;
                width = this.objectsSpriteData[idGroup][(idObject << 2) + 2];
                height = this.objectsSpriteData[idGroup][(idObject << 2) + 3];
            }
            if (this.isObjectInScreen((x += this.objectsOffset[idGroup][(idObject << 1) + 0]) + incx, (y += this.objectsOffset[idGroup][(idObject << 1) + 1]) + incy, width, height)) {
                if (!animObject) {
                    g.setClip(x, y, (int)this.objectsSpriteData[idGroup][(idObject << 2) + 2], (int)this.objectsSpriteData[idGroup][(idObject << 2) + 3]);
                    g.drawImage(this.imageObjects[idGroup], x - this.objectsSpriteData[idGroup][(idObject << 2) + 0], y - this.objectsSpriteData[idGroup][(idObject << 2) + 1], 20);
                } else {
                    this.animations[idGroup - this.numGroups].drawAnimation(g, idObject, System.currentTimeMillis(), x, y, true, 0);
                }
                int indexRepaint = this.getIndexRepaint(tileX, tileY);
                if (indexRepaint != -1) {
                    this.isoEngine.paintRepaintsTile(g, indexRepaint, xWorld, yWorld, x, y, width, height);
                }
            }
        }
    }

    private boolean isObjectInScreen(int x, int y, int width, int height) {
        return this.isoEngine.collision(x, y, width, height, IsoEngine.CAMERA_GAP_X, IsoEngine.CAMERA_GAP_Y, IsoEngine.SCREEN_WIDTH, IsoEngine.SCREEN_HEIGHT);
    }

    public int getIndexRepaint(int tileX, int tileY) {
        return this.binarySearchIndexRepaint(this.getCoordUniDim(tileX, tileY), 0, this.tilesRepaint.length - 1);
    }

    public short[] getTilesRepaints(int index) {
        return this.tilesRepaint[index];
    }

    private int binarySearchIndexRepaint(int tile, int left, int right) {
        if (right < left) {
            return -1;
        }
        int mid = (left + right) / 2;
        if (this.tilesRepaint[mid][0] == tile) {
            return mid;
        }
        if (tile < this.tilesRepaint[mid][0]) {
            return this.binarySearchIndexRepaint(tile, left, mid - 1);
        }
        return this.binarySearchIndexRepaint(tile, mid + 1, right);
    }

    private void setTile(int x, int y, short compressedTile) {
        this.map[this.getCoordUniDim((int)x, (int)y)] = compressedTile;
    }

    private void setTile(int x, int y, int numTile, int numTileSet, int height, int numTilesRepaint, boolean walkable) {
        int posTile = this.getCoordUniDim(x, y);
        if (this.map[posTile] != -1) {
            this.map[posTile] = (short)((numTile & 0x1F) << 0);
            int n = posTile;
            this.map[n] = (short)(this.map[n] | (numTileSet & 7) << 5);
            int n2 = posTile;
            this.map[n2] = (short)(this.map[n2] | (numTilesRepaint & 7) << 8);
            int n3 = posTile;
            this.map[n3] = (short)(this.map[n3] | (height & 0xF) << 11);
            if (walkable) {
                int n4 = posTile;
                this.map[n4] = (short)(this.map[n4] | 0x8000);
            }
        }
    }

    public Image getTileSetImage(int numTileSet) {
        return this.images[numTileSet];
    }

    public int getSpriteDataTile(int numTile, int numTileSet, int typeData) {
        switch (typeData) {
            case 4: {
                return this.tilesWallsOffset[numTileSet][this.numWalls[numTileSet] * 2 + numTile * 2 + 4 - 4];
            }
            case 5: {
                return this.tilesWallsOffset[numTileSet][this.numWalls[numTileSet] * 2 + numTile * 2 + 5 - 4];
            }
        }
        return this.tilesWallsSpriteData[numTileSet][this.numWalls[numTileSet] * 4 + numTile * 4 + typeData];
    }

    public int getSpriteDataWall(int numWall, int numTileSet, int typeData) {
        switch (typeData) {
            case 4: {
                return this.tilesWallsOffset[numTileSet][numWall * 2 + 4 - 4];
            }
            case 5: {
                return this.tilesWallsOffset[numTileSet][numWall * 2 + 5 - 4];
            }
        }
        return this.tilesWallsSpriteData[numTileSet][numWall * 4 + typeData];
    }

    public short getCompressedTile(int x, int y) {
        return this.map[this.getCoordUniDim(x, y)];
    }

    private int getCoordUniDim(int x, int y) {
        return y * this.mapWidth + x;
    }

    public int getNumWall(int x, int y) {
        int numTileSet = this.getNumTileSet(x, y);
        int numTile = this.getNumTile(x, y);
        return this.tilesIndexWall[this.getNumTileSet(x, y)][this.getNumTile(x, y)];
    }

    public short getTile(int x, int y) {
        return this.map[this.getCoordUniDim(x, y)];
    }

    public int getNumTile(int x, int y) {
        return this.map[this.getCoordUniDim(x, y)] >> 0 & 0x1F;
    }

    public int getNumTileSet(int x, int y) {
        return this.map[this.getCoordUniDim(x, y)] >> 5 & 7;
    }

    public int getHeightMapTile(int x, int y) {
        return this.map[this.getCoordUniDim(x, y)] >> 11 & 0xF;
    }

    public int getNumTilesRepaint(int x, int y) {
        return this.map[this.getCoordUniDim(x, y)] >> 8 & 7;
    }

    public boolean getWalkableTile(int x, int y) {
        return (this.map[this.getCoordUniDim(x, y)] >> 15 & 1) == 1;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileGapX() {
        return this.tileGapX;
    }

    public int getTileGapY() {
        return this.tileGapY;
    }

    public int getTileGapHeight() {
        return this.tileGapHeight;
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    public boolean isTileInMap(int tileX, int tileY) {
        return tileX >= 0 && tileY >= 0 && tileX < this.mapWidth && tileY < this.mapHeight;
    }

    public boolean isFurby(int idList) {
        return this.getNumFurbyFromObject(idList) != -1;
    }

    public int getNumFurbyFromObject(int idList) {
        boolean animObject;
        int idGroup = this.listObjectsMap[idList][0];
        byte idObject = this.listObjectsMap[idList][1];
        boolean bl = animObject = (idGroup & 0x80) >> 7 == 1;
        if (animObject) {
            idGroup = (byte)(idGroup & 0x7F) - this.numGroups;
            for (int i = 0; i < this.furbyFriends.length; i += 2) {
                if (idGroup != this.furbyFriends[i] || idObject != this.furbyFriends[i + 1]) continue;
                return i / 2;
            }
        }
        return -1;
    }

    public boolean isItemRock(int idList) {
        int idGroup = this.listObjectsMap[idList][0];
        byte idObject = this.listObjectsMap[idList][1];
        if ((idGroup & 0x80) >> 7 == 1) {
            idGroup = (byte)(idGroup & 0x7F) - this.numGroups;
            for (int i = 0; i < this.rocksItems.length; i += 2) {
                if (idGroup != this.rocksItems[i] || idObject != this.rocksItems[i + 1]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isItemShell(int idList) {
        int idGroup = this.listObjectsMap[idList][0];
        byte idObject = this.listObjectsMap[idList][1];
        if ((idGroup & 0x80) >> 7 == 1) {
            idGroup = (byte)(idGroup & 0x7F) - this.numGroups;
            for (int i = 0; i < this.shellsItems.length; i += 2) {
                if (idGroup != this.shellsItems[i] || idObject != this.shellsItems[i + 1]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isItemPlant(int idList) {
        int idGroup = this.listObjectsMap[idList][0];
        byte idObject = this.listObjectsMap[idList][1];
        if ((idGroup & 0x80) >> 7 == 1) {
            idGroup = (byte)(idGroup & 0x7F) - this.numGroups;
            for (int i = 0; i < this.plantItems.length; i += 2) {
                if (idGroup != this.plantItems[i] || idObject != this.plantItems[i + 1]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isItemWood(int idList) {
        int idGroup = this.listObjectsMap[idList][0];
        byte idObject = this.listObjectsMap[idList][1];
        if ((idGroup & 0x80) >> 7 == 1) {
            idGroup = (byte)(idGroup & 0x7F) - this.numGroups;
            for (int i = 0; i < this.woodItems.length; i += 2) {
                if (idGroup != this.woodItems[i] || idObject != this.woodItems[i + 1]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isItemToFish(int idList) {
        boolean animObject;
        int idGroup = this.listObjectsMap[idList][0];
        byte idObject = this.listObjectsMap[idList][1];
        boolean bl = animObject = (idGroup & 0x80) >> 7 == 1;
        return animObject && (idGroup = (byte)(idGroup & 0x7F) - this.numGroups) == 6 && idObject == 0;
    }

    public int isObjectInMap(int item) {
        byte idGroup = 0;
        byte idObject = 0;
        switch (item) {
            case 82: {
                idGroup = 7;
                idObject = 8;
                break;
            }
            case 20: {
                idGroup = 8;
                idObject = 4;
                break;
            }
            case 28: {
                idGroup = 8;
                idObject = 5;
                break;
            }
            case 23: {
                idGroup = 7;
                idObject = 3;
                break;
            }
            case 24: {
                idGroup = 7;
                idObject = 4;
                break;
            }
            default: {
                return -1;
            }
        }
        for (int i = 0; i < this.listObjectsMap.length; ++i) {
            if (this.listObjectsMap[i][0] != idGroup || this.listObjectsMap[i][1] != idObject) continue;
            return i;
        }
        return -1;
    }

    public void replaceObjectInMap(int objectIndex, byte newIdGroup, byte newIdObject) {
        this.listObjectsMap[objectIndex][0] = newIdGroup;
        this.listObjectsMap[objectIndex][1] = newIdObject;
    }
}

