/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.furby;

import com.lemonquest.furby.Inventory;
import com.lemonquest.utils.SSFunctions;
import com.lemonquest.utils.SSResourceManager;
import java.util.Random;
import java.util.Vector;

public class Items {
    public static final int TIME_RESPAWN_ITEMS = 10000;
    private Vector itemsRecolected;
    public static final int TYPE_MATERIAL = 0;
    public static final int TYPE_MANUFACTURE = 1;
    public static final int TYPE_ICON = 2;
    public static final int TYPE_MIN = 0;
    public static final int TYPE_MAX = 1;
    public static final int MAT_NUM_CATEGORIES = 9;
    public static final int MAT_NUM_ITEMS = 45;
    public static final int MAT_INDEX_CATEGORIES = 0;
    public static final int MAT_INDEX_ITEMS = 9;
    public static final int MAT_PERCENT_SELL = 60;
    private byte[] itemsMaterialsPrice = new byte[]{1, 2, 3, 4, 5, 1, 2, 3, 4, 5, 1, 2, 3, 4, 5, 1, 2, 3, 4, 5, 1, 2, 3, 4, 5, 2, 4, 6, 8, 10, 2, 4, 6, 8, 10, 32, 48, 80, 64, 80, 48, 32, 48, 64, 32, 0};
    private byte[] itemsMaterialsAnim = new byte[]{0, 0, 0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 7, 19, 6, 7, 8, 8, 8, 8, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 19, 19, 19, 19, 6, 19, 19, 6, 19, 38};
    public static final int CAT_CONCHAS = 0;
    public static final int CAT_GEOLOGY = 1;
    public static final int CAT_FISH = 2;
    public static final int CAT_PLANT = 3;
    public static final int CAT_CHOP = 4;
    public static final int CAT_JARDINERIA = 5;
    public static final int CAT_TOOLS = 6;
    public static final int CAT_FURNITURE = 7;
    public static final int CAT_ORNAMENT = 8;
    public static final int CAT_MEAL = 9;
    public static final int CAT_OTHERS = 10;
    public static final int MANUF_NUM_CATEGORIES = 10;
    public static final int MANUF_NUM_ITEMS = 90;
    public static final int MANUF_INDEX_CATEGORRIES = 0;
    public static final int MANUF_INDEX_ITEMS = 10;
    public static final int MANUF_INDEX_ITEMS_CAT_0 = 10;
    public static final int MANUF_INDEX_ITEMS_CAT_1 = 13;
    public static final int MANUF_INDEX_ITEMS_CAT_2 = 16;
    public static final int MANUF_INDEX_ITEMS_CAT_3 = 19;
    public static final int MANUF_INDEX_ITEMS_CAT_4 = 22;
    public static final int MANUF_INDEX_ITEMS_CAT_5 = 25;
    public static final int MANUF_INDEX_ITEMS_CAT_6 = 49;
    public static final int MANUF_INDEX_ITEMS_CAT_7 = 64;
    public static final int MANUF_INDEX_ITEMS_CAT_8 = 89;
    public static final int MANUF_INDEX_ITEMS_CAT_9 = 97;
    private byte[] itemsManufacturesPrice = new byte[]{5, 14, 22, 3, 12, 19, 2, 12, 18, 6, 12, 23, 3, 12, 18, 9, 19, 33, 54, 12, 20, 35, 48, 8, 20, 32, 50, 9, 16, 28, 52, 12, 24, 29, 50, 7, 12, 25, 51, 15, 28, 36, 52, 8, 22, 35, 53, 10, 22, 34, 60, 15, 25, 30, 7, 7, 20, 18, 17, 10, 19, 18, 20, 19, 22, 29, 7, 12, 11, 11, 16, 23, 16, 16, 23, 30, 27, 21};
    private static int STORE_LIMIT_MATERIALES = 20;
    private short[] itemsStore = new short[]{35, 2, 40, 3, 36, 3, 37, 5, 43, 4, 38, 4, 39, 5, 41, 2, 42, 3, 44, 2, 25, 4, 26, 8, 27, 12, 28, 16, 29, 20, 30, 4, 31, 8, 32, 12, 33, 16, 34, 20, 3, 10, 78, 100, 79, 250, 80, 450, 81, 750, 82, 100, 83, 250, 84, 450, 85, 750, 86, 750, 87, 100, 88, 250, 89, 450, 90, 500};
    public static final int ITEM_ALMEJA = 0;
    public static final int ITEM_VIEIRA = 1;
    public static final int ITEM_OSTRA = 2;
    public static final int ITEM_CONCHA_REINA = 3;
    public static final int ITEM_CARACOLA = 4;
    public static final int ITEM_CANTO_RODADO = 5;
    public static final int ITEM_CUARZO = 6;
    public static final int ITEM_BASALTO = 7;
    public static final int ITEM_CRISTAL_DE_ROCA = 8;
    public static final int ITEM_PIEDRA_DE_LUNA = 9;
    public static final int ITEM_SARDINA = 10;
    public static final int ITEM_MERLUZA = 11;
    public static final int ITEM_LUBINA = 12;
    public static final int ITEM_TRUCHA = 13;
    public static final int ITEM_SALMON = 14;
    public static final int ITEM_PEREJIL = 15;
    public static final int ITEM_CANELA = 16;
    public static final int ITEM_LAUREL = 17;
    public static final int ITEM_MENTA = 18;
    public static final int ITEM_OREGANO = 19;
    public static final int ITEM_BAMBU = 20;
    public static final int ITEM_PINO = 21;
    public static final int ITEM_ROBLE = 22;
    public static final int ITEM_NOGAL = 23;
    public static final int ITEM_EBANO = 24;
    public static final int ITEM_PATATA = 25;
    public static final int ITEM_SANDIA = 26;
    public static final int ITEM_ZANAHORIA = 27;
    public static final int ITEM_FRESA = 28;
    public static final int ITEM_LECHUGA = 29;
    public static final int ITEM_NARANJA = 30;
    public static final int ITEM_PIMIENTO = 31;
    public static final int ITEM_MANZANA = 32;
    public static final int ITEM_TOMATE = 33;
    public static final int ITEM_KIWI = 34;
    public static final int ITEM_CLAVOS = 35;
    public static final int ITEM_CUERDA = 36;
    public static final int ITEM_CUERO = 37;
    public static final int ITEM_METAL = 38;
    public static final int ITEM_TELA = 39;
    public static final int ITEM_ACEITE = 40;
    public static final int ITEM_AZUCAR = 41;
    public static final int ITEM_HARINA = 42;
    public static final int ITEM_LECHE = 43;
    public static final int ITEM_SAL = 44;
    public static final int ITEM_PACKAGE_QUEST = 45;
    public static final int ITEM_CA\u00d1A_BAMBU = 0;
    public static final int ITEM_CA\u00d1A_MADERA = 1;
    public static final int ITEM_CA\u00d1A_FIBRA = 2;
    public static final int ITEM_HACHA_PIEDRA = 3;
    public static final int ITEM_HACHA_HIERRO = 4;
    public static final int ITEM_HACHA_ACERO = 5;
    public static final int ITEM_MARTILLO_MADERA = 6;
    public static final int ITEM_MARTILLO_HIERRO = 7;
    public static final int ITEM_MARTILLO_ACERO = 8;
    public static final int ITEM_PARRILLA = 9;
    public static final int ITEM_SARTEN = 10;
    public static final int ITEM_OLLA = 11;
    public static final int ITEM_AZADA_MADERA = 12;
    public static final int ITEM_AZADA_HIERRO = 13;
    public static final int ITEM_AZADA_ACERO = 14;
    public static final int ITEM_ARMARIO_SIMPLE = 15;
    public static final int ITEM_ARMARIO_ROPERO = 16;
    public static final int ITEM_ARMARIO_DOBLE = 17;
    public static final int ITEM_ARMARIO_LUJO = 18;
    public static final int ITEM_CAMASTRO = 19;
    public static final int ITEM_CAMA_SIMPLE = 20;
    public static final int ITEM_CAMA_DOBLE = 21;
    public static final int ITEM_CAMA_DOSEL = 22;
    public static final int ITEM_COCINA_LE\u00d1A = 23;
    public static final int ITEM_COCINA_GAS = 24;
    public static final int ITEM_COCINA_LUJO = 25;
    public static final int ITEM_COCINA_PROFESIONAL = 26;
    public static final int ITEM_MESILLA = 27;
    public static final int ITEM_MESA_COCINA = 28;
    public static final int ITEM_MESA_COMEDOR = 29;
    public static final int ITEM_MESA_FIESTA = 30;
    public static final int ITEM_SILLON = 31;
    public static final int ITEM_BUTACA = 32;
    public static final int ITEM_SOFA = 33;
    public static final int ITEM_SOFA_DOBLE = 34;
    public static final int ITEM_TABURETE = 35;
    public static final int ITEM_SILLA = 36;
    public static final int ITEM_MECEDORA = 37;
    public static final int ITEM_TRONO = 38;
    public static final int ITEM_ESTERA = 39;
    public static final int ITEM_ALFOMBRA = 40;
    public static final int ITEM_MOQUETA = 41;
    public static final int ITEM_TAPIZ = 42;
    public static final int ITEM_COLGANTE = 43;
    public static final int ITEM_COLLAR = 44;
    public static final int ITEM_MEDALLON = 45;
    public static final int ITEM_ATRAPASUE\u00d1OS = 46;
    public static final int ITEM_LIENZO = 47;
    public static final int ITEM_CUADRO = 48;
    public static final int ITEM_RETRATO = 49;
    public static final int ITEM_MURAL = 50;
    public static final int ITEM_BONGO = 51;
    public static final int ITEM_TAMBOR = 52;
    public static final int ITEM_TROMPETA = 53;
    public static final int ITEM_SARDINAS_ASADAS = 54;
    public static final int ITEM_PESCADO_REBOZADO = 55;
    public static final int ITEM_ENSALADA = 56;
    public static final int ITEM_TOMATES_RELLENOS = 57;
    public static final int ITEM_TRUCHA_RELLENA = 58;
    public static final int ITEM_PESCADO = 59;
    public static final int ITEM_ENSALADA_PATATA = 60;
    public static final int ITEM_PIMIENTOS_ASADOS = 61;
    public static final int ITEM_SALMON_HORNO = 62;
    public static final int ITEM_SOPA_PESCADO = 63;
    public static final int ITEM_SALMON_AHUMADO = 64;
    public static final int ITEM_CREMA_VERDURAS = 65;
    public static final int ITEM_ZUMO_NARANJA = 66;
    public static final int ITEM_TARTA_MANZANA = 67;
    public static final int ITEM_MANZANAS_ASADAS = 68;
    public static final int ITEM_MERMELADA_MANZANA = 69;
    public static final int ITEM_ZUMO_SANDIA = 70;
    public static final int ITEM_TARTA_FRESAS = 71;
    public static final int ITEM_BATIDO_FRESA = 72;
    public static final int ITEM_MERMELADA_FRESA = 73;
    public static final int ITEM_ZUMO_FRUTAS = 74;
    public static final int ITEM_TARTA_KIWI = 75;
    public static final int ITEM_MACEDONIA = 76;
    public static final int ITEM_MERMELADA_KIWI = 77;
    public static final int ITEM_NEVERA = 78;
    public static final int ITEM_FRIGORIFICO = 79;
    public static final int ITEM_FRIGORIFICO_GRANDE = 80;
    public static final int ITEM_FRIGORIFICO_LUJO = 81;
    public static final int ITEM_TV_PEQUE\u00d1A = 82;
    public static final int ITEM_TV_GRANDE = 83;
    public static final int ITEM_TV_PANORAMICA = 84;
    public static final int ITEM_TV_PLASMA = 85;
    public static final int ITEM_CONSOLA = 86;
    public static final int ITEM_PELOTA = 87;
    public static final int ITEM_FRISBEE = 88;
    public static final int ITEM_PALAS = 89;
    public static final int ITEM_GIFT = 90;
    public static final int ITEM_TV_PEQUE\u00d1A_IDGROUP = 7;
    public static final int ITEM_TV_PEQUE\u00d1A_IDOBJECT = 8;
    public static final int ITEM_TV_PLASMA_IDGROUP = 7;
    public static final int ITEM_TV_PLASMA_IDOBJECT = 6;
    public static final int ITEM_CAMA_SIMPLE_IDGROUP = 8;
    public static final int ITEM_CAMA_SIMPLE_IDOBJECT = 4;
    public static final int ITEM_CAMA_DOSEL_IDGROUP = 7;
    public static final int ITEM_CAMA_DOSEL_IDOBJECT = 1;
    public static final int ITEM_COCINA_LE\u00d1A_IDGROUP = 7;
    public static final int ITEM_COCINA_LE\u00d1A_IDOBJECT = 3;
    public static final int ITEM_COCINA_GAS_IDGROUP = 7;
    public static final int ITEM_COCINA_GAS_IDOBJECT = 4;
    public static final int ITEM_COCINA_LUJO_IDGROUP = 7;
    public static final int ITEM_COCINA_LUJO_IDOBJECT = 5;
    public static final int ITEM_MESA_COCINA_IDGROUP = 8;
    public static final int ITEM_MESA_COCINA_IDOBJECT = 5;
    public static final int ITEM_MESA_FIESTA_IDGROUP = 8;
    public static final int ITEM_MESA_FIESTA_IDOBJECT = 6;
    private byte[] itemsManufacturesAnim = new byte[]{38, 38, 38, 20, 20, 20, 21, 22, 23, 24, 25, 26, 27, 28, 28, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 29, 29, 29, 30, 38, 38, 38, 38, 38, 38, 38, 4, 5, 13, 17, 5, 4, 13, 15, 31, 32, 31, 32, 7, 31, 16, 7, 7, 31, 7, 7, 7, 31, 31, 7, 38, 38, 38, 38, 38, 38, 38, 38, 34, 35, 36, 38, 38};
    private byte[][] itemsManufactureCost = new byte[][]{{20, 36}, {86, 100}, {87, 100, 37}, {20, 5}, {85, 35, 38}, {86, 35, 102}, {20}, {21, 99, 38}, {22, 99, 102}, {20, 38}, {21, 102}, {23, -26}, {84}, {-107, 38}, {-106, 35, 38}, {-107, 35}, {-106, 23, 99}, {-41, 88, 99}, {-41, -40, 99, 73}, {85, 35, 39}, {-106, 35, 39}, {87, 88, 99, 103}, {68, -105, -104, -93, 100}, {-123, 38}, {5, -121, 102}, {-121, 72, -90}, {-57, 72, 88, -26}, {85, 99}, {85, 86, 99}, {-106, -105, 99}, {-105, -40, -93, 103}, {85, 99}, {86, 23, 35, 103}, {87, 24, 99, -92}, {-105, 88, -93, 36, -89}, {84, 21, 35}, {84, 85, 99}, {-42, 87, 99}, {9, -105, 88, 99, 100, 103}, {1, 6, 103}, {3, 8, 36, -89}, {67, 8, 100, -89}, {-122, -120, 73, -25}, {0, 1, 100}, {70, 72, 36, 37}, {2, 72, 9, 36, 37, 102}, {2, -124, 72, 73, 88, 36, 37}, {84, 35, 39}, {21, 86, 35, 103}, {86, 87, 24, 35, 103}, {1, 2, -105, 88, 99, -89}, {86, 36, 37}, {86, 23, 36, 101}, {9, 99, 37, -26}, {10, 40, 44}, {15, 11, 42}, {15, 29, 33}, {27, 33, 40}, {13, 17, 27, 25}, {12, 15, 108}, {15, 25, 27, 33}, {17, 27, 31, 40}, {14, 19, 25, 31, 40}, {10, 11, 13, 17, 27}, {14, 17, 19, 31, 44}, {19, 27, 31, 33, 40}, {94, 41}, {32, 41, 42}, {32, 16, 41}, {32, 105}, {90, 18, 41}, {92, 41, 42}, {16, 28, 41, 43}, {16, 28, 105}, {26, 18, 28, 30, 41}, {16, 98, 41, 42}, {18, 30, 32, 34, 41}, {34, 105, 16, 18}};
    private String[] itemsMaterials;
    private String[] itemsManufacture;
    private String[] itemsMaterialsDescription;
    private String[] itemsManufactureDescription;
    private SSResourceManager resManager;
    private Random random;

    public Items(SSResourceManager resManager) {
        this.resManager = resManager;
        this.random = new Random();
        this.random.setSeed(System.currentTimeMillis());
        this.itemsRecolected = new Vector();
        this.initItems();
    }

    private void initItems() {
        this.itemsMaterials = SSFunctions.loadLangUnicode(this.resManager.getResourceAsStream("im.dat"), 55);
        this.itemsMaterialsDescription = SSFunctions.loadLangUnicode(this.resManager.getResourceAsStream("imdesc.dat"), 46);
        this.itemsManufacture = SSFunctions.loadLangUnicode(this.resManager.getResourceAsStream("imf.dat"), 101);
        this.itemsManufactureDescription = SSFunctions.loadLangUnicode(this.resManager.getResourceAsStream("imfdesc.dat"), 91);
    }

    public boolean isCraftable(int numItem, Inventory inventory) {
        for (int i = 0; i < this.getNumItemsCostManufactureItem(numItem); ++i) {
            if (inventory.isItemInInventory(0, this.getNumItemCost(numItem, i), this.getStackItemCost(numItem, i))) continue;
            return false;
        }
        return true;
    }

    public int getNumItemsManufacture() {
        return this.itemsManufactureCost.length;
    }

    public int getNumItemsCostManufactureItem(int numItem) {
        return this.itemsManufactureCost[numItem % this.itemsManufactureCost.length].length;
    }

    public int getStackItemCost(int numItem, int numCost) {
        return (this.itemsManufactureCost[numItem % this.itemsManufactureCost.length][numCost] >> 6 & 3) + 1;
    }

    public int getNumItemCost(int numItem, int numCost) {
        return this.itemsManufactureCost[numItem % this.itemsManufactureCost.length][numCost] & 0x3F;
    }

    public int getItemStoreNumItems() {
        return this.itemsStore.length >> 1;
    }

    public int getItemStoreType(int numItem) {
        if (numItem < STORE_LIMIT_MATERIALES) {
            return 0;
        }
        return 1;
    }

    public int getItemStoreNumItem(int numItem) {
        return this.itemsStore[(numItem << 1) + 0];
    }

    public String getItemStoreName(int numItem) {
        if (numItem < STORE_LIMIT_MATERIALES) {
            return this.getNameItem(0, this.itemsStore[(numItem << 1) + 0]);
        }
        return this.getNameItem(1, this.itemsStore[(numItem << 1) + 0]);
    }

    public int getItemStorePrice(int numItem) {
        return this.itemsStore[(numItem << 1) + 1];
    }

    public int getCategory(int typeItem, int numItem) {
        if (typeItem == 0) {
            if (numItem <= 4) {
                return 0;
            }
            if (numItem <= 9) {
                return 1;
            }
            if (numItem <= 14) {
                return 2;
            }
            if (numItem <= 19) {
                return 3;
            }
            if (numItem <= 24) {
                return 4;
            }
            if (numItem <= 34) {
                return 5;
            }
            return 10;
        }
        if (numItem <= 14) {
            return 6;
        }
        if (numItem <= 38) {
            return 7;
        }
        if (numItem <= 53) {
            return 8;
        }
        if (numItem <= 77) {
            return 9;
        }
        return 10;
    }

    public int isGoodItemToFurby(int numFurby, int typeItem, int numItem) {
        if (typeItem == 1) {
            if (numItem == 90) {
                return 5;
            }
            if (numItem == 46) {
                return 10;
            }
        }
        int cat = this.getCategory(typeItem, numItem);
        switch (numFurby) {
            case 0: {
                switch (cat) {
                    case 2: {
                        return -2;
                    }
                    case 8: {
                        return 2;
                    }
                    case 9: {
                        return 1;
                    }
                }
            }
            case 10: {
                switch (cat) {
                    case 1: {
                        return -2;
                    }
                    case 4: {
                        return 1;
                    }
                    case 7: {
                        return 2;
                    }
                }
            }
            case 1: {
                switch (cat) {
                    case 3: {
                        return 1;
                    }
                    case 8: {
                        return -2;
                    }
                    case 9: {
                        return 2;
                    }
                }
            }
            case 11: {
                switch (cat) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 1;
                    }
                    case 5: {
                        return -2;
                    }
                }
            }
            case 7: {
                switch (cat) {
                    case 0: {
                        return -2;
                    }
                    case 2: {
                        return 1;
                    }
                    case 9: {
                        return 2;
                    }
                }
            }
            case 2: {
                switch (cat) {
                    case 7: {
                        return -2;
                    }
                    case 8: {
                        return 1;
                    }
                    case 10: {
                        return 2;
                    }
                }
            }
            case 4: {
                switch (cat) {
                    case 3: {
                        return 1;
                    }
                    case 5: {
                        return 2;
                    }
                    case 10: {
                        return -2;
                    }
                }
            }
            case 3: {
                switch (cat) {
                    case 3: {
                        return 2;
                    }
                    case 4: {
                        return -2;
                    }
                    case 5: {
                        return 1;
                    }
                }
            }
            case 5: {
                switch (cat) {
                    case 0: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return -2;
                    }
                }
            }
            case 6: {
                switch (cat) {
                    case 1: {
                        return 2;
                    }
                    case 7: {
                        return 1;
                    }
                    case 10: {
                        return -2;
                    }
                }
            }
            case 9: {
                switch (cat) {
                    case 7: {
                        return 2;
                    }
                    case 9: {
                        return -2;
                    }
                    case 10: {
                        return 1;
                    }
                }
            }
            case 8: {
                switch (cat) {
                    case 4: {
                        return 2;
                    }
                    case 8: {
                        return 1;
                    }
                    case 5: {
                        return -2;
                    }
                }
            }
        }
        return 0;
    }

    public void addItemRecolected(int numMap, int idObjectList, long time) {
        this.itemsRecolected.addElement(new ItemRecolected(numMap, idObjectList, time));
    }

    public boolean isItemRecolected(int numMap, int idObjectList, long timeActual) {
        for (int i = 0; i < this.itemsRecolected.size(); ++i) {
            ItemRecolected ir = (ItemRecolected)this.itemsRecolected.elementAt(i);
            if (ir.numMap != numMap || ir.idObjectList != idObjectList) continue;
            if (timeActual < ir.timeRecolected) {
                return true;
            }
            this.itemsRecolected.removeElementAt(i);
            --i;
        }
        return false;
    }

    public boolean isEdibleItem(int typeItem, int numItem) {
        return this.getCategory(typeItem, numItem) == 9 || this.getCategory(typeItem, numItem) == 5;
    }

    public int getLevelItem(int typeItem, int numItem) {
        if (typeItem == 0) {
            return numItem % 5 + 1;
        }
        int cat = this.getCategory(typeItem, numItem);
        switch (cat) {
            case 6: {
                return numItem % 3 + 1;
            }
            case 7: {
                return (numItem - 15) % 4 + 1;
            }
            case 8: {
                return (numItem - 39) % 4 + 1;
            }
            case 9: {
                return (numItem - 54) % 4 + 2;
            }
        }
        return 1;
    }

    public int getBuyPrice(int typeItem, int numItem) {
        for (int i = 0; i < this.itemsStore.length / 2; ++i) {
            if (this.getItemStoreNumItem(i) != numItem) continue;
            return this.getItemStorePrice(i);
        }
        return 0;
    }

    public int getSellPrice(int typeItem, int numItem) {
        int buyPrice = this.getBuyPrice(typeItem, numItem);
        if (buyPrice > 0) {
            return (buyPrice = buyPrice * 60 / 100) <= 0 ? 1 : buyPrice;
        }
        if (typeItem == 0) {
            return this.itemsMaterialsPrice[numItem];
        }
        return this.itemsManufacturesPrice[numItem];
    }

    public String getNameItem(int typeItem, int numItem) {
        if (typeItem == 0) {
            return this.itemsMaterials[numItem + 9];
        }
        return this.itemsManufacture[numItem + 10];
    }

    public String getDescriptionItem(int typeItem, int numItem) {
        if (typeItem == 0) {
            return this.itemsMaterialsDescription[numItem];
        }
        return this.itemsManufactureDescription[numItem];
    }

    public int getNumAnimItem(int typeItem, int numItem) {
        if (typeItem == 0) {
            return this.itemsMaterialsAnim[numItem];
        }
        return this.itemsManufacturesAnim[numItem];
    }

    public int getFishItem(int numMap) {
        switch (numMap) {
            case 5: {
                if (this.hitPercent(50)) {
                    return 10;
                }
                return 11;
            }
            case 1: {
                return 12;
            }
            case 6: {
                return 13;
            }
            case 2: {
                return 14;
            }
        }
        return 10;
    }

    public int getRockItem(int numMap) {
        switch (numMap) {
            case 1: {
                if (this.hitPercent(70)) {
                    return 6;
                }
                return 7;
            }
            case 6: {
                return 8;
            }
            case 2: {
                return 9;
            }
        }
        return 5;
    }

    public int getShellItem(int numMap) {
        switch (numMap) {
            case 1: {
                if (this.hitPercent(60)) {
                    return 2;
                }
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        if (this.hitPercent(50)) {
            return 0;
        }
        return 1;
    }

    public int getPlantItem(int numMap) {
        switch (numMap) {
            case 4: {
                if (this.hitPercent(80)) {
                    return 17;
                }
                return 18;
            }
            case 6: {
                return 19;
            }
        }
        if (this.hitPercent(80)) {
            return 15;
        }
        return 16;
    }

    public int getWoodItem(int numMap) {
        switch (numMap) {
            case 4: {
                if (this.hitPercent(60)) {
                    return 23;
                }
                return 24;
            }
            case 0: {
                return 21;
            }
            case 1: {
                return 22;
            }
        }
        return 20;
    }

    public int getFishLevel(int numMap, int minMax) {
        switch (numMap) {
            case 5: {
                return minMax == 0 ? 1 : 2;
            }
            case 1: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 2: {
                return 5;
            }
        }
        return 1;
    }

    public int getRockLevel(int numMap, int minMax) {
        switch (numMap) {
            case 1: {
                return minMax == 0 ? 2 : 3;
            }
            case 6: {
                return 4;
            }
            case 2: {
                return 5;
            }
        }
        return 1;
    }

    public int getShellLevel(int numMap, int minMax) {
        switch (numMap) {
            case 1: {
                return minMax == 0 ? 3 : 4;
            }
            case 4: {
                return 5;
            }
        }
        return minMax == 0 ? 1 : 2;
    }

    public int getPlantLevel(int numMap, int minMax) {
        switch (numMap) {
            case 4: {
                return minMax == 0 ? 3 : 4;
            }
            case 6: {
                return 5;
            }
        }
        return minMax == 0 ? 1 : 2;
    }

    public int getWoodLevel(int numMap, int minMax) {
        switch (numMap) {
            case 4: {
                return minMax == 0 ? 4 : 5;
            }
            case 0: {
                return minMax == 0 ? 2 : 3;
            }
        }
        return 1;
    }

    private boolean hitPercent(int percentMaxToHit) {
        return this.nextInt(100) <= percentMaxToHit;
    }

    private int nextInt(int max) {
        return Math.abs(this.random.nextInt()) % max;
    }

    public void destroy() {
        int i;
        for (i = 0; i < this.itemsMaterials.length; ++i) {
            this.itemsMaterials[i] = null;
        }
        this.itemsMaterialsPrice = null;
        for (i = 0; i < this.itemsManufacture.length; ++i) {
            this.itemsManufacture[i] = null;
        }
        this.itemsManufacturesPrice = null;
    }

    public void cheatShop() {
        this.itemsStore = new short[274];
        STORE_LIMIT_MATERIALES = 46;
        for (int i = 0; i < this.itemsStore.length; i += 2) {
            this.itemsStore[i] = i < STORE_LIMIT_MATERIALES * 2 ? (short)(i / 2) : (short)((i - STORE_LIMIT_MATERIALES * 2) / 2);
            this.itemsStore[i + 1] = 1;
        }
    }

    private class ItemRecolected {
        public int numMap;
        public int idObjectList;
        public long timeRecolected;

        public ItemRecolected(int numMap, int idObjectList, long timeRecolected) {
            this.numMap = numMap;
            this.idObjectList = idObjectList;
            this.timeRecolected = timeRecolected;
        }
    }
}

