/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.furby;

import com.lemonquest.utils.SSAnimation;
import javax.microedition.lcdui.Graphics;

public class Actor {
    public static final int DIRECTION_UP = 0;
    public static final int DIRECTION_LEFT = 1;
    public static final int DIRECTION_DOWN = 2;
    public static final int DIRECTION_RIGHT = 3;
    public static final int FURBY_ANIM_DOWN = 0;
    public static final int FURBY_ANIM_QUIET_DOWN = 0;
    public static final int FURBY_ANIM_RIGHT = 1;
    public static final int FURBY_ANIM_UP = 2;
    public static final int FURBY_ANIM_LEFT = 3;
    public static final int FURBY_ANIM_WHISTLE_DOWN = 4;
    public static final int FURBY_ANIM_WHISTLE_RIGHT = 5;
    public static final int FURBY_ANIM_UP_LEVEL = 6;
    public static final int FURBY_ANIM_SLEEP_DOWN = 7;
    public static final int FURBY_ANIM_SLEEP_UP = 8;
    public static final int FURBY_ANIM_FISH_RIGHT = 9;
    public static final int FURBY_ANIM_FISH2_RIGHT = 9;
    public static final int FURBY_ANIM_TAKE_DOWN = 10;
    public static final int FURBY_ANIM_TAKE_RIGHT = 11;
    public static final int FURBY_ANIM_HOP_UP = 12;
    private byte[] numAnimations;
    public String name;
    public int x;
    public int y;
    public int height;
    public int tileX;
    public int tileY;
    public int direction;
    public boolean stopped;
    public boolean depress;
    public int numAnimationForced;
    public int minX;
    public int minY;
    public int maxX;
    public int maxY;
    private SSAnimation animation;

    public Actor(String name, int x, int y, int direction, SSAnimation animation) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.direction = direction;
        this.animation = animation;
        this.numAnimationForced = -1;
        this.numAnimations = new byte[4];
        this.stopped = true;
    }

    public void setAnimationDirection(int direction, int numAnimation, boolean flipHorizontal) {
        this.numAnimations[direction] = (byte)(numAnimation & 0x7F);
        if (flipHorizontal) {
            int n = direction;
            this.numAnimations[n] = (byte)(this.numAnimations[n] | 0x80);
        }
    }

    public void setAnimationDirection(int direction, byte byteAnimation) {
        this.numAnimations[direction] = byteAnimation;
    }

    public void updateMaxClipping() {
        int numAnim = this.numAnimations[this.direction] & 0x7F;
        int flip = this.numAnimations[this.direction] >> 6 & 2;
        long time = this.stopped ? 0L : System.currentTimeMillis();
        int frame = this.animation.getFramePos(numAnim, time, true);
        this.animation.getFrameWidth(frame, flip);
        this.animation.getFrameHeight(frame, flip);
        this.minX = this.animation.minX;
        this.maxX = this.animation.maxX;
        this.minY = this.animation.minY;
        this.maxY = this.animation.maxY;
    }

    public int getHeight() {
        return Math.abs(this.maxY - this.minY);
    }

    public int getWidth() {
        return Math.abs(this.maxX - this.minX);
    }

    public void paint(Graphics g, int screenX, int screenY, int numAnim, long time, boolean cyclical) {
        this.animation.drawAnimation(g, numAnim, time, screenX, screenY, cyclical, 0);
    }

    public void paint(Graphics g, int rootX, int rootY) {
        int numAnim = this.numAnimations[this.direction] & 0x7F;
        int flip = this.numAnimations[this.direction] >> 6 & 2;
        if (this.numAnimationForced != -1) {
            numAnim = this.numAnimationForced;
        }
        long time = this.stopped ? 0L : System.currentTimeMillis();
        this.animation.drawAnimation(g, numAnim, time, this.x + rootX, this.y + rootY, true, flip);
    }

    public void setAnimation(SSAnimation animation) {
        this.animation = animation;
    }
}

