/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.furby;

import com.lemonquest.furby.Actor;
import com.lemonquest.furby.Map;
import com.lemonquest.utils.SSFunctions;
import com.lemonquest.utils.SSResourceManager;
import java.io.DataInputStream;

public class QuestManager {
    public static final int MAX_QUESTS = 49;
    public static final int TYPE_TALK = 1;
    public static final int TYPE_ITEM = 2;
    private String[] langQuests;
    private Actor playerActor;
    private int actualQuest;
    private short[][] requirements;
    public static final int REWARD_NONE = -1;
    public static final int REWARD_TYPE_MATERIAL = 0;
    public static final int REWARD_TYPE_MANUFACTURE = 1;
    public static final int REWARD_TYPE_SKILL = 2;
    public static final int REWARD_TYPE_MONEY = 3;
    private byte[] rewards = new byte[]{-1, -1, 1, 20, -1, -1, -1, -1, -1, -1, -123, 1, 1, 45, -1, -1, -1, -1, -123, 0, 10, 20, -1, -1, -1, -1, -64, 10, -64, 50, -1, -1, 65, 1, 65, 0, -1, -1, -123, 2, -1, -1, -1, -1, 65, 3, -1, -1, -64, 100, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -123, 6, -1, -1, -1, -1, -1, -1, -123, 4, -1, -1, 65, 90, 66, 90, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -123, 3, -1, -1, -1, -1, -64, -56};

    public QuestManager(Actor playerActor, SSResourceManager resManager) {
        this.initQuests(resManager);
        this.playerActor = playerActor;
        this.actualQuest = -1;
    }

    public int getRewardType(int numQuest) {
        if (this.rewards[numQuest << 1] == -1 && this.rewards[(numQuest << 1) + 1] == -1) {
            return -1;
        }
        return this.rewards[numQuest << 1] >> 6 & 3;
    }

    public int getRewardStack(int numQuest) {
        return this.rewards[numQuest << 1] & 0x3F;
    }

    public int getRewardItem(int numQuest) {
        return this.rewards[(numQuest << 1) + 1] & 0xFF;
    }

    public int getNumItemRequirement(int numQuest, int numRequirement) {
        return this.requirements[numQuest][numRequirement] & 0xFF;
    }

    public int getTypeRequirement(int numQuest, int numRequirement) {
        return (this.requirements[numQuest][numRequirement] & 0xC000) >> 14;
    }

    public int getSizeRequirement(int numQuest, int numRequirement) {
        return (this.requirements[numQuest][numRequirement] & 0x3F00) >> 8;
    }

    public int getNumRequirements(int numQuest) {
        return this.requirements[numQuest].length;
    }

    public int getRequirement(int numQuest, int numRequirement) {
        return this.requirements[numQuest][numRequirement];
    }

    public String getQuestName(int numQuest) {
        return this.langQuests[numQuest * 4 + 0];
    }

    public String getQuestDescription(int numQuest) {
        return this.langQuests[numQuest * 4 + 1];
    }

    public String getQuestLongText(int numQuest) {
        return this.langQuests[numQuest * 4 + 2];
    }

    public String getQuestRewardText(int numQuest) {
        return this.langQuests[numQuest * 4 + 3];
    }

    public int getActualQuest() {
        return this.actualQuest;
    }

    public void setActualQuest(int actualQuest) {
        this.actualQuest = actualQuest;
    }

    private void initQuests(SSResourceManager resManager) {
        this.langQuests = SSFunctions.loadLangUnicode(resManager.getResourceAsStream("quests.dat"), 196);
        for (int i = 0; i < this.langQuests.length; ++i) {
            for (int j = 0; j < Map.furbyFriendsName.length; j += 2) {
                this.langQuests[i] = SSFunctions.replace(this.langQuests[i], Map.furbyFriendsName[j], Map.furbyFriendsName[j + 1]);
            }
        }
        this.loadQuests(resManager);
    }

    private void loadQuests(SSResourceManager resManager) {
        try {
            DataInputStream dis = resManager.getResourceAsStream("q.qst");
            int numQuest = dis.readUnsignedByte();
            this.requirements = new short[numQuest][];
            for (int i = 0; i < numQuest; ++i) {
                short sFurby = dis.readShort();
                int numReq = dis.readUnsignedByte();
                this.requirements[i] = new short[numReq + 1];
                for (int j = 0; j < numReq; ++j) {
                    this.requirements[i][j + 1] = dis.readShort();
                }
                this.requirements[i][0] = sFurby;
            }
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Unable Load Quests");
        }
    }
}

