/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.furby;

import com.lemonquest.furby.Actor;
import com.lemonquest.furby.GameEngine;
import com.lemonquest.furby.IsoEngine;
import com.lemonquest.furby.Map;
import com.lemonquest.utils.SSAnimation;
import com.lemonquest.utils.SSFont;
import com.lemonquest.utils.SSFunctions;
import com.lemonquest.utils.SSResourceManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas {
    public static final int INTERFACE_INFO = 0;
    public static final int INTERFACE_INVENTORY = 1;
    public static final int INTERFACE_MAP = 2;
    public static final int INTERFACE_QUESTS = 3;
    public static final int INTERFACE_HANDCRAFT = 4;
    public static final int INTERFACE_MENU = 5;
    public static final int INTERFACE_STORE_BUY = 6;
    public static final int INTERFACE_STORE_SELL = 7;
    public static final int INTERFACE_DICTIONARY = 8;
    private GameEngine ge;
    public static final int TLOADING = 0;
    public static final int TSTART = 1;
    public static final int THELP = 2;
    public static final int TABOUT = 3;
    public static final int TEXIT = 4;
    public static final int TSOUND = 5;
    public static final int TON = 6;
    public static final int TOFF = 7;
    public static final int TSOUND_QUESTION = 8;
    public static final int THELPTEXT = 9;
    public static final int TABOUTTEXT = 10;
    public static final int TNEWGAME = 11;
    public static final int TCONTINUE = 12;
    public static final int TSKILLS = 13;
    public static final int TSTATUS = 14;
    public static final int TFURBY_NAME = 15;
    public static final int TGAME_TIME = 16;
    public static final int TBACK_TO_GAME = 17;
    public static final int TINTERFACE_NAME = 18;
    public static final int TINVENTORY = 19;
    public static final int TBUY = 24;
    public static final int TSELL = 25;
    public static final int TSHOP = 26;
    public static final int TSHELLS = 27;
    public static final int TGEOLOGY = 28;
    public static final int TFISHING = 29;
    public static final int TPLANT = 30;
    public static final int TCHOP = 31;
    public static final int THANDCRAFT = 32;
    public static final int TCOOKING = 33;
    public static final int TFRIENDSHIP = 34;
    public static final int TSLEEP = 35;
    public static final int THUNGER = 36;
    public static final int TFUN = 37;
    public static final int TFEATHERS = 38;
    public static final int TINVENTORY_SIZE = 39;
    public static final int TTASK_DETAILS = 40;
    public static final int TREQUIRED = 41;
    public static final int TTALK_WITH = 42;
    public static final int TQUEST_COMPLETED = 43;
    public static final int TNEW_QUEST = 44;
    public static final int TBUTTONS_NAME = 45;
    public static final int TMAPS_NAME = 55;
    public static final int TYOU_RECEIVED = 64;
    public static final int THOUR = 65;
    public static final int THOURS = 66;
    public static final int TDAY = 67;
    public static final int TDAYS = 68;
    public static final int TDESC_FURBYS = 69;
    public static final int TQUEST_NOT_COMPLETED = 81;
    public static final int TGIVE_ITEM_GOOD = 82;
    public static final int TGIVE_ITEM_BAD = 83;
    public static final int TPHRASES_FURBYS = 84;
    public static final int TPHRASES_GENERIC = 108;
    public static final int TBACK = 128;
    public static final int TPRICE = 129;
    public static final int TCREATE = 130;
    public static final int TNEED_ROD = 131;
    public static final int TNEED_HAMMER = 132;
    public static final int TNEED_STOVE = 133;
    public static final int TNEED_AXE = 134;
    public static final int TCANT_EAT = 135;
    public static final int TDONT_HAVE_LEVEL = 136;
    public static final int TNEED_BETTER_TOOL = 137;
    public static final int TLOCK_BEACH = 138;
    public static final int TLOCK_LAKE_CAVE = 139;
    public static final int TLOCK_WATERFALL = 140;
    public static final int TTUTORIAL = 141;
    public static final int TSAVE_AND_EXIT = 142;
    public static final int TNEW_FURNITURE = 143;
    public static final int TEMPTY_BAR_DREAM = 144;
    public static final int TEMPTY_BAR_HUNGRY = 145;
    public static final int TEMPTY_BAR_FUN = 146;
    public static final int TGROWUP = 147;
    public static final int TLEVELUP = 148;
    public static final int TWORD_NEW = 149;
    public static final int TWARLOCK_1 = 150;
    public static final int TWARLOCK_2 = 151;
    public static final int TWARLOCK_3 = 152;
    public static final int TWARLOCK_YES = 153;
    public static final int TWARLOCK_NO = 154;
    public static final int TWARLOCK_MAYBE = 155;
    public static final int TWARLOCK_4 = 156;
    public static final int TDICTIONARY = 157;
    public static final int TDICTIONARY_WORDS = 158;
    public static final int TTUTORIAL_TEXTS = 374;
    public static final int TINTRO_TEXT = 388;
    public static final int TMINIGAME_TEXT = 389;
    public static final int TINVENTORY_FULL = 390;
    public static final int TTEXT_PARTY = 391;
    public static final int TDONT_TAKE_IT = 392;
    public static final int TEND_GAME = 393;
    public static final int TDONT_LEVEL_CHOP = 394;
    public static final int TDONT_LEVEL_FISH = 395;
    public static final int TDONT_LEVEL_GATHER = 396;
    public static final int TDONT_LEVEL_PRACTICE = 397;
    public static final int TFALL_BAR_DREAM = 398;
    public static final int TFALL_BAR_HUNGRY = 399;
    public static final int TFALL_BAR_FUN = 400;
    public static final int TGETMOREGAMES = 401;
    public static final int TEXIT_GAME_QUESTION = 402;
    public static final int MAX_LINES = 403;
    public static final int MAX_TUTORIAL_TEXTS = 7;
    public static final int MAX_DICTIONARY_WORDS = 108;
    public static final int MAX_PHRASES_GENERIC = 20;
    public static final int MAX_PHRASES_FURBYS = 2;
    public static final int ICON_NO_ICON = -1;
    public static final int ICON_OK = 0;
    public static final int ICON_NO = 1;
    public static final int ICON_BACK = 2;
    public static final int ICON_SIZE = 8;
    public static final int RES_SPLASH = 0;
    public static final int RES_FONT_MENU = 1;
    public static final int RES_FONT_GAME = 2;
    public static final int RES_FONT_GAME_SMALL = 3;
    public static final int RES_COVER = 4;
    public static final int RES_MAP = 5;
    public static final int RES_FURBY = 6;
    public static final int RES_BUTTONS_INTERFACE = 7;
    public static final int RES_MAP_ISLAND = 8;
    public static final int RES_BAR_INTERFACE = 9;
    public static final int RES_INTERFACE_POINT = 10;
    public static final int RES_ICON_BARS = 11;
    public static final int RES_ICON_FEATHER = 12;
    public static final int RES_ITEMS_ICONS = 13;
    public static final int RES_INTERFACE_ARROWS = 14;
    public static final int RES_FURBY_BABY = 15;
    public static final int RES_POPUP_TILE = 16;
    public static final int RES_EXCLAMATION = 17;
    public static final int RES_TRAME = 18;
    public static final int RES_DUST = 19;
    public static final int RES_MENU_TITLE = 20;
    public static final int RES_MENU_GRASS = 21;
    public static final int RES_MENU_TREE_BIG = 22;
    public static final int RES_MENU_TREE_SMALL = 23;
    public static final int RES_SPLASH_HASBRO = 24;
    public static final int RES_ICONS_MENU = 25;
    public static final int RES_PARTY = 26;
    public static final int RES_MAX = 27;
    public static final int MENU_SCROLL_BAR_WIDTH = 10;
    public static final int BAR_DOWN_SKILLS_BARS_WIDTH = 12;
    public static final int BAR_DOWN_SKILLS_BARS_HEIGHT = 3;
    public static final int BAR_DOWN_SKILLS_BARS_GAP_Y = 3;
    public static final int BAR_DOWN_FIRST_BAR_X = 49;
    public static final int BAR_DOWN_FIRST_BAR_Y = 9;
    public static final int BAR_DOWN_TEXT_GAP_Y = 2;
    public static final int BAR_DOWN_MONEY_X = 14;
    public static final int INTERFACE_INVENTORY_ICON_SIZE = 14;
    public static final int INTERFACE_INVENTORY_ITEM_GAP_X = 2;
    public static final int ARROW_H_WIDTH = 7;
    public static final int ARROW_H_HEIGHT = 11;
    public static final int ARROW_V_WIDTH = 11;
    public static final int ARROW_V_HEIGHT = 7;
    public static final int ARROW_H_LEFT = 0;
    public static final int ARROW_H_RIGHT = 1;
    public static final int ARROW_V_UP = 2;
    public static final int ARROW_V_DOWN = 3;
    public static final int ARROW_TIME_FRAME_ANIMATION = 150;
    public static final int ARROW_NUM_FRAMES_ANIMATION = 4;
    public static final int INTERFACE_INFO_COLOR_1 = 6121784;
    public static final int INTERFACE_INFO_COLOR_2 = 7569481;
    public static final int INTERFACE_INFO_COLOR_3 = 9807453;
    public static final int INTERFACE_TALK_COLOR_1 = 0xFFFFFF;
    public static final int INTERFACE_TALK_COLOR_2 = 0x888888;
    public static final int INTERFACE_TALK_COLOR_3 = 6702942;
    public static final int SKILL_BAR_BASE_COLOR_1 = 14781347;
    public static final int SKILL_BAR_BASE_COLOR_2 = 13248090;
    public static final int SKILL_BAR_BASE_COLOR_3 = 6689582;
    public static final int SKILL_BAR_SLEEP_COLOR_1 = 16770190;
    public static final int SKILL_BAR_SLEEP_COLOR_2 = 16764973;
    public static final int SKILL_BAR_SLEEP_COLOR_3 = 8284182;
    public static final int SKILL_BAR_HUNGER_COLOR_1 = 16561540;
    public static final int SKILL_BAR_HUNGER_COLOR_2 = 16415503;
    public static final int SKILL_BAR_HUNGER_COLOR_3 = 8077318;
    public static final int SKILL_BAR_FUN_COLOR_1 = 14216191;
    public static final int SKILL_BAR_FUN_COLOR_2 = 12311807;
    public static final int SKILL_BAR_FUN_COLOR_3 = 6188414;
    public static final int INTERFACE_BORDER_COLOR_1 = 0;
    public static final int INTERFACE_BORDER_COLOR_2 = 9807727;
    public static final int INTERFACE_BORDER_COLOR_3 = 2965255;
    public static final int INTERFACE_BORDER_COLOR_4 = 0;
    public static final int INTERFACE_BORDER_SIZE = 4;
    public static final int INTERFACE_TOP_COLOR = 9195119;
    public static final int INTERFACE_BOTTOM_COLOR_1 = 6121784;
    public static final int INTERFACE_BOTTOM_COLOR_2 = 7304034;
    public static final int MINIGAME_BAR_HEIGHT = 5;
    public static final int MINIGAME_BAR_HEIGHT_1 = 3;
    public static final int MINIGAME_BAR_HEIGHT_2 = 2;
    public static final int MINIGAME_BAR_COLOR = 4538932;
    public static final int MINIGAME_BAR_COLOR_BORDER = 0xFFFFFF;
    public static final int MINIGAME_BAR_COLOR_BASE_1 = 0x838383;
    public static final int MINIGAME_BAR_COLOR_BASE_2 = 0x666666;
    public static final int MINIGAME_BAR_COLOR_MEDIUM_1 = 15836707;
    public static final int MINIGAME_BAR_COLOR_MEDIUM_2 = 12354075;
    public static final int MINIGAME_BAR_COLOR_HIGH_1 = 15808034;
    public static final int MINIGAME_BAR_COLOR_HIGH_2 = 12331547;
    public static final int MINIGAME_BAR_PIECE_COLOR = 11454006;
    public static final int WIDTH_POPUP = 128;
    public static int GAP_FURBY_X = 32;
    public static final int POPUP_TILE_SIZE = 14;
    public boolean bPanoramic;
    public SSFont fntMenu = null;
    public SSFont fntGame = null;
    public SSFont fntGameSmall = null;
    private Image cover = null;
    private Image mapIsland = null;
    private Image panoramic = null;
    private Image buttons = null;
    private Image barDown = null;
    private Image interfacePoints = null;
    private Image iconBars = null;
    private Image iconFeather = null;
    private Image arrows = null;
    private Image popupTile = null;
    private Image trame = null;
    private Image iconsMenu = null;
    public Image sign = null;
    public Image cloud = null;
    public Image logo = null;
    public SSAnimation furby = null;
    public SSAnimation items = null;
    public SSAnimation dust = null;
    public Map map;
    private int menuFrames = 0;
    public Image menuTreeBig = null;
    public Image menuTreeSmall = null;
    public Image menuGrass = null;
    public Image menuTitle = null;
    public int heightActor;
    private int stateLoading = 0;
    private int maxLoadResources = 0;
    public static final int BUTTON_MAX_RADIUS = 21;
    public static final int BUTTON_INC_RADIUS = 5;
    public static final int BUTTON_INC_ANGLE = 30;
    public static final int BUTTON_EYE = 0;
    public static final int BUTTON_TALK = 1;
    public static final int BUTTON_TRADE = 2;
    public static final int BUTTON_PLAY = 3;
    public static final int BUTTON_USE = 4;
    public static final int BUTTON_SLEEP = 5;
    public static final int BUTTON_GIVE = 6;
    public static final int BUTTON_INVENTORY = 7;
    public static final int BUTTON_CANCEL = 8;
    public static final int BUTTON_EAT = 9;
    public static final int MAX_BUTTONS = 10;
    private int buttonInterfaceWidth;
    private int buttonInterfaceHeight;
    public SSResourceManager resManager;
    public boolean pButtonsInterface;
    public int widthTalk;
    public int heightTalk;
    public static final int MAX_MODIFIERS = 7;
    private int[] modifiers;
    public static final int SKILLS_TIME = 1500;
    public long skillsTime = 0L;

    public GameCanvas(GameEngine ge) {
        this.ge = ge;
        this.modifiers = new int[28];
        this.resManager = new SSResourceManager();
    }

    public void resetModifiers() {
        for (int i = 0; i < this.modifiers.length; ++i) {
            this.modifiers[i] = 0;
        }
    }

    private int getModifierEmpty() {
        for (int i = 0; i < this.modifiers.length; i += 4) {
            if (this.modifiers[i + 3] != 0) continue;
            return i;
        }
        return -1;
    }

    public void addModifier(int x, int y, int typeItem, int numItem, int value, int life) {
        int posModifier = this.getModifierEmpty();
        if (posModifier != -1) {
            this.modifiers[posModifier + 0] = x;
            this.modifiers[posModifier + 1] = y;
            this.modifiers[posModifier + 2] = Integer.MIN_VALUE | (value < 0 ? 1 : 0) << 30 | (Math.abs(value) & 0xFF) << 16 | (typeItem & 0xFF) << 8 | numItem & 0xFF;
            this.modifiers[posModifier + 3] = life;
        }
    }

    public void addModifier(int x, int y, int value, int life) {
        int posModifier = this.getModifierEmpty();
        if (posModifier != -1) {
            this.modifiers[posModifier + 0] = x;
            this.modifiers[posModifier + 1] = y;
            this.modifiers[posModifier + 2] = value;
            this.modifiers[posModifier + 3] = life;
        }
    }

    public void processModifiers() {
        for (int i = 0; i < this.modifiers.length; i += 4) {
            if (this.modifiers[i + 3] <= 0) continue;
            if (this.modifiers[i + 3] > 20) {
                int n = i + 1;
                this.modifiers[n] = this.modifiers[n] - 1;
            }
            int n = i + 3;
            this.modifiers[n] = this.modifiers[n] - 1;
            break;
        }
    }

    private void paintModifiers(Graphics g, int x, int y) {
        int size = this.modifiers.length;
        for (int i = 0; i < size; i += 4) {
            if (this.modifiers[i + 3] <= 0) continue;
            this.paintModifier(g, x + this.modifiers[i + 0], y + this.modifiers[i + 1], this.modifiers[i + 2]);
            break;
        }
    }

    private void paintModifier(Graphics g, int x, int y, int value) {
        if ((value >> 31 & 1) > 0) {
            boolean negative = (value >> 30 & 1) == 1;
            int typeItem = value >> 8 & 0xFF;
            int numItem = value & 0xFF;
            int valueModifier = value >> 16 & 0xFF;
            String text = negative ? "-" + valueModifier + " X" : "+" + valueModifier + " X";
            this.fntGameSmall.drawString(g, text.toCharArray(), x - 7, y, 10);
            if (typeItem == 2) {
                this.paintIconBar(g, x - this.iconBars.getWidth() / 3 / 2, y - this.iconBars.getHeight() / 2, numItem);
            } else {
                this.items.drawAnimation(g, this.ge.items.getNumAnimItem(typeItem, numItem), 0L, x + 3, y, true, 0);
            }
        } else {
            StringBuffer sb = new StringBuffer();
            if (value > 0) {
                sb.append("+");
            }
            sb.append(value);
            this.fntGameSmall.drawString(g, sb.toString().toCharArray(), x, y, 33);
        }
    }

    public void setMaxLoadResources(int maxLoadResources) {
        this.maxLoadResources = maxLoadResources;
        this.stateLoading = 0;
    }

    public void loadPanoramic(int numMap) {
        String image;
        switch (numMap) {
            case 0: {
                image = "p1.png";
                break;
            }
            case 1: {
                image = "p2.png";
                break;
            }
            case 4: 
            case 5: {
                image = "p4.png";
                break;
            }
            case 7: {
                image = "p5.png";
                break;
            }
            default: {
                image = "p3.png";
            }
        }
        this.bPanoramic = false;
        this.panoramic = this.resManager.getImage(image);
        this.ge.repaint();
        this.ge.serviceRepaints();
        this.panoramic = null;
        System.gc();
        this.ge.sleep(150);
    }

    public void loadResource(int resource) {
        boolean resourceLoaded = false;
        switch (resource) {
            case 26: {
                this.cover = this.resManager.getImage("ending.png");
                break;
            }
            case 25: {
                this.iconsMenu = this.resManager.getImage("iconsMenu.png");
                break;
            }
            case 22: {
                this.menuTreeBig = this.resManager.getImage("menuTreeBig.png");
                break;
            }
            case 23: {
                this.menuTreeSmall = this.resManager.getImage("menuTreeSmall.png");
                break;
            }
            case 21: {
                this.menuGrass = this.resManager.getImage("menuGrass.png");
                break;
            }
            case 20: {
                this.menuTitle = this.resManager.getImage("menuTitle.png");
                break;
            }
            case 1: {
                this.fntMenu = new SSFont(this.resManager.getResourceAsStream("fontMenu.ssf"), null);
                break;
            }
            case 2: {
                this.fntGame = new SSFont(this.resManager.getResourceAsStream("fontGame.ssf"), new int[][]{{14613267}});
                break;
            }
            case 3: {
                this.fntGameSmall = this.fntGame;
                break;
            }
            case 0: {
                this.logo = this.resManager.getImage("lq.png");
                break;
            }
            case 24: {
                this.logo = this.resManager.getImage("logohasbro.png");
                break;
            }
            case 18: {
                this.trame = this.resManager.getImage("trame.png");
                break;
            }
            case 19: {
                this.dust = new SSAnimation(this.resManager.getResourceAsStream("polvo.lqa"));
                break;
            }
            case 4: {
                this.cover = this.resManager.getImage("cover.png");
                break;
            }
            case 7: {
                this.buttons = this.resManager.getImage("ibuttons.png");
                this.buttonInterfaceWidth = this.buttons.getWidth() / 10;
                this.buttonInterfaceHeight = this.buttons.getHeight() / 2;
                break;
            }
            case 17: {
                this.sign = this.resManager.getImage("sign.png");
                break;
            }
            case 16: {
                this.popupTile = this.resManager.getImage("popup.png");
                break;
            }
            case 8: {
                this.mapIsland = this.resManager.getImage("island.png");
                break;
            }
            case 10: {
                this.interfacePoints = this.resManager.getImage("points.png");
                break;
            }
            case 11: {
                this.iconBars = this.resManager.getImage("iconBars.png");
                break;
            }
            case 12: {
                this.iconFeather = this.resManager.getImage("feather.png");
                break;
            }
            case 9: {
                this.barDown = this.resManager.getImage("idown.png");
                break;
            }
            case 14: {
                this.arrows = this.resManager.getImage("arrows.png");
                break;
            }
            case 5: {
                this.map = new Map(this);
                break;
            }
            case 15: {
                this.furby = new SSAnimation(this.resManager.getResourceAsStream("bebe.lqa"));
                break;
            }
            case 6: {
                this.furby = new SSAnimation(this.resManager.getResourceAsStream("furby.lqa"));
                break;
            }
            case 13: {
                this.items = new SSAnimation(this.resManager.getResourceAsStream("items.lqa"));
            }
        }
        this.resourceLoaded();
    }

    public void resourceLoaded() {
        ++this.stateLoading;
        this.ge.repaint();
        this.ge.serviceRepaints();
    }

    public void unloadResource(int resource) {
        switch (resource) {
            case 25: {
                this.iconsMenu = null;
                break;
            }
            case 22: {
                this.menuTreeBig = null;
                break;
            }
            case 23: {
                this.menuTreeSmall = null;
                break;
            }
            case 21: {
                this.menuGrass = null;
                break;
            }
            case 20: {
                this.menuTitle = null;
                break;
            }
            case 1: {
                this.fntMenu = null;
                break;
            }
            case 2: {
                this.fntGame = null;
                break;
            }
            case 3: {
                this.fntGameSmall = null;
                break;
            }
            case 0: 
            case 24: {
                this.logo = null;
                break;
            }
            case 18: {
                this.trame = null;
                break;
            }
            case 19: {
                this.dust = null;
                break;
            }
            case 4: 
            case 26: {
                this.cover = null;
                break;
            }
            case 7: {
                this.buttons = null;
                break;
            }
            case 17: {
                this.sign = null;
                this.cloud = null;
                break;
            }
            case 16: {
                this.popupTile = null;
                break;
            }
            case 8: {
                this.mapIsland = null;
                break;
            }
            case 10: {
                this.interfacePoints = null;
                break;
            }
            case 11: {
                this.iconBars = null;
                break;
            }
            case 12: {
                this.iconFeather = null;
                break;
            }
            case 9: {
                this.barDown = null;
                break;
            }
            case 14: {
                this.arrows = null;
                break;
            }
            case 5: {
                this.map = null;
                break;
            }
            case 6: 
            case 15: {
                this.furby = null;
                break;
            }
            case 13: {
                this.items = null;
            }
        }
        System.gc();
        this.ge.repaint();
        this.ge.serviceRepaints();
    }

    public void paintCover(Graphics g) {
        this.resetClip(g);
        g.drawImage(this.cover, 64, 80, 3);
    }

    private void paintHandcraftBar(Graphics g, IsoEngine isoEngine) {
        int width = 32;
        int height = 3;
        int x = IsoEngine.CAMERA_GAP_X + isoEngine.rootInScreenX + this.ge.playerActor.x - (width >> 1);
        int y = IsoEngine.CAMERA_GAP_Y + isoEngine.rootInScreenY + this.ge.playerActor.y + this.heightActor;
        int percent = 100 - (int)((this.ge.timeFinish - this.ge.lastProcessTime) * 100L / (long)(this.ge.stateGame == 11 ? 10000 : 5000));
        this.paintSkillBar(g, x, y, width, height << 1, 100, 14781347, 13248090, 6689582);
        this.paintSkillBar(g, x, y, width, height << 1, percent, 16561540, 16415503, 8077318);
    }

    public void paintGameOver(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 128, 160);
    }

    public void paintGame(Graphics g, IsoEngine isoEngine) {
        isoEngine.paint(g);
        if (this.ge.stateGame == 12) {
            this.paintHandcraftBar(g, isoEngine);
        }
        if (this.ge.stateGame == 11) {
            this.paintHandcraftBar(g, isoEngine);
            this.dust.drawAnimation(g, 0, System.currentTimeMillis(), IsoEngine.CAMERA_GAP_X + isoEngine.rootInScreenX + this.ge.playerActor.x, IsoEngine.CAMERA_GAP_Y + isoEngine.rootInScreenY + this.ge.playerActor.y, true, 0);
        }
        this.paintModifiers(g, IsoEngine.CAMERA_GAP_X + isoEngine.rootInScreenX, IsoEngine.CAMERA_GAP_Y + isoEngine.rootInScreenY);
        this.paintDownBar(g, this.ge.playerMoney, this.ge.playerBars, this.ge.messageTextDown);
        if (this.ge.stateGame != 8) {
            this.paintArrow(g, 112, 146, 3, true);
        }
    }

    private void paintTrame(Graphics g, int x, int y, int width, int height) {
        g.setClip(x, y, width, height);
        for (int yImage = y; yImage < y + height; yImage += this.trame.getHeight()) {
            for (int xImage = x; xImage < x + width; xImage += this.trame.getWidth()) {
                g.drawImage(this.trame, xImage, yImage, 20);
            }
        }
    }

    public void paintPopup(Graphics g, String textPopup) {
        int widthPopup = 102;
        int heightPopup = this.fntGame.getFontHeight() * 11 + 28;
        int xPopup = (128 - widthPopup) / 2;
        int yPopup = (160 - heightPopup) / 2;
        this.paintBorderPopup(g, xPopup, yPopup, widthPopup, heightPopup);
        this.fntGame.drawString(g, textPopup.toCharArray(), xPopup + 14, yPopup + 14 + this.fntGame.getFontHeight(), widthPopup - 28, heightPopup - (14 + this.fntGame.getFontHeight()) * 2, 3);
        this.paintArrow(g, xPopup + widthPopup - 14 - 5, yPopup + heightPopup - 14 - 7, 3, true);
    }

    public void paintPopupGameOver(Graphics g, String textPopup, IsoEngine isoEngine) {
        int widthPopup = 102;
        int heightPopup = this.fntGame.getFontHeight() * 11 + 28;
        int xPopup = (128 - widthPopup) / 2;
        int yPopup = (160 - heightPopup) / 2;
        this.paintBorderPopup(g, xPopup, yPopup, widthPopup, heightPopup);
        isoEngine.paintFurby(g, 64, yPopup + 2);
        this.fntGame.drawString(g, textPopup.toCharArray(), xPopup + 14, yPopup + 14 + (this.fntGame.getFontHeight() + this.fntGame.getLineSpacing()) * 3, widthPopup - 28, heightPopup - (14 + this.fntGame.getFontHeight()) * 2, 17);
        this.paintArrow(g, xPopup + widthPopup - 14 - 5, yPopup + heightPopup - 14 - 7, 3, true);
    }

    private void paintBorderPopup(Graphics g, int x, int y, int width, int height) {
        int h;
        int w;
        int i;
        int widthHorizontal = width - 28;
        int heightVertical = height - 28;
        int widthTileHorizontal = this.popupTile.getWidth() - 28;
        int heightTileVertical = this.popupTile.getHeight() - 28;
        int x2 = x + 14;
        int y2 = y + height - 14;
        for (i = 0; i <= widthHorizontal / widthTileHorizontal; ++i) {
            w = x2 + widthTileHorizontal >= x + width - 14 ? x + width - 14 - x2 : widthTileHorizontal;
            g.setClip(x2, y, w, 14);
            g.drawImage(this.popupTile, x2 - 14, y, 20);
            g.setClip(x2, y2, w, 14);
            g.drawImage(this.popupTile, x2 - 14, y2 - (this.popupTile.getHeight() - 14), 20);
            x2 += widthTileHorizontal;
        }
        x2 = x + width - 14;
        y2 = y + 14;
        for (i = 0; i <= heightVertical / heightTileVertical; ++i) {
            h = y2 + heightTileVertical >= y + height - 14 ? y + height - 14 - y2 : heightTileVertical;
            g.setClip(x, y2, 14, h);
            g.drawImage(this.popupTile, x, y2 - 14, 20);
            g.setClip(x2, y2, 14, h);
            g.drawImage(this.popupTile, x2 - (this.popupTile.getWidth() - 14), y2 - 14, 20);
            y2 += heightTileVertical;
        }
        y2 = y + height - 14;
        g.setClip(x, y, 14, 14);
        g.drawImage(this.popupTile, x, y, 20);
        g.setClip(x, y2, 14, 14);
        g.drawImage(this.popupTile, x, y2 - (this.popupTile.getWidth() - 14), 20);
        x2 = x + width - 14;
        g.setClip(x2, y, 14, 14);
        g.drawImage(this.popupTile, x2 - (this.popupTile.getWidth() - 14), y, 20);
        g.setClip(x2, y2, 14, 14);
        g.drawImage(this.popupTile, x2 - (this.popupTile.getWidth() - 14), y2 - (this.popupTile.getWidth() - 14), 20);
        y2 = y + 14;
        for (int j = 0; j <= heightVertical / heightTileVertical; ++j) {
            x2 = x + 14;
            for (int i2 = 0; i2 <= widthHorizontal / widthTileHorizontal; ++i2) {
                w = x2 + widthTileHorizontal >= x + width - 14 ? x + width - 14 - x2 : widthTileHorizontal;
                h = y2 + heightTileVertical >= y + height - 14 ? y + height - 14 - y2 : heightTileVertical;
                g.setClip(x2, y2, w, h);
                g.drawImage(this.popupTile, x2 - 14, y2 - 14, 20);
                x2 += widthTileHorizontal;
            }
            y2 += heightTileVertical;
        }
    }

    public void paintTalk(Graphics g, String textTalk, IsoEngine isoEngine) {
        String furbyName;
        int heightPopup = this.fntGame.getFontHeight() * 2 + 8 + (this.fntGame.getFontHeight() + this.fntGame.getLineSpacing()) * 5;
        int yPopup = 160 - heightPopup;
        int gap = 0;
        this.resetClip(g);
        g.setColor(0xFFFFFF);
        g.fillRoundRect(0, yPopup, 129, heightPopup - 1, 15, 15);
        g.fillRect(0, yPopup + heightPopup - 15, 128, 15);
        g.setColor(0x888888);
        g.fillRoundRect(4, yPopup + 4, 119, heightPopup - 9, 15, 15);
        g.setColor(6702942);
        g.drawRoundRect(4, yPopup + 4, 118, heightPopup - 10, 15, 15);
        if (this.ge.idFurbyTalk >= 0) {
            gap = 32;
            furbyName = Map.furbyFriendsName[(this.ge.idFurbyTalk << 1) + 1].toUpperCase();
        } else if (this.ge.idFurbyTalk == -2) {
            furbyName = this.ge.lang[141];
            gap = 4;
        } else {
            furbyName = this.ge.playerActor.name;
        }
        this.ge.linesScreen = 4;
        this.fntGame.setCurrentPalette(1);
        this.fntGame.drawString(g, furbyName.toCharArray(), GAP_FURBY_X + this.fntGame.getFontHeight(), yPopup + 4 + this.fntGame.getFontHeight() - this.fntGame.getLineSpacing() + 2, 20);
        this.fntGame.setCurrentPalette(0);
        this.fntGame.drawFastString(g, textTalk.toCharArray(), this.ge.lineData, GAP_FURBY_X + this.fntGame.getFontHeight(), yPopup + 4 + this.fntGame.getFontHeight() + (this.fntGame.getFontHeight() + this.fntGame.getLineSpacing()), 128 - GAP_FURBY_X - this.fntGame.getFontHeight() * 3, 20, this.ge.lineActual, this.ge.linesScreen);
        if (this.ge.lineActual + this.ge.linesScreen < this.ge.maxLines) {
            this.paintArrow(g, 119, yPopup + heightPopup - 4 - 7 - 3, 3, true);
        }
    }

    private void resetClip(Graphics g) {
        g.setClip(0, 0, 128, 160);
    }

    public void paintSplash(Graphics g) {
        if (this.logo != null) {
            g.setColor(this.ge.state == 0 ? 0xFFFFFF : 0);
            g.fillRect(0, 0, 128, 160);
            g.drawImage(this.logo, 64, 80, 3);
        }
    }

    public void paintMainMenu(Graphics g) {
        int i;
        ++this.menuFrames;
        int posX = 0;
        int itemPosY = 0;
        int itemNumShow = 0;
        int itemFirstShow = 0;
        g.setColor(2699293);
        g.fillRect(0, 0, 128, 160);
        posX = Math.min(-(this.menuFrames % this.menuTreeSmall.getWidth()), 0);
        for (i = 0; i <= 128 / this.menuTreeSmall.getWidth() + 1; ++i) {
            g.drawImage(this.menuTreeSmall, posX + i * this.menuTreeSmall.getWidth(), 0, 20);
        }
        posX = Math.min(-(this.menuFrames % (this.menuTreeBig.getWidth() / 2)), 0);
        for (i = 0; i <= 128 / this.menuTreeSmall.getWidth() + 1; ++i) {
            g.drawImage(this.menuTreeBig, 2 * posX + i * this.menuTreeBig.getWidth(), 0, 20);
        }
        g.drawImage(this.menuTitle, 64, this.menuTreeBig.getHeight() / 2, 3);
        g.drawImage(this.menuGrass, 0, this.menuTreeBig.getHeight(), 6);
        if (this.ge.state == 4) {
            itemPosY = this.menuTreeBig.getHeight() + this.menuGrass.getHeight() / 2;
            itemNumShow = (160 - itemPosY) / (2 * this.fntMenu.getFontHeight());
            g.setColor(2588703);
            g.fillRect(0, itemPosY + Math.min(this.ge.optionActual, itemNumShow - 1) * 2 * this.fntMenu.getFontHeight(), 128, 2 * this.fntMenu.getFontHeight());
            if (this.ge.optionActual >= itemNumShow) {
                itemFirstShow = this.ge.optionActual - itemNumShow + 1;
            }
            itemPosY += this.fntMenu.getFontHeight();
            for (i = 0; i < itemNumShow && i < this.ge.optionsMenu.length; ++i) {
                this.fntMenu.drawString(g, this.ge.optionsMenu[i + itemFirstShow].toCharArray(), 64, itemPosY, 3);
                itemPosY += 2 * this.fntMenu.getFontHeight();
            }
        } else if (this.ge.state == 3 || this.ge.state == 11) {
            String textQuestion = this.ge.state == 3 ? this.ge.lang[8] : this.ge.lang[402];
            this.fntMenu.drawString(g, textQuestion.toCharArray(), this.fntMenu.getFontHeight() << 1, this.menuTreeBig.getHeight() + (this.fntMenu.getFontHeight() << 1), 128 - (this.fntMenu.getFontHeight() << 1) * 2, 160 - this.menuTreeBig.getHeight() - (this.fntMenu.getFontHeight() << 1) * 2, 3);
        }
    }

    public void paintIconsBottom(Graphics g) {
        if (this.ge.iconLeft != -1) {
            this.paintIcon(g, 2, 150, this.ge.iconLeft);
        }
        if (this.ge.iconRight != -1) {
            this.paintIcon(g, 118, 150, this.ge.iconRight);
        }
    }

    public void paintIcon(Graphics g, int x, int y, int numIcon) {
        g.setClip(x, y, 8, 8);
        g.drawImage(this.iconsMenu, x - numIcon * 8, y, 20);
    }

    public void paintLoading(Graphics g) {
        int y;
        int width = 128;
        int height = 0;
        if (this.fntMenu != null) {
            height = this.fntMenu.getFontHeight();
        }
        int x = (128 - width) / 2;
        int yText = y = 160 - height - 1;
        if (!this.bPanoramic) {
            this.resetClip(g);
            g.setColor(6121784);
            g.fillRect(0, 0, 128, 160);
            if (this.panoramic != null) {
                int xPanoramic = (128 - this.panoramic.getWidth()) / 2;
                this.bPanoramic = true;
                yText = (160 - this.panoramic.getHeight()) / 2;
                g.setColor(0);
                g.drawRect(xPanoramic - 1, (160 - this.panoramic.getHeight()) / 2 - 1, this.panoramic.getWidth() + 2, this.panoramic.getHeight() + 1);
                g.drawImage(this.panoramic, xPanoramic, (160 - this.panoramic.getHeight()) / 2, 20);
            }
            if (this.fntMenu != null && this.ge.lang != null) {
                this.fntMenu.drawString(g, this.ge.lang[0].toCharArray(), 64, yText - this.fntMenu.getFontHeight() - 4, 17);
            }
        }
        this.resetClip(g);
        g.setColor(0);
        g.drawRect(x, y, width - 1, height - 1);
        g.setColor(9807453);
        g.fillRect(x + 1, y + 1, this.stateLoading * (width - 2) / this.maxLoadResources, height - 2);
    }

    public void paintNewGame(Graphics g) {
        int i;
        ++this.menuFrames;
        int posX = 0;
        int posY = 0;
        g.setColor(2699293);
        g.fillRect(0, 0, 128, 160);
        posX = Math.min(-(this.menuFrames % this.menuTreeSmall.getWidth()), 0);
        for (i = 0; i <= 128 / this.menuTreeSmall.getWidth() + 1; ++i) {
            g.drawImage(this.menuTreeSmall, posX + i * this.menuTreeSmall.getWidth(), 0, 20);
        }
        posX = Math.min(-(this.menuFrames % (this.menuTreeBig.getWidth() / 2)), 0);
        for (i = 0; i <= 128 / this.menuTreeSmall.getWidth() + 1; ++i) {
            g.drawImage(this.menuTreeBig, 2 * posX + i * this.menuTreeBig.getWidth(), 0, 20);
        }
        g.drawImage(this.menuTitle, 64, this.menuTreeBig.getHeight() / 2, 3);
        g.drawImage(this.menuGrass, 0, this.menuTreeBig.getHeight(), 6);
        posY = this.menuTreeBig.getHeight() + this.menuGrass.getHeight() / 2 + this.fntMenu.getFontHeight();
        this.fntMenu.drawString(g, this.ge.lang[15].toCharArray(), 64, posY, 3);
        this.ge.textBox.paint(g, (128 - this.ge.textBox.width) / 2, posY += this.fntMenu.getFontHeight());
    }

    public void paintHelp(Graphics g) {
        int i;
        ++this.menuFrames;
        int posX = 0;
        int posY = 0;
        int textFrameHeight = 0;
        int textFrameWidth = 0;
        int gapPosY = 0;
        int gapHeight = 0;
        g.setColor(2699293);
        g.fillRect(0, 0, 128, 160);
        posX = Math.min(-(this.menuFrames % this.menuTreeSmall.getWidth()), 0);
        for (i = 0; i <= 128 / this.menuTreeSmall.getWidth() + 1; ++i) {
            g.drawImage(this.menuTreeSmall, posX + i * this.menuTreeSmall.getWidth(), 0, 20);
        }
        posX = Math.min(-(this.menuFrames % (this.menuTreeBig.getWidth() / 2)), 0);
        for (i = 0; i <= 128 / this.menuTreeSmall.getWidth() + 1; ++i) {
            g.drawImage(this.menuTreeBig, 2 * posX + i * this.menuTreeBig.getWidth(), 0, 20);
        }
        g.drawImage(this.menuTitle, 64, this.menuTreeBig.getHeight() / 2, 3);
        g.drawImage(this.menuGrass, 0, this.menuTreeBig.getHeight(), 6);
        posY = this.menuTreeBig.getHeight() + this.menuGrass.getHeight() / 2;
        textFrameHeight = 152 - posY - 5;
        textFrameWidth = 102;
        this.ge.maxLines = textFrameHeight / (this.fntGame.getFontHeight() + this.fntGame.getLineSpacing());
        gapHeight = textFrameHeight / (this.ge.lineData.length - this.ge.maxLines + 2);
        gapPosY = posY + textFrameHeight * this.ge.lineActual / (this.ge.lineData.length - this.ge.maxLines + 2);
        g.setColor(2588703);
        g.setClip(117, posY, 11, textFrameHeight);
        g.fillRect(119, gapPosY, 7, gapHeight);
        g.drawRect(117, posY, 10, textFrameHeight - 1);
        this.fntGame.drawFastString(g, this.ge.lang[9].toCharArray(), (128 - textFrameWidth) / 2, posY, textFrameWidth, textFrameHeight, 17, this.ge.lineActual, this.ge.maxLines);
    }

    public void paintAbout(Graphics g) {
        int i;
        ++this.menuFrames;
        int posX = 0;
        int posY = 0;
        int textFrameHeight = 0;
        int textFrameWidth = 0;
        int gapPosY = 0;
        int gapHeight = 0;
        g.setColor(2699293);
        g.fillRect(0, 0, 128, 160);
        posX = Math.min(-(this.menuFrames % this.menuTreeSmall.getWidth()), 0);
        for (i = 0; i <= 128 / this.menuTreeSmall.getWidth() + 1; ++i) {
            g.drawImage(this.menuTreeSmall, posX + i * this.menuTreeSmall.getWidth(), 0, 20);
        }
        posX = Math.min(-(this.menuFrames % (this.menuTreeBig.getWidth() / 2)), 0);
        for (i = 0; i <= 128 / this.menuTreeSmall.getWidth() + 1; ++i) {
            g.drawImage(this.menuTreeBig, 2 * posX + i * this.menuTreeBig.getWidth(), 0, 20);
        }
        g.drawImage(this.menuTitle, 64, this.menuTreeBig.getHeight() / 2, 3);
        g.drawImage(this.menuGrass, 0, this.menuTreeBig.getHeight(), 6);
        posY = this.menuTreeBig.getHeight() + this.menuGrass.getHeight() / 2;
        textFrameHeight = 152 - posY - 5;
        textFrameWidth = 102;
        this.ge.maxLines = textFrameHeight / (this.fntGame.getFontHeight() + this.fntGame.getLineSpacing());
        gapHeight = textFrameHeight / (this.ge.lineData.length - this.ge.maxLines + 2);
        gapPosY = posY + textFrameHeight * this.ge.lineActual / (this.ge.lineData.length - this.ge.maxLines + 2);
        if (gapHeight <= 0) {
            gapHeight = 1;
        }
        g.setColor(2588703);
        g.setClip(117, posY, 11, textFrameHeight);
        g.fillRect(119, gapPosY, 7, gapHeight);
        g.drawRect(117, posY, 10, textFrameHeight - 1);
        this.fntGame.drawFastString(g, this.ge.lang[10].toCharArray(), (128 - textFrameWidth) / 2, posY, textFrameWidth, textFrameHeight, 17, this.ge.lineActual, this.ge.maxLines);
    }

    public void paintButtonsInterface(Graphics g, int x, int y, int radius, byte[] buttons, short[] buttonsAngle, short[] buttonsAngleOffset) {
        for (int i = 0; i < buttons.length; ++i) {
            if (buttons[i] == -1) continue;
            int ofx = SSFunctions.coseno(buttonsAngle[i] - buttonsAngleOffset[i]) * radius / 10000;
            int ofy = -(SSFunctions.seno(buttonsAngle[i] - buttonsAngleOffset[i]) * radius) / 10000;
            this.paintButtonInterface(g, x + ofx - this.buttonInterfaceWidth / 2, y + ofy - this.buttonInterfaceHeight / 2, buttons[i], i == this.ge.optionActual);
        }
        this.fntGame.drawString(g, this.ge.messageTextDown.toCharArray(), x, y + radius + this.buttonInterfaceHeight, 17);
    }

    private void paintButtonInterface(Graphics g, int x, int y, int numButton, boolean active) {
        g.setClip(x, y, this.buttonInterfaceWidth, this.buttonInterfaceHeight);
        g.drawImage(this.buttons, x - numButton * this.buttonInterfaceWidth, y - (active ? this.buttonInterfaceHeight : 0), 20);
    }

    public void paintMapIsland(Graphics g, int height) {
        this.resetClip(g);
        g.setColor(4882645);
        g.fillRect(0, 0, 128, height);
        g.drawImage(this.mapIsland, 0, (height - this.mapIsland.getHeight()) / 2, 20);
        this.paintMapPoints(g, this.ge.posInventory, height);
        this.ge.playerActor.paint(g, this.map.MAP_POINTS[this.ge.posFurbyMap + 0], this.map.MAP_POINTS[this.ge.posFurbyMap + 1], 0, System.currentTimeMillis(), true);
    }

    private void paintMapPoints(Graphics g, int posPoint, int height) {
        int y = (height - this.mapIsland.getHeight()) / 2;
        this.resetClip(g);
        for (int i = 0; i < 24; i += 3) {
            this.paintMapPoint(g, this.map.MAP_POINTS[i + 0] - 6, this.map.MAP_POINTS[i + 1] - 6, i / 3 == posPoint);
        }
    }

    private void paintMapPoint(Graphics g, int x, int y, boolean selected) {
        int offset = 0;
        if (selected && this.ge.optionInterface == 1) {
            offset = SSFunctions.seno((int)(System.currentTimeMillis() >> 1)) * 2 / 10000;
        }
        g.setColor(0xFFFFFF);
        g.fillArc(x - offset / 2, y - offset / 2, 12 + offset, 12 + offset, 0, 360);
        if (selected) {
            g.setColor(13898770);
        } else {
            g.setColor(0x737373);
        }
        g.fillArc(x - offset / 2 + 2, y - offset / 2 + 2, 12 + offset - 4, 12 + offset - 4, 0, 360);
    }

    private void paintDownBar(Graphics g, int money, int[] bars, String message) {
        this.resetClip(g);
        g.drawImage(this.barDown, 0, 160, 36);
        this.fntGame.drawString(g, String.valueOf(money).toCharArray(), 14, 158, 33);
        if (message != null) {
            this.fntGame.drawString(g, message.toCharArray(), 64, 5, 17);
        }
        this.paintDownBarSkillsBars(g);
    }

    private void paintDownBarSkillsBars(Graphics g) {
        this.paintSkillBar(g, 49, 169 - this.barDown.getHeight(), 12, 3, this.ge.playerBars[0], 16770190, 16764973, 8284182);
        this.paintSkillBar(g, 49, 169 - this.barDown.getHeight() + 6, 12, 3, this.ge.playerBars[1], 16561540, 16415503, 8077318);
        this.paintSkillBar(g, 49, 169 - this.barDown.getHeight() + 12, 12, 3, this.ge.playerBars[2], 14216191, 12311807, 6188414);
    }

    public void paintInterface(Graphics g, int sheet) {
        int heightTop = 0;
        int heightBottom = 0;
        if (sheet != 2) {
            heightTop = this.paintInterfaceTop(g);
        }
        heightBottom = this.paintInterfaceBottom(g);
        switch (sheet) {
            case 0: {
                this.paintInterfaceInfo(g, heightTop, 160 - heightBottom - heightTop);
                break;
            }
            case 1: {
                this.paintInterfaceInventory(g, heightTop, 160 - heightBottom - heightTop);
                break;
            }
            case 2: {
                this.paintMapIsland(g, 160 - heightBottom);
                break;
            }
            case 3: {
                this.paintInterfaceQuests(g, heightTop, 160 - heightBottom - heightTop);
                break;
            }
            case 6: {
                this.paintInterfaceStore(g, heightTop, 160 - heightBottom - heightTop);
                break;
            }
            case 7: {
                this.paintInterfaceInventory(g, heightTop, 160 - heightBottom - heightTop);
                if (this.ge.stateGame != 4) break;
                this.paintInterfaceStoreBuyConfirm(g, 128 - (this.fntGame.getFontHeight() << 2), 106);
                break;
            }
            case 4: {
                this.paintInterfaceStore(g, heightTop, 160 - heightBottom - heightTop);
                if (this.ge.stateGame != 5) break;
                int popupWidth = 128 - (this.fntGame.getFontHeight() << 1);
                int popupHeight = (Math.min(3, this.ge.items.getNumItemsCostManufactureItem(this.ge.posStore)) + 5) * 17;
                this.paintInterfaceStoreBuyConfirm(g, popupWidth, popupHeight);
                break;
            }
            case 5: {
                this.paintInterfaceMenu(g, heightTop, 160 - heightBottom - heightTop);
                break;
            }
            case 8: {
                this.paintInterfaceDictionary(g, heightTop, 160 - heightBottom - heightTop);
            }
        }
        if (sheet != 2) {
            this.paintInterfaceTopActor(g, heightTop);
        }
        if (this.ge.optionActual == 1 || this.ge.optionActual == 2 || this.ge.optionActual == 7) {
            this.paintArrow(g, 59, 160 - heightBottom - 3, this.ge.optionInterface == 0 ? 2 : 3, true);
        }
        this.paintModifiers(g, 0, 0);
    }

    private void paintInterfaceQuests(Graphics g, int y, int height) {
        this.resetClip(g);
        g.setColor(7569481);
        g.fillRect(0, y, 128, height);
        int yTitleHeight = this.fntGameSmall.getFontHeight() << 1;
        this.paintInterfaceMiniTitle(g, this.ge.lang[40], y, yTitleHeight);
        int playerQuest = this.ge.qm.getActualQuest();
        int xTitle = 4;
        int yTitle = y + yTitleHeight + 2;
        int widthTitle = 128 - xTitle * 2;
        yTitle = y + yTitleHeight + 4;
        int heightTitle = this.fntGame.getFontHeight() * 3;
        this.resetClip(g);
        g.setColor(6121784);
        g.fillRoundRect(xTitle, yTitle, widthTitle, heightTitle, 5, 5);
        if (this.ge.qm.getActualQuest() < 49) {
            if (this.ge.qm.getQuestName(playerQuest).length() > 26) {
                this.fntGame.drawString(g, (this.ge.qm.getQuestName(playerQuest).substring(0, 26) + "...").toCharArray(), xTitle + this.fntGame.getFontHeight(), yTitle + heightTitle / 2, 6);
            } else {
                this.fntGame.drawString(g, this.ge.qm.getQuestName(playerQuest).toCharArray(), xTitle + this.fntGame.getFontHeight(), yTitle + heightTitle / 2, 6);
            }
        }
        yTitle = yTitle + heightTitle + 4;
        heightTitle = (height - (yTitle - y)) * 2 / 3;
        this.resetClip(g);
        g.setColor(6121784);
        g.fillRoundRect(xTitle, yTitle, widthTitle, heightTitle, 5, 5);
        if (this.ge.qm.getActualQuest() < 49) {
            this.fntGameSmall.drawString(g, this.ge.qm.getQuestDescription(playerQuest).toCharArray(), xTitle + this.fntGame.getFontHeight(), yTitle + this.fntGame.getFontHeight(), widthTitle - this.fntGame.getFontHeight() * 3, heightTitle - this.fntGame.getFontHeight() * 2, 20);
        }
        yTitle = yTitle + heightTitle + 4;
        heightTitle = height - (yTitle - y) - 4;
        this.resetClip(g);
        g.setColor(6121784);
        g.fillRoundRect(xTitle, yTitle, widthTitle, heightTitle, 5, 5);
        this.fntGameSmall.drawString(g, this.ge.lang[41].toCharArray(), xTitle + this.fntGame.getFontHeight(), yTitle + this.fntGameSmall.getFontHeight() / 2, 36);
        yTitle += this.fntGame.getFontHeight();
        heightTitle -= this.fntGame.getFontHeight() * 2;
        if (this.ge.qm.getActualQuest() < 49 && this.ge.qm.getActualQuest() != 16) {
            this.paintRequirements(g, xTitle, yTitle, widthTitle, heightTitle, playerQuest);
        }
    }

    private void paintRequirementsHandcraft(Graphics g, int x, int y, int width, int height, int numHandcraft) {
        StringBuffer sb = new StringBuffer();
        int yItem = y;
        int iInicial = 0;
        int iFinal = 0;
        if (this.ge.items.getNumItemsCostManufactureItem(numHandcraft) > 4) {
            if (this.skillsTime < this.ge.lastProcessTime) {
                iInicial = 0;
                iFinal = 4;
                if (this.skillsTime + 1500L < this.ge.lastProcessTime) {
                    this.skillsTime = this.ge.lastProcessTime + 1500L;
                }
            } else {
                iInicial = 4;
                iFinal = this.ge.items.getNumItemsCostManufactureItem(numHandcraft);
            }
        } else {
            iInicial = 0;
            iFinal = this.ge.items.getNumItemsCostManufactureItem(numHandcraft);
        }
        for (int i = iInicial; i < iFinal; ++i) {
            int xItem = x + this.fntGame.getFontHeight();
            int numItem = this.ge.items.getNumItemCost(numHandcraft, i);
            sb.append(this.ge.items.getStackItemCost(numHandcraft, i));
            sb.append(" X ");
            this.fntGame.drawString(g, sb.toString().toCharArray(), xItem, yItem, width, height, 20);
            this.items.drawAnimation(g, this.ge.items.getNumAnimItem(0, numItem), 0L, (xItem += this.fntGame.getLineWidth(sb.toString().toCharArray())) + 7, yItem - (this.fntGame.getFontHeight() - 14) / 2, true, 0);
            this.fntGame.drawString(g, this.ge.items.getNameItem(0, numItem).toCharArray(), xItem += 14 + this.fntGame.getLineWidth(" ".toCharArray()), yItem, 20);
            sb.delete(0, sb.length());
            yItem += 17;
        }
        sb = null;
    }

    private void paintRequirements(Graphics g, int x, int y, int width, int height, int numQuest) {
        int iFinal;
        int iInicial;
        StringBuffer sb = new StringBuffer();
        int xItem = x + this.fntGame.getFontHeight();
        int yItem = y;
        if (this.ge.qm.getNumRequirements(numQuest) > 3) {
            if (this.skillsTime < this.ge.lastProcessTime) {
                iInicial = this.ge.qm.getNumRequirements(numQuest) > 1 ? 1 : 0;
                iFinal = 3;
                if (this.skillsTime + 1500L < this.ge.lastProcessTime) {
                    this.skillsTime = this.ge.lastProcessTime + 1500L;
                }
            } else {
                iInicial = 3;
                iFinal = this.ge.qm.getNumRequirements(numQuest);
            }
        } else {
            iInicial = this.ge.qm.getNumRequirements(numQuest) > 1 ? 1 : 0;
            iFinal = this.ge.qm.getNumRequirements(numQuest);
        }
        for (int i = iInicial; i < iFinal; ++i) {
            int typeReq = this.ge.qm.getTypeRequirement(numQuest, i);
            int numItem = this.ge.qm.getNumItemRequirement(numQuest, i);
            if (typeReq == 1) {
                sb.append(this.ge.lang[42]);
                sb.append(' ');
                sb.append(Map.furbyFriendsName[numItem * 2 + 1]);
                continue;
            }
            if (typeReq < 2) continue;
            sb.append(this.ge.qm.getSizeRequirement(numQuest, i));
            sb.append(" X ");
            this.fntGame.drawString(g, sb.toString().toCharArray(), xItem, yItem, width, height, 20);
            this.items.drawAnimation(g, this.ge.items.getNumAnimItem(typeReq - 2, numItem), 0L, (xItem += this.fntGame.getLineWidth(sb.toString().toCharArray())) + 7, yItem - (this.fntGame.getFontHeight() - 14) / 2, true, 0);
            xItem += 21;
            sb.delete(0, sb.length());
        }
        if (sb.length() > 0) {
            this.fntGameSmall.drawString(g, sb.toString().toCharArray(), x + this.fntGame.getFontHeight(), y, width, height - this.fntGame.getFontHeight() * 2, 20);
        }
        sb = null;
    }

    private void paintInterfaceStoreBuyConfirm(Graphics g, int width, int height) {
        String buttonOk;
        String title;
        int price;
        int numItem;
        int typeItem;
        int x = 128 - width >> 1;
        int y = 160 - height >> 1;
        int itemX = x + 8;
        int itemY = y + this.fntGameSmall.getFontHeight() * 2;
        int itemWidth = 16;
        int itemHeight = 14 + this.fntGameSmall.getFontHeight();
        itemX = x + 4;
        int widthDesc = width - 8;
        if (this.ge.stateGame == 3) {
            typeItem = this.ge.items.getItemStoreType(this.ge.posStore);
            numItem = this.ge.items.getItemStoreNumItem(this.ge.posStore);
            price = this.ge.items.getItemStorePrice(this.ge.posStore);
            title = this.ge.lang[24];
            buttonOk = this.ge.lang[24];
        } else if (this.ge.stateGame == 4) {
            typeItem = this.ge.inventory.getTypeItem(this.ge.posInventory);
            numItem = this.ge.inventory.getNumItem(this.ge.posInventory);
            price = this.ge.items.getSellPrice(typeItem, numItem);
            title = this.ge.lang[25];
            buttonOk = this.ge.lang[25];
        } else {
            typeItem = 1;
            numItem = this.ge.posStore;
            price = 0;
            title = this.ge.lang[32];
            buttonOk = this.ge.lang[130];
        }
        this.resetClip(g);
        g.setColor(7569481);
        g.fillRoundRect(x, y, width, height, 10, 10);
        g.setColor(0xCCCCCC);
        g.drawRoundRect(x, y, width, height, 10, 10);
        this.fntGameSmall.drawString(g, title.toCharArray(), x + (width >> 1), y + this.fntGameSmall.getFontHeight() / 2, 17);
        this.resetClip(g);
        g.setColor(6121784);
        g.fillRoundRect(itemX, itemY, widthDesc, itemHeight, 5, 5);
        this.paintInterfaceInventoryItem(g, itemX, itemY, itemWidth, itemHeight, false, typeItem, numItem, 0);
        this.fntGame.drawString(g, this.ge.items.getNameItem(typeItem, numItem).toCharArray(), itemX + itemWidth + 4, itemY + itemHeight / 2, 6, widthDesc - 14 - 20);
        itemY = itemY + itemHeight + 4;
        itemHeight = this.ge.stateGame != 5 ? height + y - itemY - this.fntGame.getFontHeight() * 2 - this.fntGameSmall.getFontHeight() * 2 - itemHeight - 4 : height + y - itemY - this.fntGame.getFontHeight() * 2 - this.fntGameSmall.getFontHeight() * 2;
        this.resetClip(g);
        g.setColor(6121784);
        g.fillRoundRect(itemX, itemY, widthDesc, itemHeight, 10, 10);
        if (this.ge.stateGame != 5) {
            this.fntGameSmall.drawString(g, this.ge.items.getDescriptionItem(typeItem, numItem).toCharArray(), itemX + 4, itemY + 4, widthDesc - 8, itemHeight - 8, 20);
        } else {
            this.paintRequirementsHandcraft(g, itemX, itemY + this.fntGame.getFontHeight(), widthDesc, itemHeight, this.ge.posStore);
        }
        if (this.ge.stateGame != 5) {
            itemY = itemY + 4 + itemHeight;
            itemHeight = 14 + this.fntGameSmall.getFontHeight();
            this.resetClip(g);
            g.setColor(6121784);
            g.fillRoundRect(itemX, itemY, widthDesc, itemHeight, 10, 10);
            this.fntGame.drawString(g, this.ge.lang[129].toCharArray(), itemX + 8, itemY + 4, widthDesc - 16, itemHeight - 8, 6);
            this.fntGame.drawString(g, String.valueOf(price).toCharArray(), itemX + 8, itemY + 4, widthDesc - 16, itemHeight - 8, 10);
        }
        itemY = itemY + 4 + itemHeight;
        widthDesc = (widthDesc - this.fntGame.getFontHeight() * 2) / 2;
        itemHeight = height + y - itemY - 4;
        this.resetClip(g);
        if (this.ge.optionPopup == 0) {
            g.setColor(9807453);
        } else {
            g.setColor(6121784);
        }
        g.fillRoundRect(itemX, itemY, widthDesc, itemHeight, 10, 10);
        if (this.ge.optionPopup == 1) {
            g.setColor(9807453);
        } else {
            g.setColor(6121784);
        }
        g.fillRoundRect(itemX + widthDesc + this.fntGame.getFontHeight() * 2, itemY, widthDesc, itemHeight, 10, 10);
        this.fntGame.drawString(g, buttonOk.toCharArray(), itemX + widthDesc / 2, itemY + itemHeight / 2, 3);
        this.fntGame.drawString(g, this.ge.lang[128].toCharArray(), itemX + widthDesc + this.fntGame.getFontHeight() * 2 + widthDesc / 2, itemY + itemHeight / 2, 3);
        if (!this.ge.activeButton) {
            this.paintTrame(g, itemX, itemY, widthDesc, itemHeight);
        }
    }

    private void paintInterfaceMenu(Graphics g, int y, int height) {
        this.paintInterfaceStore(g, y, height);
    }

    private void paintInterfaceStore(Graphics g, int y, int height) {
        this.resetClip(g);
        g.setColor(7569481);
        g.fillRect(0, y, 128, height);
        int yInventory = this.paintInfoInventory(g, y);
        int yTitleHeight = this.fntGameSmall.getFontHeight() << 1;
        if (this.ge.optionActual == 5) {
            this.paintInterfaceMiniTitle(g, this.ge.lang[23], yInventory, yTitleHeight);
        } else {
            this.paintInterfaceMiniTitle(g, this.ge.lang[19], yInventory, yTitleHeight);
        }
        this.paintInterfaceStoreItems(g, yInventory + yTitleHeight, height + y - yInventory - yTitleHeight);
        if (this.ge.stateGame == 3 || this.ge.stateGame == 4) {
            this.paintInterfaceStoreBuyConfirm(g, 128 - (this.fntGame.getFontHeight() << 2), 106 + (this.fntGame.getFontHeight() + this.fntGame.getLineSpacing() + 1));
        }
    }

    private void paintInterfaceStoreItems(Graphics g, int y, int height) {
        int itemWidth = 16;
        int itemHeight = 14 + this.fntGameSmall.getFontHeight() + this.fntGameSmall.getFontHeight() * 2 / 3;
        this.ge.numItems = height / (itemHeight + 2);
        int gapY = (height - this.ge.numItems * itemHeight) / (this.ge.numItems + 1);
        int itemX = 2;
        int itemY = y + gapY;
        int typeItem = 0;
        int numItem = 0;
        for (int i = this.ge.posMinList; i < this.ge.posMinList + this.ge.numItems; ++i) {
            if (this.ge.optionActual == 4) {
                typeItem = 1;
                numItem = i;
            } else if (this.ge.optionActual == 5) {
                numItem = -1;
                typeItem = -1;
                itemWidth = 0;
                if (i >= this.ge.optionsMenu.length) {
                    continue;
                }
            } else {
                typeItem = this.ge.items.getItemStoreType(i);
                numItem = this.ge.items.getItemStoreNumItem(i);
            }
            boolean active = this.ge.posStore == i;
            int xDesc = itemX + itemWidth + 2;
            int widthPrice = this.ge.optionActual != 4 && this.ge.optionActual != 5 ? itemWidth * 2 : 0;
            int widthDesc = this.ge.optionActual != 5 ? 128 - itemWidth - widthPrice - 8 : 128 - itemWidth - widthPrice - 8;
            int xPrice = itemX + itemWidth + widthDesc + 4;
            if (this.ge.optionActual != 5) {
                this.paintInterfaceInventoryItem(g, itemX, itemY, itemWidth, itemHeight, active, typeItem, numItem, 0);
            }
            this.resetClip(g);
            if (active) {
                g.setColor(9807453);
            } else {
                g.setColor(6121784);
            }
            g.fillRoundRect(xDesc, itemY, widthDesc, itemHeight, 5, 5);
            g.fillRoundRect(xPrice, itemY, widthPrice, itemHeight, 5, 5);
            if (this.ge.optionActual == 5) {
                this.fntGame.drawString(g, this.ge.optionsMenu[i].toCharArray(), xDesc + this.fntGame.getFontHeight(), itemY, widthDesc - this.fntGame.getFontHeight() * 2, itemHeight, 3);
            } else {
                this.fntGame.drawString(g, this.ge.items.getNameItem(typeItem, numItem).toCharArray(), xDesc + this.fntGame.getFontHeight(), itemY, widthDesc - this.fntGame.getFontHeight() * 2, itemHeight, 6);
            }
            if (this.ge.optionActual != 4 && this.ge.optionActual != 5) {
                this.fntGame.drawString(g, String.valueOf(this.ge.items.getItemStorePrice(i)).toCharArray(), xPrice + this.fntGame.getFontHeight(), itemY, widthPrice - this.fntGame.getFontHeight() * 2, itemHeight, 3);
            }
            itemY += itemHeight + gapY;
        }
    }

    private void paintInterfaceInventory(Graphics g, int y, int height) {
        this.resetClip(g);
        g.setColor(7569481);
        g.fillRect(0, y, 128, height);
        int yInventory = this.paintInfoInventory(g, y);
        int yTitleHeight = -1 + this.fntGameSmall.getFontHeight() << 1;
        this.paintInterfaceMiniTitle(g, this.ge.lang[19], yInventory, yTitleHeight);
        this.paintInterfaceInventoryItems(g, yInventory + yTitleHeight, height + y - yInventory - yTitleHeight);
    }

    private void paintInterfaceInventoryItems(Graphics g, int y, int height) {
        int stackItem;
        int numItem;
        int typeItem;
        int itemX;
        int itemWidth = 16;
        int itemHeight = 14 + 1 * this.fntGameSmall.getFontHeight() / 3;
        int itemY = y + this.fntGame.getFontHeight();
        int posItem = 0;
        for (int j = 0; j < 3; ++j) {
            itemX = (128 - (itemWidth * 7 + 12)) / 2;
            for (int i = 0; i < 7; ++i) {
                typeItem = this.ge.inventory.getTypeItem(posItem);
                numItem = this.ge.inventory.getNumItem(posItem);
                stackItem = this.ge.inventory.getStackItem(posItem);
                boolean active = this.ge.optionInterface == 1 && this.ge.posInventory == j * 7 + i;
                this.paintInterfaceInventoryItem(g, itemX, itemY, itemWidth, itemHeight, active, typeItem, numItem, stackItem);
                ++posItem;
                itemX += itemWidth + 2;
            }
            itemY += itemHeight + 2;
        }
        itemX = (128 - (itemWidth * 7 + 12)) / 2;
        this.resetClip(g);
        g.setColor(6121784);
        g.fillRoundRect(itemX, itemY + 2, itemWidth * 7 + 12, height - (itemY - y) - 2 - this.fntGame.getFontHeight(), 5, 5);
        if (this.ge.optionInterface == 1) {
            typeItem = this.ge.inventory.getTypeItem(this.ge.posInventory);
            numItem = this.ge.inventory.getNumItem(this.ge.posInventory);
            stackItem = this.ge.inventory.getStackItem(this.ge.posInventory);
            if (stackItem > 0) {
                this.paintInterfaceInventoryDescription(g, itemX, itemY + 2, itemWidth * 7 + 12, height - (itemY - y) - 2 - this.fntGame.getFontHeight(), typeItem, numItem);
            }
        }
    }

    private void paintInterfaceInventoryDescription(Graphics g, int x, int y, int width, int height, int typeItem, int numItem) {
        String name = this.ge.items.getNameItem(typeItem, numItem);
        String description = this.ge.items.getDescriptionItem(typeItem, numItem);
        this.items.drawAnimation(g, this.ge.items.getNumAnimItem(typeItem, numItem), 0L, x + this.fntGameSmall.getFontHeight() + 7, y + 7, true, 0);
        int xTitle = x + this.fntGameSmall.getFontHeight() * 2 + 14;
        int yTitle = y + 2;
        this.fntGame.drawString(g, name.toCharArray(), xTitle, yTitle, 20);
        yTitle += this.fntGame.getFontHeight() + this.fntGame.getLineSpacing();
    }

    private void paintInterfaceInventoryItem(Graphics g, int x, int y, int width, int height, boolean selected, int typeItem, int numItem, int stack) {
        g.setClip(x, y, width, height);
        if (selected) {
            g.setColor(9807453);
        } else {
            g.setColor(6121784);
        }
        g.fillRoundRect(x, y, width, height, 5, 5);
        if (stack > 0 || this.ge.optionActual == 6 || this.ge.optionActual == 4 || this.ge.stateGame == 4 && stack > 0) {
            if (this.ge.optionActual == 6 || this.ge.optionActual == 4) {
                this.items.drawAnimation(g, this.ge.items.getNumAnimItem(typeItem, numItem), 0L, x + width / 2, y + 7 + this.fntGameSmall.getFontHeight() / 2 + 2, true, 0);
            } else {
                this.items.drawAnimation(g, this.ge.items.getNumAnimItem(typeItem, numItem), 0L, x + width / 2, y + 7 + this.fntGameSmall.getFontHeight() / 2 - 1, true, 0);
            }
        }
        if (stack > 0) {
            String stackText = "X" + stack;
            this.fntGameSmall.drawString(g, stackText.toCharArray(), x + width / 2, y + height, 33);
        }
    }

    private int paintInfoInventory(Graphics g, int y) {
        int xBox = 0;
        int yBox = 0;
        StringBuffer sb = new StringBuffer();
        int yTitleHeight = this.fntGame.getFontHeight() * 2;
        this.resetClip(g);
        g.setColor(6121784);
        g.fillRect(0, y, 128, yTitleHeight);
        this.fntGameSmall.drawString(g, (this.ge.lang[38] + ": " + String.valueOf(this.ge.playerMoney + this.ge.playerMoneyOffset)).toCharArray(), 64, y + yTitleHeight / 2, 3);
        int boxHeight = 2 + 3 * this.fntGame.getFontHeight() / 2;
        int boxMoneyWidth = this.fntGameSmall.getFontHeight() * 3 + 14 + this.fntGame.getLineWidth(String.valueOf(this.ge.playerMoney + this.ge.playerMoneyOffset).toCharArray());
        this.resetClip(g);
        xBox = (64 - boxMoneyWidth) / 2;
        yBox = y;
        return yBox + boxHeight + this.fntGameSmall.getFontHeight() / 2;
    }

    private void paintInterfaceInfo(Graphics g, int y, int height) {
        int yStatus = 0;
        this.resetClip(g);
        g.setColor(7569481);
        g.fillRect(0, y, 128, height);
        int ySkills = this.paintSkills(g, y, height);
        yStatus = this.paintStatus(g, ySkills);
        this.paintInfoFurby(g, y, yStatus - y);
    }

    private void paintInfoFurby(Graphics g, int y, int height) {
    }

    private int paintStatus(Graphics g, int ySkill) {
        int lineHeight = this.fntGame.getFontHeight() * 2;
        int yTitleHeight = this.fntGameSmall.getFontHeight() * 2;
        int heightStatus = this.fntGame.getFontHeight() * 7;
        int yTitle = ySkill - heightStatus - yTitleHeight;
        this.paintInterfaceMiniTitle(g, this.ge.lang[14], yTitle, yTitleHeight);
        int widthIcon = this.iconBars.getWidth() / 3;
        int yText = yTitle + yTitleHeight + lineHeight / 2;
        int xText = this.fntGame.getFontHeight() * 2 + widthIcon;
        int lengthText = this.getMaxLengthSkillWord(35, 3);
        int lengthPercent = this.fntGame.getLineWidth("100/100".toCharArray());
        int lengthBar = 128 - xText - lengthText - this.fntGame.getFontHeight() * 4 - lengthPercent;
        int xBar = xText + lengthText + this.fntGame.getFontHeight();
        int xPercent = xBar + lengthBar + lengthPercent + this.fntGame.getFontHeight();
        this.paintIconBar(g, xText - this.fntGame.getFontHeight() - widthIcon, yText - 1, 0);
        this.fntGame.drawString(g, this.ge.lang[35].toCharArray(), xText, yText, 20);
        this.paintSkillBar(g, xBar, yText + 1, lengthBar, this.fntGame.getFontHeight() - 2, 100, 14781347, 13248090, 6689582);
        this.paintSkillBar(g, xBar, yText + 1, lengthBar, this.fntGame.getFontHeight() - 2, this.ge.playerBars[0], 16770190, 16764973, 8284182);
        this.fntGameSmall.drawString(g, (this.ge.playerBars[0] + "/100").toCharArray(), xPercent, yText + this.fntGame.getFontHeight() / 2, 10);
        this.paintIconBar(g, xText - this.fntGame.getFontHeight() - widthIcon, yText += lineHeight, 1);
        this.fntGame.drawString(g, this.ge.lang[36].toCharArray(), xText, yText, 20);
        this.paintSkillBar(g, xBar, yText + 1, lengthBar, this.fntGame.getFontHeight() - 2, 100, 14781347, 13248090, 6689582);
        this.paintSkillBar(g, xBar, yText + 1, lengthBar, this.fntGame.getFontHeight() - 2, this.ge.playerBars[1], 16561540, 16415503, 8077318);
        this.fntGameSmall.drawString(g, (this.ge.playerBars[1] + "/100").toCharArray(), xPercent, yText + this.fntGame.getFontHeight() / 2, 10);
        this.paintIconBar(g, xText - this.fntGame.getFontHeight() - widthIcon, yText += lineHeight, 2);
        this.fntGame.drawString(g, this.ge.lang[37].toCharArray(), xText, yText, 20);
        this.paintSkillBar(g, xBar, yText + 1, lengthBar, this.fntGame.getFontHeight() - 2, 100, 14781347, 13248090, 6689582);
        this.paintSkillBar(g, xBar, yText + 1, lengthBar, this.fntGame.getFontHeight() - 2, this.ge.playerBars[2], 14216191, 12311807, 6188414);
        this.fntGameSmall.drawString(g, (this.ge.playerBars[2] + "/100").toCharArray(), xPercent, yText + this.fntGame.getFontHeight() / 2, 10);
        return yTitle;
    }

    private void paintIconBar(Graphics g, int x, int y, int numIcon) {
        int widthIcon = this.iconBars.getWidth() / 3;
        g.setClip(x, y, widthIcon, this.iconBars.getHeight());
        g.drawImage(this.iconBars, x - widthIcon * numIcon, y, 20);
    }

    private void paintSkillBar(Graphics g, int x, int y, int width, int height, int percent, int color1, int color2, int color3) {
        width = width * percent / 100;
        if (percent > 0) {
            this.resetClip(g);
            g.setColor(color1);
            g.drawLine(x, y, x + width - 1, y);
            g.setColor(color2);
            g.fillRect(x, y + 1, width, height - 2);
            g.setColor(color3);
            g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            g.setColor(color1);
            g.drawLine(x, y, x, y + height - 1);
            if (percent >= 100) {
                g.setColor(color3);
                g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            }
        }
    }

    private int getMaxLengthSkillWord(int firstText, int numTexts) {
        int length = Integer.MIN_VALUE;
        for (int i = 0; i < numTexts; ++i) {
            length = Math.max(length, this.fntGame.getLineWidth(this.ge.lang[firstText + i].toCharArray()));
        }
        return length;
    }

    private void paintSkill(Graphics g, int x, int y, int xPoints, String text, int skillLevel) {
        this.fntGame.drawString(g, text.toCharArray(), x, y, 20);
        this.paintSkillPoints(g, xPoints, y, skillLevel);
    }

    private void paintSkillPoints(Graphics g, int x, int y, int skillLevel) {
        int widthPoint = this.interfacePoints.getWidth() / 2;
        int heightPoint = this.interfacePoints.getHeight();
        for (int i = 0; i < 5; ++i) {
            int xImage = i <= skillLevel - 1 ? widthPoint : 0;
            g.setClip(x, y, widthPoint, heightPoint);
            g.drawImage(this.interfacePoints, x - xImage, y, 20);
            x += widthPoint - 1;
        }
    }

    private int paintSkills(Graphics g, int yInfo, int heightInfo) {
        int lineHeight = this.fntGame.getFontHeight() * 2;
        int yTitleHeight = this.fntGameSmall.getFontHeight() * 2;
        int heightSkill = this.fntGame.getFontHeight() * 9;
        int yTitle = yInfo + heightInfo - heightSkill - yTitleHeight;
        this.paintInterfaceMiniTitle(g, this.ge.lang[13], yTitle, yTitleHeight);
        int yText = yTitle + yTitleHeight + lineHeight / 2;
        int xText = this.fntGame.getFontHeight();
        int xPoints = xText + this.getMaxLengthSkillWord(27, 8) + this.fntGame.getFontHeight() / 2;
        boolean changed = this.skillsTime < this.ge.lastProcessTime;
        for (int i = 0; i < 4; ++i) {
            if (changed) {
                this.paintSkill(g, xText, yText, xPoints, this.ge.lang[27 + i], this.ge.playerSkills[i]);
                if (this.skillsTime + 1500L < this.ge.lastProcessTime) {
                    this.skillsTime = this.ge.lastProcessTime + 1500L;
                }
            } else {
                this.paintSkill(g, xText, yText, xPoints, this.ge.lang[27 + i + 4], this.ge.playerSkills[4 + i]);
            }
            yText += lineHeight;
        }
        return yTitle;
    }

    private void paintInterfaceMiniTitle(Graphics g, String text, int yTitle, int yTitleHeight) {
        this.resetClip(g);
        g.setColor(6121784);
        g.fillRect(0, yTitle, 128, yTitleHeight);
        this.fntGameSmall.drawString(g, text.toCharArray(), 64, yTitle + yTitleHeight / 2, 3);
    }

    private int paintInterfaceBottom(Graphics g) {
        int heightBack = this.fntGame.getFontHeight() * 2 + this.fntGameSmall.getFontHeight() + 4;
        int heightOption = this.fntGame.getFontHeight() * 3 + 4;
        this.resetClip(g);
        if (this.ge.optionInterface == 0) {
            g.setColor(7569481);
        } else {
            g.setColor(6121784);
        }
        g.fillRect(0, 160 - heightBack - heightOption, 128, heightOption);
        this.paintBorder(g, 160 - heightBack - heightOption);
        g.setColor(7304034);
        g.fillRect(0, 160 - heightBack, 128, heightBack);
        this.paintBorder(g, 160 - heightBack);
        this.fntGameSmall.drawString(g, this.ge.lang[17].toCharArray(), 123, 160 - heightBack / 2, 10);
        int yPos = 160 - heightBack - heightOption / 2;
        if (this.ge.optionActual != 6 && this.ge.optionActual != 8) {
            this.paintArrow(g, 5, 160 - heightBack - heightOption / 2 - 5, 0, this.ge.optionInterface == 0);
            if (this.ge.optionActual != 5) {
                this.fntGame.drawString(g, this.ge.getInterfaceName(this.ge.optionActual - 1, this.ge.maxOptions).toCharArray(), 15, yPos, 6);
            }
        }
        if (this.ge.optionActual != 7 && this.ge.optionActual != 8) {
            this.paintArrow(g, 116, 160 - heightBack - heightOption / 2 - 5, 1, this.ge.optionInterface == 0);
            this.fntGame.drawString(g, this.ge.getInterfaceName(this.ge.optionActual + 1, this.ge.maxOptions).toCharArray(), 113, yPos, 10);
        }
        return heightBack + heightOption;
    }

    private void paintInterfaceTopActor(Graphics g, int height) {
        int xFurby = this.ge.playerActor.getWidth() / 2;
        this.fntGame.drawString(g, this.ge.getInterfaceName(this.ge.optionActual, this.ge.maxOptions).toCharArray(), xFurby + this.ge.playerActor.getWidth(), (height - 4) / 2, 6);
        if (this.ge.optionActual < 6) {
            this.ge.playerActor.paint(g, xFurby, height - 4, 0, System.currentTimeMillis(), true);
        }
    }

    private int paintInterfaceTop(Graphics g) {
        int height = this.fntGame.getFontHeight() * 3 + 4;
        this.resetClip(g);
        g.setColor(9195119);
        g.fillRect(0, 0, 128, height);
        this.paintBorder(g, height - 4);
        int xFurby = this.ge.playerActor.getWidth() / 2;
        this.fntGame.drawString(g, this.ge.getInterfaceName(this.ge.optionActual, this.ge.maxOptions).toCharArray(), xFurby + this.ge.playerActor.getWidth(), (height - 4) / 2, 6);
        if (this.ge.optionActual < 6) {
            String text = this.ge.optionActual + 1 + "/" + this.ge.maxOptions;
            this.fntGame.drawString(g, text.toCharArray(), 128 - this.fntGame.getFontHeight(), (height - 4) / 2, 10);
        }
        return height;
    }

    private void paintBorder(Graphics g, int y) {
        g.setColor(0);
        g.drawLine(0, y, 128, y);
        g.setColor(9807727);
        g.drawLine(0, y + 1, 128, y + 1);
        g.setColor(2965255);
        g.drawLine(0, y + 2, 128, y + 2);
        g.setColor(0);
        g.drawLine(0, y + 3, 128, y + 3);
    }

    private void paintArrow(Graphics g, int x, int y, int typeArrow, boolean anim) {
        int height;
        int width;
        int yImage;
        int xImage;
        int offsetX = 0;
        int offsetY = 0;
        int frame = (int)(System.currentTimeMillis() % 600L) / 150;
        switch (typeArrow) {
            case 0: {
                xImage = 0;
                yImage = 0;
                width = 7;
                height = 11;
                if (!anim) break;
                offsetX = -frame;
                break;
            }
            case 1: {
                xImage = 7;
                yImage = 0;
                width = 7;
                height = 11;
                if (!anim) break;
                offsetX = frame;
                break;
            }
            case 2: {
                xImage = 0;
                yImage = 11;
                width = 11;
                height = 7;
                if (!anim) break;
                offsetY = -frame;
                break;
            }
            default: {
                xImage = 0;
                yImage = 18;
                width = 11;
                height = 7;
                if (!anim) break;
                offsetY = frame;
            }
        }
        g.setClip(x + offsetX, y + offsetY, width, height);
        g.drawImage(this.arrows, x - xImage + offsetX, y - yImage + offsetY, 20);
    }

    public void paintMiniGameGow(Graphics g) {
        int widthGame = 102;
        int heightGame = 10 + this.fntGame.getFontHeight() * 3;
        int xGame = (128 - widthGame) / 2;
        int yGame = 4 + (heightGame - 5) / 2;
        int xBarMedium = this.ge.percentZoneMedium * widthGame / 100;
        int xBarHigh = this.ge.percentZoneHigh * widthGame / 100;
        int lengthBarMedium = widthGame * this.ge.percentZoneMediumSize / 100;
        int lengthBarHigh = widthGame * this.ge.percentZoneHighSize / 100;
        this.resetClip(g);
        g.setColor(4538932);
        g.fillRect(0, 4, 128, heightGame);
        this.paintBorder(g, 0);
        this.paintBorder(g, 4 + heightGame);
        this.paintFillRect(g, xGame, yGame, widthGame, 0x838383, 0x666666);
        g.setColor(0xFFFFFF);
        g.drawRect(xGame - 1, yGame - 1, widthGame, 6);
        this.paintFillRect(g, xGame + xBarMedium, yGame, lengthBarMedium, 15836707, 12354075);
        this.paintFillRect(g, xGame + xBarHigh, yGame, lengthBarHigh, 15808034, 12331547);
        g.setColor(0xFFFFFF);
        g.drawLine(xGame - 1, yGame - 3 - 1, xGame - 1, yGame + 5 + 2 + 1);
        g.drawLine(xGame + widthGame - 1, yGame - 3 - 1, xGame + widthGame - 1, yGame + 5 + 2 + 1);
        g.drawLine(xGame + xBarMedium, yGame - 3 - 1, xGame + xBarMedium, yGame - 1);
        g.drawLine(xGame + xBarMedium + lengthBarMedium - 1, yGame - 3 - 1, xGame + xBarMedium + lengthBarMedium - 1, yGame - 1);
        g.drawLine(xGame + xBarHigh, yGame - 3 - 1, xGame + xBarHigh, yGame - 1);
        g.drawLine(xGame + xBarHigh + lengthBarHigh - 1, yGame - 3 - 1, xGame + xBarHigh + lengthBarHigh - 1, yGame - 1);
        int percentPiece = this.ge.stateGame == 6 ? (int)((System.currentTimeMillis() - this.ge.timeStartMiniGameGow) * 100L / 750L) % 100 : this.ge.percentPiece;
        int xPiece = xGame + percentPiece * widthGame / 100;
        g.setColor(11454006);
        g.fillRect(xPiece - 2, yGame - 3, 4, 11);
        g.setColor(0xFFFFFF);
        g.drawRect(xPiece - 2, yGame - 3, 4, 11);
    }

    private void paintFillRect(Graphics g, int x, int y, int width, int color1, int color2) {
        g.setColor(color1);
        g.fillRect(x, y, width, 3);
        g.setColor(color2);
        g.fillRect(x, y + 3, width, 2);
    }

    public void paintParty(Graphics g) {
        this.resetClip(g);
        g.setColor(0);
        g.fillRect(0, 0, 128, 160);
        g.drawImage(this.cover, 64, 80 + this.cover.getHeight() / 10, 3);
        this.fntGame.setCurrentPalette(0);
        this.fntGame.drawString(g, this.ge.lang[391].toCharArray(), 5, 5, 118, 80 - this.cover.getHeight() / 2 + this.cover.getHeight() / 10 - 10, 3);
    }

    public void paintFurbyGrown(Graphics g, Actor playerActor) {
        this.resetClip(g);
        g.setColor(0);
        g.fillRect(0, 0, 128, 160);
        playerActor.paint(g, 64, 80, 6, System.currentTimeMillis(), true);
        this.fntGame.drawString(g, this.ge.lang[147].toCharArray(), this.fntGame.getFontHeight(), this.fntGame.getFontHeight(), 128 - this.fntGame.getFontHeight() * 2, 160, 17);
    }

    public void paintFade(Graphics g) {
        this.resetClip(g);
        g.setColor(6121784);
        g.fillRect(0, 0, 64 * this.ge.fade / 100, 80 * this.ge.fade / 100);
        g.fillRect(64, 0, 64 * this.ge.fade / 100, 80 * this.ge.fade / 100);
        g.fillRect(0, 80, 64 * this.ge.fade / 100, 80 * this.ge.fade / 100);
        g.fillRect(64, 80, 64 * this.ge.fade / 100, 80 * this.ge.fade / 100);
    }

    private void paintInterfaceDictionary(Graphics g, int y, int height) {
        this.resetClip(g);
        g.setColor(7569481);
        g.fillRect(0, y, 128, height);
        int yInventory = this.paintInfoInventory(g, y);
        int yTitleHeight = this.fntGameSmall.getFontHeight() << 1;
        this.paintInterfaceMiniTitle(g, this.ge.lang[157], yInventory, yTitleHeight);
        this.paintInterfaceDictionaryWords(g, yInventory + yTitleHeight, height + y - yInventory - yTitleHeight);
        if (this.ge.stateGame == 3) {
            this.paintInterfaceDictionaryBuyConfirm(g, 128 - (this.fntGame.getFontHeight() << 2), 80);
        }
    }

    private void paintInterfaceDictionaryWords(Graphics g, int y, int height) {
        int itemWidth = 16;
        int itemHeight = 14;
        this.ge.numItems = height / (itemWidth + 2);
        int gapY = (height - this.ge.numItems * itemHeight) / (this.ge.numItems + 1);
        int itemX = 2;
        int itemY = y + gapY;
        for (int i = this.ge.posMinList; i < this.ge.posMinList + this.ge.numItems; ++i) {
            boolean active = this.ge.posStore == i;
            int xDesc = itemX + 2;
            int widthPrice = itemWidth * 2;
            int widthDesc = 128 - widthPrice - 6;
            int xPrice = itemX + widthDesc + 4;
            this.resetClip(g);
            if (active) {
                g.setColor(9807453);
            } else {
                g.setColor(6121784);
            }
            g.fillRoundRect(xDesc, itemY, widthDesc, itemHeight, 5, 5);
            g.fillRoundRect(xPrice, itemY, widthPrice, itemHeight, 5, 5);
            this.fntGame.drawString(g, this.ge.lang[266 + i].toCharArray(), xDesc + this.fntGame.getFontHeight(), itemY, widthDesc - this.fntGame.getFontHeight() * 2, itemHeight, 6);
            if (this.ge.dictionaryWordsPrices[i] != 0) {
                this.fntGame.drawString(g, String.valueOf(this.ge.dictionaryWordsPrices[i]).toCharArray(), xPrice + this.fntGame.getFontHeight(), itemY, widthPrice - this.fntGame.getFontHeight() * 2, itemHeight, 3);
            }
            itemY += itemHeight + gapY;
        }
    }

    private void paintInterfaceDictionaryBuyConfirm(Graphics g, int width, int height) {
        int x = 128 - width >> 1;
        int y = 160 - height >> 1;
        int itemX = x + 8;
        int itemY = y + this.fntGameSmall.getFontHeight() * 2;
        int price = this.ge.dictionaryWordsPrices[this.ge.posStore];
        String title = this.ge.lang[24];
        String buttonOk = this.ge.lang[24];
        int itemWidth = 16;
        int itemHeight = 14;
        int widthDesc = width - 16;
        this.resetClip(g);
        g.setColor(7569481);
        g.fillRoundRect(x, y, width, height, 10, 10);
        g.setColor(0xCCCCCC);
        g.drawRoundRect(x, y, width, height, 10, 10);
        this.fntGameSmall.drawString(g, title.toCharArray(), x + (width >> 1), y + this.fntGameSmall.getFontHeight() / 2, 17);
        this.resetClip(g);
        g.setColor(6121784);
        g.fillRoundRect(itemX, itemY, widthDesc, itemHeight, 5, 5);
        this.fntGame.drawString(g, this.ge.lang[this.ge.posStore + 158 + 108].toCharArray(), itemX + itemWidth + 4, itemY + itemHeight / 2, 6);
        itemY = itemY + itemHeight + 4;
        itemHeight = height + y - itemY - this.fntGame.getFontHeight() * 2 - this.fntGameSmall.getFontHeight() * 2 - itemHeight - 4;
        this.resetClip(g);
        g.setColor(6121784);
        g.fillRoundRect(itemX, itemY, widthDesc, itemHeight, 10, 10);
        title = this.ge.lang[this.ge.posStore + 158];
        if (price != 0) {
            title = "?????";
        }
        this.fntGame.drawString(g, title.toCharArray(), itemX + 4, itemY + 4, widthDesc - 8, itemHeight - 8, 20);
        itemY = itemY + 4 + itemHeight;
        itemHeight = 14;
        this.resetClip(g);
        g.setColor(6121784);
        g.fillRoundRect(itemX, itemY, widthDesc, itemHeight, 10, 10);
        if (price != 0) {
            this.fntGame.drawString(g, this.ge.lang[129].toCharArray(), itemX + 8, itemY + 4, widthDesc - 16, itemHeight - 8, 6);
            this.fntGame.drawString(g, String.valueOf(price).toCharArray(), itemX + 8, itemY + 4, widthDesc - 16, itemHeight - 8, 10);
        }
        itemY = itemY + 4 + itemHeight;
        widthDesc = (widthDesc - this.fntGame.getFontHeight() * 2) / 2;
        itemHeight = height + y - itemY - 4;
        this.resetClip(g);
        if (this.ge.optionPopup == 0) {
            g.setColor(9807453);
        } else {
            g.setColor(6121784);
        }
        g.fillRoundRect(itemX, itemY, widthDesc, itemHeight, 10, 10);
        if (this.ge.optionPopup == 1) {
            g.setColor(9807453);
        } else {
            g.setColor(6121784);
        }
        g.fillRoundRect(itemX + widthDesc + this.fntGame.getFontHeight() * 2, itemY, widthDesc, itemHeight, 10, 10);
        this.fntGame.drawString(g, buttonOk.toCharArray(), itemX + widthDesc / 2, itemY + itemHeight / 2, 3);
        this.fntGame.drawString(g, this.ge.lang[128].toCharArray(), itemX + widthDesc + this.fntGame.getFontHeight() * 2 + widthDesc / 2, itemY + itemHeight / 2, 3);
        if (!this.ge.activeButton) {
            this.paintTrame(g, itemX, itemY, widthDesc, itemHeight);
        }
    }

    private String getTutorialTitle() {
        return this.ge.lang[374 + this.ge.tutorialActual];
    }

    public void paintTutorial(Graphics g) {
        int i;
        ++this.menuFrames;
        int posX = 0;
        int posY = 0;
        int textFrameHeight = 0;
        int textFrameWidth = 0;
        int gapPosY = 0;
        int gapHeight = 0;
        g.setColor(2699293);
        g.fillRect(0, 0, 128, 160);
        posX = Math.min(-(this.menuFrames % this.menuTreeSmall.getWidth()), 0);
        for (i = 0; i <= 128 / this.menuTreeSmall.getWidth() + 1; ++i) {
            g.drawImage(this.menuTreeSmall, posX + i * this.menuTreeSmall.getWidth(), 0, 20);
        }
        posX = Math.min(-(this.menuFrames % (this.menuTreeBig.getWidth() / 2)), 0);
        for (i = 0; i <= 128 / this.menuTreeSmall.getWidth() + 1; ++i) {
            g.drawImage(this.menuTreeBig, 2 * posX + i * this.menuTreeBig.getWidth(), 0, 20);
        }
        g.drawImage(this.menuTitle, 64, this.menuTreeBig.getHeight() / 2, 3);
        g.drawImage(this.menuGrass, 0, this.menuTreeBig.getHeight(), 6);
        g.setColor(2588703);
        posY = this.menuTreeBig.getHeight() + this.menuGrass.getHeight() / 2;
        g.fillRoundRect(0, posY - 1, 128, this.fntGame.getFontHeight() + 3, 5, 5);
        this.fntGame.drawString(g, this.getTutorialTitle().toCharArray(), (128 - textFrameWidth) / 2, posY, 17);
        this.paintArrow(g, 5, posY - 1, 0, true);
        this.paintArrow(g, 116, posY - 1, 1, true);
        textFrameHeight = 152 - (posY += this.fntGame.getFontHeight() + this.fntGame.getLineSpacing()) - 5;
        textFrameWidth = 102;
        this.ge.lineData = this.fntGame.getLineData(this.ge.lang[381 + this.ge.tutorialActual].toCharArray(), textFrameWidth);
        this.ge.maxLines = textFrameHeight / (this.fntGame.getFontHeight() + this.fntGame.getLineSpacing());
        if (this.ge.lineData.length < this.ge.maxLines) {
            this.ge.maxLines = this.ge.lineData.length;
        }
        gapHeight = textFrameHeight / (this.ge.lineData.length - this.ge.maxLines + 2);
        gapPosY = posY + textFrameHeight * this.ge.lineActual / (this.ge.lineData.length - this.ge.maxLines + 2);
        if (gapHeight <= 0) {
            gapHeight = 1;
        }
        g.setClip(117, posY, 11, textFrameHeight);
        g.fillRect(119, gapPosY, 7, gapHeight);
        g.drawRect(117, posY, 10, textFrameHeight - 1);
        this.fntGame.drawFastString(g, this.ge.lang[381 + this.ge.tutorialActual].toCharArray(), (128 - textFrameWidth) / 2, posY, textFrameWidth, textFrameHeight, 17, this.ge.lineActual, this.ge.maxLines);
    }
}

