/*
 * Decompiled with CFR 0.152.
 */
package utilitare;

import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CSysFont {
    public static int NONE = 0;
    public static int LEFT = 1;
    public static int UP = 1;
    public static int CENTER = 2;
    public static int RIGHT = 3;
    public static int DOWN = 3;
    public static int SPACE_W = 3;
    public int fHeight = 0;
    public String fName = "";
    public String fVariant = "";
    public char[] fChars;
    public int[] charL;
    public int[] charR;
    public Image fVarImg;
    public InputStream is = null;
    public DataInputStream isr = null;
    public int numSymbols = 0;
    public int hSpacing = 1;

    public CSysFont(String fname, String fvariant) {
        this.fName = fname;
        this.fVariant = fvariant;
        try {
            Class<?> c = this.getClass();
            this.is = c.getResourceAsStream("/" + this.fName + ".fon");
            if (this.is == null) {
                throw new Exception("fisierul de font nu exista.");
            }
            this.isr = new DataInputStream(this.is);
            this.numSymbols = this.isr.readUnsignedByte();
            this.fChars = new char[this.numSymbols];
            this.charL = new int[this.numSymbols];
            this.charR = new int[this.numSymbols];
            boolean bHi = false;
            boolean bLow = false;
            for (int ii = 0; ii < this.numSymbols; ++ii) {
                this.fChars[ii] = (char)this.isr.readByte();
                this.charL[ii] = this.isr.readUnsignedShort();
                this.charR[ii] = this.isr.readUnsignedShort();
                System.err.println(this.fChars[ii] + " , " + this.charL[ii] + ":" + this.charR[ii]);
            }
            if (this.isr != null) {
                this.isr.close();
            }
        }
        catch (Exception e) {
            System.err.println("CFont::error");
        }
        this.setVariant(this.fVariant);
    }

    public void setVariant(String vName) {
        try {
            this.fVarImg = Image.createImage((String)("/" + this.fName + "_" + vName + ".png"));
            this.fHeight = this.fVarImg.getHeight();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getChrIdx(char chru) {
        int retValue = 0;
        for (int kk = 0; kk < this.numSymbols; ++kk) {
            if (this.fChars[kk] != chru) continue;
            retValue = kk;
        }
        return retValue;
    }

    public int getCharW(char chru) {
        int retValue = 0;
        for (int kk = 0; kk < this.numSymbols; ++kk) {
            if (this.fChars[kk] != chru) continue;
            retValue = this.charR[kk] - this.charL[kk] + 1;
        }
        if (chru == ' ') {
            retValue = SPACE_W;
        }
        return retValue;
    }

    public int getStringW(String stru) {
        int retValue = 0;
        for (int yy = 0; yy < stru.length(); ++yy) {
            retValue += this.hSpacing;
            retValue += this.getCharW(stru.charAt(yy));
        }
        return retValue;
    }

    public void drawString(String str, int x, int y, Graphics gg, int hType, int vType) {
        int sWid = this.getStringW(str);
        int xCursor = 0;
        int yCursor = 0;
        if (hType == NONE) {
            xCursor = x;
        }
        if (hType == LEFT) {
            xCursor = x;
        }
        if (hType == CENTER) {
            xCursor = x - sWid / 2;
        }
        if (hType == RIGHT) {
            xCursor = x - sWid;
        }
        if (vType == NONE) {
            yCursor = y;
        }
        if (vType == UP) {
            yCursor = y;
        }
        if (vType == CENTER) {
            yCursor = y - this.fHeight / 2;
        }
        if (vType == DOWN) {
            yCursor = y - this.fHeight;
        }
        for (int hh = 0; hh < str.length(); ++hh) {
            int chrIdx = this.getChrIdx(str.charAt(hh));
            if (str.charAt(hh) != ' ') {
                gg.drawRegion(this.fVarImg, this.charL[chrIdx], 0, this.charR[chrIdx] - this.charL[chrIdx] + 1, this.fHeight, 0, xCursor, yCursor, 0);
            }
            xCursor += this.hSpacing;
            xCursor += this.getCharW(str.charAt(hh));
        }
    }
}

