/*
 * Decompiled with CFR 0.152.
 */
package utilitare;

import javax.microedition.lcdui.Graphics;
import utilitare.CFont;

public class CEditBox {
    char[] realtimeText = new char[100];
    int realtimeLength = 0;
    int[] realtimePos = new int[100];
    int realtimeCaretPos = 0;
    public int xstart = 0;
    public int ystart = 0;
    public int boxWidth = 0;
    public int backColor = 0;
    public int textColor = 0;
    public int borderColor = 0;
    public int borderWidth = 0;
    public CFont boxFont;
    public int scrollX = 0;
    public int caretPos = 0;
    public int cyclicFrame = 0;
    public int MAX_TEXT_LENGTH = 254;

    public CEditBox(CFont boxfont, int x, int y, int width, int bordercolor, int borderwidth, int backcolor, int textcolor) {
        this.boxFont = boxfont;
        this.xstart = x;
        this.ystart = y;
        this.boxWidth = width;
        this.borderColor = bordercolor;
        this.borderWidth = borderwidth;
        this.backColor = backcolor;
        this.textColor = textcolor;
    }

    public String getCText() {
        String tmpRet = "";
        char[] tmpCh = new char[this.realtimeLength];
        for (int iy = 0; iy < this.realtimeLength; ++iy) {
            tmpCh[iy] = this.realtimeText[iy];
        }
        tmpRet = new String(tmpCh);
        return tmpRet;
    }

    public void resetControl() {
        this.realtimeLength = 0;
        boolean realtimeCaretPos = false;
        this.caretPos = 0;
    }

    public void processCaret(int cPos) {
        char[] tmpC = new char[cPos];
        for (int oo = 0; oo < cPos; ++oo) {
            tmpC[oo] = this.realtimeText[oo];
        }
        this.caretPos = this.boxFont.getStringW(new String(tmpC));
    }

    public void processMessage(String msg, char data) {
        int oo;
        if (msg == "addLetter") {
            if (this.realtimeCaretPos == this.realtimeLength) {
                this.realtimeText[this.realtimeCaretPos] = data;
                ++this.realtimeLength;
                ++this.realtimeCaretPos;
                this.processCaret(this.realtimeLength);
            } else {
                ++this.realtimeLength;
                for (oo = this.realtimeLength; oo > this.realtimeCaretPos; --oo) {
                    this.realtimeText[oo] = this.realtimeText[oo - 1];
                }
                this.realtimeText[this.realtimeCaretPos] = data;
                ++this.realtimeCaretPos;
                this.processCaret(this.realtimeCaretPos);
            }
            if (this.caretPos - this.scrollX > this.boxWidth - 5) {
                this.scrollX += 15;
            }
        }
        if (msg == "modifyLetterLast" && this.realtimeCaretPos > 0) {
            this.realtimeText[this.realtimeCaretPos - 1] = data;
            this.processCaret(this.realtimeCaretPos);
        }
        if (msg == "moveCaret") {
            if (data == '1') {
                if (this.realtimeCaretPos > 0) {
                    --this.realtimeCaretPos;
                }
                this.processCaret(this.realtimeCaretPos);
                if (this.caretPos < this.scrollX) {
                    this.scrollX -= 15;
                }
            }
            if (data == '2') {
                if (this.realtimeCaretPos < this.realtimeLength) {
                    ++this.realtimeCaretPos;
                }
                this.processCaret(this.realtimeCaretPos);
                if (this.caretPos - this.scrollX > this.boxWidth - 5) {
                    this.scrollX += 15;
                }
            }
        }
        if (msg == "delLetter") {
            if (this.realtimeCaretPos > 0 && this.realtimeLength > 0) {
                for (oo = this.realtimeCaretPos; oo < this.realtimeLength; ++oo) {
                    this.realtimeText[oo - 1] = this.realtimeText[oo];
                }
                --this.realtimeCaretPos;
                --this.realtimeLength;
                this.processCaret(this.realtimeCaretPos);
            }
            if (this.caretPos < this.scrollX) {
                this.scrollX -= 15;
            }
        }
    }

    public void drawCaret(Graphics gdd) {
        gdd.setColor(this.textColor);
        gdd.drawLine(this.xstart + 5 + this.caretPos - this.scrollX, this.ystart + 1, this.xstart + 5 + this.caretPos - this.scrollX, this.ystart + this.boxFont.tFH + 2);
    }

    public void draw(Graphics gd, boolean hasFocus) {
        gd.setColor(this.backColor);
        gd.fillRect(this.xstart, this.ystart, this.boxWidth, this.boxFont.tFH + 4);
        gd.setColor(this.borderColor);
        for (int oo = 0; oo < this.borderWidth; ++oo) {
            gd.drawRect(this.xstart + oo, this.ystart + oo, this.boxWidth - 2 * oo, this.boxFont.tFH + 4 - 2 * oo);
        }
        char[] tmpCh = new char[this.realtimeLength];
        for (int oo = 0; oo < this.realtimeLength; ++oo) {
            tmpCh[oo] = this.realtimeText[oo];
        }
        this.boxFont.drawString(new String(tmpCh), this.xstart + 5 - this.scrollX, this.ystart + 2, gd, this.textColor, 0, false, 0, 0);
        if (this.cyclicFrame < 5 && hasFocus) {
            this.drawCaret(gd);
        }
        this.cyclicFrame = (this.cyclicFrame + 1) % 10;
    }
}

