/*
 * Decompiled with CFR 0.152.
 */
package utilitare;

import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import utilitare.CBTDiscoveryListener;

public class CBTDiscovery {
    LocalDevice device;
    public DiscoveryAgent agent;
    public CBTDiscoveryListener discListener;
    public static Vector snames = new Vector();
    public byte[][] snameurile = new byte[100][];
    public static Vector devices = new Vector();
    public static Vector devicesOK = new Vector();
    public ServiceRecord serviceComm = null;
    public ServiceRecord serviceEcho = null;
    public static Vector services = new Vector();
    public static boolean inqCOMPL = false;
    public static boolean sinqCOMPL = false;

    public boolean getFCServer(RemoteDevice rDev) {
        boolean retValue = false;
        this.serviceComm = null;
        this.serviceEcho = null;
        try {
            for (int kk = 0; kk < services.size(); ++kk) {
                String sName = this.findServiceName((ServiceRecord)services.elementAt(kk));
                if (!sName.startsWith("FCBTCOM")) continue;
                this.serviceComm = (ServiceRecord)services.elementAt(kk);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.serviceComm != null) {
            retValue = true;
        }
        return retValue;
    }

    public void doDiscoverDevice() {
        try {
            this.device = LocalDevice.getLocalDevice();
            this.device.setDiscoverable(10390323);
            this.agent = this.device.getDiscoveryAgent();
            this.discListener = new CBTDiscoveryListener();
            this.agent.startInquiry(10390323, (DiscoveryListener)this.discListener);
        }
        catch (BluetoothStateException e) {
            e.printStackTrace();
        }
    }

    public void doDiscoverService(RemoteDevice remote) {
        try {
            if (services.size() > 0) {
                services.removeAllElements();
            }
            int[] attr = new int[]{0, 1, 256};
            this.agent.searchServices(attr, new UUID[]{new UUID(256L)}, remote, (DiscoveryListener)new CBTDiscoveryListener());
        }
        catch (BluetoothStateException e) {
            e.printStackTrace();
        }
    }

    public String findServiceName(ServiceRecord sr) {
        String sName = "";
        try {
            DataElement elm = sr.getAttributeValue(256);
            if (elm != null && elm.getDataType() == 32) {
                sName = elm.getValue().toString();
            }
        }
        catch (Throwable tt) {
            sName = "ERROR";
        }
        return sName;
    }

    public boolean isSerialPort(ServiceRecord sR) {
        boolean retValue = false;
        try {
            DataElement e = sR.getAttributeValue(1);
            Enumeration enumu = (Enumeration)e.getValue();
            DataElement e2 = (DataElement)enumu.nextElement();
            Object v = e2.getValue();
            String sName = CBTDiscovery.uuidToName((UUID)v);
            if (sName == "SerialPort") {
                retValue = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retValue;
    }

    public String getSType(ServiceRecord sR) {
        String retValue = "";
        try {
            DataElement e = sR.getAttributeValue(1);
            Enumeration enumu = (Enumeration)e.getValue();
            DataElement e2 = (DataElement)enumu.nextElement();
            Object v = e2.getValue();
            retValue = CBTDiscovery.uuidToName((UUID)v);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retValue;
    }

    public int findChannelId(ServiceRecord r) {
        DataElement e1 = r.getAttributeValue(4);
        Enumeration enum1 = (Enumeration)e1.getValue();
        while (enum1.hasMoreElements()) {
            DataElement e2 = (DataElement)enum1.nextElement();
            Enumeration enum2 = (Enumeration)e2.getValue();
            DataElement e3 = (DataElement)enum2.nextElement();
            if (!e3.getValue().equals(new UUID(3L))) continue;
            DataElement e4 = (DataElement)enum2.nextElement();
            int id = (int)e4.getLong();
            return id;
        }
        return -1;
    }

    public static String uuidToName(UUID u) {
        if (u.equals((Object)new UUID(1L))) {
            return "SDP";
        }
        if (u.equals((Object)new UUID(3L))) {
            return "RFCOMM";
        }
        if (u.equals((Object)new UUID(8L))) {
            return "OBEX";
        }
        if (u.equals((Object)new UUID(12L))) {
            return "HTTP";
        }
        if (u.equals((Object)new UUID(256L))) {
            return "L2CAP";
        }
        if (u.equals((Object)new UUID(15L))) {
            return "BNEP";
        }
        if (u.equals((Object)new UUID(4096L))) {
            return "ServiceDiscoveryServerServiceClassID";
        }
        if (u.equals((Object)new UUID(4097L))) {
            return "BrowseGroupDescriptorCerviceClassID";
        }
        if (u.equals((Object)new UUID(4098L))) {
            return "PublicBrowseGroup";
        }
        if (u.equals((Object)new UUID(4353L))) {
            return "SerialPort";
        }
        if (u.equals((Object)new UUID(4354L))) {
            return "LANAccessUsingPPP";
        }
        if (u.equals((Object)new UUID(4355L))) {
            return "DialupNetworking";
        }
        if (u.equals((Object)new UUID(4356L))) {
            return "IrMCSync";
        }
        if (u.equals((Object)new UUID(4357L))) {
            return "OBEX ObjectPushProfile";
        }
        if (u.equals((Object)new UUID(4358L))) {
            return "OBEX FileTrasnferProfile";
        }
        if (u.equals((Object)new UUID(4359L))) {
            return "IrMCSyncCommand";
        }
        if (u.equals((Object)new UUID(4360L))) {
            return "Headset";
        }
        if (u.equals((Object)new UUID(4361L))) {
            return "CordlessTelephony";
        }
        if (u.equals((Object)new UUID(4362L))) {
            return "AudioSource";
        }
        if (u.equals((Object)new UUID(4369L))) {
            return "Fax";
        }
        if (u.equals((Object)new UUID(4370L))) {
            return "HeadsetAudioGateway";
        }
        if (u.equals((Object)new UUID(4373L))) {
            return "PersonalAreaNetworkingUser";
        }
        if (u.equals((Object)new UUID(4374L))) {
            return "NetworkAccessPoint";
        }
        if (u.equals((Object)new UUID(4375L))) {
            return "GroupNetwork";
        }
        if (u.equals((Object)new UUID(4382L))) {
            return "Handsfree";
        }
        if (u.equals((Object)new UUID(4383L))) {
            return "HandsfreeAudioGateway";
        }
        if (u.equals((Object)new UUID(4609L))) {
            return "GenericNetworking";
        }
        if (u.equals((Object)new UUID(4610L))) {
            return "GenericFileTransfer";
        }
        if (u.equals((Object)new UUID(4611L))) {
            return "GenericAudio";
        }
        if (u.equals((Object)new UUID(4612L))) {
            return "GenericTelephony";
        }
        return u.toString();
    }
}

