/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.Composition;
import app.MidiFile;
import app.Translation;
import com.siemens.mp.io.File;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class Session {
    static final boolean DECODE = true;
    public static final byte CREATED = 0;
    public static final byte LOADED = 1;
    public static final byte PARSED = 2;
    private String name;
    private byte state = 0;
    public Composition composition;
    private byte[] sessionData;
    public boolean dirty = false;

    public void readSessionData(String fileName) throws Exception {
        this.name = fileName;
        fileName = String.valueOf(String.valueOf(fileName)).concat(".ses");
        this.unload();
        File file = new File();
        int fd = -1;
        try {
            if (File.exists((String)fileName) < 0) {
                throw new Exception(Translation.strings.FORMAT_ERROR);
            }
            fd = file.open(fileName);
            int length = file.length(fd);
            if (length == 0) {
                throw new Exception("Session has zero length");
            }
            this.sessionData = new byte[length];
            file.read(fd, this.sessionData, 0, length);
            file.close(fd);
            this.state = 1;
        }
        catch (Exception e) {
            this.sessionData = null;
            throw e;
        }
    }

    public void readFactorySession(String fileName) throws Exception {
        this.name = fileName;
        fileName = String.valueOf(String.valueOf(fileName)).concat(".ses");
        this.unload();
        try {
            InputStream stream = this.getClass().getResourceAsStream("content/".concat(String.valueOf(String.valueOf(fileName))));
            if (stream == null) {
                throw new Exception("Resource not found: ".concat(String.valueOf(String.valueOf(fileName))));
            }
            int length = stream.available();
            this.sessionData = new byte[length];
            stream.read(this.sessionData, 0, length);
            this.state = 1;
        }
        catch (Exception e) {
            this.sessionData = null;
            throw e;
        }
    }

    public void readComposition(String fileName) throws Exception {
        if (!fileName.endsWith(".comp")) {
            fileName = String.valueOf(String.valueOf(fileName)).concat(".comp");
        }
        this.unload();
        File file = new File();
        int fd = -1;
        try {
            if (File.exists((String)fileName) < 0) {
                throw new Exception(Translation.strings.FORMAT_ERROR);
            }
            fd = file.open(fileName);
            int length = file.length(fd);
            if (length == 0) {
                throw new Exception(Translation.strings.FORMAT_ERROR);
            }
            byte[] compStrData = new byte[length];
            file.read(fd, compStrData, 0, length);
            file.close(fd);
            this.setCompositionData(compStrData);
        }
        catch (Exception e) {
            this.sessionData = null;
            throw e;
        }
    }

    public static String readCompositionName(String fileName) throws Exception {
        fileName = String.valueOf(String.valueOf(fileName)).concat(".comp");
        File file = new File();
        int fd = -1;
        try {
            if (File.exists((String)fileName) < 0) {
                throw new Exception(Translation.strings.FORMAT_ERROR);
            }
            fd = file.open(fileName);
            int length = file.length(fd);
            if (length == 0) {
                throw new Exception(Translation.strings.FORMAT_ERROR);
            }
            byte[] compStrData = new byte[length];
            file.read(fd, compStrData, 0, length);
            file.close(fd);
            String string = Session.extractCompositionName(compStrData);
            return string;
        }
        catch (Exception exception) {
            return new String("Unknown");
        }
    }

    public static String extractCompositionName(byte[] compStrData) throws Exception {
        try {
            ByteArrayInputStream strInput = new ByteArrayInputStream(compStrData);
            DataInputStream strStream = new DataInputStream(strInput);
            String compString = strStream.readUTF();
            int compDataStart = compString.indexOf(58);
            int compNameStart = compString.indexOf(58, compDataStart + 1);
            int compTempoStart = compString.indexOf(58, compNameStart + 1);
            String string = compTempoStart > 0 ? compString.substring(compNameStart + 1, compTempoStart) : compString.substring(compNameStart + 1);
            return string;
        }
        catch (Exception exception) {
            return new String("Unknown");
        }
    }

    void download(String sessionName, String url) throws IOException {
        block9: {
            this.name = sessionName;
            this.unload();
            HttpConnection c = null;
            InputStream s = null;
            try {
                int ch;
                block8: {
                    long timeNow;
                    c = (HttpConnection)Connector.open((String)url, (int)1);
                    long timeOut = System.currentTimeMillis() + (long)10000;
                    do {
                        long length = 0L;
                        try {
                            length = c.getLength();
                        }
                        catch (Exception e) {
                            length = 0L;
                        }
                        if (length > (long)0) break block8;
                    } while ((timeNow = System.currentTimeMillis()) <= timeOut);
                    throw new Exception("Timeout");
                }
                s = c.openInputStream();
                ByteArrayOutputStream buffer = new ByteArrayOutputStream(2000);
                while ((ch = s.read()) != -1) {
                    buffer.write(ch);
                }
                if (buffer.size() > 0) {
                    this.sessionData = buffer.toByteArray();
                    this.state = 1;
                }
                c.close();
                c = null;
            }
            catch (Exception e) {
                if (s != null) {
                    s.close();
                }
                if (c == null) break block9;
                c.close();
            }
        }
    }

    public void writeComposition(String fileName, byte[] data) throws Exception {
        fileName = String.valueOf(String.valueOf(fileName)).concat(".comp");
        File file = new File();
        int fd = -1;
        if (File.exists((String)fileName) >= 0) {
            File.delete((String)fileName);
        }
        fd = file.open(fileName);
        file.write(fd, data, 0, data.length);
        file.close(fd);
        this.dirty = false;
    }

    public void writeSessionData(String fileName) throws Exception {
        if (this.state < 1) {
            return;
        }
        fileName = String.valueOf(String.valueOf(fileName)).concat(".ses");
        File file = new File();
        int fd = -1;
        byte[] buffer = this.encodeSession();
        if (buffer == null) {
            throw new Exception("Encode session failed");
        }
        if (File.exists((String)fileName) >= 0) {
            File.delete((String)fileName);
        }
        fd = file.open(fileName);
        file.write(fd, buffer, 0, buffer.length);
        file.close(fd);
        this.dirty = false;
    }

    public void writeRingtone(String fileName) throws Exception {
        this.writeMidiFile(String.valueOf(String.valueOf(new StringBuffer("a:/Sounds/").append(fileName).append(".mid"))), 1);
    }

    public void writeMidiFile(String path, int loopCount) throws Exception {
        if (this.state < 1) {
            return;
        }
        File file = new File();
        int fd = -1;
        byte[] buffer = this.encodeMidiFile(loopCount);
        if (File.exists((String)path) >= 0) {
            File.delete((String)path);
        }
        fd = file.open(path);
        file.write(fd, buffer, 0, buffer.length);
        file.close(fd);
    }

    public int getVariant(int track, int bar) {
        if (this.state == 2) {
            return this.composition.tracks[track].matrix[bar];
        }
        return 0;
    }

    public String getCompositionName() {
        return this.composition.name;
    }

    public void setCompositionName(String name) {
        if (this.composition != null) {
            this.composition.name = name;
        }
    }

    public int getTempo() {
        if (this.state == 2) {
            return this.composition.tempo;
        }
        return 120;
    }

    public void setTempo(int tempo) {
        if (this.state == 2) {
            if (tempo > 200) {
                tempo = 200;
            }
            if (tempo < 10) {
                tempo = 10;
            }
            this.composition.tempo = tempo;
        }
    }

    public void setVariant(int track, int bar, int index) {
        if (this.state == 2 && this.composition.tracks[track].matrix[bar] != (byte)index) {
            this.composition.tracks[track].matrix[bar] = (byte)index;
            this.dirty = true;
        }
    }

    public String getTrackName(int index) {
        if (this.state == 2) {
            return this.composition.tracks[index].name;
        }
        return new String("X");
    }

    public void unload() {
        this.dirty = false;
        this.sessionData = null;
        this.composition = null;
        this.state = 0;
    }

    public void decode() throws Exception {
        if (this.state == 1) {
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(this.sessionData));
            this.composition = new Composition();
            this.composition.name = this.name;
            MidiFile midiFile = new MidiFile(stream, this.composition);
            midiFile.read();
            this.state = (byte)2;
        }
    }

    public void reset() {
        this.composition = new Composition();
        this.state = (byte)2;
    }

    public byte[] encodeMidiFile(int loopCount) throws Exception {
        if (this.state == 2) {
            this.composition.collectCellOnly = false;
            MidiFile midiFile = new MidiFile(this.composition);
            return midiFile.writeFormat0(loopCount);
        }
        return null;
    }

    public byte[] encodeBar(int track, int bar) throws Exception {
        if (this.state == 2) {
            this.composition.collectCellOnly = true;
            this.composition.activeBar = bar;
            this.composition.activeTrack = track;
            MidiFile midiFile = new MidiFile(this.composition);
            return midiFile.writeFormat0(1);
        }
        return null;
    }

    public byte[] encodeSession() {
        if (this.state == 2) {
            block0: for (int i = 0; i < this.sessionData.length; ++i) {
                if (this.sessionData[i] == -1 && this.sessionData[i + 1] == 81 && this.sessionData[i + 2] == 3) {
                    int t = 60000000 / this.composition.getTempo();
                    this.sessionData[i + 3] = (byte)(t >> 16);
                    this.sessionData[i + 4] = (byte)(t >> 8);
                    this.sessionData[i + 5] = (byte)t;
                }
                if (this.sessionData[i] != -16 || this.sessionData[i + 1] != 17 || this.sessionData[i + 2] != 17 || this.sessionData[i + 3] != 16) continue;
                int location = i + 5;
                int trackIndex = 0;
                while (true) {
                    if (trackIndex >= 4) break block0;
                    int bar = 0;
                    while (true) {
                        if (bar >= 4) break;
                        this.sessionData[location++] = (byte)this.getVariant(trackIndex, bar);
                        ++bar;
                    }
                    ++trackIndex;
                }
            }
            return this.sessionData;
        }
        return null;
    }

    public void findAndLoadSession(String name) throws Exception {
        try {
            this.readFactorySession(name);
            return;
        }
        catch (Exception exception) {
            this.readSessionData(name);
            return;
        }
    }

    public byte[] getCompositionData() throws Exception {
        String compStr = new String(this.name);
        compStr = String.valueOf(String.valueOf(compStr)).concat(":");
        int trackIndex = 0;
        while (true) {
            if (trackIndex >= 4) break;
            int bar = 0;
            while (true) {
                if (bar >= 4) break;
                compStr = String.valueOf(String.valueOf(compStr)).concat(String.valueOf(String.valueOf(String.valueOf(this.getVariant(trackIndex, bar)))));
                ++bar;
            }
            ++trackIndex;
        }
        compStr = String.valueOf(String.valueOf(compStr)).concat(":");
        compStr = String.valueOf(String.valueOf(compStr)).concat(String.valueOf(String.valueOf(this.composition.name)));
        compStr = String.valueOf(String.valueOf(compStr)).concat(":");
        compStr = String.valueOf(String.valueOf(compStr)).concat(String.valueOf(String.valueOf(String.valueOf(this.composition.tempo))));
        ByteArrayOutputStream strOutput = new ByteArrayOutputStream();
        DataOutputStream strStream = new DataOutputStream(strOutput);
        strStream.writeUTF(compStr);
        return strOutput.toByteArray();
    }

    public void setCompositionData(byte[] compStrData) throws Exception {
        ByteArrayInputStream strInput = new ByteArrayInputStream(compStrData);
        DataInputStream strStream = new DataInputStream(strInput);
        String compString = strStream.readUTF();
        int compDataStart = compString.indexOf(58);
        int compNameStart = compString.indexOf(58, compDataStart + 1);
        int compTempoStart = compString.indexOf(58, compNameStart + 1);
        String sessionName = compString.substring(0, compDataStart);
        String compData = compString.substring(compDataStart + 1);
        String compName = compTempoStart > 0 ? compString.substring(compNameStart + 1, compTempoStart) : sessionName;
        String compTempo = "";
        if (compTempoStart > 0) {
            compTempo = compString.substring(compTempoStart + 1);
        }
        try {
            this.findAndLoadSession(sessionName);
            this.decode();
        }
        catch (Exception e) {
            String message = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Translation.strings.SESNOTAVAILABLE_ERROR1))).append(" ").append(sessionName).append(" ").append(Translation.strings.SESNOTAVAILABLE_ERROR2)));
            throw new Exception(message);
        }
        for (int i = 0; i < 16; ++i) {
            int value = compData.charAt(i) - 48;
            if (value > this.composition.numVariations) {
                value = this.composition.numVariations;
            }
            if (value < 0) {
                value = 0;
            }
            this.setVariant(i / 4, i % 4, value);
            this.dirty = false;
        }
        if (compName.length() > 0) {
            this.composition.name = compName;
        }
        if (compTempo.length() > 0) {
            this.setTempo(Integer.parseInt(compTempo));
        }
    }

    static {
        DECODE = true;
        CREATED = 0;
        LOADED = 1;
        PARSED = (byte)2;
    }
}

