/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.CubasisMobile;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class EditScreen
extends Canvas {
    private int activeBar;
    private int activeTrack;
    private CubasisMobile cumo;
    private int test;
    private int tempo;
    private Image background;
    private Image triangle;
    private Image circle;
    private Image square;
    private Image[][] img;
    static final int KEY_UP = -59;
    static final int KEY_DOWN = -60;
    static final int KEY_RIGHT = -4;
    static final int KEY_LEFT = -1;
    static final int KEY_ARROW_LEFT = -61;
    static final int KEY_ARROW_RIGHT = -62;
    static final int KEY_GREEN = -11;
    static final int KEY_RED = -12;

    public EditScreen(CubasisMobile cumo) {
        this.cumo = cumo;
        this.activeTrack = 0;
        this.activeBar = 0;
        this.tempo = cumo.session.getTempo();
        try {
            this.background = cumo.getImage("arrange.png");
            if (cumo.display.isColor()) {
                this.img = new Image[4][3];
                for (int i = 0; i < 4; ++i) {
                    for (int j = 1; j <= 3; ++j) {
                        this.img[i][j - 1] = cumo.getImage(String.valueOf(String.valueOf(new StringBuffer("img").append(i).append(j).append(".png"))));
                    }
                }
            } else {
                this.triangle = cumo.getImage("triangle.png");
                this.circle = cumo.getImage("circle.png");
                this.square = cumo.getImage("square.png");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCommandListener(cumo);
    }

    public void hiliteCell(int track, int bar) {
        this.activeTrack = track;
        this.activeBar = bar;
        this.repaint();
    }

    protected void keyPressed(int k) {
        this.test = k;
        switch (k) {
            case 48: {
                try {
                    this.cumo.previewBar(this.activeTrack, this.activeBar);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
                break;
            }
            case 49: {
                try {
                    this.cumo.preview(false);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
                break;
            }
            case 51: {
                try {
                    this.cumo.previewer.stop();
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
                break;
            }
            case -61: 
            case 52: {
                if (--this.activeBar >= 0) break;
                this.activeBar = 0;
                break;
            }
            case -62: 
            case 54: {
                if (++this.activeBar <= 3) break;
                this.activeBar = 3;
                break;
            }
            case 50: {
                if (--this.activeTrack >= 0) break;
                this.activeTrack = 0;
                break;
            }
            case 56: {
                if (++this.activeTrack <= 3) break;
                this.activeTrack = 3;
                break;
            }
            case -1: {
                if (!this.hasNavigation()) break;
            }
            case 53: {
                int c = this.cumo.session.getVariant(this.activeTrack, this.activeBar);
                if (++c > 3) {
                    c = 0;
                }
                this.cumo.session.setVariant(this.activeTrack, this.activeBar, c);
                break;
            }
            case -12: 
            case -4: {
                this.cumo.gotoAppMenu();
                break;
            }
            case -59: {
                if (this.hasNavigation()) {
                    if (--this.activeTrack >= 0) break;
                    this.activeTrack = 0;
                    break;
                }
            }
            case 35: {
                this.cumo.adjustTempo(1);
                break;
            }
            case 42: {
                this.cumo.adjustTempo(-1);
                break;
            }
            case -60: {
                if (this.hasNavigation()) {
                    if (++this.activeTrack <= 3) break;
                    this.activeTrack = 3;
                    break;
                }
            }
            case -11: {
                try {
                    this.cumo.togglePreview();
                }
                catch (Exception exception) {}
                break;
            }
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        int height = this.getHeight();
        int width = this.getWidth();
        int gridX = 21;
        int gridY = 12;
        int cellW = 25;
        int cellH = 13;
        int textY = 11;
        if (height == 80) {
            gridX = 1;
            gridY = 14;
            cellH = 16;
            textY = 13;
        }
        g.setColor(0, 0, 0);
        g.drawImage(this.background, 0, 0, 0);
        for (int track = 0; track < 4; ++track) {
            for (int bar = 0; bar < 4; ++bar) {
                int v = this.cumo.session.getVariant(track, bar);
                int x = gridX + bar * cellW;
                int y = gridY + cellH * track;
                if (this.cumo.display.isColor()) {
                    if (v == 0) continue;
                    g.drawImage(this.img[track][v - 1], x, y, 0);
                    continue;
                }
                if (v == 1) {
                    g.drawImage(this.square, x, y, 0);
                    continue;
                }
                if (v == 2) {
                    g.drawImage(this.circle, x, y, 0);
                    continue;
                }
                if (v != 3) continue;
                g.drawImage(this.triangle, x, y, 0);
            }
        }
        g.setColor(180, 255, 255);
        Font fnt = Font.getFont((int)64, (int)0, (int)8);
        g.setFont(fnt);
        g.setClip(0, 0, 66, 20);
        g.drawString(this.cumo.session.getCompositionName(), 0, textY, 36);
        g.setClip(0, 0, 101, 80);
        String tempo = new String();
        g.drawString(String.valueOf(this.cumo.session.getTempo()), 66, textY, 36);
        int x = gridX + this.activeBar * cellW;
        int y = gridY + this.activeTrack * cellH;
        g.drawRect(x, y, cellW - 2, cellH - 2);
        g.drawRect(x - 1, y - 1, cellW, cellH);
    }

    boolean hasNavigation() {
        return true;
    }

    static {
        KEY_UP = -59;
        KEY_DOWN = -60;
        KEY_RIGHT = -4;
        KEY_LEFT = -1;
        KEY_ARROW_LEFT = -61;
        KEY_ARROW_RIGHT = -62;
        KEY_GREEN = -11;
        KEY_RED = -12;
    }
}

