/*
 * Decompiled with CFR 0.152.
 */
package j2meunit.framework;

import j2meunit.framework.AssertionFailedError;
import j2meunit.framework.Protectable;
import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestFailure;
import j2meunit.framework.TestListener;
import java.util.Enumeration;
import java.util.Vector;

public class TestResult {
    protected Vector fErrors;
    protected Vector fFailures = new Vector();
    protected Vector fListeners;
    protected int fAssertions;
    protected int fRunTests = 0;
    private boolean fStop = false;

    public TestResult() {
        this.fErrors = new Vector();
        this.fListeners = new Vector();
    }

    public void addError(Test test, Throwable t) {
        this.fErrors.addElement(new TestFailure(test, t));
        int i = 0;
        int cnt = this.fListeners.size();
        while (i < cnt) {
            ((TestListener)this.fListeners.elementAt(i)).addError(test, t);
            ++i;
        }
    }

    public synchronized void addFailure(Test test, AssertionFailedError t) {
        this.fFailures.addElement(new TestFailure(test, t));
        int i = 0;
        int cnt = this.fListeners.size();
        while (i < cnt) {
            ((TestListener)this.fListeners.elementAt(i)).addFailure(test, t);
            ++i;
        }
    }

    public synchronized void addListener(TestListener listener) {
        this.fListeners.addElement(listener);
    }

    public synchronized int assertionCount() {
        return this.fAssertions;
    }

    public synchronized void assertionMade() {
        ++this.fAssertions;
    }

    public void endTest(Test test) {
        int i = 0;
        int cnt = this.fListeners.size();
        while (i < cnt) {
            ((TestListener)this.fListeners.elementAt(i)).endTest(test);
            ++i;
        }
    }

    public void endTestStep(Test test) {
        int i = 0;
        int cnt = this.fListeners.size();
        while (i < cnt) {
            ((TestListener)this.fListeners.elementAt(i)).endTestStep(test);
            ++i;
        }
    }

    public synchronized int errorCount() {
        return this.fErrors.size();
    }

    public synchronized Enumeration errors() {
        return this.fErrors.elements();
    }

    public synchronized int failureCount() {
        return this.fFailures.size();
    }

    public synchronized Enumeration failures() {
        return this.fFailures.elements();
    }

    public synchronized int runCount() {
        return this.fRunTests;
    }

    public void runProtected(Test test, Protectable p) {
        try {
            p.protect();
        }
        catch (AssertionFailedError e) {
            this.addFailure(test, e);
        }
        catch (Throwable e) {
            this.addError(test, e);
        }
    }

    public synchronized int runTests() {
        return this.runCount();
    }

    public synchronized boolean shouldStop() {
        return this.fStop;
    }

    public void startTest(Test test) {
        TestResult testResult = this;
        synchronized (testResult) {
            ++this.fRunTests;
        }
        int i = 0;
        int cnt = this.fListeners.size();
        while (i < cnt) {
            ((TestListener)this.fListeners.elementAt(i)).startTest(test);
            ++i;
        }
    }

    public synchronized void stop() {
        this.fStop = true;
    }

    public synchronized int testErrors() {
        return this.errorCount();
    }

    public synchronized int testFailures() {
        return this.failureCount();
    }

    public synchronized boolean wasSuccessful() {
        return this.testFailures() == 0 && this.testErrors() == 0;
    }

    protected void run(final TestCase test) {
        this.startTest(test);
        Protectable p = new Protectable(){

            public void protect() throws Throwable {
                test.runBare();
            }
        };
        this.runProtected(test, p);
        this.endTest(test);
    }
}

