/*
 * Decompiled with CFR 0.152.
 */
package j2meunit.framework;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestResult;
import java.util.Enumeration;
import java.util.Vector;

public class TestSuite
implements Test {
    private String fName;
    private Vector fTests = new Vector(10);

    public TestSuite() {
    }

    public TestSuite(String sName) {
        this.fName = sName;
    }

    public TestSuite(Test rTest) {
        this.addTest(rTest);
    }

    public TestSuite(Test[] rTests) {
        int i = 0;
        while (i < rTests.length) {
            this.addTest(rTests[i]);
            ++i;
        }
    }

    public TestSuite(Class theClass, String[] testNames) {
        this(theClass.getName());
        int i = 0;
        while (i < testNames.length) {
            TestCase testCase = null;
            try {
                testCase = (TestCase)theClass.newInstance();
            }
            catch (Exception e) {
                String sMessage = "Need to have public default constructor in " + theClass.getName();
                System.out.println(sMessage);
                throw new RuntimeException(sMessage);
            }
            testCase.setName(testNames[i]);
            this.addTest(testCase);
            ++i;
        }
    }

    public void addTest(Test test) {
        this.fTests.addElement(test);
    }

    public int countTestCases() {
        int count = 0;
        int i = 0;
        int cnt = this.fTests.size();
        while (i < cnt) {
            count += ((Test)this.fTests.elementAt(i)).countTestCases();
            ++i;
        }
        return count;
    }

    public int countTestSteps() {
        int count = 0;
        int i = 0;
        int cnt = this.fTests.size();
        while (i < cnt) {
            count += ((Test)this.fTests.elementAt(i)).countTestSteps();
            ++i;
        }
        return count;
    }

    public void run(TestResult result) {
        Enumeration e = this.tests();
        while (e.hasMoreElements()) {
            if (result.shouldStop()) break;
            Test test = (Test)e.nextElement();
            test.run(result);
        }
    }

    public Test testAt(int index) {
        return (Test)this.fTests.elementAt(index);
    }

    public int testCount() {
        return this.fTests.size();
    }

    public Enumeration tests() {
        return this.fTests.elements();
    }

    public String toString() {
        if (this.fName != null) {
            return this.fName;
        }
        return super.toString();
    }

    private Test warning(final String message) {
        return new TestCase("warning"){

            protected void runTest() {
                this.fail(message);
            }
        };
    }
}

